/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.apps.content.migration.core.ContentMigrationAdapter;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.RecoverRunEnvironment;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomDataRecoveryHandler
implements CommandHandler<RecoverRunEnvironment> {
    private RecoverRunEnvironment rcvrRunEnv;
    Logger logger = LogManager.getLogger(CustomDataRecoveryHandler.class);
    private String logDir = null;

    private Properties createProperties(Command command, BackupSession session) {
        Properties props = new Properties();
        CommandRequestContext requestContext = session.getRequestContext();
        props.setProperty("cmu.base.dir", command.getParameter("configdir"));
        props.setProperty("cmu.sasroot", requestContext.getSASRoot());
        props.setProperty("cmu.sashome", requestContext.getSASHome());
        props.setProperty("cmu.migration.mode", "import");
        props.setProperty("cmu.package.dir", this.rcvrRunEnv.getVaultBase() + File.separator + command.getParameter("backupid") + File.separator + command.getParameter("source"));
        props.setProperty("cmu.target.dir", command.getParameter("configdir"));
        props.setProperty("config.xml.dir.path", BackupServerUtil.getCfgwizardPath(requestContext.getSASHome()));
        props.setProperty("deploywizard.groovy.path", BackupServerUtil.getDeployWizardPath(requestContext.getSASHome()) + File.separator + "deploywiz" + File.separator + "groovy");
        this.logDir = this.rcvrRunEnv.getLogAreaPath();
        props.setProperty("cmu.logs.dir", this.logDir);
        return props;
    }

    @Override
    public int execute(RecoverRunEnvironment recoverRunEnv, BackupSession session) throws BackupException {
        this.rcvrRunEnv = recoverRunEnv;
        this.logger.info("Calling cmu to recover user specified directories");
        ContentMigrationAdapter cmu = new ContentMigrationAdapter();
        this.logger.debug("Staring command to run the data recover");
        Command command = recoverRunEnv.getCommand();
        try {
            cmu.migrateContents(this.createProperties(command, session));
            this.logger.info("User specified directories recoverd successfully");
        }
        catch (ContentMigrationException e) {
            this.logger.error((Object)e.getStackTrace());
            throw new BackupException("User specified directories recovery failed", e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_CMU.getErrorCode());
        }
        return 0;
    }
}

