/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.common.definitions.BackupException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConnectionInfo {
    private static String CONNECXT_URL_REGEX = "(.+)://(.+)" + Pattern.quote("@@") + "(.+)" + Pattern.quote(":") + "([0-9]{1,5}+)" + Pattern.quote("::") + "(.+)";
    private static Pattern connectURLPattern = Pattern.compile(CONNECXT_URL_REGEX);
    private static final String EXCLUDE_FILTER_TOKEN = "excludes=";
    private static final String INCLUDE_FILTER_TOKEN = "&includes=";
    private Matcher urlMatcher;
    private String includes;
    private String excludes;

    ConnectionInfo(String url) throws BackupException {
        int questionMarkIndex = url.indexOf("?");
        String urlStringWithoutFilter = url;
        if (questionMarkIndex != -1) {
            urlStringWithoutFilter = url.substring(0, questionMarkIndex);
            this.setFilters(url.substring(questionMarkIndex + 1));
        }
        this.urlMatcher = connectURLPattern.matcher(urlStringWithoutFilter);
        if (!this.urlMatcher.matches()) {
            throw new IllegalArgumentException("Unable to parse connection string : " + url);
        }
    }

    private void setFilters(String urlFilterString) {
        if (urlFilterString != null && !urlFilterString.isEmpty()) {
            int excludeFilterBeginIndex = urlFilterString.indexOf(EXCLUDE_FILTER_TOKEN);
            int includeFilterBeginIndex = urlFilterString.indexOf(INCLUDE_FILTER_TOKEN);
            if (excludeFilterBeginIndex != -1) {
                this.excludes = includeFilterBeginIndex > excludeFilterBeginIndex ? urlFilterString.substring(excludeFilterBeginIndex + EXCLUDE_FILTER_TOKEN.length(), includeFilterBeginIndex) : urlFilterString.substring(excludeFilterBeginIndex + EXCLUDE_FILTER_TOKEN.length());
            }
            if (includeFilterBeginIndex != -1) {
                this.includes = urlFilterString.substring(includeFilterBeginIndex + INCLUDE_FILTER_TOKEN.length());
            }
        }
    }

    String getUniqueIdentity() {
        return this.getHost() + this.getPort() + this.getName();
    }

    String getUserName() {
        return this.urlMatcher.group(2);
    }

    String getPassword() {
        return this.urlMatcher.group(5);
    }

    String getHost() {
        return this.urlMatcher.group(3);
    }

    String getPort() {
        return this.urlMatcher.group(4);
    }

    String getName() {
        return this.urlMatcher.group(1);
    }

    String getIncludes() {
        return this.includes;
    }

    String getExcludes() {
        return this.excludes;
    }
}

