/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import com.sas.svcs.backup.server.util.ConfigurationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationHandler
implements CommandHandler<RunEnvironment> {
    private Logger logger = LogManager.getLogger(ConfigurationHandler.class);
    Properties confProp = null;
    private static final String DROP_ZONE = "dropzone";
    public static final String DROP_ZONE_CONFIG_SUBDIR = "config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void LoadPropertiesFile(String dirUtility) throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(dirUtility + "/" + "configuration.properties"));
            this.confProp = new Properties();
            this.confProp.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Properties createProperties(Command command, BackupSession session) {
        String hostAlias;
        Properties props = new Properties();
        props.setProperty("backupserver.install.dir", command.getParameter("platformtypeinstalldir") + "/SASDeploymentBackup");
        props.setProperty("backupserver.workspace.dir", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace"));
        props.setProperty("backupserver.vault.dir", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/" + command.getParameter("vault"));
        props.setProperty("backupserver.result.dir", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/" + command.getParameter("result"));
        props.setProperty("backupserver.log.dir", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/" + command.getParameter("log"));
        props.setProperty("sas.config.dir", command.getParameter("configdir"));
        props.setProperty("sas.home.dir", command.getParameter("sashome"));
        props.setProperty("backupserver.drop.zone", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/" + DROP_ZONE);
        props.setProperty("backupserver.drop.zone.config.subdir", command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/" + DROP_ZONE + "/" + DROP_ZONE_CONFIG_SUBDIR);
        String temp = command.getParameter("configdir");
        if (temp != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.SAS_CONFIG_BASE, command.getParameter("configdir"));
        }
        if ((hostAlias = command.getParameter("hostalias")) != null) {
            props.setProperty(BackupServerConstants.BACKUP_HOST_ALIAS, hostAlias);
        }
        if ((temp = command.getParameter("sashome")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_SAS_HOME, command.getParameter("sashome"));
        }
        if ((temp = command.getParameter("sasroot")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_SAS_ROOT, command.getParameter("sasroot"));
        }
        if ((temp = command.getParameter("utilitiesdir")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_UTILITIES_DIR, command.getParameter("utilitiesdir"));
        }
        if ((temp = command.getParameter("scsjndiname")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JNDI_NAME, temp);
        }
        if ((temp = command.getParameter("scsjdbcurl")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_URL, temp);
        }
        if ((temp = command.getParameter("scsjdbcdriver")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_DRIVER, temp);
        }
        if ((temp = command.getParameter("pgdatabaselist")) == null) {
            props.setProperty(BackupServerConstants.BACKUP_POSTGRES_LIST_DATABASE, "");
        } else {
            props.setProperty(BackupServerConstants.BACKUP_POSTGRES_LIST_DATABASE, temp);
        }
        temp = command.getParameter("tier");
        if (temp != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_TIER_NAME, temp);
        }
        if ((temp = command.getParameter("ostype")) != null && !temp.equals("")) {
            props.setProperty(BackupServerConstants.BACKUP_OSTYPE, temp);
        }
        return props;
    }

    @Override
    public int execute(RunEnvironment runEnvironment, BackupSession session) throws BackupException {
        this.logger.info(RB.getStringResource("ConfigurationHandler.starting.backup.wrokspace.configuration.txt"));
        try {
            Command command = runEnvironment.getCommand();
            boolean isReConfigure = command.hasParameter("reconfigure");
            if (!isReConfigure) {
                Properties prop = this.createProperties(command, session);
                ConfigurationHelper helper = new ConfigurationHelper(prop);
                helper.configure(command);
                this.logger.info("Done with configuration");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new BackupException(e, BackupServer.ReturnCode.SERVER_CONFIGURATION_ERROR.getErrorCode());
        }
        return 0;
    }
}

