/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.BackupContentDetails;
import com.sas.svcs.backup.client.BackupDetailsDAO;
import com.sas.svcs.backup.client.BackupHostDetails;
import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.ArchiveRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.Synchronizer;
import com.sas.svcs.backup.server.handler.ArchiveValidationManager;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveHandler
implements CommandHandler<ArchiveRunEnvironment>,
CommandPostProcessor<ArchiveRunEnvironment> {
    private Logger logger = LogManager.getLogger(ArchiveHandler.class);

    @Override
    public int execute(ArchiveRunEnvironment archiveRunEnv, BackupSession session) throws BackupException {
        int returnCode;
        block39: {
            Command command = archiveRunEnv.getCommand();
            String sharedVaultBase = archiveRunEnv.getSharedVaultBase();
            String dropzone = archiveRunEnv.getBackupConfigRootPath() + File.separator + "dropzone";
            boolean sharedVaultAccessible = false;
            boolean sharedVaultSpecified = sharedVaultBase != null;
            returnCode = 0;
            if (!sharedVaultSpecified) {
                this.logger.info("Shared vault base is not specified.");
            }
            try {
                boolean isSharedVaultBase;
                boolean bl = isSharedVaultBase = sharedVaultSpecified ? BackupServerUtil.prepareSharedVault(dropzone, sharedVaultBase) : false;
                if (isSharedVaultBase) {
                    sharedVaultAccessible = true;
                }
            }
            catch (BackupException e) {
                sharedVaultAccessible = false;
            }
            if (sharedVaultSpecified && !sharedVaultAccessible) {
                this.logger.warn("Shared vault base is not accessible " + sharedVaultBase);
            }
            String localStaging = archiveRunEnv.getVaultBase() + File.separator + (command.hasParameter("backupid") ? command.getParameter("backupid") : session.getSessionId());
            String dropzoneSessionPath = archiveRunEnv.getBackupConfigRootPath() + File.separator + "dropzone" + File.separator + (command.hasParameter("backupid") ? command.getParameter("backupid") : session.getSessionId());
            boolean copyDropZone = new File(dropzoneSessionPath).exists();
            boolean metaTier = command.hasParameter("metadatastaging");
            File metadata = null;
            String metadataStaging = null;
            File localMetaBase = null;
            File sharedMetaBase = null;
            String way = command.getParameter("way");
            if (metaTier) {
                metadataStaging = command.getParameter("metadatastaging");
                if (way.equals("up")) {
                    metadata = BackupServerUtil.presentAndAccessible(metadataStaging);
                }
                String sharedMetaParent = sharedVaultBase != null ? new File(sharedVaultBase).getParent() : null;
                sharedMetaBase = new File(sharedMetaParent, "metadataserver");
                localMetaBase = new File(localStaging, "metadataserver");
                if (sharedVaultSpecified && sharedVaultAccessible) {
                    sharedMetaBase.mkdir();
                    session.putSessionData("meta.shared.vault", sharedMetaBase.getPath());
                    session.putSessionData("meta.shared.vault.parent", sharedMetaParent);
                }
                if (!sharedVaultAccessible) {
                    localMetaBase.mkdirs();
                }
            }
            Synchronizer sync = new Synchronizer();
            String metaToDir = null;
            String localMetaDir = null;
            String metaFromDir = null;
            String deployToDir = null;
            String deployFromDir = null;
            if (way.equals("up")) {
                if (metaTier) {
                    metaToDir = sharedMetaBase.getAbsolutePath();
                    metaFromDir = metadataStaging;
                }
                deployToDir = sharedVaultBase;
                deployFromDir = localStaging;
                this.logger.debug(" Copy Drop Zone " + copyDropZone + " dropzoneSessionPath" + dropzoneSessionPath + "localStaging" + localStaging);
                if (copyDropZone) {
                    sync.addToCopy(dropzoneSessionPath, localStaging);
                }
            } else {
                if (metaTier) {
                    metaToDir = metadataStaging;
                    BackupServerUtil.ifNotExistsCreate(metaToDir);
                    metaFromDir = sharedMetaBase.getAbsolutePath();
                }
                deployToDir = localStaging;
                BackupServerUtil.ifNotExistsCreate(deployToDir);
                deployFromDir = sharedVaultBase;
            }
            if (metaTier) {
                localMetaDir = localMetaBase.getAbsolutePath();
                if (way.equals("up") && !sharedVaultAccessible) {
                    sync.addToCopy(metaFromDir, localMetaDir, "MetadataServerJournal.dat");
                } else if (!sharedVaultAccessible && way.equals("down")) {
                    sync.addToCopy(localMetaDir, metadataStaging, "MetadataServerJournal.dat");
                }
                if (sharedVaultAccessible) {
                    sync.addToCopy(metaFromDir, metaToDir, "MetadataServerJournal.dat");
                }
            }
            if (sharedVaultAccessible) {
                this.logger.info(RB.getStringResource("ArchiveHandler.archiving.backup.to.central.location.txt"));
                sync.addToCopy(deployFromDir, deployToDir, "metadataserver/**");
            }
            if ("up".equals(way)) {
                sync.synchronizeUp(new File(localStaging), sharedVaultSpecified, command);
                String metaSharedVault = session.getSessionData("meta.shared.vault", String.class);
                if (!BackupServerUtil.isEmpty(metaSharedVault)) {
                    String perm = "700";
                    sync.setPermission(command, "700", session.getSessionData("meta.shared.vault.parent", String.class));
                }
                if (copyDropZone) {
                    this.logger.info("Removing the content server backup copy from drop zone");
                    File dropZoneStaging = new File(dropzoneSessionPath);
                    if (FileUtils.deleteQuietly((File)dropZoneStaging)) {
                        this.logger.info("Content server backup is removed from staging area");
                    } else {
                        this.logger.info("Unable to clean the content server backup from staging area " + dropzoneSessionPath);
                    }
                }
            } else {
                sync.synchronize(command);
                if (copyDropZone) {
                    this.logger.info("Removing the content server backup copy from drop zone");
                    File dropZoneStaging = new File(dropzoneSessionPath);
                    if (FileUtils.deleteQuietly((File)dropZoneStaging)) {
                        this.logger.info("Content server backup is removed from staging area");
                    } else {
                        this.logger.info("Unable to clean the content server backup from staging area " + dropzoneSessionPath);
                    }
                }
            }
            this.logger.info(RB.getStringResource("ArchiveHandler.archive.complete.txt"));
            if (sharedVaultSpecified && !sharedVaultAccessible) {
                throw new BackupException("Shared vault base is not accessible " + sharedVaultBase, BackupServer.ReturnCode.ARCHIVE_SHARED_VAULT_NOT_ACCESSIBLE.getErrorCode());
            }
            boolean forceDown = command.hasParameter("force");
            if (way.equals("up") && archiveRunEnv.calculateChecksum()) {
                try {
                    String checkSumRoot;
                    Properties p = new Properties();
                    String string = checkSumRoot = deployToDir == null ? deployFromDir : deployToDir;
                    if (ArchiveHandler.fileExists(checkSumRoot)) {
                        this.logger.info("Calculating chechsum for the backup : " + checkSumRoot);
                        String calculatedcheckSum = this.calculateChecksum(new File(checkSumRoot));
                        this.logger.info("Calculated chechsum for the backup : " + calculatedcheckSum + " : " + deployToDir);
                        p.setProperty("checksum", calculatedcheckSum);
                        session.putSessionData("result.properties", p);
                        this.saveBackupDetails(calculatedcheckSum, new File(checkSumRoot));
                        break block39;
                    }
                    this.logger.info("No source directory found for calculating checksum");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.warn("Error calculating checksum : " + e.getMessage());
                    returnCode = BackupServer.ReturnCode.COMMAND_ARCV_CHECKSUM_GENRATION_WARNING.getErrorCode();
                }
            } else if (archiveRunEnv.calculateChecksum() && !forceDown) {
                try {
                    boolean validated = this.validateChecksum(new File(deployToDir));
                    returnCode = !validated ? BackupServer.ReturnCode.COMMAND_ARCV_CHECKSUM_VALIDATION_ERROR.getErrorCode() : returnCode;
                }
                catch (BackupException exception) {
                    throw exception;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("Unable to validate the backup at this moment : " + e.getMessage());
                    returnCode = BackupServer.ReturnCode.COMMAND_ARCV_CHECKSUM_VALIDATION_ERROR.getErrorCode();
                }
            }
        }
        return returnCode;
    }

    private void saveBackupDetails(String checksum, File deployTo) throws IOException {
        BackupContentDetails details = new BackupContentDetails();
        details.setName(deployTo.getName());
        ArrayList<BackupHostDetails> hdetails = new ArrayList<BackupHostDetails>(1);
        details.setHostDetails(hdetails);
        BackupDetailsDAO.getInstance(deployTo).save(checksum);
    }

    private String calculateChecksum(File backupRoot) throws Exception {
        ArchiveValidationManager validationManager = ArchiveValidationManager.getInstance(backupRoot);
        return validationManager.checkSum();
    }

    private boolean validateChecksum(File backupRoot) throws Exception {
        this.logger.info("Validating checksum");
        BackupDetailsDAO dao = BackupDetailsDAO.getInstance(backupRoot);
        String checkSum = dao.loadChecksum();
        this.logger.info("Loaded the checksum : " + checkSum + " : from " + backupRoot.getPath());
        if (!"".equals(checkSum)) {
            ArchiveValidationManager validationManager = ArchiveValidationManager.getInstance(backupRoot);
            return validationManager.validate(checkSum);
        }
        this.logger.info("Unable to find checksum to validate, Proceeding without validating the checksum ");
        return true;
    }

    @Override
    public void doPostProcess(ArchiveRunEnvironment environment, BackupSession session) throws BackupException {
        if (environment.hasSharedVaultBase()) {
            File[] sourceBases;
            String metaSharedVault = session.getSessionData("meta.shared.vault", String.class);
            Properties properties = session.getSessionData("result.properties", Properties.class);
            if (properties == null) {
                properties = new Properties();
                session.putSessionData("result.properties", properties);
            }
            if ((sourceBases = new File(environment.getSharedVaultBase()).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) != null) {
                for (File sourceBase : sourceBases) {
                    String mappedSourceName;
                    if (sourceBase == null || sourceBase.getPath() == null || (mappedSourceName = this.mapSourceBase(sourceBase.getName())) == null) continue;
                    properties.setProperty(mappedSourceName, sourceBase.getPath());
                }
            }
        }
    }

    private String mapSourceBase(String sourceBaseName) {
        if (sourceBaseName.equals("content")) {
            return "contentServer";
        }
        if (sourceBaseName.equals("db")) {
            return "database";
        }
        if (sourceBaseName.equals("levconfig")) {
            return "configDirectories";
        }
        if (sourceBaseName.equals("customdata")) {
            return "customDirectories";
        }
        return null;
    }

    private static boolean fileExists(String file) {
        File f;
        boolean exists = false;
        if (file != null && (f = new File(file)).exists()) {
            File[] lfiles = f.listFiles();
            for (int i = 0; i < lfiles.length; ++i) {
                File child = lfiles[i];
                if (!child.equals(new File(file, "metadataserver"))) {
                    return true;
                }
                exists = false;
            }
        }
        return exists;
    }
}

