/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;

public class XMLFilteredStreamReader {
    private XMLStreamReader baseReader;
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public XMLFilteredStreamReader(InputStream xmlFile) throws BackupException {
        try {
            this.baseReader = this.inputFactory.createXMLStreamReader(xmlFile);
        }
        catch (Exception e) {
            throw new BackupException(e, BackupServer.ReturnCode.ERROR_FORMING_COMMAND_DEFINITIONS.getErrorCode());
        }
    }

    private Queue<QName> convert(String xPath) {
        String[] splitted = xPath.split(Pattern.quote("/"));
        LinkedList<QName> queue = new LinkedList<QName>();
        for (String split : splitted) {
            queue.add(new QName(split));
        }
        return queue;
    }

    public XMLStreamReader filter(String xPath) throws XMLStreamException {
        final Queue<QName> nameQueue = this.convert(xPath);
        return this.inputFactory.createFilteredReader(this.baseReader, new StreamFilter(){
            private boolean process = false;
            private int currentPos = -1;
            private QName leafQname = null;

            @Override
            public boolean accept(XMLStreamReader reader) {
                Location location = reader.getLocation();
                int position = location.getCharacterOffset();
                QName qName = null;
                if (position != this.currentPos) {
                    this.currentPos = position;
                    switch (reader.getEventType()) {
                        case 1: {
                            if (!reader.getName().equals(nameQueue.peek())) break;
                            qName = (QName)nameQueue.poll();
                            if (nameQueue.size() != 1) break;
                            this.process = true;
                            this.leafQname = (QName)nameQueue.peek();
                            break;
                        }
                        case 2: {
                            if (!reader.getName().equals(this.leafQname)) break;
                            this.process = false;
                        }
                    }
                }
                return this.process;
            }
        });
    }

    public static void main(String[] args) throws BackupException, XMLStreamException {
        XMLFilteredStreamReader stReader = new XMLFilteredStreamReader(XMLFilteredStreamReader.class.getResourceAsStream("/com/sas/svcs/backup/client/commandContext.xml"));
        XMLStreamReader xmlPortion = stReader.filter("backupserver/commands/global");
        int eventType = -1;
        XMLEventAllocator allocator = stReader.inputFactory.getEventAllocator();
        while (xmlPortion.hasNext()) {
            eventType = xmlPortion.next();
            if (eventType != 1) continue;
        }
    }
}

