/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Synchronizer {
    private Map<String, String> copy = new LinkedHashMap<String, String>(3);
    private Map<String, String> excludes = new HashMap<String, String>(3);
    private Logger logger = LogManager.getLogger(Synchronizer.class);

    public void addToCopy(String sourceDir, String targetDir, String excludePattern) {
        this.copy.put(sourceDir, targetDir);
        if (excludePattern != null) {
            this.excludes.put(sourceDir, excludePattern);
        }
    }

    public void addToCopy(String sourceDir, String targetDir) {
        this.copy.put(sourceDir, targetDir);
    }

    public void synchronizeUp(File localVault, boolean sharedVault, Command command) throws BackupException {
        this.synchronize(command);
        try {
            if (sharedVault) {
                this.cleanLocalVault(localVault);
            }
        }
        catch (Exception e) {
            throw new BackupException(e, BackupServer.ReturnCode.ARCHIVE_LOCALVAULT_CLEAN_WARNING.getErrorCode());
        }
    }

    public void synchronize(Command command) throws BackupException {
        String antFile = this.createANTFile();
        if (antFile != null) {
            try {
                this.logger.debug(antFile);
                BackupServerUtil.runANTProject(antFile, command);
            }
            catch (Exception exception) {
                throw new BackupException(exception, BackupServer.ReturnCode.ARCHIVE_SYNC_ERROR.getErrorCode());
            }
        }
    }

    public void setPermission(Command command, String permission, String path) throws BackupException {
        String antFile = this.createANTFilePermission(permission, path);
        if (antFile != null) {
            try {
                this.logger.debug(antFile);
                BackupServerUtil.runANTProject(antFile, command);
            }
            catch (Exception exception) {
                this.logger.error("Failed to set permission for " + path, (Throwable)exception);
            }
        }
    }

    private String createANTFile() {
        if (!this.copy.isEmpty()) {
            StringBuilder projectFile = new StringBuilder();
            String startEncode = "<?xml version=\"1.0\"?>";
            String projectFilePrePart = "<project name=\"synchronize\" default=\"sync\"><target name=\"sync\">";
            String projectFilePostPart = "</target></project>";
            String copyCommandPrePart = "<copy todir=\"";
            String excludesPart = " excludes=\"";
            String quote = "\"";
            String excludeDirs = null;
            String copyCommandPostPart = "\" verbose=\"true\" preservelastmodified=\"true\">";
            String filesetCommandPrePart = "<fileset dir=\"";
            String filesetCommandPostPart = "\"/></copy>";
            String target = null;
            projectFile.append(startEncode);
            projectFile.append(projectFilePrePart);
            for (String source : this.copy.keySet()) {
                if (this.exists(source)) {
                    target = this.copy.get(source);
                    projectFile.append(copyCommandPrePart);
                    projectFile.append(target);
                    projectFile.append(copyCommandPostPart);
                    projectFile.append(filesetCommandPrePart);
                    projectFile.append(source);
                    if (this.excludes.containsKey(source)) {
                        excludeDirs = this.excludes.get(source);
                        projectFile.append(quote);
                        projectFile.append(excludesPart);
                        projectFile.append(excludeDirs);
                    }
                    projectFile.append(filesetCommandPostPart);
                    continue;
                }
                this.logger.info("Skipping the copy as the source directory " + source + " does not exists");
            }
            projectFile.append(projectFilePostPart);
            return projectFile.toString();
        }
        return null;
    }

    private String createANTFilePermission(String permission, String path) {
        StringBuilder projectFile = new StringBuilder();
        String startEncode = "<?xml version=\"1.0\"?>";
        String projectFilePrePart = "<project name=\"setPermission\" default=\"permit\">";
        String projectFileConfigTargetPart = "<target name=\"permit\"><chmod perm=\"" + permission + "\" dir=\"" + path + "\" /></target>";
        String projectFilePostPart = "</project>";
        projectFile.append(startEncode);
        projectFile.append(projectFilePrePart);
        projectFile.append(projectFileConfigTargetPart);
        projectFile.append(projectFilePostPart);
        this.logger.info("createANTFileSharedVaultPermission projectFile=" + projectFile);
        return projectFile.toString();
    }

    private boolean exists(String source) {
        if (source != null) {
            return new File(source).exists();
        }
        return false;
    }

    public void cleanLocalVault(File localVault) throws IOException {
        if (localVault != null && localVault.exists()) {
            FileUtils.deleteDirectory((File)localVault);
        }
    }
}

