/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.DefaultCommandEnvironmentPreparator;
import com.sas.svcs.backup.server.RecoverRunEnvironment;
import java.io.File;

public class RecoveryEnvironmentPreparator
extends DefaultCommandEnvironmentPreparator<RecoverRunEnvironment> {
    @Override
    public RecoverRunEnvironment prepare(BackupServer server, BackupSession session) throws BackupException {
        final DefaultCommandEnvironment defaultRunEnvironment = super.prepare(server, session);
        Command command = session.getRequestContext().getCommand();
        String handlerDecider = command.getHandlerdefiningparam();
        String id = command.getParameter("backupid");
        final String sourcePath = defaultRunEnvironment.getVaultBase() + File.separator + id + File.separator + command.getParameter(handlerDecider);
        return new RecoverRunEnvironment(){

            @Override
            public String getLogBase() {
                return defaultRunEnvironment.getLogBase();
            }

            @Override
            public String getLogAreaPath() {
                return defaultRunEnvironment.getLogAreaPath();
            }

            @Override
            public String getStatusAreaPath() {
                return defaultRunEnvironment.getStatusAreaPath();
            }

            @Override
            public String getSourcePath() {
                return sourcePath;
            }

            @Override
            public String getBackupConfigRootPath() {
                return defaultRunEnvironment.getBackupConfigRootPath();
            }

            @Override
            public long getSize() {
                return defaultRunEnvironment.getSize();
            }

            @Override
            public String getVaultBase() {
                return defaultRunEnvironment.getVaultBase();
            }

            @Override
            public BackupJournal getJournal() {
                return defaultRunEnvironment.getJournal();
            }

            @Override
            public String getSharedVaultBase() {
                return defaultRunEnvironment.getSharedVaultBase();
            }

            @Override
            public boolean hasSharedVaultBase() {
                return defaultRunEnvironment.hasSharedVaultBase();
            }

            @Override
            public String getStatusAreaBase() {
                return defaultRunEnvironment.getStatusAreaBase();
            }

            @Override
            public String getHostName() {
                return defaultRunEnvironment.getHostName();
            }

            @Override
            public Command getCommand() {
                return defaultRunEnvironment.getCommand();
            }

            @Override
            public String getSharedVault() {
                return defaultRunEnvironment.getSharedVault();
            }
        };
    }
}

