/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialConfigContext {
    private static InitialConfigContext instance;
    private Properties initialProps;
    Logger logger = LogManager.getLogger(InitialConfigContext.class);

    private InitialConfigContext(String backupWorkspaceDir) throws BackupException {
        String backupConfigBase = backupWorkspaceDir;
        File backBase = BackupServerUtil.presentAndAccessible(backupConfigBase, BackupServer.ReturnCode.SERVER_CONFIGURATION_ERROR);
        File iniFile = new File(backBase, BackupServerConstants.BACKUP_INI_FILE);
        this.initialProps = BackupServerUtil.loadProperties(iniFile);
        this.logger.info("Initial COnfiguration Properties");
        this.logger.info("================================");
        this.logger.info((Object)this.initialProps);
        this.logger.info("================================");
    }

    public static InitialConfigContext getInitialContext() throws BackupException {
        if (instance != null) {
            return instance;
        }
        return null;
    }

    public static InitialConfigContext initializeContext(String backupWorkspaceDir) throws BackupException {
        if (instance == null) {
            instance = new InitialConfigContext(backupWorkspaceDir);
        }
        return instance;
    }

    public Properties getConfigurationProperties() {
        return this.initialProps;
    }

    public String getProperty(String name) {
        return this.initialProps.getProperty(name);
    }

    public String getProperty(String iniParamName, Command command, String commandParamName) {
        String value = this.initialProps.getProperty(iniParamName);
        if (value == null && command != null) {
            value = command.hasParameter(commandParamName) ? command.getParameter(commandParamName) : null;
        }
        return value;
    }
}

