/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.EnvironmentPreparator;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.ConstantsMapper;
import java.io.File;
import java.net.InetAddress;

public class DefaultCommandEnvironmentPreparator<T extends RunEnvironment>
implements EnvironmentPreparator<RunEnvironment> {
    @Override
    public DefaultCommandEnvironment prepare(BackupServer server, BackupSession session) throws BackupException {
        final Command command = session.getRequestContext().getCommand();
        InitialConfigContext config = InitialConfigContext.getInitialContext();
        final String configPath = config.getProperty(BackupServerConstants.BACKUP_CONFIG_BASE);
        final String resultBase = config.getProperty(BackupServerConstants.BACKUP_RESULT_BASE);
        final String hostName = this.getHostName(config);
        String commandName = command.getCommandName();
        String handlerDecider = command.getHandlerdefiningparam();
        final String vaultBase = config.getProperty(BackupServerConstants.BACKUP_VAULT_BASE);
        String tierName = config.getProperty(BackupServerConstants.BACKUP_TIER_NAME);
        String tierAndHostStr = BackupServerUtil.isEmpty(tierName) ? hostName : tierName + "@" + hostName;
        String uniqueId = command.hasParameter("backupid") ? command.getParameter("backupid") : session.getSessionId();
        final String sharedVault = config.getProperty(BackupServerConstants.BACKUP_SHARED_VAULT, command, "sharedvaultbase");
        final boolean hasVaultBase = sharedVault != null && !sharedVault.isEmpty();
        final String sharedVaultBase = hasVaultBase ? sharedVault + "/" + uniqueId + "/" + tierAndHostStr : null;
        File sessionResultBase = new File(resultBase, session.getSessionId());
        File sessionCommandNameResultBase = new File(sessionResultBase, commandName);
        File sessionCommandResultBase = new File(sessionCommandNameResultBase, command.getParameter(handlerDecider));
        final String statusAreaPath = sessionCommandResultBase.getAbsolutePath();
        File resultFile = new File(statusAreaPath, "result.properties");
        if (resultFile.exists()) {
            resultFile.delete();
        }
        sessionCommandResultBase.mkdirs();
        final BackupJournal journal = server.getJournal();
        final String logsBase = config.getProperty(BackupServerConstants.BACKUP_LOG_BASE);
        File sessionLogBase = new File(logsBase, session.getSessionId());
        File sessionCommandLogBase = null;
        sessionCommandLogBase = new File(sessionLogBase, commandName);
        String sessionSubCommandLogBaseName = null;
        String subCommandName = server.getCommandContext().getSubCommandName(command);
        sessionSubCommandLogBaseName = subCommandName != null && !subCommandName.equals("") ? (ConstantsMapper.hasReadablecmdParams(subCommandName) ? ConstantsMapper.getReadablecmdParams(subCommandName) : subCommandName) : (ConstantsMapper.hasReadablecmdParams(command.getCommandName()) ? ConstantsMapper.getReadablecmdParams(command.getCommandName()) : command.getCommandName());
        File sessionSubCommandLogBase = new File(sessionCommandLogBase, sessionSubCommandLogBaseName);
        final String logAreaPath = sessionSubCommandLogBase.getAbsolutePath();
        sessionSubCommandLogBase.mkdirs();
        return new DefaultCommandEnvironment(){

            @Override
            public String getLogBase() {
                return logsBase;
            }

            @Override
            public String getLogAreaPath() {
                return logAreaPath;
            }

            @Override
            public String getStatusAreaPath() {
                return statusAreaPath;
            }

            @Override
            public String getBackupConfigRootPath() {
                return configPath;
            }

            @Override
            public long getSize() {
                return 0L;
            }

            @Override
            public String getVaultBase() {
                return vaultBase;
            }

            @Override
            public BackupJournal getJournal() {
                return journal;
            }

            @Override
            public String getSharedVaultBase() {
                return hasVaultBase ? sharedVaultBase : null;
            }

            @Override
            public boolean hasSharedVaultBase() {
                return hasVaultBase;
            }

            @Override
            public String getStatusAreaBase() {
                return resultBase;
            }

            @Override
            public String getHostName() {
                return hostName;
            }

            @Override
            public Command getCommand() {
                return command;
            }

            @Override
            public String getSharedVault() {
                return sharedVault;
            }
        };
    }

    private String getHostName(InitialConfigContext config) {
        String hostName = config.getProperty(BackupServerConstants.BACKUP_HOST_ALIAS);
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception exception) {}
        } else {
            hostName = hostName.trim();
        }
        return hostName;
    }
}

