/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.client.CommandContext;
import com.sas.svcs.backup.client.XMLConfigCommandContext;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupServerSession;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandGobalParam;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.RB;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.text.Message;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultBackupServer
implements BackupServer {
    private CommandContext context;
    private BackupJournal journal;
    private Logger logger = LogManager.getLogger(DefaultBackupServer.class);

    private void initilize() throws BackupException {
        InputStream stream = DefaultBackupServer.class.getResourceAsStream("/com/sas/svcs/backup/client/commandContext.xml");
        this.context = XMLConfigCommandContext.getXMLConfigCommandContext(stream);
    }

    public DefaultBackupServer() throws BackupException {
        this.initilize();
    }

    @Override
    public boolean alreadyRunning(Command command) {
        BackupJournal journal = this.getJournal(command.getParameter(CommandGobalParam.CONFIGBASE.name().toLowerCase()));
        boolean alreadyRunning = false;
        alreadyRunning = journal.alreadyRunning(BackupJournal.EntryType.RECOVER);
        return alreadyRunning;
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public BackupSession getSession(CommandRequestContext context) throws BackupException {
        BackupJournal journal = this.getJournal(context.getConfigPath());
        String sessionId = context.getSessinId();
        BackupJournal.SessionStatus sessionStatus = journal.getSessionStatus(sessionId);
        BackupServerSession session = new BackupServerSession(context, this, BackupJournal.SessionStatus.NEW.equals((Object)sessionStatus));
        if (sessionStatus == BackupJournal.SessionStatus.INVALIDATED) {
            throw new BackupException(RB.getStringResource("DefaultBackupServer.exception.sesseion.invalidated.txt"), BackupServer.ReturnCode.SESSION_INVALIDATED.getErrorCode());
        }
        return session;
    }

    private BackupJournal getJournal(String configPath) {
        if (this.journal == null) {
            this.journal = new BackupJournal(configPath);
        }
        return this.journal;
    }

    @Override
    public BackupJournal getJournal() {
        return this.journal;
    }

    @Override
    public Properties getInitOptions() {
        return null;
    }

    @Override
    public boolean isBootStrapping(CommandRequestContext command) {
        return command.getCommand().getCommandType().equals((Object)CommandContext.CommandType.CONFIGURE);
    }

    @Override
    public int bootStrap(CommandRequestContext context) throws BackupException {
        int rc;
        block4: {
            CommandContext commandContext = this.getCommandContext();
            RunEnvironment environemnt = null;
            rc = 0;
            try {
                BackupSession session = this.getSession(CommandRequestContext.getRequestContext(context.getCommand()));
                if (session == null || (environemnt = session.getBackupEnvironment()) == null) break block4;
                CommandHandler handler = commandContext.getCommandHandler(context.getCommand());
                if (handler != null) {
                    rc = handler.execute(environemnt, null);
                    break block4;
                }
                throw new BackupException(BackupServer.ReturnCode.NO_COMMNAD_HANDLER.getErrorCode());
            }
            catch (BackupException exception) {
                throw exception;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error(Message.format((String)RB.getStringResource("DefaultBackupServer.exception.running.command.fmt"), (Object)exception.getMessage()));
                throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode());
            }
        }
        return rc;
    }
}

