/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.EnvironmentPreparator;
import com.sas.svcs.backup.server.RB;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.text.Message;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigureEnvironmentPreparator
implements EnvironmentPreparator<RunEnvironment> {
    Logger logger = LogManager.getLogger(ConfigureEnvironmentPreparator.class);

    @Override
    public RunEnvironment prepare(BackupServer server, BackupSession session) throws BackupException {
        final Command command = session.getRequestContext().getCommand();
        String sharedVaultBase = command.getParameter("sharedvaultbase");
        boolean created = this.prepareSharedVault(sharedVaultBase, command);
        if (!created) {
            throw new BackupException(BackupServer.ReturnCode.ARCHIVE_SHARED_VAULT_NOT_ACCESSIBLE.getErrorCode());
        }
        return new RunEnvironment(){

            @Override
            public Command getCommand() {
                return command;
            }
        };
    }

    private boolean prepareSharedVault(String sharedVaultBase, Command command) throws BackupException {
        boolean created = true;
        if (sharedVaultBase != null && !sharedVaultBase.equals("")) {
            File sharedBase = new File(sharedVaultBase);
            if (!sharedBase.exists()) {
                this.logger.error(Message.format((String)RB.getStringResource("ConfigureEnvironmentPreparator.config.error.fmt.txt"), (Object)sharedVaultBase));
                created = false;
            }
            if (created) {
                String dropZone = command.getParameter("configdir") + File.separator + command.getParameter("backupworkspace") + File.separator + "dropzone";
                created = BackupServerUtil.isPathAccessible(dropZone, sharedBase);
                created = created && !this.isLocalEquals(sharedVaultBase, command);
            }
        }
        return created;
    }

    private boolean isLocalEquals(String sharedVaultBase, Command command) throws BackupException {
        String localVault = command.getParameter("configdir") + "/" + command.getParameter("backupworkspace") + "/Vault";
        if (localVault != null) {
            File localVaultFile = new File(localVault);
            File sharedVaultBaseFile = new File(sharedVaultBase);
            return localVaultFile.equals(sharedVaultBaseFile);
        }
        return false;
    }
}

