/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.server.CommandGobalParam;

public class CommandRequestContext {
    private Command command;

    private CommandRequestContext(Command command) {
        this.command = command;
    }

    public static CommandRequestContext getRequestContext(Command command) {
        return new CommandRequestContext(command);
    }

    public String getClientHost() {
        return this.command.getParameter(CommandGobalParam.HOST.name().toLowerCase());
    }

    public boolean runAsync() {
        return this.command.hasParameter(CommandGobalParam.ASYNC.name().toLowerCase());
    }

    public String getUser() {
        return this.command.getParameter(CommandGobalParam.USER.name().toLowerCase());
    }

    public Command getCommand() {
        return this.command;
    }

    public String getConfigPath() {
        return this.command.getParameter(CommandGobalParam.CONFIGBASE.name().toLowerCase());
    }

    public String getSessinId() {
        return this.command.getParameter(CommandGobalParam.SESSIONID.name().toLowerCase());
    }

    public String getSASConfigBasePath() {
        return this.command.getParameter(CommandGobalParam.CONFIGDIR.name().toLowerCase());
    }

    public String getSASHome() {
        return this.command.getParameter(CommandGobalParam.SASHOME.name().toLowerCase());
    }

    public String getSASRoot() {
        return this.command.getParameter(CommandGobalParam.SASROOT.name().toLowerCase());
    }

    public boolean hasEndSessionHint() {
        return "session".equals(this.command.getCommandName()) && this.command.hasParameter("end");
    }
}

