/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.ArchiveRunEnvironment;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.EnvironmentPreparator;
import com.sas.svcs.backup.server.RB;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.ConstantsMapper;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class BackupServerSession
implements BackupSession,
CommandPostProcessor<RunEnvironment> {
    CommandRequestContext requestContext;
    BackupServer server;
    RunEnvironment environment;
    boolean isNew;
    private Map<String, Object> userObjects;
    private Logger logger = LogManager.getLogger(BackupServerSession.class);
    public static final String SCS_SOURCE = "content";
    private BackupException backupException;
    public static final String FILE_SEPERATOR = "/";
    private int lastCommandResult;

    public BackupException getException() {
        return this.backupException;
    }

    public void setBackupException(BackupException backupException) {
        this.backupException = backupException;
    }

    public BackupServerSession(CommandRequestContext context, BackupServer server, boolean isNew) throws BackupException {
        this.requestContext = context;
        this.server = server;
        this.isNew = isNew;
        Command command = context.getCommand();
        EnvironmentPreparator preparator = server.getCommandContext().getEnvironmentPreparator(command);
        try {
            if (preparator != null) {
                this.environment = preparator.prepare(server, this);
            }
        }
        catch (BackupException backupException) {
            try {
                this.logger.error("Error occured while preparing environment ", (Throwable)backupException);
                this.writeCommandResult(command, backupException.getErrorCode());
            }
            catch (BackupException be) {
                this.logger.error("Error occured while writing command result ", (Throwable)be);
            }
            throw backupException;
        }
        this.userObjects = new HashMap<String, Object>();
    }

    @Override
    public int execute(Command command) throws BackupException {
        ExecutorService pool = null;
        BackupJournal journal = null;
        int result = 0;
        this.logger.info(Message.format((String)RB.getStringResource("BackupServerSession.validating.command.fmt"), (Object)command.getCommandLine(true)));
        CommandHandler handler = this.server.getCommandContext().getCommandHandler(command);
        CommandPostProcessor postProcessor = this.server.getCommandContext().getPostProcessor(command);
        this.logger.info(Message.format((String)RB.getStringResource("BackupServerSession.command.validated.successfully.fmt"), (Object)command.getCommandLine(true)));
        if (!this.server.alreadyRunning(command)) {
            journal = this.server.getJournal();
            if (!this.isSessionEnding(command)) {
                journal.addSessionCommandStart(this);
            }
            try {
                if (this.requestContext.runAsync()) {
                    this.logger.info(Message.format((String)RB.getStringResource("BackupServerSession.command.will.run.asynch.fmt"), (Object)command.getCommandName()));
                    pool = Executors.newFixedThreadPool(1);
                    Future<Integer> future = pool.submit(this.server.getCommandContext().getCallableCommandHandler(this));
                } else {
                    this.logger.info(Message.format((String)RB.getStringResource("BackupServerSession.runnig.command.in.same.session.fmt"), (Object)command.getCommandName()));
                    String logFileName = this.getLogFileName(command);
                    Boolean status = this.setAppenderLog4jFile(logFileName);
                    this.logger.debug("Appender log file is set " + status);
                    this.lastCommandResult = handler.execute(this.environment, this);
                }
            }
            catch (BackupException exception) {
                this.logger.error(Message.format((String)RB.getStringResource("BackupServerSession.backupException.running.command.fmt"), (Object)exception.getMessage()));
                this.backupException = exception;
                result = exception.getErrorCode();
                this.lastCommandResult = exception.getErrorCode();
                throw exception;
            }
            catch (Exception exception) {
                this.logger.error(Message.format((String)RB.getStringResource("BackupServerSession.backupException.running.command.fmt"), (Object)exception.getMessage()));
                result = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode();
                this.lastCommandResult = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode();
                this.backupException = new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode());
                throw this.backupException;
            }
            finally {
                if (postProcessor != null) {
                    this.logger.info("Calling post processor : " + postProcessor.getClass().getName());
                    postProcessor.doPostProcess(this.environment, this);
                }
                this.doPostProcess(this.environment, (BackupSession)this);
            }
        }
        return this.lastCommandResult;
    }

    private String getLogFileName(Command command) {
        String logFileName = null;
        String subCommandName = this.server.getCommandContext().getSubCommandName(command);
        logFileName = subCommandName != null && !subCommandName.equals("") ? (ConstantsMapper.hasReadablecmdParams(subCommandName) ? ConstantsMapper.getReadablecmdParams(subCommandName) : subCommandName) : (ConstantsMapper.hasReadablecmdParams(command.getCommandName()) ? ConstantsMapper.getReadablecmdParams(command.getCommandName()) : command.getCommandName());
        return logFileName;
    }

    public Boolean setAppenderLog4jFileNew(String srcType) {
        Boolean status = false;
        String logFileName = srcType + ".log";
        String logpath = ((DefaultCommandEnvironment)this.getBackupEnvironment()).getLogAreaPath();
        String logFile = logpath + File.separator + logFileName;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        FileAppender fa1 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("NewMyLogger1")).withFileName(logFile).setLayout((Layout)PatternLayout.newBuilder().withPattern("%d [%t] %-5p %c - %m%n").build())).setConfiguration(config)).build();
        fa1.start();
        config.addAppender((Appender)fa1);
        ctx.getRootLogger().addAppender(ctx.getConfiguration().getAppender(fa1.getName()));
        ctx.getLogger(this.logger.getName()).addAppender((Appender)fa1);
        ctx.updateLoggers();
        status = true;
        return status;
    }

    public Boolean setAppenderLog4jFile(String srcType) {
        Boolean status = false;
        String logFileName = srcType + ".log";
        String logpath = ((DefaultCommandEnvironment)this.getBackupEnvironment()).getLogAreaPath();
        String logFile = logpath + File.separator + logFileName;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        FileAppender fa = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("mylogger")).withFileName(logFile).setLayout((Layout)PatternLayout.newBuilder().withPattern("%d [%t] %-5p %c - %m%n").build())).setConfiguration(config)).build();
        fa.start();
        config.addAppender((Appender)fa);
        ctx.getRootLogger().addAppender(ctx.getConfiguration().getAppender(fa.getName()));
        ctx.getLogger(this.logger.getName()).addAppender((Appender)fa);
        ctx.updateLoggers();
        status = true;
        return status;
    }

    private void writeCommandResult(Command command, int commandResult) throws BackupException {
        String statusArea = ((DefaultCommandEnvironment)this.environment).getStatusAreaPath();
        File resultFile = new File(statusArea, "result.properties");
        InputStream commandRes = this.readCommandWrittenResults(resultFile);
        FileOutputStream stream = null;
        String targetPath = null;
        FileOutputStream serializedBackupException = null;
        ObjectOutputStream objectOutStream = null;
        if (this.environment instanceof BackupRunEnvironment) {
            targetPath = ((BackupRunEnvironment)this.environment).getTargetPath();
        }
        String logPath = ((DefaultCommandEnvironment)this.environment).getLogAreaPath();
        Properties result = new Properties();
        try {
            if (commandRes != null) {
                result.load(commandRes);
            }
            result.setProperty("log.file.path", logPath);
            result.setProperty("status", String.valueOf(commandResult));
            this.addSessionResultProperties(result);
            if (targetPath != null) {
                result.setProperty("vault.location", targetPath);
                if (command.getParameter("source").equals(SCS_SOURCE)) {
                    this.logger.info("Setting the size of content server backup");
                    String dropZonePath = result.getProperty("scs.Backup.Path");
                    if (dropZonePath != null) {
                        File contentBackup = new File(dropZonePath);
                        this.logger.info("content server backup path : " + dropZonePath);
                        if (contentBackup.exists()) {
                            result.setProperty("size", String.valueOf(BackupServerUtil.getDirectorySize(new File(dropZonePath))));
                        }
                    }
                } else {
                    result.setProperty("size", String.valueOf(BackupServerUtil.getDirectorySize(new File(targetPath))));
                }
            }
            stream = new FileOutputStream(resultFile);
            if (this.backupException != null) {
                this.addDetailsToException(command);
                File backupExceptionFile = new File(statusArea, "BackupException.ser");
                serializedBackupException = new FileOutputStream(backupExceptionFile);
                objectOutStream = new ObjectOutputStream(serializedBackupException);
                objectOutStream.writeObject(this.backupException);
                result.setProperty("backup.exception.object.path", backupExceptionFile.getCanonicalPath());
            }
        }
        catch (IOException exception) {
            throw new BackupException(exception, BackupServer.ReturnCode.ERROR_RESULT_NOT_WRITTEN.getErrorCode());
        }
        finally {
            try {
                if (stream != null) {
                    if (!BackupServerUtil.isEmpty(result)) {
                        result.store(stream, "Result Data for command");
                    }
                    stream.close();
                }
                if (commandRes != null) {
                    commandRes.close();
                }
                if (objectOutStream != null) {
                    objectOutStream.close();
                }
                if (serializedBackupException != null) {
                    serializedBackupException.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addSessionResultProperties(Properties result) {
        Properties userProps = this.getSessionData("result.properties", Properties.class);
        if (userProps != null) {
            this.logger.info("Found session result properties : " + userProps.size());
            result.putAll((Map<?, ?>)userProps);
        }
    }

    private InputStream readCommandWrittenResults(File resultFile) {
        FileInputStream stream = null;
        if (resultFile.exists()) {
            try {
                stream = new FileInputStream(resultFile);
            }
            catch (IOException exception) {
                this.logger.error(RB.getStringResource("BackupServerSession.error.reading.command.results.txt"));
            }
        }
        return stream;
    }

    @Override
    public RunEnvironment getBackupEnvironment() {
        return this.environment;
    }

    @Override
    public CommandRequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public String getSessionId() {
        return this.requestContext.getSessinId();
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    private void endSession() throws BackupException {
        BackupJournal journal = this.server.getJournal();
        if (journal.sessionCommandRunning(this)) {
            throw new BackupException(BackupServer.ReturnCode.SESSION_COMMAND_RUNNING.getErrorCode());
        }
        journal.addSessionEnd(this);
    }

    private boolean isSessionEnding(Command command) {
        return command.getCommandName().equals("session") && command.hasParameter("end");
    }

    @Override
    public List<BackupJournal.JournalEntry> getSessionCommands() {
        BackupJournal journal = this.server.getJournal();
        return journal.getSessionCommands(this);
    }

    @Override
    public void doPostProcess(RunEnvironment environment, BackupSession session) throws BackupException {
        boolean endSession;
        BackupJournal journal = this.server.getJournal();
        Command commad = session.getBackupEnvironment().getCommand();
        if (!commad.getCommandName().equals("session")) {
            journal.addSessionCommandEnd(this);
        }
        if (endSession = session.getRequestContext().hasEndSessionHint()) {
            this.endSession();
        }
        this.writeCommandResult(commad, this.lastCommandResult);
        if (commad.getCommandName().equals("archive")) {
            this.setAppenderLog4jFileNew("ContentDetails");
            String vaultPath = null;
            vaultPath = ((DefaultCommandEnvironment)environment).getSharedVaultBase() != null ? ((DefaultCommandEnvironment)environment).getSharedVaultBase() + FILE_SEPERATOR + SCS_SOURCE : ((DefaultCommandEnvironment)environment).getVaultBase() + FILE_SEPERATOR + session.getSessionId() + FILE_SEPERATOR + SCS_SOURCE;
            this.logger.debug("Writing the content details from " + vaultPath);
            this.SCSContentFilesSubDirectories(vaultPath);
        }
    }

    @Override
    public void putSessionData(String key, Object value) {
        this.userObjects.put(key, value);
    }

    @Override
    public <T> T getSessionData(String key, Class<T> t) {
        if (this.userObjects.containsKey(key)) {
            return (T)this.userObjects.get(key);
        }
        return null;
    }

    @Override
    public void removeSessionData(String key) {
        this.userObjects.remove(key);
    }

    @Override
    public boolean validate(Command command) throws BackupException {
        if (this.environment instanceof ArchiveRunEnvironment) {
            ArchiveRunEnvironment environ = (ArchiveRunEnvironment)this.environment;
            BackupServerUtil.presentAndAccessible(environ.getBackupConfigRootPath());
            if (!(command.getCommandName().equals("archive") || command.hasParameter("way") && command.getParameter("way").equals("down") || !command.hasParameter("backupid"))) {
                BackupServerUtil.presentAndAccessible(environ.getSourcePath(), BackupServer.ReturnCode.SOURCE_NOT_PRESENTACCESSIBLE);
            }
            return true;
        }
        return false;
    }

    private void addDetailsToException(Command command) {
        if (this.backupException != null) {
            String originalCommand;
            String logpath;
            String logFileName;
            String operationType = command.getCommandType().toString();
            if (!BackupServerUtil.isEmpty(operationType)) {
                this.backupException.setErrorInfo("operationType", operationType.toLowerCase());
            }
            if (!BackupServerUtil.isEmpty(logFileName = this.getLogFileName(command) + ".log")) {
                this.backupException.setErrorInfo("logName", logFileName);
            }
            if (!BackupServerUtil.isEmpty(logpath = ((DefaultCommandEnvironment)this.getBackupEnvironment()).getLogAreaPath())) {
                this.backupException.setErrorInfo("logFileLocation", logpath);
            }
            if (!BackupServerUtil.isEmpty(originalCommand = command.getCommandLine(true))) {
                this.backupException.setErrorInfo("originalMessage", originalCommand);
            }
        }
    }

    private void SCSContentFilesSubDirectories(String directoryName) {
        File[] fList;
        File directory;
        if (directoryName != null && (directory = new File(directoryName)).exists() && (fList = directory.listFiles()) != null && !BackupServerUtil.isEmpty(fList)) {
            for (File file : fList) {
                if (file.isFile()) {
                    this.logger.info("FilePath@ " + file.getAbsolutePath());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.SCSContentFilesSubDirectories(file.getAbsolutePath());
            }
        }
    }
}

