/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.server.BackupSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public final class BackupJournal {
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String sessionId;
    private Map<String, List<JournalEntry>> entries;
    private File journalFile;
    private File journalArchive;

    public BackupJournal(String journalPath) {
        this.journalFile = new File(journalPath + "/backup.journal");
        this.journalArchive = new File(journalPath + "/backup.archive");
        this.entries = new HashMap<String, List<JournalEntry>>();
        try {
            if (!this.journalFile.exists()) {
                this.journalFile.createNewFile();
            }
            if (!this.journalArchive.exists()) {
                this.journalArchive.createNewFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addSessionStart(BackupSession session) {
        JournalEntry entry = new JournalEntry();
        entry.sessionId = session.getSessionId();
        entry.startTime = new SimpleDateFormat(this.dateFormat).format(new Date());
        entry.ended = false;
        entry.entryName = session.getSessionId();
        entry.entryType = EntryType.SESSION;
        entry.endTime = "@@";
        entry.flushed = false;
        this.pushEntry(entry);
        this.flushEntry(entry);
        entry.flushed = true;
    }

    private String convert(JournalEntry entry) {
        StringBuilder builder = new StringBuilder();
        builder.append(entry.sessionId);
        builder.append("#!");
        builder.append(entry.entryName);
        builder.append("#!");
        builder.append(entry.entryType.toString());
        builder.append("#!");
        builder.append(entry.startTime);
        builder.append("#!");
        builder.append(entry.endTime);
        builder.append("#!");
        builder.append(Boolean.toString(entry.ended));
        return builder.toString();
    }

    public void addSessionEnd(BackupSession session) {
        JournalEntry entry = this.getSessionEntry(session.getSessionId());
        if (entry != null) {
            entry.ended = true;
            entry.endTime = new SimpleDateFormat(this.dateFormat).format(new Date());
            this.flushEntries(this.getAll());
        }
    }

    public void addSessionCommandStart(BackupSession session) {
        JournalEntry entry = new JournalEntry();
        entry.sessionId = session.getSessionId();
        entry.startTime = new SimpleDateFormat(this.dateFormat).format(new Date());
        entry.ended = false;
        entry.entryName = this.getEntryName(session);
        entry.entryType = EntryType.valueOf(session.getRequestContext().getCommand().getCommandName().toUpperCase());
        entry.endTime = "@@";
        entry.flushed = false;
        this.pushEntry(entry);
        this.flushEntry(entry);
        entry.flushed = true;
    }

    private String getEntryName(BackupSession session) {
        String entryName = null;
        Command command = session.getRequestContext().getCommand();
        entryName = command.getCommandName().equals("session") ? (command.hasParameter("start") ? "start" : "end") : session.getRequestContext().getCommand().getParameter("source");
        return entryName;
    }

    public void addSessionCommandEnd(BackupSession session) {
        JournalEntry commandEntry = this.getSessionCommandEntry(session);
        if (commandEntry != null) {
            commandEntry.ended = true;
            commandEntry.endTime = new SimpleDateFormat(this.dateFormat).format(new Date());
            this.flushEntries(this.getAll());
        }
    }

    private JournalEntry getSessionCommandEntry(BackupSession session) {
        this.readJournal();
        Command command = session.getRequestContext().getCommand();
        String sessionId = session.getSessionId();
        EntryType commandEntryType = EntryType.valueOf(command.getCommandName().toUpperCase());
        String entryName = command.getParameter("source");
        if (this.entries.containsKey(sessionId)) {
            List<JournalEntry> journalEntries = this.entries.get(sessionId);
            for (JournalEntry entry : journalEntries) {
                if (!entry.entryType.equals((Object)commandEntryType) || entry.ended || !entryName.equals("") && (entryName.equals("") || !entryName.equals(entry.entryName))) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEntry(JournalEntry entry) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.journalFile, true));
            writer.append(this.convert(entry));
            writer.newLine();
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException excption) {
            excption.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private void flushEntries(List<JournalEntry> entries) {
        this.flushEntries(entries, this.journalFile, false);
    }

    private void flushArchivedEntries(List<JournalEntry> entries) {
        this.flushEntries(entries, this.journalArchive, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void flushEntries(List<JournalEntry> entries, File file, boolean append) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file, append));
            for (JournalEntry entry : entries) {
                writer.append(this.convert(entry));
                writer.newLine();
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(writer);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public boolean sessionCommandRunning(BackupSession session) {
        List<JournalEntry> sessionCommands = this.getSessionCommands(session);
        if (sessionCommands != null) {
            for (JournalEntry entry : sessionCommands) {
                if (entry.ended) continue;
                return true;
            }
        }
        return false;
    }

    public List<JournalEntry> getSessionCommands(BackupSession session) {
        this.readJournal();
        ArrayList<JournalEntry> commands = null;
        if (this.entries.containsKey(this.sessionId)) {
            List<JournalEntry> journalEntries = this.entries.get(this.sessionId);
            commands = new ArrayList<JournalEntry>(journalEntries.size());
            for (JournalEntry entry : journalEntries) {
                if (entry.entryType.equals((Object)EntryType.SESSION)) continue;
                commands.add(entry);
            }
        }
        return commands;
    }

    private JournalEntry getSessionEntry(String sessionId) {
        this.readJournal();
        if (this.entries.containsKey(sessionId)) {
            List<JournalEntry> journalEntries = this.entries.get(sessionId);
            for (JournalEntry entry : journalEntries) {
                if (!entry.entryType.equals((Object)EntryType.SESSION)) continue;
                return entry;
            }
        }
        return null;
    }

    public SessionStatus getSessionStatus(String sessionId) {
        JournalEntry entry = this.getSessionEntry(sessionId);
        if (entry != null) {
            return entry.ended ? SessionStatus.INVALIDATED : SessionStatus.RUNNING;
        }
        return SessionStatus.NEW;
    }

    public boolean alreadyRunning(Command command) {
        EntryType type = this.convert(command);
        String source = command.getParameter("source");
        return this.alreadyRunning(type, source);
    }

    public boolean alreadyRunning(EntryType type) {
        return this.alreadyRunning(type, null);
    }

    private boolean alreadyRunning(EntryType type, String source) {
        List<JournalEntry> entries = this.getRunningCommands();
        boolean alreadyRunning = false;
        if (entries != null) {
            for (JournalEntry entry : entries) {
                if (entry.entryType != type || !this.checkSource(type)) continue;
                alreadyRunning = entry.entryName.equals(source) && !entry.ended;
                return alreadyRunning;
            }
        }
        return alreadyRunning;
    }

    private EntryType convert(Command command) {
        return EntryType.valueOf(command.getCommandName().toUpperCase());
    }

    private boolean checkSource(EntryType type) {
        return type.equals((Object)EntryType.BACKUP);
    }

    private List<JournalEntry> getRunningCommands() {
        this.readJournal();
        List<JournalEntry> all = this.getAll();
        LinkedList<JournalEntry> running = new LinkedList<JournalEntry>();
        for (JournalEntry entry : all) {
            if (this.isSessionTypeEntry(entry) || entry.ended) continue;
            running.add(entry);
        }
        return running;
    }

    private boolean isSessionTypeEntry(JournalEntry entry) {
        return entry.entryType.equals((Object)EntryType.SESSION);
    }

    private List<JournalEntry> getAll() {
        Set<String> sessions = this.entries.keySet();
        ArrayList<JournalEntry> allEntries = new ArrayList<JournalEntry>();
        if (sessions != null) {
            for (String sessionId : sessions) {
                allEntries.addAll((Collection<JournalEntry>)this.entries.get(sessionId));
            }
        }
        return allEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournal() {
        BufferedReader reader = null;
        if (this.entries.size() > 0) {
            this.entries.clear();
        }
        try {
            reader = new BufferedReader(new FileReader(this.journalFile));
            String line = null;
            JournalEntry entry = null;
            while ((line = reader.readLine()) != null) {
                entry = this.processLine(line);
                if (entry == null) continue;
                this.pushEntry(entry);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void pushEntry(JournalEntry entry) {
        if (this.entries.containsKey(entry.sessionId)) {
            this.entries.get(entry.sessionId).add(entry);
        } else {
            LinkedList<JournalEntry> sessionEntries = new LinkedList<JournalEntry>();
            sessionEntries.add(entry);
            this.entries.put(entry.sessionId, sessionEntries);
        }
    }

    private JournalEntry processLine(String line) {
        String[] tokens = line.split(Pattern.quote("#!"));
        JournalEntry entry = null;
        if (tokens.length > 5) {
            entry = new JournalEntry();
            entry.sessionId = tokens[0];
            entry.entryName = tokens[1];
            entry.entryType = EntryType.valueOf(tokens[2]);
            entry.startTime = tokens[3];
            entry.endTime = tokens[4];
            entry.ended = Boolean.valueOf(tokens[5]);
            entry.flushed = true;
        }
        return entry;
    }

    public List<JournalEntry> getBeforeDate(Date date, EntryType type) {
        this.readJournal();
        List<JournalEntry> filteredEntries = Collections.emptyList();
        if (this.entries != null) {
            Date entryDate = null;
            List<JournalEntry> entries = this.getAll();
            filteredEntries = new ArrayList<JournalEntry>();
            for (JournalEntry entry : entries) {
                if (!entry.ended || !entry.entryType.equals((Object)type)) continue;
                try {
                    entryDate = new SimpleDateFormat(this.dateFormat).parse(entry.endTime);
                    if (!entryDate.before(date)) continue;
                    filteredEntries.add(entry);
                }
                catch (ParseException parseException) {}
            }
        }
        return filteredEntries;
    }

    public void archive(List<String> sessionIds) {
        if (sessionIds != null && sessionIds.size() > 0) {
            this.readJournal();
            List<JournalEntry> entries = this.getAll();
            ArrayList<JournalEntry> journalEntries = new ArrayList<JournalEntry>(entries.size());
            ArrayList<JournalEntry> archived = new ArrayList<JournalEntry>(sessionIds.size());
            String sessionId = null;
            int index = 0;
            for (JournalEntry entry : entries) {
                sessionId = entry.sessionId;
                if (sessionIds.contains(sessionId)) {
                    archived.add(entry);
                } else {
                    journalEntries.add(entry);
                }
                ++index;
            }
            this.flushEntries(journalEntries);
            this.flushArchivedEntries(archived);
        }
    }

    public class JournalEntry {
        private String sessionId;
        private String entryName;
        private EntryType entryType;
        private String startTime;
        private String endTime;
        private boolean ended;
        private boolean flushed;

        public String getSessionId() {
            return this.sessionId;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public EntryType getEntryType() {
            return this.entryType;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public boolean isEnded() {
            return this.ended;
        }

        public boolean isFlushed() {
            return this.flushed;
        }
    }

    public static enum EntryType {
        BACKUP,
        RECOVER,
        PURGE,
        SESSION,
        ARCHIVE,
        UTIL,
        POSTRECOVER;

    }

    public static enum SessionStatus {
        NEW,
        RUNNING,
        INVALIDATED;

    }
}

