/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.DefaultCommandEnvironmentPreparator;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import java.io.File;

public class BackupEnvironmentPreparator
extends DefaultCommandEnvironmentPreparator<BackupRunEnvironment> {
    @Override
    public BackupRunEnvironment prepare(BackupServer server, BackupSession session) throws BackupException {
        final DefaultCommandEnvironment defaultRunEnvironment = super.prepare(server, session);
        Command command = session.getRequestContext().getCommand();
        InitialConfigContext config = InitialConfigContext.getInitialContext();
        final String vaultBase = config.getProperty(BackupServerConstants.BACKUP_VAULT_BASE);
        String handlerDecider = command.getHandlerdefiningparam();
        File sessionVaultBase = new File(vaultBase, session.getSessionId());
        File sessionCommandVaultBase = new File(sessionVaultBase, command.getParameter(handlerDecider));
        final String targetPath = sessionCommandVaultBase.getAbsolutePath();
        sessionCommandVaultBase.mkdirs();
        return new BackupRunEnvironment(){

            @Override
            public String getLogBase() {
                return defaultRunEnvironment.getLogBase();
            }

            @Override
            public String getLogAreaPath() {
                return defaultRunEnvironment.getLogAreaPath();
            }

            @Override
            public String getTargetPath() {
                return targetPath;
            }

            @Override
            public String getStatusAreaPath() {
                return defaultRunEnvironment.getStatusAreaPath();
            }

            @Override
            public String getBackupConfigRootPath() {
                return defaultRunEnvironment.getBackupConfigRootPath();
            }

            @Override
            public long getSize() {
                return defaultRunEnvironment.getSize();
            }

            @Override
            public String getVaultBase() {
                return vaultBase;
            }

            @Override
            public BackupJournal getJournal() {
                return defaultRunEnvironment.getJournal();
            }

            @Override
            public String getSharedVaultBase() {
                return defaultRunEnvironment.getSharedVaultBase();
            }

            @Override
            public boolean hasSharedVaultBase() {
                return defaultRunEnvironment.hasSharedVaultBase();
            }

            @Override
            public String getStatusAreaBase() {
                return defaultRunEnvironment.getStatusAreaBase();
            }

            @Override
            public String getHostName() {
                return defaultRunEnvironment.getHostName();
            }

            @Override
            public Command getCommand() {
                return defaultRunEnvironment.getCommand();
            }

            @Override
            public String getSharedVault() {
                return defaultRunEnvironment.getSharedVault();
            }
        };
    }
}

