/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.ArchiveRunEnvironment;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.DefaultCommandEnvironmentPreparator;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;

public class ArchiveEnvironmentPreparator
extends DefaultCommandEnvironmentPreparator<ArchiveRunEnvironment> {
    @Override
    public ArchiveRunEnvironment prepare(BackupServer server, BackupSession session) throws BackupException {
        final DefaultCommandEnvironment defaultRunEnvironment = super.prepare(server, session);
        Command command = session.getRequestContext().getCommand();
        String handlerDecider = command.getHandlerdefiningparam();
        if (this.requireMetaStagingValidation(command) && this.metaStagingNotAccessible(command)) {
            throw new BackupException(BackupServer.ReturnCode.ARCHIVE_METASTAGING_NA_WARNING.getErrorCode());
        }
        String id = command.getParameter("backupid");
        final String sourcePath = defaultRunEnvironment.getVaultBase() + File.separator + id + File.separator + command.getParameter(handlerDecider);
        InitialConfigContext config = InitialConfigContext.getInitialContext();
        final String calculateChecksum = config.getProperty("backupserver.calculate.checksum");
        return new ArchiveRunEnvironment(){

            @Override
            public String getLogBase() {
                return defaultRunEnvironment.getLogBase();
            }

            @Override
            public String getLogAreaPath() {
                return defaultRunEnvironment.getLogAreaPath();
            }

            @Override
            public String getSourcePath() {
                return sourcePath;
            }

            @Override
            public String getStatusAreaPath() {
                return defaultRunEnvironment.getStatusAreaPath();
            }

            @Override
            public String getBackupConfigRootPath() {
                return defaultRunEnvironment.getBackupConfigRootPath();
            }

            @Override
            public long getSize() {
                return defaultRunEnvironment.getSize();
            }

            @Override
            public String getVaultBase() {
                return defaultRunEnvironment.getVaultBase();
            }

            @Override
            public BackupJournal getJournal() {
                return defaultRunEnvironment.getJournal();
            }

            @Override
            public String getSharedVaultBase() {
                return defaultRunEnvironment.getSharedVaultBase();
            }

            @Override
            public boolean hasSharedVaultBase() {
                return defaultRunEnvironment.hasSharedVaultBase();
            }

            @Override
            public String getStatusAreaBase() {
                return defaultRunEnvironment.getStatusAreaBase();
            }

            @Override
            public String getHostName() {
                return defaultRunEnvironment.getHostName();
            }

            @Override
            public Command getCommand() {
                return defaultRunEnvironment.getCommand();
            }

            @Override
            public boolean calculateChecksum() {
                return calculateChecksum != null ? Boolean.parseBoolean(calculateChecksum) : true;
            }

            @Override
            public String getSharedVault() {
                return defaultRunEnvironment.getSharedVault();
            }
        };
    }

    private boolean requireMetaStagingValidation(Command command) {
        return command.hasParameter("metastaging");
    }

    private boolean metaStagingNotAccessible(Command command) {
        String metaStaging = command.getParameter("metastaging");
        if (metaStaging != null) {
            File file = new File(metaStaging);
            return file.canRead();
        }
        return true;
    }

    private boolean prepareSharedVault(String dropzone, String sharedVaultBase) {
        boolean created = true;
        if (sharedVaultBase != null) {
            File sharedBase = new File(sharedVaultBase);
            created = !sharedBase.exists() ? sharedBase.mkdirs() : BackupServerUtil.isPathAccessible(dropzone, sharedBase);
        }
        return created;
    }
}

