/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.client.CommandContext;
import com.sas.svcs.backup.client.RB;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.AsyncCommandHandler;
import com.sas.svcs.backup.server.BackupEnvironmentPreparator;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CallableCommandHandler;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.EnvironmentPreparator;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.RunEnvironment;
import com.sas.svcs.backup.server.util.ConstantsMapper;
import com.sas.text.Message;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigCommandContext
implements CommandContext {
    private static CommandContext commandContext;
    private Map<String, CommandDefinition> cDefs;
    private Map<CommandContext.CommandType, Class<? extends EnvironmentPreparator>> envPreprators;
    private Document cmdDoc;
    Logger logger = LogManager.getLogger(XMLConfigCommandContext.class);

    @Override
    public String getSubCommandName(Command command) {
        String cmdName = command.getCommandName();
        CommandDefinition cmdDefinition = this.cDefs.get(cmdName);
        String subCmdName = null;
        if (cmdDefinition.hasSubCommands()) {
            Map cmdDefProperties = cmdDefinition.getProps();
            String handlerDefiningParam = null;
            if (cmdDefProperties != null && (handlerDefiningParam = (String)cmdDefProperties.get("handlerdefiningparam")) != null) {
                subCmdName = command.getParameter(handlerDefiningParam);
            }
        }
        return subCmdName;
    }

    private Map<String, CommandDefinition> populate(Node cmds) {
        Node glblParamsList = this.SearchForChildNode(cmds, "global");
        HashMap<String, ParamNode> GlblparamNodes = new HashMap<String, ParamNode>();
        if (glblParamsList != null) {
            ArrayList<Node> params = this.SearchForChildrenNodeByName(glblParamsList, "param");
            for (Node param : params) {
                String prmName = this.getAttribValue(param, "name");
                Boolean isRequired = Boolean.valueOf(this.getAttribValue(param, "required"));
                ParamNode paramNode = new ParamNode(prmName, isRequired);
                GlblparamNodes.put(prmName, paramNode);
            }
        }
        ArrayList<Node> cmdList = this.SearchForChildrenNodeByName(cmds, "command");
        HashMap<String, CommandDefinition> cmdDefs = new HashMap<String, CommandDefinition>();
        for (Node cmd : cmdList) {
            CommandDefinition cmdDef = new CommandDefinition();
            cmdDef.setGlobalParams(GlblparamNodes);
            this.populateCommand(cmdDef, cmd);
            cmdDefs.put(this.getAttribValue(cmd, "name"), cmdDef);
        }
        return cmdDefs;
    }

    private void populateCommand(CommandDefinition cmdDef, Node cmd) {
        String cmdName = this.getAttribValue(cmd, "name");
        ArrayList<Node> params = this.SearchForChildrenNodeByName(cmd, "param");
        HashMap<String, ParamNode> paramNodes = new HashMap<String, ParamNode>();
        String cmdHandler = this.getAttribValue(cmd, "handler");
        String cmdPostProcessor = this.getAttribValue(cmd, "postprocessor");
        String envPreparator = this.getAttribValue(cmd, "environmentPreparator");
        NamedNodeMap cmdAttributes = cmd.getAttributes();
        HashMap<String, String> cmdProps = new HashMap<String, String>();
        for (int i = 0; i < cmdAttributes.getLength(); ++i) {
            Node attribNode = cmdAttributes.item(i);
            if (attribNode == null) continue;
            cmdProps.put(attribNode.getNodeName(), attribNode.getNodeValue());
        }
        for (Node param : params) {
            String prmName = this.getAttribValue(param, "name");
            Boolean isRequired = Boolean.valueOf(this.getAttribValue(param, "required"));
            ParamNode paramNode = new ParamNode(prmName, isRequired);
            paramNodes.put(prmName, paramNode);
            String paramType = this.getAttribValue(param, "type");
            if (paramType == null || !paramType.equals("subcommand")) continue;
            cmdDef.setSubCommands(this.populate(param));
        }
        cmdDef.setProps(cmdProps);
        if (cmdHandler != null && !cmdHandler.equals("")) {
            cmdDef.setCommandHandlerClass(cmdHandler);
        }
        if (envPreparator != null && !envPreparator.equals("")) {
            cmdDef.setEnvironmentPreparator(envPreparator);
        }
        if (paramNodes != null && !paramNodes.isEmpty()) {
            cmdDef.setParams(paramNodes);
        }
        if (cmdName != null && !cmdName.equals("")) {
            cmdDef.setName(cmdName);
        }
        if (cmdPostProcessor != null && !cmdPostProcessor.equals("")) {
            cmdDef.setCommandPostProcessorClass(cmdPostProcessor);
        }
        cmdDef.buildDescriptorNode(cmdDef);
    }

    private XMLConfigCommandContext(InputStream commandContextConfig) throws BackupException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.cmdDoc = docBuilder.parse(commandContextConfig);
            this.cDefs = new HashMap<String, CommandDefinition>();
            Node rootNode = this.getRootNode(this.cmdDoc);
            Node cmds = this.SearchForChildNode(rootNode, "commands");
            this.cDefs = this.populate(cmds);
            this.envPreprators = new HashMap<CommandContext.CommandType, Class<? extends EnvironmentPreparator>>(3);
            this.envPreprators.put(CommandContext.CommandType.BACKUP, BackupEnvironmentPreparator.class);
            this.envPreprators.put(CommandContext.CommandType.RECOVER, BackupEnvironmentPreparator.class);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new BackupException(e, BackupServer.ReturnCode.ERROR_FORMING_COMMAND_DEFINITIONS.getErrorCode());
        }
    }

    public static CommandContext getXMLConfigCommandContext(InputStream configPath) throws BackupException {
        if (commandContext == null) {
            commandContext = new XMLConfigCommandContext(configPath);
        }
        return commandContext;
    }

    public ArrayList<Node> SearchForChildrenNodeByName(Node rootNode, String NodeNameTobeSearched) {
        NodeList childs = rootNode.getChildNodes();
        ArrayList<Node> childrenByName = new ArrayList<Node>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            String nodeName = child.getNodeName();
            if (nodeName == null || !nodeName.equals(NodeNameTobeSearched)) continue;
            childrenByName.add(child);
        }
        return childrenByName;
    }

    public Node getRootNode(Document doc) {
        if (doc != null) {
            return doc.getFirstChild();
        }
        return null;
    }

    public Node SearchForChildNode(Node rootNode, String NodeNameTobeSearched) {
        NodeList childs = rootNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node nestedChild;
            Node child = childs.item(i);
            String nodeName = child.getNodeName();
            if (nodeName != null && nodeName.equals(NodeNameTobeSearched)) {
                return child;
            }
            if (!child.hasChildNodes() || (nestedChild = this.SearchForChildNode(child, NodeNameTobeSearched)) == null) continue;
            return nestedChild;
        }
        return null;
    }

    public String getAttribValue(Node node, String attribName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap attribs = node.getAttributes();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attrib = attribs.item(i);
                if (!attrib.getNodeName().equals(attribName)) continue;
                return attrib.getNodeValue();
            }
        }
        return null;
    }

    @Override
    public Command getCommandTemplate(String commandName, String filter) throws BackupException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Command commandTemplate = null;
        String cmdName = null;
        CommandDefinition cdef = this.cDefs.get(commandName);
        String handlerParam = (String)cdef.getProps().get("handlerdefiningparam");
        if (cdef != null) {
            HashSet params = new HashSet();
            cmdName = commandName;
            cdef.collectOptionalParameters(params);
            cdef.collectRequiredParameters(params);
            Map subCmds = cdef.getSubCommands();
            if (subCmds != null && subCmds.size() > 0 && subCmds.containsKey(filter)) {
                CommandDefinition filteredCmd = (CommandDefinition)subCmds.get(filter);
                filteredCmd.collectOptionalParameters(params);
                filteredCmd.collectRequiredParameters(params);
            }
            for (String paramName : params) {
                properties.put(paramName, "");
            }
            commandTemplate = Command.getInstance(cmdName, handlerParam, properties, this.getCommandType(cmdName));
        }
        return commandTemplate;
    }

    private CommandContext.CommandType getCommandType(String commandName) {
        CommandContext.CommandType commandType = CommandContext.CommandType.valueOf(commandName.toUpperCase());
        return commandType == null ? CommandContext.CommandType.ADMIN : commandType;
    }

    public void getGlobalParamsFromINI(String commandName, Map<String, String> properties) throws BackupException {
        String backupWorkspaceDir = properties.get("configbase");
        InitialConfigContext config = InitialConfigContext.initializeContext(backupWorkspaceDir);
        CommandDefinition cmdDef = this.cDefs.get(commandName);
        if (cmdDef == null) {
            this.logger.error("Invalid Command Name!");
        }
        Map allParmas = cmdDef.getGlobalParams();
        Map cmdParams = cmdDef.getParams();
        if (cmdParams != null) {
            allParmas.putAll(cmdParams);
        }
        if (cmdDef.hasSubCommands()) {
            String cmdDefiningProperty = (String)cmdDef.getProps().get("handlerdefiningparam");
            String subCmdName = properties.get(cmdDefiningProperty);
            Map subCmds = cmdDef.getSubCommands();
            CommandDefinition subCommand = (CommandDefinition)subCmds.get(subCmdName);
            Map subCmdParams = subCommand.getParams();
            if (subCmdParams != null) {
                allParmas.putAll(subCmdParams);
            }
        }
        Set allParamsSet = allParmas.keySet();
        for (String param : allParamsSet) {
            String readablePropertyValue = ConstantsMapper.getReadablecmdParams(param);
            if (readablePropertyValue == null || config.getProperty(readablePropertyValue) == null || properties.containsKey(param)) continue;
            properties.put(param, config.getProperty(readablePropertyValue));
        }
    }

    @Override
    public Command parseCommand(String[] command) throws BackupException {
        String handlerParam;
        Command cmd;
        CommandDefinition cmdDef;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String commandName = null;
        String param = null;
        String value = null;
        if (command != null && command.length > 0) {
            int prevToken = 0;
            int index = 1;
            for (index = 0; index < command.length; ++index) {
                String token = command[index];
                if (commandName == null) {
                    commandName = token.trim().toLowerCase();
                } else if (token.startsWith("-")) {
                    param = token.substring(1);
                    ++prevToken;
                } else {
                    value = token;
                    if ("emptystring".equals(token)) {
                        value = "";
                    }
                    prevToken = 0;
                }
                if (prevToken == 2) {
                    token = command[--index];
                    param = token.substring(1);
                }
                if ((param == null || value == null) && (param == null || value != null || prevToken != 2 && index != command.length - 1)) continue;
                properties.put(param.toLowerCase(), value);
                param = null;
                value = null;
            }
        }
        if ((cmdDef = this.cDefs.get(commandName)) == null) {
            this.logger.error("Invalid Command Name!");
            throw new BackupException(new IllegalArgumentException(), BackupServer.ReturnCode.ERROR_INVALID_COMMAND.getErrorCode());
        }
        if (!commandName.equalsIgnoreCase("configure")) {
            this.getGlobalParamsFromINI(commandName, properties);
        }
        if (!this.isValidCommand(cmd = Command.getInstance(commandName, handlerParam = (String)cmdDef.getProps().get("handlerdefiningparam"), properties, this.getCommandType(commandName)), command)) {
            this.logger.error("Command is INVALID");
            throw new BackupException(new IllegalArgumentException(), BackupServer.ReturnCode.ERROR_INVALID_COMMAND.getErrorCode());
        }
        return cmd;
    }

    public boolean isValidCommand(Command cmd, String[] splittedCommand) throws BackupException {
        ParamsQueue q;
        CommandDefinition cDefinition;
        boolean b = false;
        if (this.cDefs.containsKey(cmd.getCommandName())) {
            cDefinition = this.cDefs.get(cmd.getCommandName());
            String[] parts = splittedCommand;
            q = new ParamsQueue();
            Set defParams = cDefinition.getAllDefinedParams();
            Map<String, String> commandProperties = cmd.getParamaters();
            for (String key : commandProperties.keySet()) {
                if (!defParams.contains(key) || q.containsParam(key)) {
                    this.logger.error(Message.format((String)RB.getStringResource("XMLConfigCommandContext.command.invalid.arguments.missing.fmt"), (Object)key));
                    return false;
                }
                String value = commandProperties.get(key);
                q.pushParam(key);
                q.pushParam(value);
            }
        } else {
            throw new BackupException(new IllegalArgumentException(), BackupServer.ReturnCode.ERROR_INVALID_COMMAND.getErrorCode());
        }
        b = this.validAgainstDescriptor(q, cDefinition.descNode);
        return b;
    }

    private boolean validAgainstDescriptor(ParamsQueue q, CommandDefinition.DescriptorNode descNode) {
        Map reqparams = descNode.requiredChildrenParams;
        Map optparams = descNode.optionalChildrenParams;
        if (reqparams != null && !this.checkForRequiredParams(q, reqparams)) {
            return false;
        }
        if (optparams != null) {
            this.checkForOptionalParams(q, optparams);
        }
        return q.isEmpty();
    }

    private boolean checkForRequiredParams(ParamsQueue q, Map<String, CommandDefinition.DescriptorNode> params) {
        for (String paramName : params.keySet()) {
            String value;
            CommandDefinition.DescriptorNode paramDescNode = params.get(paramName);
            Map paramsListToParse = null;
            paramsListToParse = paramDescNode.requiredChildrenParams;
            if (paramsListToParse != null && !paramsListToParse.isEmpty()) {
                if (q.containsParam(paramName)) {
                    value = q.popParamWithValue(q.indexOfParam(paramName));
                    CommandDefinition.DescriptorNode valueDescNode = (CommandDefinition.DescriptorNode)paramsListToParse.get(value);
                    Map valueDescNodeParams = null;
                    if (valueDescNode == null) {
                        this.logger.error(Message.format((String)RB.getStringResource("XMLConfigCommandContext.arguments.value.missing.fmt"), (Object)paramName));
                        return false;
                    }
                    valueDescNodeParams = valueDescNode.requiredChildrenParams;
                    if (valueDescNodeParams == null) continue;
                    this.validAgainstDescriptor(q, valueDescNode);
                    continue;
                }
                this.logger.error(Message.format((String)RB.getStringResource("XMLConfigCommandContext.argument.missing.fmt"), (Object)paramName));
                return false;
            }
            if (q.containsParam(paramName)) {
                value = q.popParamWithValue(q.indexOfParam(paramName));
                if (value != null) continue;
                this.logger.error(Message.format((String)RB.getStringResource("XMLConfigCommandContext.arguments.value.missing.fmt"), (Object)paramName));
                return false;
            }
            this.logger.error(Message.format((String)RB.getStringResource("XMLConfigCommandContext.argument.missing.fmt"), (Object)paramName));
            return false;
        }
        return true;
    }

    private boolean checkForOptionalParams(ParamsQueue q, Map<String, CommandDefinition.DescriptorNode> params) {
        for (String paramName : params.keySet()) {
            CommandDefinition.DescriptorNode paramDescNode = params.get(paramName);
            Map paramsListToParse = null;
            paramsListToParse = paramDescNode.optionalChildrenParams;
            if (paramsListToParse != null && !paramsListToParse.isEmpty()) {
                if (!q.containsParam(paramName)) continue;
                String value = q.popParamWithValue(q.indexOfParam(paramName));
                CommandDefinition.DescriptorNode valueDescNode = (CommandDefinition.DescriptorNode)paramsListToParse.get(value);
                Map valueDescNodeParams = null;
                if (valueDescNode == null) {
                    return false;
                }
                valueDescNodeParams = valueDescNode.optionalChildrenParams;
                if (valueDescNodeParams == null) continue;
                this.validAgainstDescriptor(q, valueDescNode);
                continue;
            }
            if (!q.containsParam(paramName)) continue;
            String string = q.popParamWithValue(q.indexOfParam(paramName));
        }
        return true;
    }

    private boolean commandHandlerDefined(Command command, CommandDefinition cDef) {
        return true;
    }

    private CommandDefinition getCommandDefinition(Command command) {
        return this.cDefs.get(command.getCommandName());
    }

    @Override
    public CommandHandler<? extends RunEnvironment> getCommandHandler(Command command) throws BackupException {
        CommandDefinition cDef = this.getCommandDefinition(command);
        String className = cDef.getCommandHandlerClass(command);
        CommandHandler handler = null;
        if (className != null) {
            try {
                Class<?> commandHandler = Class.forName(className);
                handler = (CommandHandler)commandHandler.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return handler;
    }

    @Override
    public CallableCommandHandler getCallableCommandHandler(BackupSession session) throws BackupException {
        return new AsyncCommandHandler(this.getCommandHandler(session.getRequestContext().getCommand()), session);
    }

    @Override
    public EnvironmentPreparator getEnvironmentPreparator(Command command) {
        CommandDefinition cDef = this.getCommandDefinition(command);
        String className = cDef.getEnvironmentPreparatorClass(command);
        EnvironmentPreparator preparator = null;
        if (className != null) {
            try {
                Class<?> preparatorClazz = Class.forName(className);
                preparator = (EnvironmentPreparator)preparatorClazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return preparator;
    }

    @Override
    public CommandPostProcessor getPostProcessor(Command command) {
        CommandDefinition cDef = this.getCommandDefinition(command);
        String className = cDef.getPostProcessorClass(command);
        CommandPostProcessor processor = null;
        if (className != null) {
            try {
                Class<?> postProcessor = Class.forName(className);
                processor = (CommandPostProcessor)postProcessor.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return processor;
    }

    private class CommandDefinition {
        private Map<String, ParamNode> GlobalParams;
        private Map<String, String> props;
        private String name;
        private Map<String, ParamNode> params;
        private String commandHandlerClass;
        private Map<String, CommandDefinition> subCommands;
        private DescriptorNode descNode;
        private String envPreparatorClass;
        private String commandPostProcessorClass;

        private CommandDefinition() {
        }

        private Set<String> getAllDefinedParams() {
            HashSet<String> defParams = new HashSet<String>();
            for (String name : this.GlobalParams.keySet()) {
                ParamNode tempParamNode = this.GlobalParams.get(name);
                defParams.add(tempParamNode.getName());
            }
            this.colectAllDefiniedParams(this, defParams);
            if (this.subCommands != null) {
                for (String name : this.subCommands.keySet()) {
                    CommandDefinition tempCmdNode = this.subCommands.get(name);
                    tempCmdNode.colectAllDefiniedParams(tempCmdNode, defParams);
                }
            }
            return defParams;
        }

        private void colectAllDefiniedParams(CommandDefinition subCommand, Set<String> defParams) {
            for (String name : subCommand.params.keySet()) {
                ParamNode tempParamNode = subCommand.params.get(name);
                defParams.add(tempParamNode.getName());
            }
        }

        private DescriptorNode buildDescriptorNode(CommandDefinition cmdDef) {
            cmdDef.descNode = new DescriptorNode();
            cmdDef.descNode.paramName = this.name;
            HashSet<String> reqParams = new HashSet<String>();
            HashSet<String> optParams = new HashSet<String>();
            cmdDef.collectRequiredParameters(reqParams);
            cmdDef.collectOptionalParameters(optParams);
            cmdDef.descNode.requiredChildrenParams = this.populateDEscNodesChildParams(cmdDef, reqParams);
            cmdDef.descNode.optionalChildrenParams = this.populateDEscNodesChildParams(cmdDef, optParams);
            return cmdDef.descNode;
        }

        private Map<String, DescriptorNode> populateDEscNodesChildParams(CommandDefinition cmdDef, Set<String> params) {
            HashMap<String, DescriptorNode> childParams = new HashMap<String, DescriptorNode>();
            for (String reqParam : params) {
                DescriptorNode temp = null;
                if (reqParam.equals(cmdDef.getProps().get("handlerdefiningparam"))) {
                    Map<String, CommandDefinition> subCommands = cmdDef.getSubCommands();
                    HashMap<String, DescriptorNode> tempChildParams = new HashMap<String, DescriptorNode>();
                    for (String subCmdName : subCommands.keySet()) {
                        CommandDefinition subCmd = subCommands.get(subCmdName);
                        tempChildParams.put(subCmdName, this.buildDescriptorNode(subCmd));
                    }
                    temp = new DescriptorNode(reqParam, tempChildParams);
                } else {
                    temp = new DescriptorNode(reqParam, null);
                }
                childParams.put(reqParam, temp);
            }
            return childParams;
        }

        private String getName() {
            return this.name;
        }

        private Set<String> getCommandsAllRequiredParameters() {
            HashSet<String> reqParams = new HashSet<String>();
            this.collectRequiredParameters(reqParams);
            if (this.subCommands != null) {
                for (String name : this.subCommands.keySet()) {
                    CommandDefinition tempCmdNode = this.subCommands.get(name);
                    tempCmdNode.collectRequiredParameters(reqParams);
                }
            }
            return reqParams;
        }

        private void collectOptionalParameters(Set<String> reqParams) {
            ParamNode tempParamNode;
            for (String name : this.params.keySet()) {
                tempParamNode = this.params.get(name);
                if (tempParamNode.isRequired().booleanValue()) continue;
                reqParams.add(tempParamNode.getName());
            }
            for (String name : this.GlobalParams.keySet()) {
                tempParamNode = this.GlobalParams.get(name);
                if (tempParamNode.isRequired().booleanValue()) continue;
                reqParams.add(tempParamNode.getName());
            }
        }

        private void collectRequiredParameters(Set<String> reqParams) {
            ParamNode tempParamNode;
            for (String name : this.params.keySet()) {
                tempParamNode = this.params.get(name);
                if (!tempParamNode.isRequired().booleanValue()) continue;
                reqParams.add(tempParamNode.getName());
            }
            for (String name : this.GlobalParams.keySet()) {
                tempParamNode = this.GlobalParams.get(name);
                if (!tempParamNode.isRequired().booleanValue()) continue;
                reqParams.add(tempParamNode.getName());
            }
        }

        private boolean isDefined(String parameterName) {
            return this.params.containsKey(parameterName);
        }

        private String getCommandHandlerClass(Command command) {
            String cmdHandler = this.getCommandHandlerClass();
            if (cmdHandler != null) {
                return cmdHandler;
            }
            if (this.subCommands != null) {
                String subCmdName = command.getParameter(this.getProps().get("handlerdefiningparam"));
                CommandDefinition subCmdDef = this.subCommands.get(subCmdName);
                return subCmdDef.getCommandHandlerClass();
            }
            return null;
        }

        private String getEnvironmentPreparatorClass(Command command) {
            String envPreparator = this.getEnvironemntPreparator();
            if (envPreparator != null) {
                return envPreparator;
            }
            if (this.subCommands != null) {
                String subCmdName = command.getParameter(this.getProps().get("handlerdefiningparam"));
                CommandDefinition subCmdDef = this.subCommands.get(subCmdName);
                return subCmdDef.getEnvironemntPreparator();
            }
            return null;
        }

        private String getPostProcessorClass(Command command) {
            String envPreparator = this.getCommandPostProcessorClass();
            if (envPreparator != null) {
                return envPreparator;
            }
            if (this.subCommands != null) {
                String subCmdName = command.getParameter(this.getProps().get("handlerdefiningparam"));
                CommandDefinition subCmdDef = this.subCommands.get(subCmdName);
                return subCmdDef.getCommandPostProcessorClass();
            }
            return null;
        }

        private boolean hasSubCommands() {
            return this.subCommands != null && !this.subCommands.isEmpty();
        }

        private CommandDefinition getSubCommand(Command command) {
            if (this.subCommands.containsKey(command.getCommandName())) {
                return this.subCommands.get(command.getCommandName());
            }
            return null;
        }

        private Map<String, CommandDefinition> getSubCommands() {
            return this.subCommands;
        }

        private void setSubCommands(Map<String, CommandDefinition> subCommands) {
            this.subCommands = subCommands;
        }

        private String getCommandHandlerClass() {
            return this.commandHandlerClass;
        }

        private void setCommandHandlerClass(String commandHandlerClass) {
            this.commandHandlerClass = commandHandlerClass;
        }

        private String getEnvironemntPreparator() {
            return this.envPreparatorClass;
        }

        private void setCommandPostProcessorClass(String commandPostProcessorClass) {
            this.commandPostProcessorClass = commandPostProcessorClass;
        }

        private String getCommandPostProcessorClass() {
            return this.commandPostProcessorClass;
        }

        private void setEnvironmentPreparator(String envPreparatorClass) {
            this.envPreparatorClass = envPreparatorClass;
        }

        private Map<String, ParamNode> getParams() {
            return this.params;
        }

        private void setParams(Map<String, ParamNode> params) {
            this.params = params;
        }

        private void setName(String name) {
            this.name = name;
        }

        private Map<String, String> getProps() {
            return this.props;
        }

        private void setProps(Map<String, String> props) {
            this.props = props;
        }

        private Map<String, ParamNode> getGlobalParams() {
            return this.GlobalParams;
        }

        private void setGlobalParams(Map<String, ParamNode> globalParams) {
            this.GlobalParams = globalParams;
        }

        private class DescriptorNode {
            private String paramName;
            private Map<String, DescriptorNode> requiredChildrenParams;
            private Map<String, DescriptorNode> optionalChildrenParams;

            private DescriptorNode() {
            }

            private DescriptorNode(String name, Map<String, DescriptorNode> childParams) {
                this.paramName = name;
                this.requiredChildrenParams = childParams;
            }
        }
    }

    private class ParamNode {
        private String name;
        private Boolean isRequired;

        private ParamNode(String name, Boolean isRequired) {
            this.name = name;
            this.isRequired = isRequired;
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        private Boolean isRequired() {
            return this.isRequired;
        }
    }

    private class ParamsQueue {
        private List<String> queue = new ArrayList<String>();

        private ParamsQueue() {
        }

        private void pushParam(String arg) {
            this.queue.add(arg);
        }

        private String popParamWithValue(int index) {
            String value = null;
            this.queue.remove(index);
            if (index < this.queue.size()) {
                value = this.queue.get(index);
                this.queue.remove(index);
            }
            return value;
        }

        private boolean isEmpty() {
            return this.queue.isEmpty();
        }

        private boolean containsParam(String arg) {
            return this.queue.indexOf(arg) >= 0;
        }

        private int indexOfParam(String arg) {
            return this.queue.indexOf(arg);
        }
    }
}

