/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.svcs.backup.client.CommandContext;
import java.util.Map;
import java.util.Set;

public class Command {
    private String commandName;
    private Map<String, String> properties;
    private CommandContext.CommandType type;
    private String handlerdefiningparam;

    private Command(String command) {
    }

    private Command(String commandName, String handlerParam, Map<String, String> properties, CommandContext.CommandType type) {
        this.commandName = commandName;
        this.properties = properties;
        this.handlerdefiningparam = handlerParam;
        this.type = type;
    }

    public static Command getInstance(String commandName, String handlerParam, Map<String, String> properties, CommandContext.CommandType commandType) throws IllegalArgumentException {
        return new Command(commandName, handlerParam, properties, commandType);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Map<String, String> getParamaters() {
        return this.properties;
    }

    public String getParameter(String param) {
        if (this.properties.containsKey(param)) {
            return this.properties.get(param);
        }
        return "";
    }

    public boolean hasParameter(String param) {
        return this.properties.containsKey(param);
    }

    public String getCommandLine(boolean hidePassword) {
        Set<String> params = this.properties.keySet();
        StringBuffer commandLine = new StringBuffer(this.getCommandName());
        for (String param : params) {
            commandLine.append(" -" + param + " " + this.properties.get(param));
        }
        try {
            if (hidePassword) {
                commandLine = new StringBuffer(this.removePassword(commandLine.toString(), "{SAS00"));
                commandLine = new StringBuffer(this.removePassword(commandLine.toString(), "{sas00"));
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred while masking password in the log message");
            return "";
        }
        return commandLine.toString();
    }

    public String removePassword(String strCommand, String strEncryption) {
        String strPassword;
        int nRight;
        int nLeft;
        if (strCommand.contains("-pw ")) {
            nLeft = strCommand.indexOf("-pw ") + 4;
            nRight = strCommand.indexOf(" ", nLeft);
            strPassword = strCommand.substring(nLeft, nRight);
            strCommand = strCommand.replace(strPassword, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        }
        if (strCommand.contains("-dbconnecturl ")) {
            nLeft = strCommand.indexOf("-dbconnecturl ") + 14;
            nRight = strCommand.indexOf(" -", nLeft);
            String dbconnecturl = strCommand.substring(nLeft, nRight);
            while (dbconnecturl.contains("::")) {
                String strPassword2 = "";
                if ((dbconnecturl = dbconnecturl.substring(dbconnecturl.indexOf("::") + 2)).contains(",")) {
                    strPassword2 = dbconnecturl.substring(0, dbconnecturl.indexOf(","));
                    dbconnecturl = dbconnecturl.substring(dbconnecturl.indexOf(",") + 1);
                } else {
                    strPassword2 = dbconnecturl;
                    dbconnecturl = "";
                }
                strCommand = strCommand.replace(strPassword2, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            }
        }
        while (strCommand.contains(strEncryption)) {
            nLeft = strCommand.indexOf(strEncryption);
            nRight = strCommand.indexOf(strEncryption) + 40;
            if (nRight > strCommand.length()) {
                nRight = strCommand.length();
            }
            strPassword = strCommand.substring(nLeft, nRight);
            strCommand = strCommand.replace(strPassword, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        }
        return strCommand;
    }

    public CommandContext.CommandType getCommandType() {
        return this.type;
    }

    public String getHandlerdefiningparam() {
        return this.handlerdefiningparam;
    }
}

