/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.personalization;

import com.sas.text.NLFormats;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDateTimeFormat
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDateTimeFormat.class);
    private static final long serialVersionUID = 1L;
    private String key;
    private final Collection<NLFormats.FormatPattern> validationCollection;

    protected AbstractDateTimeFormat(Collection<NLFormats.FormatPattern> c) {
        if (null == c || c.isEmpty()) {
            throw new IllegalArgumentException("Collection must be non-null and contain entries.");
        }
        this.validationCollection = c;
    }

    protected void setKey(String key) {
        String validatedKey = null;
        if (null != key && key.trim().length() > 0) {
            for (NLFormats.FormatPattern format : this.validationCollection) {
                if (!key.equals(format.name)) continue;
                validatedKey = format.name;
            }
        }
        if (null == validatedKey) {
            validatedKey = this.validationCollection.iterator().next().name;
            if (LOGGER.isEnabled(Level.WARN)) {
                LOGGER.warn("Unrecognized key pattern, '" + key + "' used for format. The default, '" + validatedKey + "' is being used.");
            }
        }
        this.key = validatedKey;
    }

    protected String getKey() {
        return this.key;
    }

    public String getPattern(Locale l) {
        return NLFormats.getPattern((String)this.key, (Locale)l);
    }

    @Deprecated
    public String getLabel(Locale l) {
        return this.getPattern(l);
    }
}

