/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.opt.internal.ServerNotifForwarder;
import com.sun.jmx.remote.opt.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.opt.security.SubjectDelegator;
import com.sun.jmx.remote.opt.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.OrderClassLoaders;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.GenericConnectorServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

class ServerIntermediary {
    private final MBeanServer mbeanServer;
    private final GenericConnectorServer myServer;
    private final ServerSynchroMessageConnection connection;
    private final String clientId;
    private final RequestHandler requestHandler = new RequestHandler();
    private final ObjectWrapping serialization;
    private final AccessControlContext acc;
    private final Subject subject;
    private final SubjectDelegator subjectDelegator;
    private final ClassLoader defaultClassLoader;
    private final ClassLoaderWithRepository clr;
    private ServerNotifForwarder serverNotifForwarder;
    private Map env;
    private GenericServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.generic", "ServerIntermediary");
    private static final int RUNNING = 0;
    private static final int FAILED = 1;
    private static final int TERMINATED = 2;
    private int state = 0;
    private final int[] stateLock = new int[0];
    private final boolean isRI10;

    public ServerIntermediary(MBeanServer mbeanServer, GenericConnectorServer myServer, ServerSynchroMessageConnection connection, ObjectWrapping wrapper, Subject subject, ClassLoader defaultClassLoader, Map env) {
        LOGGER.trace("constructor", "Create a ServerIntermediary object.");
        if (mbeanServer == null) {
            throw new NullPointerException("Null mbean server.");
        }
        if (connection == null) {
            throw new NullPointerException("Null connection.");
        }
        this.mbeanServer = mbeanServer;
        this.myServer = myServer;
        this.connection = connection;
        this.clientId = connection.getConnectionId();
        this.serialization = wrapper;
        this.subjectDelegator = new SubjectDelegator();
        this.subject = subject;
        this.acc = subject == null ? null : new AccessControlContext(AccessController.getContext(), new JMXSubjectDomainCombiner(subject));
        this.defaultClassLoader = defaultClassLoader;
        final ClassLoader dcl = defaultClassLoader;
        this.clr = (ClassLoaderWithRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoaderWithRepository(ServerIntermediary.this.getClassLoaderRepository(), dcl);
            }
        });
        this.env = env;
        long timeout = EnvHelp.getServerConnectionTimeout(this.env);
        String s = (String)this.env.get("com.sun.jmx.remote.bug.compatible");
        if (s == null) {
            s = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.sun.jmx.remote.bug.compatible");
                }
            });
        }
        this.isRI10 = "RI1.0.0".equals(s);
        this.serverCommunicatorAdmin = new GenericServerCommunicatorAdmin(timeout);
    }

    private synchronized ServerNotifForwarder getServerNotifFwd() {
        if (this.serverNotifForwarder == null) {
            this.serverNotifForwarder = new ServerNotifForwarder(this.mbeanServer, this.env, this.myServer.getNotifBuffer());
        }
        return this.serverNotifForwarder;
    }

    public Object handleRequest(MBeanServerRequestMessage req) throws Exception {
        LOGGER.trace("handleRequest", "Handle a request: " + req);
        if (req == null) {
            return null;
        }
        Object[] params = req.getParams();
        switch (req.getMethodId()) {
            case 3: {
                LOGGER.trace("handleRequest", "Handle a CREATE_MBEAN request.");
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1]);
            }
            case 5: {
                LOGGER.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER request.");
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2]);
            }
            case 4: {
                LOGGER.trace("handleRequest", "Handle a CREATE_MBEAN_PARAMS request.");
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (Object[])this.serialization.unwrap(params[2], this.clr), (String[])params[3]);
            }
            case 6: {
                LOGGER.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER_PARAMS request.");
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2], (Object[])this.unwrapWithDefault(params[3], this.getClassLoader((ObjectName)params[2])), (String[])params[4]);
            }
            case 7: {
                LOGGER.trace("handleRequest", "Handle a GET_ATTRIBUTE request.");
                return this.mbeanServer.getAttribute((ObjectName)params[0], (String)params[1]);
            }
            case 8: {
                LOGGER.trace("handleRequest", "Handle a GET_ATTRIBUTES request.");
                return this.mbeanServer.getAttributes((ObjectName)params[0], (String[])params[1]);
            }
            case 9: {
                LOGGER.trace("handleRequest", "Handle a GET_DEFAULT_DOMAIN request.");
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                LOGGER.trace("handleRequest", "Handle a GET_DOMAINS request.");
                return this.mbeanServer.getDomains();
            }
            case 11: {
                LOGGER.trace("handleRequest", "Handle a GET_MBEAN_COUNT request.");
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                LOGGER.trace("handleRequest", "Handle a GET_MBEAN_INFO request.");
                return this.mbeanServer.getMBeanInfo((ObjectName)params[0]);
            }
            case 13: {
                LOGGER.trace("handleRequest", "Handle a GET_OBJECT_INSTANCE request.");
                return this.mbeanServer.getObjectInstance((ObjectName)params[0]);
            }
            case 14: {
                LOGGER.trace("handleRequest", "Handle a INVOKE request.");
                return this.mbeanServer.invoke((ObjectName)params[0], (String)params[1], (Object[])this.unwrapWithDefault(params[2], this.getClassLoaderFor((ObjectName)params[0])), (String[])params[3]);
            }
            case 15: {
                LOGGER.trace("handleRequest", "Handle a IS_INSTANCE_OF request.");
                return this.mbeanServer.isInstanceOf((ObjectName)params[0], (String)params[1]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                LOGGER.trace("handleRequest", "Handle a IS_REGISTERED request.");
                return this.mbeanServer.isRegistered((ObjectName)params[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                LOGGER.trace("handleRequest", "Handle a QUERY_MBEANS request.");
                return this.mbeanServer.queryMBeans((ObjectName)params[0], (QueryExp)this.serialization.unwrap(params[1], this.defaultClassLoader));
            }
            case 18: {
                LOGGER.trace("handleRequest", "Handle a QUERY_NAMES request.");
                return this.mbeanServer.queryNames((ObjectName)params[0], (QueryExp)this.serialization.unwrap(params[1], this.defaultClassLoader));
            }
            case 23: {
                LOGGER.trace("handleRequest", "Handle a SET_ATTRIBUTE request.");
                this.mbeanServer.setAttribute((ObjectName)params[0], (Attribute)this.unwrapWithDefault(params[1], this.getClassLoaderFor((ObjectName)params[0])));
                return null;
            }
            case 24: {
                LOGGER.trace("handleRequest", "Handle a SET_ATTRIBUTES request.");
                return this.mbeanServer.setAttributes((ObjectName)params[0], (AttributeList)this.unwrapWithDefault(params[1], this.getClassLoaderFor((ObjectName)params[0])));
            }
            case 25: {
                LOGGER.trace("handleRequest", "Handle a UNREGISTER_MBEAN request.");
                this.mbeanServer.unregisterMBean((ObjectName)params[0]);
                return null;
            }
            case 2: {
                LOGGER.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENER_OBJECTNAME request.");
                ClassLoader cl1 = this.getClassLoaderFor((ObjectName)params[0]);
                this.mbeanServer.addNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)this.unwrapWithDefault(params[2], cl1), this.unwrapWithDefault(params[3], cl1));
                return null;
            }
            case 21: {
                LOGGER.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME request.");
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1]);
                return null;
            }
            case 22: {
                String reqname = "REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK";
                LOGGER.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK request.");
                ClassLoader cl2 = this.getClassLoaderFor((ObjectName)params[0]);
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)this.unwrapWithDefault(params[2], cl2), this.unwrapWithDefault(params[3], cl2));
                return null;
            }
            case 1: {
                int i;
                LOGGER.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENERS request.");
                if (this.isRI10) {
                    ObjectName name = ((ObjectName[])params[0])[0];
                    ClassLoader cl3 = this.getClassLoaderFor(name);
                    Object wrappedFilter = ((Object[])params[1])[0];
                    return this.getServerNotifFwd().addNotificationListener(name, (NotificationFilter)this.unwrapWithDefault(wrappedFilter, cl3));
                }
                if (params[0] == null || params[1] == null) {
                    throw new IllegalArgumentException("Got null arguments.");
                }
                ObjectName[] names = (ObjectName[])params[0];
                Object[] wrappedFilters = (Object[])params[1];
                if (names.length != wrappedFilters.length) {
                    throw new IllegalArgumentException("The value lengths of 2 parameters are not same.");
                }
                for (i = 0; i < names.length; ++i) {
                    if (names[i] != null) continue;
                    throw new IllegalArgumentException("Null Object name.");
                }
                Integer[] ids = new Integer[names.length];
                try {
                    for (i = 0; i < names.length; ++i) {
                        ClassLoader targetCl = this.getClassLoaderFor(names[i]);
                        LOGGER.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.clientId + " unwrapping filter with target extended ClassLoader.");
                        NotificationFilter filterValue = (NotificationFilter)this.unwrapWithDefault(wrappedFilters[i], targetCl);
                        LOGGER.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.clientId + ", name=" + names[i] + ", filter=" + filterValue);
                        ids[i] = this.getServerNotifFwd().addNotificationListener(names[i], filterValue);
                    }
                    return ids;
                }
                catch (Exception e) {
                    for (int j = 0; j < i; ++j) {
                        try {
                            this.getServerNotifFwd().removeNotificationListener(names[j], ids[j]);
                            continue;
                        }
                        catch (Exception eee) {
                            LOGGER.warning("handleRequest-addNotificationListener", "Failed to remove a listener from the MBean " + names[j] + ". " + eee.toString());
                        }
                    }
                    if (e instanceof PrivilegedActionException) {
                        e = this.extractException(e);
                    }
                    throw e;
                }
            }
            case 20: {
                LOGGER.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_FILTER_HANDBACK request.");
                this.getServerNotifFwd().removeNotificationListener((ObjectName)params[0], new Integer[]{(Integer)params[1]});
                return null;
            }
            case 19: {
                LOGGER.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER request.");
                this.getServerNotifFwd().removeNotificationListener((ObjectName)params[0], (Integer[])params[1]);
                return null;
            }
        }
        LOGGER.info("handleRequest", "Unknown request id: " + req.getMethodId());
        throw new IllegalArgumentException("The specified method is not found [MethodId=" + req.getMethodId() + "]");
    }

    public void terminate() {
        this.terminate(false, "The server is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(boolean local, String msg) {
        LOGGER.trace("terminate", "Terminating....");
        Object object = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 2) {
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                return;
            }
            this.state = 2;
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            if (!local) {
                LOGGER.trace("terminate", "Send a CloseMessage to the client.");
                try {
                    ServerSynchroMessageConnection serverSynchroMessageConnection = this.connection;
                    object = serverSynchroMessageConnection;
                    synchronized (serverSynchroMessageConnection) {
                        this.connection.sendOneWay(new CloseMessage(msg));
                        // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                    }
                }
                catch (UnsupportedOperationException uoe) {
                    LOGGER.trace("terminate", "The transport level does not support the method sendOneWay: " + uoe);
                }
                catch (IOException ioe) {
                    LOGGER.warning("terminate", "Failed to inform the client: " + ioe);
                    LOGGER.debug("terminate", ioe);
                }
            }
            {
                if (this.serverNotifForwarder != null) {
                    this.serverNotifForwarder.terminate();
                }
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.serverCommunicatorAdmin != null) {
                    this.serverCommunicatorAdmin.terminate();
                }
                this.myServer.clientClosing(this, this.clientId, "The method terminate is called.", null);
                LOGGER.trace("terminate", "Terminated.");
                return;
            }
        }
    }

    ServerSynchroMessageConnection getTransport() {
        return this.connection;
    }

    private NotificationResult purgeUnserializable(NotificationResult nr) {
        ArrayList<TargetedNotification> tnList = new ArrayList<TargetedNotification>();
        TargetedNotification[] tns = nr.getTargetedNotifications();
        for (int i = 0; i < tns.length; ++i) {
            TargetedNotification tn = tns[i];
            NotificationResult trialnr = new NotificationResult(0L, 0L, new TargetedNotification[]{tn});
            try {
                this.serialization.wrap(trialnr);
                tnList.add(tn);
                continue;
            }
            catch (IOException e) {
                LOGGER.warning("purgeUnserializable", "cannot serialize notif: " + tn);
                LOGGER.fine("purgeUnserializable", e);
                Integer listenerID = tn.getListenerID();
                Notification badNotif = tn.getNotification();
                String notifType = "jmx.remote.connection.notifs.lost";
                String notifMessage = "Not serializable: " + badNotif;
                JMXConnectionNotification goodNotif = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", badNotif.getSource(), this.clientId, badNotif.getSequenceNumber(), notifMessage, new Long(1L));
                tn = new TargetedNotification(goodNotif, listenerID);
                trialnr = new NotificationResult(0L, 0L, new TargetedNotification[]{tn});
                try {
                    this.serialization.wrap(trialnr);
                    tnList.add(tn);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        tns = tnList.toArray(new TargetedNotification[0]);
        return new NotificationResult(nr.getEarliestSequenceNumber(), nr.getNextSequenceNumber(), tns);
    }

    void start() {
        this.connection.setCallback(this.requestHandler);
    }

    private ClassLoaderRepository getClassLoaderRepository() {
        return (ClassLoaderRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServerIntermediary.this.mbeanServer.getClassLoaderRepository();
            }
        });
    }

    private ClassLoader getClassLoader(final ObjectName name) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoader(name);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)this.extractException(pe);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName name) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoaderFor(name);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)this.extractException(pe);
        }
    }

    private Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    private Object unwrapWithDefault(final Object obj, final ClassLoader cl) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    return ServerIntermediary.this.serialization.unwrap(obj, new OrderClassLoaders(cl, ServerIntermediary.this.defaultClassLoader));
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = this.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            return null;
        }
    }

    private class PrivilegedRequestJob
    implements PrivilegedExceptionAction {
        private final MBeanServerRequestMessage request;

        public PrivilegedRequestJob(MBeanServerRequestMessage request) {
            this.request = request;
        }

        public Object run() throws Exception {
            return ServerIntermediary.this.serialization.wrap(ServerIntermediary.this.handleRequest(this.request));
        }
    }

    private class GenericServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public GenericServerCommunicatorAdmin(long timeout) {
            super(timeout);
        }

        @Override
        protected void doStop() {
            ServerIntermediary.this.terminate();
        }
    }

    private class RequestHandler
    implements SynchroCallback {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message execute(Message msg) {
            LOGGER.debug("RequestHandler-execute", "Handling incoming request from: " + ServerIntermediary.this.connection.getConnectionId());
            boolean terminated = ServerIntermediary.this.serverCommunicatorAdmin.reqIncoming();
            try {
                if (terminated) {
                    LOGGER.warning("RequestHandler-execute", "The server has decided to close the client connection: " + ServerIntermediary.this.connection.getConnectionId());
                    LOGGER.fine("RequestHandler-execute", "Ignoring request from " + ServerIntermediary.this.connection.toString());
                    throw new ConnectionClosedException("The connection to " + ServerIntermediary.this.connection.getConnectionId() + " is being terminated by the server");
                }
                LOGGER.trace("RequestHandler-execute", "Execute the request: " + msg);
                if (msg instanceof CloseMessage) {
                    Message message = this.handleCloseMessage((CloseMessage)msg);
                    return message;
                }
                if (msg instanceof NotificationRequestMessage) {
                    Message message = this.handleNotifReqMessage((NotificationRequestMessage)msg);
                    return message;
                }
                if (msg instanceof MBeanServerRequestMessage) {
                    Message message = this.handleMBSReqMessage((MBeanServerRequestMessage)msg);
                    return message;
                }
                LOGGER.warning("RequestHandler-execute", "Got unknown message: " + msg);
                ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, "Got unknown message: " + msg, msg);
                ServerIntermediary.this.terminate(false, "Got unknown message: " + msg);
            }
            catch (IOException cce) {
                LOGGER.trace("RequestHandler.execute", cce);
            }
            finally {
                ServerIntermediary.this.serverCommunicatorAdmin.rspOutgoing();
            }
            return null;
        }

        private Message handleCloseMessage(CloseMessage msg) {
            LOGGER.trace("RequestHandler-execute", "Receive a CloseMessage.");
            ServerIntermediary.this.terminate(true, null);
            return null;
        }

        private Message handleNotifReqMessage(NotificationRequestMessage nr) throws IOException {
            Object wrapped;
            LOGGER.trace("RequestHandler-execute", "Received a NotificationRequestMessage:" + nr);
            long start = nr.getClientSequenceNumber();
            long timeout = nr.getTimeout();
            int max = nr.getMaxNotifications();
            NotificationResult result = ServerIntermediary.this.getServerNotifFwd().fetchNotifs(start, timeout, max);
            try {
                wrapped = ServerIntermediary.this.serialization.wrap(result);
            }
            catch (NotSerializableException e) {
                result = ServerIntermediary.this.purgeUnserializable(result);
                wrapped = ServerIntermediary.this.serialization.wrap(result);
            }
            long missed = result.getEarliestSequenceNumber() - start;
            if (missed > 0L) {
                LOGGER.trace("RequestHandler-execute", "Missed " + missed + " notifications. Notification buffer is probably too small.");
            }
            LOGGER.trace("RequestHandler-execute", "Returning NotificationResponseMessage:" + result + " for request: " + nr);
            return new NotificationResponseMessage(wrapped);
        }

        private Message handleMBSReqMessage(MBeanServerRequestMessage req) throws IOException {
            LOGGER.trace("RequestHandler-execute", "Receive a MBeanServerRequestMessage.");
            try {
                AccessControlContext reqACC;
                Subject delegationSubject = req.getDelegationSubject();
                if (delegationSubject == null) {
                    reqACC = ServerIntermediary.this.acc;
                } else {
                    if (ServerIntermediary.this.subject == null) {
                        String msg = "Subject delegation cannot be enabled unless an authenticated subject is put in place";
                        throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                    }
                    reqACC = ServerIntermediary.this.subjectDelegator.delegatedContext(ServerIntermediary.this.acc, delegationSubject);
                }
                Object result = AccessController.doPrivileged(new PrivilegedRequestJob(req), reqACC);
                return new MBeanServerResponseMessage(req.getMessageId(), result, false);
            }
            catch (Exception e) {
                e = ServerIntermediary.this.extractException(e);
                if (LOGGER.traceOn()) {
                    LOGGER.trace("RequestHandler-execute", "Got an exception: " + e, e);
                }
                return new MBeanServerResponseMessage(req.getMessageId(), this.wrapException(e), true);
            }
            catch (Error r) {
                if (LOGGER.traceOn()) {
                    LOGGER.trace("RequestHandler-execute", "Got an error: " + r, r);
                }
                JMXServerErrorException see = new JMXServerErrorException(r.toString(), r);
                return new MBeanServerResponseMessage(req.getMessageId(), this.wrapException(see), true);
            }
        }

        private Object wrapException(Exception e) throws IOException {
            try {
                return ServerIntermediary.this.serialization.wrap(e);
            }
            catch (NotSerializableException nse) {
                return ServerIntermediary.this.serialization.wrap(nse);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionException(Exception e) {
            int[] nArray = ServerIntermediary.this.stateLock;
            synchronized (nArray) {
                if (ServerIntermediary.this.state != 0) {
                    return;
                }
                ServerIntermediary.this.state = 1;
            }
            if (e instanceof EOFException) {
                LOGGER.warning("RequestHandler-connectionException", "JMX connector " + ServerIntermediary.this.connection + " client exited without closing connection");
            } else {
                LOGGER.warning("RequestHandler-connectionException", "JMX connector " + ServerIntermediary.this.connection + " transport got exception when reading input message from : " + e);
            }
            LOGGER.finer("RequestHandler-connectionException", e);
            String msg = e instanceof ClassNotFoundException ? "The client " + ServerIntermediary.this.clientId + "got an unknown message: " + e : "The client " + ServerIntermediary.this.clientId + " has failed: " + e;
            ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, msg, e);
            ServerIntermediary.this.terminate(true, null);
        }
    }
}

