/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServerImpl;
import com.sun.jmx.remote.opt.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnectionServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.generic.ServerIntermediary;
import javax.security.auth.Subject;

public class GenericConnectorServer
extends JMXConnectorServer {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION_SERVER = "jmx.remote.message.connection.server";
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.generic", "GenericConnectorServer");
    private Receiver receiver;
    private SynchroMessageConnectionServer sMsgServer;
    private ObjectWrapping objectWrapping;
    private final Map env;
    private ClassLoader defaultClassLoader = null;
    private final ThreadService threads = new ThreadService(0, 10);
    private final ArrayList clientList = new ArrayList();
    private static final int DEFAULT_NOTIF_BUFFER_SIZE = 1000;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private final int[] lock = new int[0];
    private static final long CLIENT_ID_COUNT = 0L;
    private static final int[] CLIENT_ID_COUNTLOCK = new int[0];
    private NotificationBuffer notifBuffer;
    private final long connectingTimeout;
    private static final Timer CONNECTING_CANCELLATION_TIMER = new Timer(true);

    public GenericConnectorServer(Map env, MBeanServer mbs) {
        super(mbs);
        if (env == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(env);
            this.env = Collections.unmodifiableMap(env);
        }
        this.connectingTimeout = DefaultConfig.getConnectingTimeout(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientClosing(ServerIntermediary inter, String connectionId, String msg, Object userData) {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.clientList.remove(inter);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            super.connectionClosed(connectionId, msg, userData);
            return;
        }
    }

    @Override
    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.sMsgServer.getAddress();
    }

    public Map getAttributes() {
        Map map = EnvHelp.filterAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            MessageConnectionServer messageServer;
            String accessFile;
            if (this.state == 1) {
                LOGGER.trace("start", "already started");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 2) {
                LOGGER.trace("start", "already stopped");
                throw new IOException("The server has been stopped.");
            }
            LOGGER.trace("start", "starting...");
            LOGGER.trace("start", "setting MBeanServer...");
            MBeanServer mbs = this.getMBeanServer();
            if (mbs == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.env != null && (accessFile = (String)this.env.get("jmx.remote.x.access.file")) != null) {
                MBeanServerFileAccessController mbsf = null;
                try {
                    mbsf = new MBeanServerFileAccessController(accessFile);
                }
                catch (IOException e) {
                    throw (IllegalArgumentException)EnvHelp.initCause(new IllegalArgumentException(e.getMessage()), e);
                }
                this.setMBeanServerForwarder(mbsf);
                mbs = this.getMBeanServer();
            }
            LOGGER.trace("start", "setting default ClassLoader...");
            try {
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.env, mbs);
            }
            catch (InstanceNotFoundException infc) {
                LOGGER.debug("start", "ClassLoader not found: " + infc);
                IllegalArgumentException x = new IllegalArgumentException("ClassLoader not found: " + infc);
                throw (IllegalArgumentException)EnvHelp.initCause(x, infc);
            }
            LOGGER.trace("start", "setting ObjectWrapping...");
            this.objectWrapping = (ObjectWrapping)this.env.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            if ((messageServer = (MessageConnectionServer)this.env.get(MESSAGE_CONNECTION_SERVER)) == null) {
                this.sMsgServer = DefaultConfig.getSynchroMessageConnectionServer(this.env);
                if (this.sMsgServer == null) {
                    String msg = "No message connection server";
                    throw new IllegalArgumentException("No message connection server");
                }
            } else {
                this.sMsgServer = new SynchroMessageConnectionServerImpl(messageServer, this.env);
            }
            this.sMsgServer.start(this.env);
            this.state = 1;
            LOGGER.trace("start", "Connector Server Address = " + this.sMsgServer.getAddress());
            LOGGER.trace("start", "started.");
            this.receiver = new Receiver();
            this.receiver.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 2) {
                LOGGER.trace("stop", "already stopped.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 0) {
                LOGGER.trace("stop", "not started yet.");
            }
            this.state = 2;
            boolean debug = LOGGER.debugOn();
            LOGGER.trace("stop", "stoping.");
            LOGGER.trace("stop", "stop MessageConnectionServer...");
            if (this.sMsgServer != null) {
                this.sMsgServer.stop();
            }
            LOGGER.trace("stop", "stop clients...");
            LOGGER.trace("stop", this.clientList.size() + "client(s) found...");
            while (this.clientList.size() > 0) {
                try {
                    ServerIntermediary inter = (ServerIntermediary)this.clientList.remove(0);
                    inter.terminate();
                }
                catch (Exception e) {
                    LOGGER.warning("stop", "Failed to stop client: " + e);
                    if (!debug) continue;
                    LOGGER.debug("stop", e);
                }
            }
            if (this.notifBuffer != null) {
                this.notifBuffer.dispose();
            }
            this.threads.terminate();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            CONNECTING_CANCELLATION_TIMER.cancel();
            LOGGER.trace("stop", "stopped.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 1;
        }
    }

    void failedConnectionNotif(String connectionId, String message, Object userData) {
        super.connectionFailed(connectionId, message, userData);
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.getMBeanServer(), this.env);
        }
        return this.notifBuffer;
    }

    private class ConnectingStopper
    extends TimerTask {
        private final ClientCreation cc;

        public ConnectingStopper(ClientCreation cc) {
            this.cc = cc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClientCreation clientCreation = this.cc;
            synchronized (clientCreation) {
                if (this.cc.done) {
                    return;
                }
                this.cc.done = true;
            }
            LOGGER.trace("ConnectingStopper.run", "Connecting timeout for: " + this.cc.connection);
            try {
                this.cc.connection.close();
            }
            catch (Exception e) {
                LOGGER.debug("ConnectingStoper.run", e);
            }
        }
    }

    private class ClientCreation
    implements Runnable {
        ServerSynchroMessageConnection connection;
        private boolean done = false;
        private ConnectingStopper stopper;

        public ClientCreation(ServerSynchroMessageConnection connection) {
            this.connection = connection;
        }

        public void setStopper(ConnectingStopper stopper) {
            this.stopper = stopper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean failed;
            Subject subject;
            block18: {
                subject = null;
                failed = false;
                try {
                    this.connection.connect(GenericConnectorServer.this.env);
                    LOGGER.trace("ClientCreation.run", "opening connection.");
                    subject = this.connection.getSubject();
                }
                catch (Throwable e) {
                    failed = true;
                    LOGGER.warning("ClientCreation.run", "Failed to open connection: " + e, e);
                    LOGGER.debug("ClientCreation.run", e);
                    try {
                        LOGGER.debug("ClientCreation.run", "cleaning up...");
                        this.connection.close();
                    }
                    catch (Exception ee) {
                        if (LOGGER.debugOn()) {
                            LOGGER.debug("ClientCreation.run", "Failed to cleanup: " + ee);
                        }
                        if (!LOGGER.debugOn()) break block18;
                        LOGGER.debug("ClientCreation.run", ee);
                    }
                }
            }
            ClientCreation e = this;
            synchronized (e) {
                if (this.done) {
                    failed = true;
                } else {
                    this.done = true;
                    if (this.stopper != null) {
                        this.stopper.cancel();
                    }
                }
            }
            if (failed) {
                return;
            }
            LOGGER.trace("ClientCreation.run", "connection opened.");
            ServerIntermediary inter = new ServerIntermediary(GenericConnectorServer.this.getMBeanServer(), GenericConnectorServer.this, this.connection, GenericConnectorServer.this.objectWrapping, subject, GenericConnectorServer.this.defaultClassLoader, GenericConnectorServer.this.env);
            int[] ee = GenericConnectorServer.this.lock;
            synchronized (ee) {
                if (GenericConnectorServer.this.state != 1) {
                    try {
                        LOGGER.debug("ClientCreation.run", "connector already stopped.");
                        LOGGER.trace("ClientCreation.run", "cleaning up...");
                        inter.terminate();
                    }
                    catch (Exception e2) {
                        LOGGER.debug("ClientCreation.run", "Failed to cleanup: " + e2);
                        LOGGER.debug("ClientCreation.run", e2);
                    }
                    return;
                }
                LOGGER.trace("ClientCreation.run", "adding connection to client list.");
                GenericConnectorServer.this.clientList.add(inter);
            }
            String cid = this.connection.getConnectionId();
            GenericConnectorServer.this.connectionOpened(cid, "New client connection " + cid + " has been established", null);
            inter.start();
        }
    }

    private class Receiver
    extends Thread {
        public Receiver() {
            this.setName("JMXMP Server - ConnectorServer Receiver " + this.getName());
        }

        @Override
        public void run() {
            LOGGER.debug("Receiver.run", "starting receiver.");
            while (GenericConnectorServer.this.isActive()) {
                ServerSynchroMessageConnection connection;
                boolean debug = LOGGER.debugOn();
                LOGGER.trace("Receiver.run", "waiting for connection.");
                try {
                    connection = GenericConnectorServer.this.sMsgServer.accept();
                }
                catch (IOException ioe) {
                    if (GenericConnectorServer.this.isActive()) {
                        LOGGER.error("Receiver.run", "Unexpected IOException: " + ioe);
                        if (debug) {
                            LOGGER.debug("Receiver.run", ioe);
                        }
                        try {
                            LOGGER.error("Receiver.run", "stopping server");
                            GenericConnectorServer.this.stop();
                        }
                        catch (IOException ie) {
                            LOGGER.warning("Receiver.run", "Failed to stop server: " + ie);
                            if (!debug) break;
                            LOGGER.debug("Receiver.run", ie);
                        }
                        break;
                    }
                    LOGGER.trace("Receiver.run", "interrupted: " + ioe);
                    break;
                }
                if (!GenericConnectorServer.this.isActive()) {
                    return;
                }
                LOGGER.trace("Receiver.run", "received connection request.");
                ClientCreation cc = new ClientCreation(connection);
                if (GenericConnectorServer.this.connectingTimeout <= 0L) {
                    GenericConnectorServer.this.threads.handoff(cc);
                    continue;
                }
                ConnectingStopper stopper = new ConnectingStopper(cc);
                cc.setStopper(stopper);
                GenericConnectorServer.this.threads.handoff(cc);
                CONNECTING_CANCELLATION_TIMER.schedule((TimerTask)stopper, GenericConnectorServer.this.connectingTimeout);
            }
            LOGGER.debug("Receiver.run", "receiver terminated");
        }
    }
}

