/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.opt.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.opt.internal.ClientListenerInfo;
import com.sun.jmx.remote.opt.internal.ClientNotifForwarder;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.NotificationResult;
import javax.management.remote.generic.GenericConnector;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

class ClientIntermediary {
    private ClientSynchroMessageConnection connection;
    private GenericConnector client;
    private ObjectWrapping serialization;
    private ClassLoader myloader;
    private GenericClientNotifForwarder notifForwarder;
    private GenericClientCommunicatorAdmin communicatorAdmin;
    private long lostNotifCounter = 0L;
    private boolean terminated;
    private final boolean requestTimeoutReconn;
    private static final ObjectName DELEGATE_NAME;
    private static final ClassLogger LOGGER;

    public ClientIntermediary(ClientSynchroMessageConnection connection, ObjectWrapping wrap, GenericConnector client, Map env) {
        LOGGER.trace("constructor", "Create a ClientIntermediary object.");
        if (connection == null) {
            throw new NullPointerException("Null connection.");
        }
        this.connection = connection;
        if (wrap == null) {
            LOGGER.trace("constructor", "Use a default ObjectWrapping implementation.");
            this.serialization = new ObjectWrappingImpl();
        } else {
            this.serialization = wrap;
        }
        this.myloader = EnvHelp.resolveClientClassLoader(env);
        this.client = client;
        this.communicatorAdmin = new GenericClientCommunicatorAdmin(EnvHelp.getConnectionCheckPeriod(env));
        this.notifForwarder = new GenericClientNotifForwarder(env);
        this.requestTimeoutReconn = DefaultConfig.getTimeoutReconnection(env);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        LOGGER.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(3, new Object[]{className, name}, delegationSubject);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        LOGGER.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(4, new Object[]{className, name, this.serialization.wrap(params), signature}, delegationSubject);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        LOGGER.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(5, new Object[]{className, name, loaderName}, delegationSubject);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        LOGGER.trace("createMBean", "called");
        try {
            int code = 6;
            return (ObjectInstance)this.mBeanServerRequest(code, new Object[]{className, name, loaderName, this.serialization.wrap(params), signature}, delegationSubject);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void unregisterMBean(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        LOGGER.trace("unregisterMBean", "called");
        try {
            this.mBeanServerRequest(25, new Object[]{name}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        LOGGER.trace("getObjectInstance", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(13, new Object[]{name}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query, Subject delegationSubject) throws IOException {
        LOGGER.trace("queryMBeans", "called");
        try {
            return (Set)this.mBeanServerRequest(17, new Object[]{name, this.serialization.wrap(query)}, delegationSubject);
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public Set queryNames(ObjectName name, QueryExp query, Subject delegationSubject) throws IOException {
        LOGGER.trace("queryNames", "called");
        try {
            return (Set)this.mBeanServerRequest(18, new Object[]{name, this.serialization.wrap(query)}, delegationSubject);
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public boolean isRegistered(ObjectName name, Subject delegationSubject) throws IOException {
        LOGGER.trace("isRegistered", "called");
        try {
            Boolean is = (Boolean)this.mBeanServerRequest(16, new Object[]{name}, delegationSubject);
            return is;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public Integer getMBeanCount(Subject delegationSubject) throws IOException {
        LOGGER.trace("getMBeanCount", "called");
        try {
            return (Integer)this.mBeanServerRequest(11, null, delegationSubject);
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public Object getAttribute(ObjectName name, String attribute, Subject delegationSubject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        LOGGER.trace("getAttribute", "called");
        try {
            return this.mBeanServerRequest(7, new Object[]{name, attribute}, delegationSubject);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        LOGGER.trace("getAttributes", "called");
        try {
            return (AttributeList)this.mBeanServerRequest(8, new Object[]{name, attributes}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute, Subject delegationSubject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        LOGGER.trace("setAttribute", "called");
        try {
            this.mBeanServerRequest(23, new Object[]{name, this.serialization.wrap(attribute)}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        LOGGER.trace("setAttributes", "called");
        try {
            Object wrappedAttrs = this.serialization.wrap(attributes);
            return (AttributeList)this.mBeanServerRequest(24, new Object[]{name, wrappedAttrs}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature, Subject delegationSubject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        LOGGER.trace("invoke", "called");
        try {
            return this.mBeanServerRequest(14, new Object[]{name, operationName, this.serialization.wrap(params), signature}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public String getDefaultDomain(Subject delegationSubject) throws IOException {
        LOGGER.trace("getDefaultDomain", "called");
        try {
            int code = 9;
            return (String)this.mBeanServerRequest(code, null, delegationSubject);
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public String[] getDomains(Subject delegationSubject) throws IOException {
        LOGGER.trace("getDomains", "called");
        try {
            return (String[])this.mBeanServerRequest(10, null, delegationSubject);
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        LOGGER.trace("getMBeanInfo", "called");
        try {
            return (MBeanInfo)this.mBeanServerRequest(12, new Object[]{name}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        LOGGER.trace("isInstanceOf", "called");
        try {
            Boolean is = (Boolean)this.mBeanServerRequest(15, new Object[]{name, className}, delegationSubject);
            return is;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        LOGGER.trace("addNotificationListener", "name=" + name);
        Integer listenerID = this.addListenerWithSubject(name, this.serialization.wrap(filter), delegationSubject, true);
        this.notifForwarder.addNotificationListener(listenerID, name, listener, filter, handback, delegationSubject);
    }

    private Integer addListenerWithSubject(ObjectName name, Object wrappedFilter, Subject delegationSubject, boolean reconnect) throws InstanceNotFoundException, IOException {
        if (LOGGER.debugOn()) {
            LOGGER.debug("addListenerWithSubject", "(ObjectName,Object,Subject)");
        }
        ObjectName[] names = new ObjectName[]{name};
        Object[] filters = new Object[]{wrappedFilter};
        Object[] params = new Object[]{names, filters};
        boolean code = true;
        try {
            Object o = this.mBeanServerRequest(1, params, delegationSubject, reconnect);
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return ((Integer[])o)[0];
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        LOGGER.trace("addNotificationListener", "called");
        try {
            int code = 2;
            this.mBeanServerRequest(code, new Object[]{name, listener, this.serialization.wrap(filter), this.serialization.wrap(handback)}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "called");
        Integer[] ids = this.notifForwarder.removeNotificationListener(name, listener);
        try {
            int code = 19;
            this.mBeanServerRequest(code, new Object[]{name, ids}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "called");
        Integer ids = this.notifForwarder.removeNotificationListener(name, listener, filter, handback);
        try {
            int code = 20;
            this.mBeanServerRequest(code, new Object[]{name, ids}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "called");
        try {
            int code = 21;
            this.mBeanServerRequest(code, new Object[]{name, listener}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "called");
        try {
            int code = 22;
            this.mBeanServerRequest(code, new Object[]{name, listener, this.serialization.wrap(filter), this.serialization.wrap(handback)}, delegationSubject);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientIntermediary.appropriateException(e);
        }
    }

    public void terminate() {
        LOGGER.trace("terminate", "Terminated.");
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.communicatorAdmin.terminate();
        this.notifForwarder.terminate();
    }

    public GenericClientCommunicatorAdmin getCommunicatorAdmin() {
        return this.communicatorAdmin;
    }

    private Object mBeanServerRequest(int methodId, Object[] params, Subject delegationSubject) throws Exception {
        return this.mBeanServerRequest(methodId, params, delegationSubject, true);
    }

    private Object mBeanServerRequest(int methodId, Object[] params, Subject delegationSubject, boolean reconnect) throws Exception {
        Object result;
        MBeanServerResponseMessage resp;
        MBeanServerRequestMessage req = new MBeanServerRequestMessage(methodId, params, delegationSubject);
        try {
            resp = (MBeanServerResponseMessage)this.connection.sendWithReturn(req);
        }
        catch (IOException e) {
            if (this.terminated || !reconnect || e instanceof InterruptedIOException) {
                throw e;
            }
            this.communicatorAdmin.gotIOException(e);
            resp = (MBeanServerResponseMessage)this.connection.sendWithReturn(req);
        }
        Object wrappedResult = resp.getWrappedResult();
        try {
            result = this.serialization.unwrap(wrappedResult, this.myloader);
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
        if (resp.isException()) {
            throw (Exception)result;
        }
        return result;
    }

    private static IOException appropriateException(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        IOException ioe = new IOException("Unexpected exception: " + e);
        EnvHelp.initCause(ioe, e);
        throw ioe;
    }

    static {
        try {
            DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.toString());
        }
        LOGGER = new ClassLogger("javax.management.remote.generic", "ClientIntermediary");
    }

    private class GenericClientNotifForwarder
    extends ClientNotifForwarder {
        public GenericClientNotifForwarder(Map env) {
            super(env);
        }

        @Override
        protected NotificationResult fetchNotifs(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException, ClassNotFoundException {
            LOGGER.trace("GenericClientNotifForwarder-fetchNotifs", "fetching notifs...");
            NotificationRequestMessage nreq = new NotificationRequestMessage(clientSequenceNumber, maxNotifications, timeout);
            NotificationResponseMessage nresp = (NotificationResponseMessage)ClientIntermediary.this.connection.sendWithReturn(nreq);
            Object wrapped = nresp.getWrappedNotificationResult();
            Object unwrapped = ClientIntermediary.this.serialization.unwrap(wrapped, ClientIntermediary.this.myloader);
            if (!(unwrapped instanceof NotificationResult)) {
                String msg = "Not a NotificationResult: " + unwrapped.getClass();
                LOGGER.warning("Forwarder.fetchNotifs", msg);
                LOGGER.warning("Forwarder.fetchNotifs", "closing connector");
                ClientIntermediary.this.client.close();
            }
            return (NotificationResult)unwrapped;
        }

        @Override
        protected Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException {
            LOGGER.trace("GenericClientNotifForwarder-addListenerForMBeanRemovedNotif", "Add a listener to receive UNREGISTRATION_NOTIFICATION");
            NotificationFilterSupport clientFilter = new NotificationFilterSupport();
            clientFilter.enableType("JMX.mbean.unregistered");
            ObjectName[] names = new ObjectName[]{DELEGATE_NAME};
            Object wrappedFilter = ClientIntermediary.this.serialization.wrap(clientFilter);
            Object[] filters = new Object[]{wrappedFilter};
            Object[] params = new Object[]{names, filters};
            try {
                int code = 1;
                Object o = ClientIntermediary.this.mBeanServerRequest(code, params, null);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                return ((Integer[])o)[0];
            }
            catch (InstanceNotFoundException n) {
                throw n;
            }
            catch (Exception e) {
                throw ClientIntermediary.appropriateException(e);
            }
        }

        @Override
        protected void removeListenerForMBeanRemovedNotif(Integer id) throws IOException {
            LOGGER.trace("GenericClientNotifForwarder-removeListenerForMBeanRemovedNotif", "Remove the listener used to receive UNREGISTRATION_NOTIFICATION.");
            try {
                int code = 20;
                ClientIntermediary.this.mBeanServerRequest(code, new Object[]{DELEGATE_NAME, id}, null, false);
            }
            catch (Exception e) {
                throw ClientIntermediary.appropriateException(e);
            }
        }

        @Override
        protected void lostNotifs(String message, long number) {
            String notifType = "jmx.remote.connection.notifs.lost";
            JMXConnectionNotification n = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", ClientIntermediary.this, ClientIntermediary.this.connection.getConnectionId(), ClientIntermediary.this.lostNotifCounter++, message, number);
            ClientIntermediary.this.client.sendNotification(n);
        }
    }

    private class GenericClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public GenericClientCommunicatorAdmin(long period) {
            super(period);
        }

        @Override
        protected void doStart() throws IOException {
            ClientIntermediary.this.connection = ClientIntermediary.this.client.reconnect();
            ClientListenerInfo[] old = ClientIntermediary.this.notifForwarder.preReconnection();
            this.reconnectNotificationListeners(old);
        }

        @Override
        protected void doStop() {
            try {
                ClientIntermediary.this.client.close();
            }
            catch (IOException ioe) {
                LOGGER.fine("close", ioe);
            }
        }

        @Override
        protected void checkConnection() throws IOException {
            try {
                ClientIntermediary.this.mBeanServerRequest(9, null, null, false);
            }
            catch (InterruptedIOException irie) {
                LOGGER.trace("GenericClientCommunicatorAdmin-checkConnection", "Timeout?", irie);
                if (ClientIntermediary.this.requestTimeoutReconn) {
                    throw (IOException)EnvHelp.initCause(new IOException(irie.getMessage()), irie);
                }
            }
            catch (Exception e) {
                throw ClientIntermediary.appropriateException(e);
            }
        }

        public void reconnectNotificationListeners(ClientListenerInfo[] old) throws IOException {
            ClientListenerInfo[] clis = new ClientListenerInfo[old.length];
            int j = 0;
            for (int i = 0; i < old.length; ++i) {
                try {
                    Integer id = ClientIntermediary.this.addListenerWithSubject(old[i].getObjectName(), ClientIntermediary.this.serialization.wrap(old[i].getNotificationFilter()), old[i].getDelegationSubject(), false);
                    clis[j++] = new ClientListenerInfo(id, old[i].getObjectName(), old[i].getListener(), old[i].getNotificationFilter(), old[i].getHandback(), old[i].getDelegationSubject());
                    continue;
                }
                catch (InstanceNotFoundException infe) {
                    LOGGER.warning("reconnectNotificationListeners", "Can't reconnect a listener for " + old[i].getObjectName(), infe);
                }
            }
            if (j != old.length) {
                ClientListenerInfo[] tmp = clis;
                clis = new ClientListenerInfo[j];
                System.arraycopy(tmp, 0, clis, 0, j);
            }
            ClientIntermediary.this.notifForwarder.postReconnection(clis);
        }
    }
}

