/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.socket;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.Message;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;

public class SocketConnection
implements SocketConnectionIf,
MessageConnection {
    private Subject subject;
    private String connectionId;
    private Socket sock;
    private InputStream in;
    private ObjectInputStream oin;
    private OutputStream out;
    private ObjectOutputStream oout;
    private boolean replaceInputStreamFlag = false;
    private boolean replaceOutputStreamFlag = false;
    private final String addr;
    private final int port;
    private ClassLoader defaultClassLoader;
    private final String defaultConnectionId = "Uninitialized connection id";
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 4;
    private static final int FAILED = 8;
    private static final int TERMINATED = 16;
    private int state = 1;
    private final int[] stateLock = new int[0];
    private long waitConnectedState = 1000L;
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "SocketConnection");

    public SocketConnection(Socket socket) throws IOException {
        LOGGER.trace("Constructor", "Creating with a socket " + socket);
        this.sock = socket;
        this.addr = this.sock.getInetAddress().getHostName();
        this.port = this.sock.getPort();
        this.replaceStreams(socket.getInputStream(), socket.getOutputStream());
    }

    public SocketConnection(String addr, int port) throws IOException {
        LOGGER.trace("Constructor", "Creating with a socket address: " + addr + " " + port);
        this.addr = addr;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Map env) throws IOException {
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(env);
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                LOGGER.trace("connect", "First time to connect to the server.");
                this.state = 2;
                this.stateLock.notifyAll();
                if (this.sock == null) {
                    this.sock = this.createAndConnectSocket(this.addr, this.port);
                }
                LOGGER.fine("connect", "Connecting to socket " + this.sock);
                this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
                if (env != null) {
                    this.defaultClassLoader = (ClassLoader)env.get("jmx.remote.default.class.loader");
                }
                this.state = 4;
                this.stateLock.notifyAll();
            } else if (this.state == 8 || this.state == 4) {
                LOGGER.trace("connect", "Try to re-connect to the server.");
                if (this.state == 4) {
                    this.state = 8;
                    this.stateLock.notifyAll();
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.state = 2;
                this.stateLock.notifyAll();
                LOGGER.trace("connect", "connecting...");
                LOGGER.trace("connect", "before");
                this.sock = this.createAndConnectSocket(this.addr, this.port);
                LOGGER.trace("connect", "after");
                this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
                LOGGER.trace("connect", "streams replaced");
                this.state = 4;
                LOGGER.trace("connect", "connected");
                this.stateLock.notifyAll();
            } else {
                if (this.state == 16) {
                    throw new IllegalStateException("The connection has been closed.");
                }
                LOGGER.trace("connect", "Waiting the state changing.");
                this.checkState();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected Socket createAndConnectSocket(String addr, int port) throws UnknownHostException, IOException {
        return new Socket(addr, port);
    }

    @Override
    public Socket getSocket() {
        return this.sock;
    }

    @Override
    public void setSocket(Socket s) throws IOException {
        this.sock = s;
        this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
    }

    @Override
    public void replaceStreams(InputStream is, OutputStream os) throws IOException {
        this.in = is;
        this.out = os;
        this.replaceInputStreamFlag = true;
        this.replaceOutputStreamFlag = true;
    }

    @Override
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @Override
    public Message readMessage() throws IOException, ClassNotFoundException {
        this.checkState();
        LOGGER.debug("readMessage", "Read a message ...");
        try {
            if (this.replaceInputStreamFlag) {
                this.oin = this.in instanceof BufferedInputStream ? new ObjectInputStreamWithLoader(this.in, this.defaultClassLoader) : new ObjectInputStreamWithLoader(new BufferedInputStream(this.in), this.defaultClassLoader);
                this.replaceInputStreamFlag = false;
            }
            return (Message)this.oin.readObject();
        }
        catch (IOException ioe) {
            throw new IOException(ioe.getMessage() + " for socket " + this.addr + ":" + this.port, ioe);
        }
    }

    @Override
    public void writeMessage(Message msg) throws IOException {
        LOGGER.debug("writeMessage", "Write a message ...");
        this.checkState();
        try {
            if (this.replaceOutputStreamFlag) {
                this.oout = this.out instanceof BufferedOutputStream ? new ObjectOutputStream(this.out) : new ObjectOutputStream(new BufferedOutputStream(this.out));
                this.replaceOutputStreamFlag = false;
            }
            this.oout.writeObject(msg);
            this.oout.flush();
            this.oout.reset();
        }
        catch (IOException ioe) {
            throw new IOException(ioe.getMessage() + " for socket " + this.addr + ":" + this.port, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOGGER.trace("close", "Close the socket connection.");
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 16) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 16;
            if (this.sock instanceof SSLSocket) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.oin.close();
            }
            catch (Exception e) {
                LOGGER.debug("close", e);
            }
            try {
                this.oout.close();
            }
            catch (Exception e) {
                LOGGER.debug("close", e);
            }
            try {
                this.sock.close();
                LOGGER.fine("close", "socket " + this.addr + ":" + this.port + " closed");
            }
            catch (Exception e) {
                LOGGER.debug("close", e);
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getConnectionId() {
        if (this.sock == null) {
            return "Uninitialized connection id";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("jmxmp://").append(this.sock.getInetAddress().getHostAddress()).append(":").append(this.sock.getPort()).append(" ");
        if (this.subject != null) {
            Set<Principal> principals = this.subject.getPrincipals();
            String sep = "";
            for (Principal p : principals) {
                String n = p.getName().replace(' ', '_').replace(';', ':');
                buf.append(sep).append(n);
                sep = ";";
            }
        }
        buf.append(" ").append(System.identityHashCode(this));
        this.connectionId = buf.toString();
        return this.connectionId;
    }

    public String toString() {
        return "SocketConnection{subject=" + this.subject + ", connectionId=" + this.connectionId + ", sock=" + this.sock + ", addr=" + this.addr + ", port=" + this.port + ", state=" + this.state + ", waitConnectedState=" + this.waitConnectedState + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IllegalStateException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 16) {
                throw new IllegalStateException("The connection has been closed.");
            }
            long waitingTime = this.waitConnectedState;
            long endTime = System.currentTimeMillis() + waitingTime;
            while (this.state != 4 && this.state != 16 && waitingTime > 0L) {
                try {
                    this.stateLock.wait(waitingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                waitingTime = endTime - System.currentTimeMillis();
            }
            if (this.state != 4) {
                throw new IllegalStateException("The connection is not currently established.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader cloader;

        public ObjectInputStreamWithLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cloader = cl;
        }

        protected Class resolveClass(ObjectStreamClass aClass) throws IOException, ClassNotFoundException {
            return this.cloader == null ? super.resolveClass(aClass) : Class.forName(aClass.getName(), false, this.cloader);
        }
    }
}

