/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.util.ArrayList;

class JobExecutor
extends Thread {
    private Runnable job = null;
    private final int[] lock = new int[0];
    private boolean terminated = false;
    private static int poolSize = 20;
    private static final ArrayList WAITING_LIST = new ArrayList(poolSize);
    private static long counter = 0L;
    private static long waitingTime = 300000L;
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("Job_Executor");
    private static final String TNAME = "Job_Executor";
    private static final ClassLogger LOGGER = new ClassLogger("com.sun.jmx.remote.opt.util", "JobExecutor");

    private JobExecutor(Runnable job) {
        super(THREAD_GROUP, TNAME + counter++);
        this.setDaemon(true);
        this.job = job;
    }

    public static void setPoolSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size.");
        }
        poolSize = size;
    }

    public static int getPoolSize() {
        return poolSize;
    }

    public static void setWaitingTime(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative waiting time.");
        }
        waitingTime = time;
    }

    public static long getWaitingTime() {
        return waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            if (this.job != null) {
                try {
                    this.job.run();
                }
                catch (Exception e) {
                    LOGGER.warning("run", "Got an unexpected exception.", e);
                }
                finally {
                    this.job = null;
                }
            }
            int[] nArray = this.lock;
            // MONITORENTER : this.lock
            ArrayList arrayList = WAITING_LIST;
            // MONITORENTER : arrayList
            if (WAITING_LIST.size() >= poolSize) {
                this.terminated = true;
                // MONITOREXIT : arrayList
                // MONITOREXIT : nArray
                return;
            }
            WAITING_LIST.add(this);
            // MONITOREXIT : arrayList
            long remainingTime = waitingTime;
            long startTime = System.currentTimeMillis();
            while (this.job == null && remainingTime > 0L) {
                try {
                    this.lock.wait(remainingTime);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                remainingTime = waitingTime - (System.currentTimeMillis() - startTime);
            }
            ArrayList arrayList2 = WAITING_LIST;
            // MONITORENTER : arrayList2
            boolean removed = WAITING_LIST.remove(this);
            // MONITOREXIT : arrayList2
            if (removed) {
                this.terminated = true;
                // MONITOREXIT : nArray
                return;
            }
            while (this.job == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ire) {
                    Thread.interrupted();
                }
            }
            // MONITOREXIT : nArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void handoff(Runnable job) {
        JobExecutor je = null;
        Object object = WAITING_LIST;
        // MONITORENTER : object
        if (WAITING_LIST.size() > 0) {
            je = (JobExecutor)WAITING_LIST.remove(0);
        }
        // MONITOREXIT : object
        if (je != null) {
            object = je.lock;
            // MONITORENTER : je.lock
            if (!je.terminated) {
                je.job = job;
                je.lock.notify();
            } else {
                je = null;
            }
            // MONITOREXIT : object
        }
        if (je != null) return;
        je = new JobExecutor(job);
        je.start();
    }
}

