/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;

public class TLSServerHandler
implements ProfileServer {
    static final boolean bundledJSSE;
    static Method getProtocol;
    static Method getEnabledProtocols;
    static Method setEnabledProtocols;
    static Method getWantClientAuth;
    static Method setWantClientAuth;
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private Subject subject = null;
    private static final String X500_PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final ClassLogger LOGGER;

    static String getProtocol(SSLSession s) throws IOException {
        try {
            return (String)getProtocol.invoke((Object)s, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            throw (IOException)EnvHelp.initCause(new IOException(t.getMessage()), t);
        }
    }

    static String[] getEnabledProtocols(SSLSocket s) throws IOException {
        try {
            return (String[])getEnabledProtocols.invoke((Object)s, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            throw (IOException)EnvHelp.initCause(new IOException(t.getMessage()), t);
        }
    }

    static void setEnabledProtocols(SSLSocket s, String[] p) throws IOException {
        try {
            setEnabledProtocols.invoke((Object)s, new Object[]{p});
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            throw (IOException)EnvHelp.initCause(new IOException(t.getMessage()), t);
        }
    }

    static Boolean getWantClientAuth(SSLSocket s) throws IOException {
        try {
            return (Boolean)getWantClientAuth.invoke((Object)s, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            throw (IOException)EnvHelp.initCause(new IOException(t.getMessage()), t);
        }
    }

    static void setWantClientAuth(SSLSocket s, Boolean b) throws IOException {
        try {
            setWantClientAuth.invoke((Object)s, b);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            throw (IOException)EnvHelp.initCause(new IOException(t.getMessage()), t);
        }
    }

    public TLSServerHandler(String profile, Map env) {
        this.profile = profile;
        this.env = env;
    }

    @Override
    public void initialize(MessageConnection mc, Subject s) throws IOException {
        String needClientAuth;
        String enabledCipherSuites;
        int i;
        int tokens;
        StringTokenizer st;
        this.mc = mc;
        this.subject = s;
        Socket socket = null;
        if (!(mc instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)mc)).getSocket();
        SSLSocketFactory ssf = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (ssf == null) {
            ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String hostname = socket.getInetAddress().getHostName();
        int port = socket.getPort();
        LOGGER.trace("initialize", "TLS: Hostname = " + hostname);
        LOGGER.trace("initialize", "TLS: Port = " + port);
        this.ts = (SSLSocket)ssf.createSocket(socket, hostname, port, true);
        this.ts.setUseClientMode(false);
        LOGGER.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        if (bundledJSSE) {
            String enabledProtocols = (String)this.env.get("jmx.remote.tls.enabled.protocols");
            if (enabledProtocols != null) {
                st = new StringTokenizer(enabledProtocols, " ");
                tokens = st.countTokens();
                String[] enabledProtocolsList = new String[tokens];
                for (i = 0; i < tokens; ++i) {
                    enabledProtocolsList[i] = st.nextToken();
                }
                TLSServerHandler.setEnabledProtocols(this.ts, enabledProtocolsList);
            }
            if (LOGGER.traceOn()) {
                LOGGER.trace("initialize", "TLS: Enabled Protocols");
                String[] enabled_p = TLSServerHandler.getEnabledProtocols(this.ts);
                if (enabled_p != null) {
                    StringBuffer str_buffer = new StringBuffer();
                    for (int i2 = 0; i2 < enabled_p.length; ++i2) {
                        str_buffer.append(enabled_p[i2]);
                        if (i2 + 1 >= enabled_p.length) continue;
                        str_buffer.append(", ");
                    }
                    LOGGER.trace("initialize", "TLS: [" + str_buffer + "]");
                } else {
                    LOGGER.trace("initialize", "TLS: []");
                }
            }
        }
        if ((enabledCipherSuites = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            st = new StringTokenizer(enabledCipherSuites, " ");
            tokens = st.countTokens();
            String[] enabledCipherSuitesList = new String[tokens];
            for (i = 0; i < tokens; ++i) {
                enabledCipherSuitesList[i] = st.nextToken();
            }
            this.ts.setEnabledCipherSuites(enabledCipherSuitesList);
        }
        if (LOGGER.traceOn()) {
            LOGGER.trace("initialize", "TLS: Enabled Cipher Suites");
            String[] enabled_cs = this.ts.getEnabledCipherSuites();
            if (enabled_cs != null) {
                StringBuffer str_buffer = new StringBuffer();
                for (int i3 = 0; i3 < enabled_cs.length; ++i3) {
                    str_buffer.append(enabled_cs[i3]);
                    if (i3 + 1 >= enabled_cs.length) continue;
                    str_buffer.append(", ");
                }
                LOGGER.trace("initialize", "TLS: [" + str_buffer + "]");
            } else {
                LOGGER.trace("initialize", "TLS: []");
            }
        }
        if ((needClientAuth = (String)this.env.get("jmx.remote.tls.need.client.authentication")) != null) {
            this.ts.setNeedClientAuth(Boolean.valueOf(needClientAuth));
        }
        LOGGER.trace("initialize", "TLS: Socket Need Client Authentication = " + this.ts.getNeedClientAuth());
        if (bundledJSSE) {
            String wantClientAuth = (String)this.env.get("jmx.remote.tls.want.client.authentication");
            if (wantClientAuth != null) {
                TLSServerHandler.setWantClientAuth(this.ts, Boolean.valueOf(wantClientAuth));
            }
            LOGGER.trace("initialize", "TLS: Socket Want Client Authentication = " + TLSServerHandler.getWantClientAuth(this.ts));
        }
    }

    @Override
    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tlspm = new TLSMessage(2);
        LOGGER.trace("produceMessage", ">>>>> TLS server message <<<<<");
        LOGGER.trace("produceMessage", "Profile Name : " + tlspm.getProfileName());
        LOGGER.trace("produceMessage", "Status : " + tlspm.getStatus());
        this.completed = true;
        return tlspm;
    }

    @Override
    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        TLSMessage tlspm = (TLSMessage)pm;
        LOGGER.trace("consumeMessage", ">>>>> TLS client message <<<<<");
        LOGGER.trace("consumeMessage", "Profile Name : " + tlspm.getProfileName());
        LOGGER.trace("consumeMessage", "Status : " + tlspm.getStatus());
        if (tlspm.getStatus() != 1) {
            throw new IOException("Unexpected TLS status [" + tlspm.getStatus() + "]");
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public Subject activate() throws IOException {
        LOGGER.trace("activate", ">>>>> TLS handshake <<<<<");
        LOGGER.trace("activate", "TLS: Start TLS Handshake");
        this.ts.startHandshake();
        SSLSession session = this.ts.getSession();
        if (session != null) {
            if (LOGGER.traceOn()) {
                LOGGER.trace("activate", "TLS: getCipherSuite = " + session.getCipherSuite());
                LOGGER.trace("activate", "TLS: getPeerHost = " + session.getPeerHost());
                if (bundledJSSE) {
                    LOGGER.trace("activate", "TLS: getProtocol = " + TLSServerHandler.getProtocol(session));
                }
            }
            try {
                Certificate[] certificate = session.getPeerCertificates();
                if (certificate != null && certificate[0] != null) {
                    Principal p = ((X509Certificate)certificate[0]).getSubjectX500Principal();
                    String pn = p.getName();
                    if (bundledJSSE) {
                        try {
                            Class<?> cl = Class.forName(X500_PRINCIPAL);
                            Constructor<?> co = cl.getConstructor(String.class);
                            p = (Principal)co.newInstance(pn);
                        }
                        catch (Exception e) {
                            String mh = "TLS: Client Authentication: ";
                            LOGGER.trace("activate", "TLS: Client Authentication: " + e.getMessage());
                            LOGGER.debug("activate", e);
                            LOGGER.trace("activate", "TLS: Client Authentication: Got exception building the javax.security.auth.x500.X500Principal from the principal stored in the client's certificate.");
                            LOGGER.trace("activate", "TLS: Client Authentication: Subject DN = [" + pn + "]");
                            LOGGER.trace("activate", "TLS: Client Authentication: Default to JMXPrincipal[" + pn + "]");
                            p = new JMXPrincipal(pn);
                        }
                    } else {
                        p = new JMXPrincipal(pn);
                    }
                    final Principal principal = p;
                    if (this.subject == null) {
                        this.subject = new Subject();
                    }
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            TLSServerHandler.this.subject.getPrincipals().add(principal);
                            return null;
                        }
                    });
                    LOGGER.trace("activate", "TLS: Client Authentication OK! SubjectDN = " + principal);
                } else {
                    LOGGER.trace("activate", "TLS: No Client Authentication");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                LOGGER.trace("activate", "TLS: No Client Authentication: " + e.getMessage());
            }
            LOGGER.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
        return this.subject;
    }

    @Override
    public void terminate() throws IOException {
    }

    @Override
    public String getName() {
        return this.profile;
    }

    static {
        boolean error = false;
        try {
            getProtocol = SSLSession.class.getMethod("getProtocol", new Class[0]);
            getEnabledProtocols = SSLSocket.class.getMethod("getEnabledProtocols", new Class[0]);
            setEnabledProtocols = SSLSocket.class.getMethod("setEnabledProtocols", String[].class);
            getWantClientAuth = SSLSocket.class.getMethod("getWantClientAuth", new Class[0]);
            setWantClientAuth = SSLSocket.class.getMethod("setWantClientAuth", Boolean.TYPE);
        }
        catch (Throwable t) {
            error = true;
        }
        bundledJSSE = !error;
        LOGGER = new ClassLogger("javax.management.remote.misc", "TLSServerHandler");
    }
}

