/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SASLOutputStream
extends OutputStream {
    private int rawSendSize = 65536;
    private final byte[] lenBuf = new byte[4];
    private final OutputStream out;
    private final SaslClient sc;
    private final SaslServer ss;
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "SASLOutputStream");

    public SASLOutputStream(SaslClient sc, OutputStream out) throws IOException {
        this.out = out;
        this.sc = sc;
        this.ss = null;
        String str = (String)sc.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (str != null) {
            try {
                this.rawSendSize = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new IOException("javax.security.sasl.rawsendsize property must be numeric string: " + str);
            }
        }
    }

    public SASLOutputStream(SaslServer ss, OutputStream out) throws IOException {
        this.out = out;
        this.ss = ss;
        this.sc = null;
        String str = (String)ss.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (str != null) {
            try {
                this.rawSendSize = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new IOException("javax.security.sasl.rawsendsize property must be numeric string: " + str);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int total) throws IOException {
        LOGGER.trace("write", "Total size: " + total);
        for (int i = 0; i < total; i += this.rawSendSize) {
            int count = total - i < this.rawSendSize ? total - i : this.rawSendSize;
            byte[] wrappedToken = this.sc != null ? this.sc.wrap(buffer, offset + i, count) : this.ss.wrap(buffer, offset + i, count);
            this.intToNetworkByteOrder(wrappedToken.length, this.lenBuf, 0, 4);
            LOGGER.trace("write", "sending size: " + wrappedToken.length);
            this.out.write(this.lenBuf, 0, 4);
            this.out.write(wrappedToken, 0, wrappedToken.length);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sc != null) {
            this.sc.dispose();
        } else {
            this.ss.dispose();
        }
        this.out.close();
    }

    private void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = count - 1; i >= 0; --i) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }
}

