/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanPermission;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ServerNotifForwarder {
    private final MBeanServer mbeanServer;
    private final long connectionTimeout;
    private static int listenerCounter = 0;
    private static final int[] LISTENER_COUNTER_LOCK = new int[0];
    private final NotificationBuffer notifBuffer;
    private final Set listenerList = new HashSet();
    private boolean terminated = false;
    private final int[] terminationLock = new int[0];
    private static final String BROADCASTER_CLASS = NotificationBroadcaster.class.getName();
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "ServerNotifForwarder");

    public ServerNotifForwarder(MBeanServer mbeanServer, Map env, NotificationBuffer notifBuffer) {
        this.mbeanServer = mbeanServer;
        this.notifBuffer = notifBuffer;
        this.connectionTimeout = EnvHelp.getServerConnectionTimeout(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotificationListener(final ObjectName name, NotificationFilter filter) throws InstanceNotFoundException, IOException {
        LOGGER.trace("addNotificationListener", "Add a listener with ObjectName " + name + " and filter " + filter);
        this.checkState();
        this.checkMBeanPermission(name, "addNotificationListener");
        try {
            Boolean instanceOf = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ServerNotifForwarder.this.mbeanServer.isInstanceOf(name, BROADCASTER_CLASS));
                }
            });
            if (!instanceOf.booleanValue()) {
                throw new IllegalArgumentException("The specified MBean [" + name + "] is not a NotificationBroadcaster object.");
            }
        }
        catch (PrivilegedActionException e) {
            throw (InstanceNotFoundException)ServerNotifForwarder.extractException(e);
        }
        Integer id = this.getListenerID();
        Set set = this.listenerList;
        synchronized (set) {
            this.listenerList.add(new ListenerInfo(id, name, filter));
        }
        return id;
    }

    public void removeNotificationListener(ObjectName name, Integer[] listenerIDs) throws Exception {
        LOGGER.trace("removeNotificationListener", "Remove some listeners from " + name);
        this.checkState();
        this.checkMBeanPermission(name, "removeNotificationListener");
        Exception re = null;
        for (int i = 0; i < listenerIDs.length; ++i) {
            try {
                this.removeNotificationListener(name, listenerIDs[i]);
                continue;
            }
            catch (Exception e) {
                if (re == null) continue;
                re = e;
            }
        }
        if (re != null) {
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, Integer listenerID) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "Remove the listener " + listenerID + " from " + name);
        this.checkState();
        if (name != null && !name.isPattern() && !this.mbeanServer.isRegistered(name)) {
            throw new InstanceNotFoundException("The MBean " + name + " is not registered.");
        }
        Set set = this.listenerList;
        synchronized (set) {
            if (!this.listenerList.remove(new ListenerInfo(listenerID, name, null))) {
                throw new ListenerNotFoundException("Listener not found!");
            }
        }
    }

    public NotificationResult fetchNotifs(long startSequenceNumber, long timeout, int maxNotifications) {
        NotificationResult nr;
        LOGGER.trace("fetchNotifs", "Fetching notifications for request startSequenceNumber=" + startSequenceNumber + ", timeout=" + timeout + ", maxNotifications=" + maxNotifications);
        long t = Math.min(this.connectionTimeout, timeout);
        LOGGER.debug("fetchNotifs", "will use timeout=" + t);
        try {
            nr = this.notifBuffer.fetchNotifications(this.listenerList, startSequenceNumber, t, maxNotifications);
        }
        catch (InterruptedException ire) {
            nr = new NotificationResult(0L, 0L, new TargetedNotification[0]);
        }
        LOGGER.trace("fetchNotifs", "Forwarding the notifs: " + nr);
        return nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        LOGGER.trace("terminate", "Be called.");
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            Set set = this.listenerList;
            synchronized (set) {
                this.listenerList.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOGGER.trace("terminate", "Terminated.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                throw new IOException("The connection has been terminated.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getListenerID() {
        int[] nArray = LISTENER_COUNTER_LOCK;
        synchronized (LISTENER_COUNTER_LOCK) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return listenerCounter++;
        }
    }

    private void checkMBeanPermission(final ObjectName name, String actions) throws InstanceNotFoundException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessControlContext acc = AccessController.getContext();
            ObjectInstance oi = null;
            try {
                oi = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstanceNotFoundException {
                        return ServerNotifForwarder.this.mbeanServer.getObjectInstance(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (InstanceNotFoundException)ServerNotifForwarder.extractException(e);
            }
            String classname = oi.getClassName();
            MBeanPermission perm = new MBeanPermission(classname, null, name, actions);
            sm.checkPermission(perm, acc);
        }
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }
}

