/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ClientListenerInfo;
import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.io.NotSerializableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public abstract class ClientNotifForwarder {
    private final ClassLoader defaultClassLoader;
    private final HashMap infoList = new HashMap();
    private long clientSequenceNumber = -1L;
    private final int maxNotifications;
    private final long timeout;
    private NotifFetcher notifFetcher;
    private Integer mbeanRemovedNotifID = null;
    private Thread currentFetchThread;
    private final boolean inited = false;
    private static final int STARTING = 0;
    private static final int STARTED = 1;
    private static final int STOPPING = 2;
    private static final int STOPPED = 3;
    private static final int TERMINATED = 4;
    private int state = 3;
    private boolean beingReconnected = false;
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "ClientNotifForwarder");

    public ClientNotifForwarder(Map env) {
        this(null, env);
    }

    public ClientNotifForwarder(ClassLoader defaultClassLoader, Map env) {
        this.maxNotifications = EnvHelp.getMaxFetchNotifNumber(env);
        this.timeout = EnvHelp.getFetchTimeout(env);
        this.defaultClassLoader = defaultClassLoader;
    }

    protected abstract NotificationResult fetchNotifs(long var1, int var3, long var4) throws IOException, ClassNotFoundException;

    protected abstract Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException;

    protected abstract void removeListenerForMBeanRemovedNotif(Integer var1) throws IOException, InstanceNotFoundException, ListenerNotFoundException;

    protected abstract void lostNotifs(String var1, long var2);

    public synchronized void addNotificationListener(Integer listenerID, ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, Subject delegationSubject) throws IOException, InstanceNotFoundException {
        LOGGER.trace("addNotificationListener", "Add the listener " + listener + " at " + name);
        this.infoList.put(listenerID, new ClientListenerInfo(listenerID, name, listener, filter, handback, delegationSubject));
        this.init(false);
    }

    public synchronized Integer[] removeNotificationListener(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, IOException {
        this.beforeRemove();
        LOGGER.trace("removeNotificationListener", "Remove the listener " + listener + " from " + name);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList values = new ArrayList(this.infoList.values());
        for (int i = values.size() - 1; i >= 0; --i) {
            ClientListenerInfo li = (ClientListenerInfo)values.get(i);
            if (!li.sameAs(name, listener)) continue;
            ids.add(li.getListenerID());
            this.infoList.remove(li.getListenerID());
        }
        if (ids.isEmpty()) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return ids.toArray(new Integer[0]);
    }

    public synchronized Integer removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException, IOException {
        LOGGER.trace("removeNotificationListener", "Remove the listener " + listener + " from " + name);
        this.beforeRemove();
        Integer id = null;
        ArrayList values = new ArrayList(this.infoList.values());
        for (int i = values.size() - 1; i >= 0; --i) {
            ClientListenerInfo li = (ClientListenerInfo)values.get(i);
            if (!li.sameAs(name, listener, filter, handback)) continue;
            id = li.getListenerID();
            this.infoList.remove(id);
            break;
        }
        if (id == null) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return id;
    }

    public synchronized Integer[] removeNotificationListener(ObjectName name) {
        LOGGER.trace("removeNotificationListener", "Remove all listeners registered at " + name);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList values = new ArrayList(this.infoList.values());
        for (int i = values.size() - 1; i >= 0; --i) {
            ClientListenerInfo li = (ClientListenerInfo)values.get(i);
            if (!li.sameAs(name)) continue;
            ids.add(li.getListenerID());
            this.infoList.remove(li.getListenerID());
        }
        return ids.toArray(new Integer[0]);
    }

    public synchronized ListenerInfo[] getListenerInfo() {
        return this.infoList.values().toArray(new ListenerInfo[0]);
    }

    public synchronized ClientListenerInfo[] preReconnection() throws IOException {
        if (this.state == 4 || this.beingReconnected) {
            throw new IOException("Illegal state.");
        }
        ClientListenerInfo[] tmp = this.infoList.values().toArray(new ClientListenerInfo[0]);
        this.beingReconnected = true;
        this.infoList.clear();
        if (this.currentFetchThread == Thread.currentThread()) {
            return tmp;
        }
        while (this.state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ire) {
                IOException ioe = new IOException(ire.toString());
                EnvHelp.initCause(ioe, ire);
                throw ioe;
            }
        }
        if (this.state == 1) {
            this.setState(2);
        }
        this.currentFetchThread.interrupt();
        return tmp;
    }

    public synchronized void postReconnection(ClientListenerInfo[] listenerInfos) throws IOException {
        if (this.state == 4) {
            return;
        }
        while (this.state == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException ire) {
                IOException ioe = new IOException(ire.toString());
                EnvHelp.initCause(ioe, ire);
                throw ioe;
            }
        }
        int len = listenerInfos.length;
        for (int i = 0; i < len; ++i) {
            LOGGER.trace("addNotificationListeners", "Add a listener at " + listenerInfos[i].getListenerID());
            this.infoList.put(listenerInfos[i].getListenerID(), listenerInfos[i]);
        }
        this.beingReconnected = false;
        this.notifyAll();
        if (this.currentFetchThread == Thread.currentThread()) {
            try {
                this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
            }
            catch (Exception e) {
                String msg = "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered";
                if (LOGGER.traceOn()) {
                    LOGGER.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", e);
                }
            }
        } else if (listenerInfos.length > 0) {
            this.init(true);
        } else if (this.infoList.size() > 0) {
            this.init(false);
        }
    }

    public synchronized void terminate() {
        if (this.state == 4) {
            return;
        }
        if (LOGGER.traceOn()) {
            LOGGER.trace("terminate", "Terminating...");
        }
        if (this.state == 1) {
            this.infoList.clear();
        }
        this.setState(4);
    }

    private synchronized void setState(int newState) {
        if (this.state == 4) {
            return;
        }
        this.state = newState;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void init(boolean reconnected) throws IOException {
        switch (this.state) {
            case 1: {
                return;
            }
            case 0: {
                return;
            }
            case 4: {
                throw new IOException("The ClientNotifForwarder has been terminated.");
            }
            case 2: {
                if (this.beingReconnected) {
                    return;
                }
                while (this.state == 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ire) {
                        ioe = new IOException(ire.toString());
                        EnvHelp.initCause(ioe, ire);
                        throw ioe;
                    }
                }
                this.init(reconnected);
                return;
            }
            case 3: {
                if (this.beingReconnected) {
                    return;
                }
                ClientNotifForwarder.LOGGER.trace("init", "Initializing...");
                if (!reconnected) {
                    try {
                        nr = this.fetchNotifs(-1L, 0, 0L);
                        this.clientSequenceNumber = nr.getNextSequenceNumber();
                    }
                    catch (ClassNotFoundException e) {
                        ClientNotifForwarder.LOGGER.warning("init", "Impossible exception: " + e);
                        ClientNotifForwarder.LOGGER.debug("init", e);
                    }
                }
                try {
                    this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
                }
                catch (Exception e) {
                    msg = "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered";
                    if (!ClientNotifForwarder.LOGGER.traceOn()) ** GOTO lbl41
                    ClientNotifForwarder.LOGGER.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", e);
                }
lbl41:
                // 3 sources

                this.setState(0);
                this.notifFetcher = new NotifFetcher();
                t = new Thread(this.notifFetcher);
                t.setName("JMXMP Client - Notif forwarder " + t.getName());
                t.setDaemon(true);
                t.start();
                return;
            }
        }
        throw new IOException("Unknown state.");
    }

    private synchronized void beforeRemove() throws IOException {
        while (this.beingReconnected) {
            if (this.state == 4) {
                throw new IOException("Terminated.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException ire) {
                IOException ioe = new IOException(ire.toString());
                EnvHelp.initCause(ioe, ire);
                throw ioe;
            }
        }
        if (this.state == 4) {
            throw new IOException("Terminated.");
        }
    }

    private class NotifFetcher
    implements Runnable {
        private Thread fetchThread;

        private NotifFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                ClientNotifForwarder.this.currentFetchThread = Thread.currentThread();
                if (ClientNotifForwarder.this.state == 0) {
                    ClientNotifForwarder.this.setState(1);
                }
            }
            if (ClientNotifForwarder.this.defaultClassLoader != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(ClientNotifForwarder.this.defaultClassLoader);
                        return null;
                    }
                });
            }
            Notification lastNotif = null;
            long lastSeq = -1L;
            while (!this.shouldStop()) {
                Integer myListenerID;
                HashMap<Integer, ListenerInfo> listeners;
                NotificationResult nr = this.fetchNotifs();
                if (nr == null) {
                    LOGGER.error("NotifFetcher-run", "Going to exit thread");
                    break;
                }
                TargetedNotification[] notifs = nr.getTargetedNotifications();
                int len = notifs.length;
                long missed = 0L;
                ClientNotifForwarder clientNotifForwarder2 = ClientNotifForwarder.this;
                synchronized (clientNotifForwarder2) {
                    if (ClientNotifForwarder.this.clientSequenceNumber >= 0L) {
                        missed = nr.getEarliestSequenceNumber() - ClientNotifForwarder.this.clientSequenceNumber;
                    }
                    ClientNotifForwarder.this.clientSequenceNumber = nr.getNextSequenceNumber();
                    int size = ClientNotifForwarder.this.infoList.size();
                    listeners = new HashMap<Integer, ListenerInfo>(size > len ? len : size);
                    if (len == 0) {
                        LOGGER.trace("NotifFetcher-run", "empty notification response: " + nr);
                    }
                    for (int i = 0; i < len; ++i) {
                        TargetedNotification tn = notifs[i];
                        Integer listenerID = tn.getListenerID();
                        if (!listenerID.equals(ClientNotifForwarder.this.mbeanRemovedNotifID)) {
                            ListenerInfo li = (ListenerInfo)ClientNotifForwarder.this.infoList.get(listenerID);
                            if (li == null) continue;
                            listeners.put(listenerID, li);
                            continue;
                        }
                        Notification notif = tn.getNotification();
                        String unreg = "JMX.mbean.unregistered";
                        if (!(notif instanceof MBeanServerNotification) || !notif.getType().equals("JMX.mbean.unregistered")) continue;
                        MBeanServerNotification mbsn = (MBeanServerNotification)notif;
                        ObjectName name = mbsn.getMBeanName();
                        ClientNotifForwarder.this.removeNotificationListener(name);
                    }
                    myListenerID = ClientNotifForwarder.this.mbeanRemovedNotifID;
                }
                if (missed > 0L) {
                    String msg = "May have lost up to " + missed + " notification" + (missed == 1L ? "" : "s") + " last seq: " + lastSeq + ", first seq:" + nr.getEarliestSequenceNumber() + " last notif data=[" + (lastNotif != null ? lastNotif.getType() + "," + lastNotif.getMessage() : "empty") + "] new notif data=[" + (notifs.length > 0 ? notifs[0].getNotification().getType() + "," + notifs[0].getNotification().getMessage() : "empty") + "]";
                    ClientNotifForwarder.this.lostNotifs(msg, missed);
                    LOGGER.trace("NotifFetcher-run", msg);
                }
                lastNotif = len > 0 ? notifs[len - 1].getNotification() : null;
                lastSeq = ClientNotifForwarder.this.clientSequenceNumber - 1L;
                for (int i = 0; i < len; ++i) {
                    TargetedNotification tn = notifs[i];
                    this.dispatchNotification(tn, myListenerID, listeners);
                }
            }
            LOGGER.trace("NotifFetcher-run", "NotifFecther thread STOPPED");
            ClientNotifForwarder.this.setState(3);
        }

        void dispatchNotification(TargetedNotification tn, Integer myListenerID, Map listeners) {
            Notification notif = tn.getNotification();
            Integer listenerID = tn.getListenerID();
            if (listenerID.equals(myListenerID)) {
                return;
            }
            ClientListenerInfo li = (ClientListenerInfo)listeners.get(listenerID);
            if (li == null) {
                LOGGER.trace("NotifFetcher.dispatch", "Listener ID not in map");
                return;
            }
            NotificationListener l = li.getListener();
            Object h = li.getHandback();
            try {
                l.handleNotification(notif, h);
            }
            catch (RuntimeException e) {
                String msg = "Failed to forward a notification to a listener";
                LOGGER.warning("NotifFetcher-run", "Failed to forward a notification to a listener", e);
            }
        }

        private NotificationResult fetchNotifs() {
            try {
                LOGGER.fine("NotifFetcher-run", "Requesting nofications from seq: " + ClientNotifForwarder.this.clientSequenceNumber);
                NotificationResult nr = ClientNotifForwarder.this.fetchNotifs(ClientNotifForwarder.this.clientSequenceNumber, ClientNotifForwarder.this.maxNotifications, ClientNotifForwarder.this.timeout);
                LOGGER.fine("NotifFetcher-run", "Got notifications from the server: " + nr);
                return nr;
            }
            catch (ClassNotFoundException e) {
                LOGGER.trace("NotifFetcher.fetchNotifs", e);
                return this.fetchOneNotif();
            }
            catch (NotSerializableException e) {
                LOGGER.trace("NotifFetcher.fetchNotifs", e);
                return this.fetchOneNotif();
            }
            catch (IOException ioe) {
                if (!this.shouldStop()) {
                    LOGGER.warning("NotifFetcher-run", "Failed to fetch notification due to exception: " + ioe.getMessage());
                    LOGGER.debug("NotifFetcher-run", ioe);
                }
                return null;
            }
        }

        private NotificationResult fetchOneNotif() {
            ClientNotifForwarder cnf = ClientNotifForwarder.this;
            long startSequenceNumber = ClientNotifForwarder.this.clientSequenceNumber;
            int notFoundCount = 0;
            NotificationResult result = null;
            while (result == null && !this.shouldStop()) {
                NotificationResult nr;
                try {
                    nr = cnf.fetchNotifs(startSequenceNumber, 0, 0L);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warning("NotifFetcher.fetchOneNotif", "Impossible exception: " + e);
                    LOGGER.debug("NotifFetcher.fetchOneNotif", e);
                    return null;
                }
                catch (IOException e) {
                    if (!this.shouldStop()) {
                        LOGGER.trace("NotifFetcher.fetchOneNotif", e);
                    }
                    return null;
                }
                if (this.shouldStop()) {
                    return null;
                }
                startSequenceNumber = nr.getNextSequenceNumber();
                try {
                    result = cnf.fetchNotifs(startSequenceNumber, 1, 0L);
                }
                catch (Exception e) {
                    if (e instanceof ClassNotFoundException || e instanceof NotSerializableException) {
                        LOGGER.warning("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification: " + e.toString());
                        if (LOGGER.traceOn()) {
                            LOGGER.trace("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification.", e);
                        }
                        ++notFoundCount;
                        ++startSequenceNumber;
                        continue;
                    }
                    if (!this.shouldStop()) {
                        LOGGER.trace("NotifFetcher.fetchOneNotif", e);
                    }
                    return null;
                }
            }
            if (notFoundCount > 0) {
                String msg = "Dropped " + notFoundCount + " notification" + (notFoundCount == 1 ? "" : "s") + " because classes were missing locally";
                ClientNotifForwarder.this.lostNotifs(msg, notFoundCount);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldStop() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                if (ClientNotifForwarder.this.state != 1) {
                    return true;
                }
                if (ClientNotifForwarder.this.infoList.isEmpty()) {
                    ClientNotifForwarder.this.setState(2);
                    return true;
                }
                return false;
            }
        }
    }
}

