/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.io.InterruptedIOException;

public abstract class ClientCommunicatorAdmin {
    private final Checker checker;
    private final long period;
    private static final int CONNECTED = 0;
    private static final int RE_CONNECTING = 1;
    private static final int FAILED = 2;
    private static final int TERMINATED = 3;
    private int state = 0;
    private final int[] lock = new int[0];
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "ClientCommunicatorAdmin");

    public ClientCommunicatorAdmin(long period) {
        this.period = period;
        if (period > 0L) {
            this.checker = new Checker();
            Thread t = new Thread(this.checker);
            t.setName("JMXMP Client - Connection Checker " + t.getName());
            t.setDaemon(true);
            t.start();
        } else {
            this.checker = null;
        }
    }

    public void gotIOException(IOException ioe) throws IOException {
        this.restart(ioe);
    }

    protected abstract void checkConnection() throws IOException;

    protected abstract void doStart() throws IOException;

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 3;
            this.lock.notifyAll();
            if (this.checker != null) {
                this.checker.stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(IOException ioe) throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 3) {
                throw new IOException("The client has been closed.");
            }
            if (this.state == 2) {
                throw ioe;
            }
            if (this.state == 1) {
                while (this.state == 1) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ire) {
                        InterruptedIOException iioe = new InterruptedIOException(ire.toString());
                        EnvHelp.initCause(iioe, ire);
                        throw iioe;
                    }
                }
                if (this.state == 3) {
                    throw new IOException("The client has been closed.");
                }
                if (this.state != 0) {
                    throw ioe;
                }
            } else {
                this.state = 1;
                this.lock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.doStart();
                nArray = this.lock;
                synchronized (this.lock) {
                    if (this.state == 3) {
                        throw new IOException("The client has been closed.");
                    }
                    this.state = 0;
                    this.lock.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOGGER.warning("restart", "Failed to restart: " + e);
                LOGGER.debug("restart", e);
                int[] nArray2 = this.lock;
                synchronized (this.lock) {
                    if (this.state == 3) {
                        throw new IOException("The client has been closed.");
                    }
                    this.state = 2;
                    this.lock.notifyAll();
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    try {
                        this.doStop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.terminate();
                    throw ioe;
                }
            }
            {
                return;
            }
        }
    }

    private class Checker
    implements Runnable {
        private Thread myThread;

        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOGGER.traceOn()) {
                LOGGER.trace("Checker-run", "Starting. Will check server connection every " + ClientCommunicatorAdmin.this.period + "ms");
            }
            this.myThread = Thread.currentThread();
            while (ClientCommunicatorAdmin.this.state != 3 && !this.myThread.isInterrupted()) {
                try {
                    Thread.sleep(ClientCommunicatorAdmin.this.period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ClientCommunicatorAdmin.this.state == 3 || this.myThread.isInterrupted()) break;
                try {
                    if (LOGGER.traceOn()) {
                        LOGGER.trace("Checker-run", "Going to check connection...");
                    }
                    ClientCommunicatorAdmin.this.checkConnection();
                }
                catch (Exception e) {
                    int[] nArray = ClientCommunicatorAdmin.this.lock;
                    synchronized (nArray) {
                        if (ClientCommunicatorAdmin.this.state == 3 || this.myThread.isInterrupted()) {
                            break;
                        }
                    }
                    e = (Exception)EnvHelp.getCause(e);
                    if (e instanceof IOException && !(e instanceof InterruptedIOException)) {
                        try {
                            ClientCommunicatorAdmin.this.restart((IOException)e);
                            continue;
                        }
                        catch (Exception ee) {
                            LOGGER.warning("Checker-run", "Failed to check connection: " + e);
                            LOGGER.warning("Checker-run", "Stopping connection checker");
                            LOGGER.debug("Checker-run", e);
                            break;
                        }
                    }
                    LOGGER.warning("Checker-run", "Failed to check the connection: " + e);
                    LOGGER.debug("Checker-run", e);
                    break;
                }
            }
            if (LOGGER.traceOn()) {
                LOGGER.trace("Checker-run", "Finished.");
            }
        }

        private void stop() {
            if (this.myThread != null && this.myThread != Thread.currentThread()) {
                this.myThread.interrupt();
            }
        }
    }
}

