/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ArrayQueue;
import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ArrayNotificationBuffer
implements NotificationBuffer {
    private boolean disposed = false;
    private static final HashMap mbsToBuffer = new HashMap(1);
    private final Collection sharers = new HashSet(1);
    private final NotificationListener bufferListener = new BufferListener();
    private static final QueryExp BROADCASTER_QUERY = new BroadcasterQuery();
    private static final NotificationFilter CREATION_FILTER;
    private final NotificationListener creationListener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notif, Object handback) {
            LOGGER.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notif);
        }
    };
    private static final ClassLogger LOGGER;
    private static final ObjectName DELEGATE_NAME;
    private final MBeanServer mBeanServer;
    private final ArrayQueue queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private Set createdDuringQuery;
    private static final String BROADCASTER_CLASS;

    public static synchronized NotificationBuffer getNotificationBuffer(MBeanServer mbs, Map env) {
        int queueSize = EnvHelp.getNotifBufferSize(env);
        ArrayNotificationBuffer buf = (ArrayNotificationBuffer)mbsToBuffer.get(mbs);
        if (buf == null) {
            buf = new ArrayNotificationBuffer(mbs, queueSize);
            mbsToBuffer.put(mbs, buf);
        }
        ArrayNotificationBuffer arrayNotificationBuffer = buf;
        arrayNotificationBuffer.getClass();
        return arrayNotificationBuffer.new ShareBuffer(queueSize);
    }

    public static synchronized void removeNotificationBuffer(MBeanServer mbs) {
        mbsToBuffer.remove(mbs);
    }

    synchronized void addSharer(ShareBuffer sharer) {
        if (sharer.getSize() > this.queueSize) {
            this.resize(sharer.getSize());
        }
        this.sharers.add(sharer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSharer(ShareBuffer sharer) {
        boolean empty;
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            this.sharers.remove(sharer);
            empty = this.sharers.isEmpty();
            if (!empty) {
                int max = 0;
                for (ShareBuffer buf : this.sharers) {
                    int bufsize = buf.getSize();
                    if (bufsize <= max) continue;
                    max = bufsize;
                }
                if (max < this.queueSize) {
                    this.resize(max);
                }
            }
        }
        if (empty) {
            this.dispose();
        }
    }

    private void resize(int newSize) {
        if (newSize == this.queueSize) {
            return;
        }
        while (this.queue.size() > newSize) {
            this.dropNotification();
        }
        this.queue.resize(newSize);
        this.queueSize = newSize;
    }

    private ArrayNotificationBuffer(MBeanServer mbs, int queueSize) {
        LOGGER.trace("Constructor", "queueSize=" + queueSize);
        if (mbs == null || queueSize < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mbs;
        this.queueSize = queueSize;
        this.queue = new ArrayQueue(queueSize);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        this.createListeners();
        LOGGER.trace("Constructor", "ends");
    }

    private synchronized boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        LOGGER.trace("dispose", "starts");
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            ArrayNotificationBuffer.removeNotificationBuffer(this.mBeanServer);
            this.disposed = true;
            this.notifyAll();
        }
        this.destroyListeners();
        LOGGER.trace("dispose", "ends");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResult fetchNotifications(Set listeners, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
        LOGGER.trace("fetchNotifications", "starts");
        if (startSequenceNumber < 0L || this.isDisposed()) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
            }
        }
        if (listeners == null || startSequenceNumber < 0L || timeout < 0L || maxNotifications < 0) {
            LOGGER.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        LOGGER.trace("fetchNotifications", "listener-length=" + listeners.size() + "; startSeq=" + startSequenceNumber + "; timeout=" + timeout + "; max=" + maxNotifications);
        if (startSequenceNumber > this.nextSequenceNumber()) {
            String msg = "Start sequence number too big: " + startSequenceNumber + " > " + this.nextSequenceNumber();
            LOGGER.trace("fetchNotifications", msg);
            throw new IllegalArgumentException(msg);
        }
        long endTime = System.currentTimeMillis() + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        LOGGER.debug("fetchNotifications", "endTime=" + endTime);
        long earliestSeq = -1L;
        long nextSeq = startSequenceNumber;
        ArrayList notifs = new ArrayList();
        LOGGER.debug("fetchNotifications", "main fetch loop starts");
        while (true) {
            NamedNotification candidate;
            LOGGER.debug("fetchNotifications", "fetch notifications");
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                if (earliestSeq < 0L) {
                    earliestSeq = this.earliestSequenceNumber();
                    if (LOGGER.debugOn()) {
                        LOGGER.debug("fetchNotifications", "earliestSeq=" + earliestSeq);
                    }
                    if (nextSeq < earliestSeq) {
                        nextSeq = earliestSeq;
                        LOGGER.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    earliestSeq = this.earliestSequenceNumber();
                }
                if (nextSeq < earliestSeq) {
                    LOGGER.trace("fetchNotifications", "nextSeq=" + nextSeq + " < " + "earliestSeq=" + earliestSeq + " so may have lost notifs");
                    break;
                }
                if (nextSeq < this.nextSequenceNumber()) {
                    candidate = this.notificationAt(nextSeq);
                    if (LOGGER.debugOn()) {
                        LOGGER.debug("fetchNotifications", "candidate: " + candidate);
                        LOGGER.debug("fetchNotifications", "nextSeq now " + nextSeq);
                    }
                } else {
                    if (notifs.size() > 0) {
                        LOGGER.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long toWait = endTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        LOGGER.debug("fetchNotifications", "timeout reached after " + timeout);
                        break;
                    }
                    if (this.isDisposed()) {
                        LOGGER.debug("fetchNotifications", "dispose called, no wait");
                        return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
                    }
                    LOGGER.debug("fetchNotifications", "wait(" + toWait + ")");
                    this.wait(toWait);
                    continue;
                }
            }
            ObjectName name = candidate.getObjectName();
            Notification notif = candidate.getNotification();
            ArrayList<TargetedNotification> matchedNotifs = new ArrayList<TargetedNotification>();
            LOGGER.debug("fetchNotifications", "applying filters to candidate");
            Set set = listeners;
            synchronized (set) {
                for (ListenerInfo li : listeners) {
                    ObjectName pattern = li.getObjectName();
                    NotificationFilter filter = li.getNotificationFilter();
                    LOGGER.debug("fetchNotifications", "pattern=<" + pattern + ">; filter=" + filter);
                    if (!pattern.apply(name)) continue;
                    LOGGER.debug("fetchNotifications", "pattern matches");
                    if (filter != null && !filter.isNotificationEnabled(notif)) continue;
                    LOGGER.debug("fetchNotifications", "filter matches");
                    Integer listenerID = li.getListenerID();
                    TargetedNotification tn = new TargetedNotification(notif, listenerID);
                    matchedNotifs.add(tn);
                }
            }
            if (matchedNotifs.size() > 0) {
                if (maxNotifications <= 0) {
                    LOGGER.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --maxNotifications;
                LOGGER.debug("fetchNotifications", "add: " + matchedNotifs);
                notifs.addAll(matchedNotifs);
            } else {
                LOGGER.debug("fetchNotifications", "no notifications found yet");
            }
            ++nextSeq;
        }
        int nnotifs = notifs.size();
        TargetedNotification[] resultNotifs = new TargetedNotification[nnotifs];
        notifs.toArray(resultNotifs);
        NotificationResult nr = new NotificationResult(earliestSeq, nextSeq, resultNotifs);
        LOGGER.debug("fetchNotifications", "Requested startSeq:" + startSequenceNumber + " and returned " + nr.toString() + " ");
        LOGGER.trace("fetchNotifications", "ends");
        return nr;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification notif) {
        if (LOGGER.traceOn()) {
            LOGGER.finer("addNotification", "Adding notification: " + notif.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            LOGGER.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(notif);
        ++this.nextSequenceNumber;
        LOGGER.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        this.notifyAll();
    }

    private void dropNotification() {
        Object o = this.queue.remove(0);
        LOGGER.debug("dropNotification", "dropped notif: " + o);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long seqNo) {
        long index = seqNo - this.earliestSequenceNumber;
        if (index < 0L || index > Integer.MAX_VALUE) {
            String msg = "Bad sequence number: " + seqNo + " (earliest " + this.earliestSequenceNumber + ")";
            LOGGER.trace("notificationAt", msg);
            throw new IllegalArgumentException(msg);
        }
        return (NamedNotification)this.queue.get((int)index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createListeners() {
        LOGGER.debug("createListeners", "starts");
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            this.createdDuringQuery = new HashSet();
        }
        try {
            this.addNotificationListener(DELEGATE_NAME, this.creationListener, CREATION_FILTER, null);
            LOGGER.debug("createListeners", "added creationListener");
        }
        catch (Exception e) {
            String msg = "Can't add listener to MBean server delegate: ";
            IllegalArgumentException re = new IllegalArgumentException("Can't add listener to MBean server delegate: " + e);
            EnvHelp.initCause(re, e);
            LOGGER.fine("createListeners", "Can't add listener to MBean server delegate: " + e);
            LOGGER.debug("createListeners", e);
            throw re;
        }
        HashSet names = this.queryNames(null, BROADCASTER_QUERY);
        names = new HashSet(names);
        ArrayNotificationBuffer msg = this;
        synchronized (msg) {
            names.addAll(this.createdDuringQuery);
            this.createdDuringQuery = null;
        }
        for (ObjectName name : names) {
            this.addBufferListener(name);
        }
        LOGGER.debug("createListeners", "ends");
    }

    private void addBufferListener(ObjectName name) {
        LOGGER.debug("addBufferListener", name.toString());
        try {
            this.addNotificationListener(name, this.bufferListener, null, name);
        }
        catch (Exception e) {
            LOGGER.trace("addBufferListener", e);
        }
    }

    private void removeBufferListener(ObjectName name) {
        LOGGER.debug("removeBufferListener", name.toString());
        try {
            this.removeNotificationListener(name, this.bufferListener);
        }
        catch (Exception e) {
            LOGGER.trace("removeBufferListener", e);
        }
    }

    private void addNotificationListener(final ObjectName name, final NotificationListener listener, final NotificationFilter filter, final Object handback) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(name, listener, filter, handback);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ArrayNotificationBuffer.extractException(e);
        }
    }

    private void removeNotificationListener(final ObjectName name, final NotificationListener listener) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(name, listener);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ArrayNotificationBuffer.extractException(e);
        }
    }

    private Set queryNames(final ObjectName name, final QueryExp query) {
        PrivilegedAction act = new PrivilegedAction(){

            public Object run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(name, query);
            }
        };
        try {
            return (Set)AccessController.doPrivileged(act);
        }
        catch (RuntimeException e) {
            LOGGER.fine("queryNames", "Failed to query names: " + e);
            LOGGER.debug("queryNames", e);
            throw e;
        }
    }

    private static boolean isInstanceOf(final MBeanServer mbs, final ObjectName name, final String className) {
        PrivilegedExceptionAction act = new PrivilegedExceptionAction(){

            public Object run() throws InstanceNotFoundException {
                return mbs.isInstanceOf(name, className);
            }
        };
        try {
            return (Boolean)AccessController.doPrivileged(act);
        }
        catch (Exception e) {
            LOGGER.fine("isInstanceOf", "failed: " + e);
            LOGGER.debug("isInstanceOf", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createdNotification(MBeanServerNotification n) {
        String shouldEqual = "JMX.mbean.registered";
        if (!n.getType().equals("JMX.mbean.registered")) {
            LOGGER.warning("createNotification", "bad type: " + n.getType());
            return;
        }
        ObjectName name = n.getMBeanName();
        LOGGER.debug("createdNotification", "for: " + name);
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            if (this.createdDuringQuery != null) {
                this.createdDuringQuery.add(name);
                return;
            }
        }
        if (ArrayNotificationBuffer.isInstanceOf(this.mBeanServer, name, BROADCASTER_CLASS)) {
            this.addBufferListener(name);
            if (this.isDisposed()) {
                this.removeBufferListener(name);
            }
        }
    }

    private void destroyListeners() {
        LOGGER.debug("destroyListeners", "starts");
        try {
            this.removeNotificationListener(DELEGATE_NAME, this.creationListener);
        }
        catch (Exception e) {
            LOGGER.warning("remove listener from MBeanServer delegate", e);
        }
        Set names = this.queryNames(null, BROADCASTER_QUERY);
        for (ObjectName name : names) {
            LOGGER.debug("destroyListeners", "remove listener from " + name);
            this.removeBufferListener(name);
        }
        LOGGER.debug("destroyListeners", "ends");
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    static {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("JMX.mbean.registered");
        CREATION_FILTER = nfs;
        LOGGER = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        try {
            DELEGATE_NAME = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            RuntimeException re = new RuntimeException("Can't create delegate name: " + e);
            EnvHelp.initCause(re, e);
            LOGGER.error("<init>", "Can't create delegate name: " + e);
            LOGGER.debug("<init>", e);
            throw re;
        }
        BROADCASTER_CLASS = NotificationBroadcaster.class.getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private BroadcasterQuery() {
        }

        @Override
        public boolean apply(ObjectName name) {
            MBeanServer mbs = QueryEval.getMBeanServer();
            return ArrayNotificationBuffer.isInstanceOf(mbs, name, BROADCASTER_CLASS);
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        @Override
        public void handleNotification(Notification notif, Object handback) {
            LOGGER.debug("BufferListener.handleNotification", "notif=" + notif + "; handback=" + handback);
            ObjectName name = (ObjectName)handback;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(name, notif));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName sender, Notification notif) {
            this.sender = sender;
            this.notification = notif;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int size) {
            this.size = size;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        @Override
        public NotificationResult fetchNotifications(Set listeners, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
            ArrayNotificationBuffer buf = ArrayNotificationBuffer.this;
            return buf.fetchNotifications(listeners, startSequenceNumber, timeout, maxNotifications);
        }

        @Override
        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

