/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnectionImpl;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnectionServer;

public class SynchroMessageConnectionServerImpl
implements SynchroMessageConnectionServer {
    private MessageConnectionServer messageConnectionServer;
    private Map env;
    private final ServerAdmin serverAdmin;
    private final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "SynchroMessageConnectionServerImpl");

    public SynchroMessageConnectionServerImpl(MessageConnectionServer messageConnectionServer, Map env) {
        if (messageConnectionServer == null) {
            throw new IllegalArgumentException("Null MessageConnectionServer");
        }
        this.messageConnectionServer = messageConnectionServer;
        this.env = env;
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
    }

    @Override
    public void start(Map env) throws IOException {
        this.LOGGER.trace("start", "Starts a SynchroMessageConnectionServerImpl.");
        this.messageConnectionServer.start(env);
    }

    @Override
    public ServerSynchroMessageConnection accept() throws IOException {
        this.LOGGER.trace("accept", "Waiting for an incoming client connection...");
        return new ServerSynchroMessageConnectionImpl(this.messageConnectionServer.accept(), this.env);
    }

    @Override
    public void stop() throws IOException {
        this.LOGGER.trace("stop", "Stops a SynchroMessageConnectionServerImpl object.");
        this.messageConnectionServer.stop();
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.messageConnectionServer.getAddress();
    }

    public MessageConnectionServer getAsynchronConnection() {
        return this.messageConnectionServer;
    }
}

