/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ProfileProviderException;
import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.generic.ProfileServerProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ProfileServerFactory {
    public static final String PROFILE_PROVIDER_PACKAGES = "jmx.remote.profile.provider.pkgs";
    public static final String PROFILE_PROVIDER_CLASS_LOADER = "jmx.remote.profile.provider.class.loader";
    private static final String PROFILE_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.profile";

    private ProfileServerFactory() {
    }

    public static ProfileServer createProfile(String profile, Map environment) throws ProfileProviderException {
        String pkgs = ProfileServerFactory.resolvePkgs(environment);
        ClassLoader loader = ProfileServerFactory.resolveClassLoader(environment);
        environment = environment == null ? new HashMap<String, ClassLoader>() : new HashMap(environment);
        environment.put(PROFILE_PROVIDER_CLASS_LOADER, loader);
        environment = Collections.unmodifiableMap(environment);
        ProfileServerProvider provider = ProfileServerFactory.getProvider(profile, pkgs, loader);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported profile: " + profile);
        }
        return provider.createProfile(profile, environment);
    }

    private static String resolvePkgs(Map env) {
        String pkgs = null;
        if (env != null) {
            pkgs = (String)env.get(PROFILE_PROVIDER_PACKAGES);
        }
        if (pkgs == null) {
            pkgs = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ProfileServerFactory.PROFILE_PROVIDER_PACKAGES);
                }
            });
        }
        pkgs = pkgs == null || pkgs.trim().equals("") ? PROFILE_PROVIDER_DEFAULT_PACKAGE : pkgs + "|com.sun.jmx.remote.profile";
        return pkgs;
    }

    private static final ProfileServerProvider getProvider(String profile, String pkgs, ClassLoader loader) throws ProfileProviderException {
        Object obj = null;
        StringTokenizer tokenizer = new StringTokenizer(pkgs, "|");
        String p = profile.toLowerCase();
        if (p.contains("/")) {
            p = p.substring(0, p.indexOf("/"));
        }
        while (tokenizer.hasMoreTokens()) {
            Class<?> providerClass;
            String pkg = tokenizer.nextToken();
            String className = pkg + "." + p + ".ServerProvider";
            try {
                providerClass = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                obj = providerClass.newInstance();
            }
            catch (Exception e) {
                throw new ProfileProviderException("Exception when instantiating provider [" + className + "]", e);
            }
            if (!(obj instanceof ProfileServerProvider)) {
                throw new IllegalArgumentException("Provider not an instance of " + ProfileServerProvider.class.getName() + ": " + obj.getClass().getName());
            }
            return (ProfileServerProvider)obj;
        }
        return null;
    }

    private static ClassLoader resolveClassLoader(Map environment) {
        Object value;
        ClassLoader loader = null;
        if (environment != null && (value = environment.get(PROFILE_PROVIDER_CLASS_LOADER)) != null) {
            if (value instanceof ClassLoader) {
                loader = (ClassLoader)ClassLoader.class.cast(value);
            } else {
                throw new IllegalArgumentException("ClassLoader not an instance of java.lang.ClassLoader: " + value.getClass().getName());
            }
        }
        if (loader == null) {
            loader = ProfileServerFactory.class.getClassLoader();
        }
        return loader;
    }
}

