/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.generic.ProfileClientProvider;
import com.sun.jmx.remote.generic.ProfileProviderException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ProfileClientFactory {
    public static final String PROFILE_PROVIDER_PACKAGES = "jmx.remote.profile.provider.pkgs";
    public static final String PROFILE_PROVIDER_CLASS_LOADER = "jmx.remote.profile.provider.class.loader";
    private static final String PROFILE_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.profile";

    private ProfileClientFactory() {
    }

    public static ProfileClient createProfile(String profile, Map environment) throws ProfileProviderException {
        String pkgs = ProfileClientFactory.resolvePkgs(environment);
        ClassLoader loader = ProfileClientFactory.resolveClassLoader(environment);
        environment = environment == null ? new HashMap<String, ClassLoader>() : new HashMap(environment);
        environment.put(PROFILE_PROVIDER_CLASS_LOADER, loader);
        environment = Collections.unmodifiableMap(environment);
        ProfileClientProvider provider = ProfileClientFactory.getProvider(profile, pkgs, loader);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported profile: " + profile);
        }
        return provider.createProfile(profile, environment);
    }

    private static String resolvePkgs(Map env) {
        String pkgs = null;
        if (env != null) {
            pkgs = (String)env.get(PROFILE_PROVIDER_PACKAGES);
        }
        if (pkgs == null) {
            pkgs = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ProfileClientFactory.PROFILE_PROVIDER_PACKAGES);
                }
            });
        }
        pkgs = pkgs == null || pkgs.trim().equals("") ? PROFILE_PROVIDER_DEFAULT_PACKAGE : pkgs + "|com.sun.jmx.remote.profile";
        return pkgs;
    }

    private static final ProfileClientProvider getProvider(String profile, String pkgs, ClassLoader loader) throws ProfileProviderException {
        Object obj = null;
        StringTokenizer tokenizer = new StringTokenizer(pkgs, "|");
        String p = profile.toLowerCase();
        if (p.contains("/")) {
            p = p.substring(0, p.indexOf("/"));
        }
        while (tokenizer.hasMoreTokens()) {
            Class<?> providerClass;
            String pkg = tokenizer.nextToken();
            String className = pkg + "." + p + ".ClientProvider";
            try {
                providerClass = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                obj = providerClass.newInstance();
            }
            catch (Exception e) {
                throw new ProfileProviderException("Exception when instantiating provider [" + className + "]", e);
            }
            if (!(obj instanceof ProfileClientProvider)) {
                throw new IllegalArgumentException("Provider not an instance of " + ProfileClientProvider.class.getName() + ": " + obj.getClass().getName());
            }
            return (ProfileClientProvider)obj;
        }
        return null;
    }

    private static ClassLoader resolveClassLoader(Map environment) {
        ClassLoader loader = null;
        if (environment != null) {
            try {
                loader = (ClassLoader)environment.get(PROFILE_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("ClassLoader not an instance of java.lang.ClassLoader : " + loader.getClass().getName());
            }
        }
        if (loader == null) {
            loader = ProfileClientFactory.class.getClassLoader();
        }
        return loader;
    }
}

