/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import javax.management.remote.generic.ObjectWrapping;

public class ObjectWrappingImpl
implements ObjectWrapping {
    @Override
    public Object wrap(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        return baos.toByteArray();
    }

    @Override
    public Object unwrap(Object wrapped, ClassLoader cloader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])wrapped);
        ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(bais);
        return ois.readObject(cloader);
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private ClassLoader cloader;

        public ObjectInputStreamWithLoader(InputStream in) throws IOException {
            super(in);
        }

        public Object readObject(ClassLoader cloader) throws IOException, ClassNotFoundException {
            this.cloader = cloader;
            return this.readObject();
        }

        protected Class resolveClass(ObjectStreamClass aClass) throws IOException, ClassNotFoundException {
            return this.cloader == null ? super.resolveClass(aClass) : Class.forName(aClass.getName(), false, this.cloader);
        }
    }
}

