/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.security.AdminServer;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.util.Map;

public class DefaultConfig {
    public static final String SERVER_MAX_THREADS = "jmx.remote.x.server.max.threads";
    public static final String SERVER_MIN_THREADS = "jmx.remote.x.server.min.threads";
    public static final String REQUEST_WAITING_TIME = "jmx.remote.x.request.timeout";
    public static final String SERVER_SIDE_CONNECTING_TIMEOUT = "jmx.remote.x.server.side.connecting.timeout";
    public static final String SERVER_ADMIN = "com.sun.jmx.remote.server.admin";
    public static final String CLIENT_ADMIN = "com.sun.jmx.remote.client.admin";
    public static final String SYNCHRO_MESSAGE_CONNECTION_SERVER = "com.sun.jmx.remote.generic.synchro.server";
    public static final String CLIENT_SYNCHRO_MESSAGE_CONNECTION = "com.sun.jmx.remote.generic.synchro.client";
    public static final String TIMEOUT_FOR_CONNECTED_STATE = "jmx.remote.x.client.connected.state.timeout";
    public static final String SERVER_REUSE_ADDRESS = "jmx.remote.x.server.reuse.address";
    public static final String TIMEOUT_RECONNECTION = "jmx.remote.x.client.timeout.reconnection";

    public static int getServerMaxThreads(Map env) {
        return (int)EnvHelp.getIntegerAttribute(env, SERVER_MAX_THREADS, 10L, 1L, Integer.MAX_VALUE);
    }

    public static int getServerMinThreads(Map env) {
        return (int)EnvHelp.getIntegerAttribute(env, SERVER_MIN_THREADS, 1L, 1L, Integer.MAX_VALUE);
    }

    public static long getRequestTimeout(Map env) {
        return EnvHelp.getIntegerAttribute(env, REQUEST_WAITING_TIME, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public static long getConnectingTimeout(Map env) {
        long l;
        try {
            l = EnvHelp.getIntegerAttribute(env, SERVER_SIDE_CONNECTING_TIMEOUT, 0L, 0L, Long.MAX_VALUE);
        }
        catch (IllegalArgumentException iae) {
            l = 0L;
        }
        return l;
    }

    public static ServerAdmin getServerAdmin(Map env) {
        ServerAdmin admin;
        Object o = env.get(SERVER_ADMIN);
        if (o == null) {
            admin = new AdminServer(env);
        } else if (o instanceof ServerAdmin) {
            admin = (ServerAdmin)o;
        } else {
            throw new IllegalArgumentException("The specified attribute [com.sun.jmx.remote.server.admin] is not a ServerAdmin object.");
        }
        return admin;
    }

    public static ClientAdmin getClientAdmin(Map env) {
        ClientAdmin admin;
        Object o = env.get(CLIENT_ADMIN);
        if (o == null) {
            admin = new AdminClient(env);
        } else if (o instanceof ClientAdmin) {
            admin = (ClientAdmin)o;
        } else {
            throw new IllegalArgumentException("The specified attribute [com.sun.jmx.remote.client.admin] is not a ClientAdmin object.");
        }
        return admin;
    }

    public static SynchroMessageConnectionServer getSynchroMessageConnectionServer(Map env) {
        SynchroMessageConnectionServer ret = null;
        if (env != null) {
            ret = (SynchroMessageConnectionServer)env.get(SYNCHRO_MESSAGE_CONNECTION_SERVER);
        }
        return ret;
    }

    public static ClientSynchroMessageConnection getClientSynchroMessageConnection(Map env) {
        ClientSynchroMessageConnection ret = null;
        if (env != null) {
            ret = (ClientSynchroMessageConnection)env.get(CLIENT_SYNCHRO_MESSAGE_CONNECTION);
        }
        return ret;
    }

    public static long getTimeoutForWaitConnectedState(Map env) {
        return EnvHelp.getIntegerAttribute(env, TIMEOUT_FOR_CONNECTED_STATE, 1000L, 1L, Long.MAX_VALUE);
    }

    public static boolean getServerReuseAddress(Map env) {
        Object o;
        if (env == null || (o = env.get(SERVER_REUSE_ADDRESS)) == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        throw new IllegalArgumentException("Attribute jmx.remote.x.server.reuse.address value must be Boolean or String.");
    }

    public static boolean getTimeoutReconnection(Map env) {
        Object o;
        if (env == null || (o = env.get(TIMEOUT_RECONNECTION)) == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        throw new IllegalArgumentException("Attribute jmx.remote.x.client.timeout.reconnection value must be Boolean or String.");
    }
}

