/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;

public class ClientSynchroMessageConnectionImpl
implements ClientSynchroMessageConnection {
    private final transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient SynchroCallback callback;
    private transient ClientAdmin clientAdmin = null;
    private Map env;
    private transient ThreadService threads;
    private transient MessageReader reader;
    private transient long wtimeout;
    private final transient HashMap waitingList = new HashMap();
    private transient Message notifResp = null;
    private final transient int[] notifLock = new int[0];
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private final int[] stateLock = new int[0];
    private long waitConnectedState;
    private static final ClassLogger LOGGER = new ClassLogger("javax.management.remote.misc", "ClientSynchroMessageConnectionImpl");

    public ClientSynchroMessageConnectionImpl(MessageConnection mc, SynchroCallback cb, Map env) {
        if (mc == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        if (cb == null) {
            throw new IllegalArgumentException("Null SynchroCallback object.");
        }
        this.connection = mc;
        this.callback = cb;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void connect(Map env) throws IOException {
        int[] nArray = this.stateLock;
        // MONITORENTER : this.stateLock
        switch (this.state) {
            case 1: {
                LOGGER.trace("connect", "Establishing the connection.");
                HashMap newEnv = new HashMap();
                if (this.env != null) {
                    newEnv.putAll(this.env);
                }
                if (env != null) {
                    newEnv.putAll(env);
                }
                this.wtimeout = DefaultConfig.getRequestTimeout(newEnv);
                this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(newEnv);
                this.clientAdmin = DefaultConfig.getClientAdmin(newEnv);
                this.state = 2;
                this.stateLock.notifyAll();
                this.connection.connect(newEnv);
                this.connection = this.clientAdmin.connectionOpen(this.connection);
                this.env = newEnv;
                this.reader = new MessageReader();
                this.threads = new ThreadService(1, 1);
                this.threads.handoff(this.reader);
                this.state = 3;
                this.stateLock.notifyAll();
                break;
            }
            case 3: 
            case 4: {
                LOGGER.trace("connect", "Re-establishing the connection...");
                if (this.state == 3) {
                    this.state = 4;
                    this.stateLock.notifyAll();
                }
                this.state = 2;
                this.stateLock.notifyAll();
                if (this.reader != null) {
                    this.reader.stop();
                }
                int[] nArray2 = this.notifLock;
                // MONITORENTER : this.notifLock
                this.notifLock.notify();
                // MONITOREXIT : nArray2
                nArray2 = this.connectionLock;
                // MONITORENTER : this.connectionLock
                this.connection.connect(this.env);
                this.connection = this.clientAdmin.connectionOpen(this.connection);
                // MONITOREXIT : nArray2
                LOGGER.trace("connect", "Wakeup the threads which are waiting a response frome the server to inform them of the connection failure.");
                ConnectionClosedException ce = new ConnectionClosedException("The connection has been closed by the server.");
                HashMap hashMap = this.waitingList;
                // MONITORENTER : hashMap
                for (Long id : this.waitingList.keySet()) {
                    ResponseMsgWrapper rm;
                    ResponseMsgWrapper responseMsgWrapper = rm = (ResponseMsgWrapper)this.waitingList.get(id);
                    // MONITORENTER : responseMsgWrapper
                    if (!rm.got) {
                        rm.got = true;
                        rm.msg = ce;
                    }
                    rm.notify();
                    // MONITOREXIT : responseMsgWrapper
                }
                this.waitingList.clear();
                // MONITOREXIT : hashMap
                this.state = 3;
                this.reader = new MessageReader();
                this.threads.handoff(this.reader);
                this.stateLock.notifyAll();
                break;
            }
            default: {
                this.checkState();
            }
        }
        // MONITOREXIT : nArray
        LOGGER.trace("connect", "Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOneWay(Message msg) throws IOException {
        LOGGER.trace("sendOneWay", "Send a message without response: " + msg);
        this.checkState();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(msg);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Message sendWithReturn(Message msg) throws IOException {
        if (LOGGER.traceOn()) {
            LOGGER.trace("sendWithReturn", "Send a message with response: " + msg);
        }
        this.checkState();
        Message ret = null;
        if (msg instanceof NotificationRequestMessage) {
            LOGGER.trace("sendWithReturn", "Send a NotificationRequestMessage: " + msg);
            this.notifResp = null;
            int[] nArray = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(msg);
            // MONITOREXIT : nArray
            nArray = this.notifLock;
            // MONITORENTER : this.notifLock
            while (true) {
                if (this.notifResp != null) {
                    ret = this.notifResp;
                    this.notifResp = null;
                    // MONITOREXIT : nArray
                    return ret;
                }
                this.checkState();
                try {
                    this.notifLock.wait();
                }
                catch (InterruptedException ire) {
                    InterruptedIOException iioe = new InterruptedIOException(ire.toString());
                    EnvHelp.initCause(iioe, ire);
                    throw iioe;
                }
            }
        }
        if (!(msg instanceof MBeanServerRequestMessage)) throw new IOException("Unknow message type: " + msg);
        LOGGER.trace("sendWithReturn", "Send a MBeanServerRequestMessage: " + msg);
        Long id = ((MBeanServerRequestMessage)msg).getMessageId();
        boolean retried = false;
        while (true) {
            ResponseMsgWrapper mwrapper = new ResponseMsgWrapper();
            Object object = this.waitingList;
            // MONITORENTER : object
            this.waitingList.put(id, mwrapper);
            // MONITOREXIT : object
            object = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(msg);
            // MONITOREXIT : object
            long remainingTime = this.wtimeout;
            long startTime = System.currentTimeMillis();
            Object object2 = mwrapper;
            // MONITORENTER : object2
            while (!mwrapper.got && remainingTime > 0L) {
                try {
                    mwrapper.wait(remainingTime);
                }
                catch (InterruptedException ie) {
                    break;
                }
                remainingTime = this.wtimeout - (System.currentTimeMillis() - startTime);
            }
            // MONITOREXIT : object2
            object2 = this.waitingList;
            // MONITORENTER : object2
            this.waitingList.remove(id);
            // MONITOREXIT : object2
            if (!mwrapper.got) {
                if (this.isTerminated()) throw new IOException("The connection has been closed or broken.");
                throw new InterruptedIOException("Waiting response timeout: " + this.wtimeout);
            }
            if (mwrapper.msg instanceof MBeanServerResponseMessage) {
                return (MBeanServerResponseMessage)mwrapper.msg;
            }
            if (!(mwrapper.msg instanceof ConnectionClosedException)) throw new IOException("Got wrong response: " + mwrapper.msg);
            if (this.isTerminated()) throw (ConnectionClosedException)mwrapper.msg;
            if (retried) {
                throw (ConnectionClosedException)mwrapper.msg;
            }
            LOGGER.trace("sendWithReturn", "Got a local ConnectionClosedException, retry.");
            retried = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LOGGER.trace("close", "Closing this SynchroMessageConnection.");
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            LOGGER.trace("close", "Close the callback reader.");
            if (this.reader != null) {
                this.reader.stop();
            }
            if (this.threads != null) {
                this.threads.terminate();
                this.threads = null;
            }
            LOGGER.trace("close", "Closing the underlying connection.");
            if (this.connection != null) {
                this.connection.close();
            }
            this.clientAdmin.connectionClosed(this.connection);
            LOGGER.trace("close", "Clean all threads waiting theire responses.");
            HashMap hashMap = this.waitingList;
            synchronized (hashMap) {
                for (ResponseMsgWrapper rm : this.waitingList.values()) {
                    ConnectionClosedException ce = new ConnectionClosedException("The connection has been closed by the server.");
                    ResponseMsgWrapper responseMsgWrapper = rm;
                    synchronized (responseMsgWrapper) {
                        if (!rm.got) {
                            rm.got = true;
                            rm.msg = ce;
                        }
                        rm.notify();
                    }
                }
                this.waitingList.clear();
            }
            this.stateLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            nArray = this.notifLock;
            synchronized (this.notifLock) {
                boolean i = false;
                this.notifLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public String getConnectionId() {
        return this.clientAdmin.getConnectionId();
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 5) {
                throw new IOException("The connection [" + this.connection.getConnectionId() + "] has been closed.");
            }
            long remainingTime = this.waitConnectedState;
            long startTime = System.currentTimeMillis();
            while (this.state != 3 && this.state != 5 && remainingTime > 0L) {
                try {
                    this.stateLock.wait(remainingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                remainingTime = this.waitConnectedState - (System.currentTimeMillis() - startTime);
            }
            if (this.state != 3) {
                throw new IOException("The connection [" + this.connection.getConnectionId() + "] is currently not established");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 5;
        }
    }

    private class RemoteJob
    implements Runnable {
        private final Message msg;

        public RemoteJob(Message msg) {
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                LOGGER.trace("RemoteJob-run", "Received a new request: " + this.msg.toString());
                try {
                    Message resp = ClientSynchroMessageConnectionImpl.this.callback.execute(this.msg);
                    if (resp == null) break block9;
                    int[] nArray = ClientSynchroMessageConnectionImpl.this.connectionLock;
                    synchronized (nArray) {
                        ClientSynchroMessageConnectionImpl.this.connection.writeMessage(resp);
                    }
                }
                catch (Exception ie) {
                    int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
                    synchronized (nArray) {
                        if (ClientSynchroMessageConnectionImpl.this.state != 3 && ClientSynchroMessageConnectionImpl.this.callback != null) {
                            ClientSynchroMessageConnectionImpl.this.callback.connectionException(ie);
                        }
                    }
                }
            }
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Object msg = null;

        public void setMsg(Message msg) {
            this.got = true;
            this.msg = msg;
        }
    }

    private class MessageReader
    implements Runnable {
        private Thread executingThread;
        private boolean executingThreadInterrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.executingThread = Thread.currentThread();
                while (!this.stopped()) {
                    Message msg;
                    LOGGER.fine("MessageReader-run", "Waiting for an incoming message...");
                    try {
                        msg = ClientSynchroMessageConnectionImpl.this.connection.readMessage();
                        LOGGER.fine("MessageReader-run", "Received a message of type: " + msg);
                    }
                    catch (Exception e) {
                        msg = null;
                        if (!this.stopped()) {
                            try {
                                ClientSynchroMessageConnectionImpl.this.callback.connectionException(e);
                            }
                            catch (Exception exception) {}
                        }
                        break;
                    }
                    if (this.stopped()) break;
                    if (msg instanceof NotificationResponseMessage) {
                        int[] e = ClientSynchroMessageConnectionImpl.this.notifLock;
                        synchronized (e) {
                            ClientSynchroMessageConnectionImpl.this.notifResp = (NotificationResponseMessage)msg;
                            ClientSynchroMessageConnectionImpl.this.notifLock.notify();
                            continue;
                        }
                    }
                    if (msg instanceof MBeanServerResponseMessage) {
                        ResponseMsgWrapper mwrapper;
                        Object object = ClientSynchroMessageConnectionImpl.this.waitingList;
                        synchronized (object) {
                            mwrapper = (ResponseMsgWrapper)ClientSynchroMessageConnectionImpl.this.waitingList.get(((MBeanServerResponseMessage)msg).getMessageId());
                        }
                        if (mwrapper == null) {
                            ClientSynchroMessageConnectionImpl.this.checkState();
                            if (!LOGGER.traceOn()) continue;
                            LOGGER.trace("MessageReader-run", "Receive a MBeanServerResponseMessage but no one is waiting it.");
                            continue;
                        }
                        object = mwrapper;
                        synchronized (object) {
                            mwrapper.setMsg(msg);
                            mwrapper.notify();
                            continue;
                        }
                    }
                    if (!(msg instanceof CloseMessage)) {
                        ClientSynchroMessageConnectionImpl.this.threads.handoff(new RemoteJob(msg));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception eee) {
                LOGGER.warning("MessageReader-run", "Need to stop because of exception: " + eee.getMessage());
                LOGGER.fine("MessageReader-run", "exception:", eee);
            }
            int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                this.executingThreadInterrupted = true;
            }
            LOGGER.trace("MessageReader-run", "ended.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            LOGGER.trace("MessageReader-terminated", "be called.");
            int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                if (Thread.currentThread() != this.executingThread && this.executingThread != null && !this.executingThreadInterrupted) {
                    this.executingThreadInterrupted = true;
                    this.executingThread.interrupt();
                }
            }
            LOGGER.trace("MessageReader-terminated", "done.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopped() {
            int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                return ClientSynchroMessageConnectionImpl.this.state != 3 || this.executingThreadInterrupted;
            }
        }
    }
}

