/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpMultipartPost {
    private static final Logger log = LoggerFactory.getLogger(HttpMultipartPost.class);
    private final Map<String, List<DiskFileItem>> nameToItems = new LinkedHashMap<String, List<DiskFileItem>>();
    private final Set<String> fileParamNames = new HashSet<String>();
    private boolean initialized;

    HttpMultipartPost(HttpServletRequest request, File tmpDir) throws IOException {
        this.extractMultipart(request, tmpDir);
        this.initialized = true;
    }

    private static DiskFileItemFactory getFileItemFactory(File tmpDir) {
        DiskFileItemFactory fiFactory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSizeMax(10240)).setFile(tmpDir)).get();
        return fiFactory;
    }

    private void extractMultipart(HttpServletRequest request, File tmpDir) throws IOException {
        if (!JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            log.debug("Request does not contain multipart content -> ignoring.");
            return;
        }
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)HttpMultipartPost.getFileItemFactory(tmpDir));
        if (request.getCharacterEncoding() == null) {
            upload.setHeaderCharset(Charset.forName("UTF-8"));
        }
        try {
            List fileItems = upload.parseRequest(request);
            for (DiskFileItem fileItem : fileItems) {
                this.addItem(fileItem);
            }
        }
        catch (FileUploadException e) {
            log.error("Error while processing multipart.", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private void addItem(DiskFileItem item) {
        String name = item.getFieldName();
        List<DiskFileItem> l = this.nameToItems.get(item.getFieldName());
        if (l == null) {
            l = new ArrayList<DiskFileItem>();
            this.nameToItems.put(name, l);
        }
        l.add(item);
        if (!item.isFormField()) {
            this.fileParamNames.add(name);
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("HttpMultipartPost not initialized (or already disposed).");
        }
    }

    synchronized void dispose() throws IOException {
        this.checkInitialized();
        for (List<DiskFileItem> fileItems : this.nameToItems.values()) {
            for (DiskFileItem fileItem : fileItems) {
                fileItem.delete();
            }
        }
        this.nameToItems.clear();
        this.fileParamNames.clear();
        this.initialized = false;
    }

    Set<String> getParameterNames() {
        this.checkInitialized();
        return this.nameToItems.keySet();
    }

    String[] getParameterTypes(String name) {
        this.checkInitialized();
        String[] cts = null;
        List<DiskFileItem> l = this.nameToItems.get(name);
        if (l != null && !l.isEmpty()) {
            cts = new String[l.size()];
            for (int i = 0; i < cts.length; ++i) {
                cts[i] = l.get(i).getContentType();
            }
        }
        return cts;
    }

    String getParameter(String name) {
        this.checkInitialized();
        List<DiskFileItem> l = this.nameToItems.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        DiskFileItem item = l.get(0);
        if (item.isFormField()) {
            return item.getString();
        }
        return item.getName();
    }

    String[] getParameterValues(String name) {
        this.checkInitialized();
        List<DiskFileItem> l = this.nameToItems.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        String[] values = new String[l.size()];
        for (int i = 0; i < values.length; ++i) {
            DiskFileItem item = l.get(i);
            values[i] = item.isFormField() ? item.getString() : item.getName();
        }
        return values;
    }

    Set<String> getFileParameterNames() {
        this.checkInitialized();
        return this.fileParamNames;
    }

    InputStream[] getFileParameterValues(String name) throws IOException {
        List<DiskFileItem> l;
        this.checkInitialized();
        InputStream[] values = null;
        if (this.fileParamNames.contains(name) && (l = this.nameToItems.get(name)) != null && !l.isEmpty()) {
            ArrayList<InputStream> ins = new ArrayList<InputStream>(l.size());
            for (DiskFileItem item : l) {
                if (item.isFormField()) continue;
                ins.add(item.getInputStream());
            }
            values = ins.toArray(new InputStream[ins.size()]);
        }
        return values;
    }
}

