/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptValueChangedListener;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.definitions.PromptDefinitionInterface;

public class BaseTransformValueChangedListener
extends BasePromptValueChangedListener
implements PromptValueChangeListener {
    public BaseTransformValueChangedListener(ITransform owner, IPromptModel model) {
        super(owner, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        if (!this.isListeningForChanges()) {
            return;
        }
        this.getOwner().getModel().startCompoundUndoable();
        try {
            super.promptValueChanged(event);
            PromptDefinitionInterface def = event.getPromptDefinition();
            if ("SystemOptions".equals(def.getPromptName())) {
                Object value = event.getNewValue();
                ((ITransform)this.getOwner()).setSystemOptions(value != null ? value.toString() : "");
            } else if ("ETLS_DIAGNOSTICS".equals(def.getPromptName())) {
                ((ITransform)this.getOwner()).setCollectDiagnostics("YES".equals(event.getNewValue()));
            } else if ("ENABLECHECKPOINT".equals(def.getPromptName())) {
                ((ITransform)this.getOwner()).setCheckpointEnabled("YES".equalsIgnoreCase((String)event.getNewValue()));
            } else if ("RUN_ALWAYS".equals(def.getPromptName())) {
                ((ITransform)this.getOwner()).setRunAlways("YES".equals((String)event.getNewValue()));
            } else if (def.getPromptName().equals("CLEARLIBREFSTRANSFORM")) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "JOB";
                }
                ((ITransform)this.getOwner()).setClearLibrefGeneration((String)value);
            }
        }
        finally {
            this.getOwner().getModel().endCompoundUndoable();
        }
    }
}

