/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.prompts.PromptValueChangeEventInterface;
import javax.swing.undo.AbstractUndoableEdit;

public class BasePromptValueChangedListener
implements IPromptValueChangeListener {
    protected IObject m_owner;
    protected IPromptModel m_model;
    private boolean m_bListening;

    public BasePromptValueChangedListener(IObject owner, IPromptModel model) {
        this.m_owner = owner;
        this.m_model = model;
        this.m_bListening = true;
    }

    @Override
    public boolean isListeningForChanges() {
        return this.m_bListening;
    }

    @Override
    public void setListeningForChanges(boolean isListening) {
        this.m_bListening = isListening;
    }

    protected IObject getOwner() {
        return this.m_owner;
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        if (!this.isListeningForChanges()) {
            return;
        }
        this.m_model.setChanged(true);
        IModel objectModel = this.m_owner.getModel();
        if (objectModel.isUndoSupported()) {
            objectModel.undoableEditHappened(new cPromptValueUndoable(this.m_model.getPromptDefinitionValue(event.getPromptDefinition()), event.getOldValue(), event.getNewValue()));
        }
        objectModel.fireModelEvent(this.m_owner, "IPromptModel:PromptValueChanged", event.getNewValue());
    }

    private class cPromptValueUndoable
    extends AbstractUndoableEdit {
        private IPromptDefinitionValue m_definition;
        private Object m_oldValue;
        private Object m_newValue;

        public cPromptValueUndoable(IPromptDefinitionValue definition, Object oldValue, Object newValue) {
            this.m_definition = definition;
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                BasePromptValueChangedListener.this.m_model.setOptionValue(this.m_definition, this.m_oldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                BasePromptValueChangedListener.this.m_model.setOptionValue(this.m_definition, this.m_newValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void die() {
            this.m_definition = null;
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }
}

