/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ITCPIPConnection;
import com.sas.etl.models.other.impl.BaseConnection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TCPIPConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;

public class BaseTCPIPConnection
extends BaseConnection
implements ITCPIPConnection {
    public BaseTCPIPConnection(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "TCPIPConnection";
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("TCPIPConnection");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            map.put("TCPIPConnection", lAssociations);
        }
        lAssociations.add("Domain");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        return map;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TCPIPConnection connection = (TCPIPConnection)omr.acquireOMRObject(this);
        if (connection.getPort() > 0) {
            this.setPort(connection.getPort());
        } else {
            IProperty portProperty = this.getProperty("PORT");
            if (portProperty != null) {
                try {
                    Integer port = Integer.valueOf(portProperty.getDefaultValue());
                    if (port != null) {
                        this.setPort(port);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.setHostName(connection.getHostName());
        this.setService(connection.getService());
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }
}

