/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IResponsibleParty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.ResponsibleParty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseResponsibleParty
extends BaseObject
implements IResponsibleParty {
    private String m_sResponsibility = "OWNER";

    public BaseResponsibleParty(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setName(String sName) {
        if (!this.isNew()) {
            throw new UnsupportedOperationException("The name of a responsible party can only be changed while it is a new object.");
        }
        super.setName(sName);
    }

    @Override
    public void setDescription(String sDescription) {
        throw new UnsupportedOperationException("The description of a responsible party can not be set.");
    }

    @Override
    public void setUserProperty(String sName, String sValue) {
        throw new UnsupportedOperationException("A user property can not be set on a responsible party.");
    }

    @Override
    public void removeUserProperty(String sName) {
        throw new UnsupportedOperationException("A user property can not be removed from a responsible party.");
    }

    @Override
    public void setResponsibility(String sResponsibility) {
        if (!this.isNew()) {
            throw new UnsupportedOperationException("The responsibility of a responsible party can only be changed while it is a new object.");
        }
        if (sResponsibility == null) {
            throw new IllegalArgumentException("The responsibility must not be null");
        }
        if (sResponsibility.length() == 0) {
            throw new IllegalArgumentException("The responsibility must not be an empty string");
        }
        if (this.m_sResponsibility.equals(sResponsibility)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetResponsibilityUndoable(this.m_sResponsibility, sResponsibility));
        }
        this.m_sResponsibility = sResponsibility;
        this.fireModelChangedEvent("ResponsibleParty:ResponsibilityChanged", null);
    }

    @Override
    public String getResponsibility() {
        return this.m_sResponsibility;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Delete");
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
        throw new UnsupportedOperationException("saveXMLToStream not implemented");
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
        throw new UnsupportedOperationException("loadXMLFromStream not implemented");
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        AssociationList persons;
        ResponsibleParty mdoRP1;
        if (!this.isChanged()) {
            ResponsibleParty mdoRP = (ResponsibleParty)omr.acquireOMRObject(this);
            mdoRP.setName(this.getName(), 2);
            mdoRP.setRole(this.m_sResponsibility, 2);
            return;
        }
        if (!this.isNew() && (mdoRP1 = (ResponsibleParty)omr.acquireOMRObject(this)) != null && ((persons = mdoRP1.getPersons()) == null || persons.isEmpty())) {
            return;
        }
        MdOMIUtil util = omr.getOMRFactory().getOMIUtil();
        ResponsibleParty mdoRP = util.getResponsibleParty(omr.getOMRStore(), this.getName(), this.m_sResponsibility);
        this.setID(mdoRP.getFQID());
        this.setChanged(false);
    }

    @Override
    public String getOMRType() {
        return "ResponsibleParty";
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        ArrayList<String> lAssociations = new ArrayList<String>();
        lAssociations.add("Persons");
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("ResponsibleParty", lAssociations);
        return map;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ResponsibleParty mdoRP = (ResponsibleParty)omr.acquireOMRObject(this);
        AssociationList lPersons = mdoRP.getPersons();
        String sName = lPersons.isEmpty() ? mdoRP.getName() : ((Identity)lPersons.get(0)).getName();
        super.setName(sName);
        String sRole = mdoRP.getRole();
        this.m_sResponsibility = sRole.length() != 0 ? sRole : mdoRP.getName();
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        throw new UnsupportedOperationException("A ResponsibleParty can not be deleted");
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        throw new UnsupportedOperationException("getOMRCopyTemplateMap not implemented");
    }

    @Override
    public Map getOMRExportTemplateMap() {
        throw new UnsupportedOperationException("getOMRExportTemplateMap not implemented");
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        throw new UnsupportedOperationException("getOMRCheckOutTemplateMap not implemented");
    }

    @Override
    public void updateIDs(Map mapIDs) {
        if (!this.isNew()) {
            return;
        }
        String sNewID = (String)mapIDs.get(this.getID());
        if (sNewID != null) {
            this.setID(sNewID);
        }
    }

    @Override
    public List getRefreshObjects() {
        return null;
    }

    private class SetResponsibilityUndoable
    extends AbstractUndoableEdit {
        private String m_sOldResponsibility;
        private String m_sNewResponsibility;

        public SetResponsibilityUndoable(String sOldResponsibility, String sNewResponsibility) {
            this.m_sOldResponsibility = sOldResponsibility;
            this.m_sNewResponsibility = sNewResponsibility;
        }

        @Override
        public void undo() {
            super.undo();
            BaseResponsibleParty.this.setResponsibility(this.m_sOldResponsibility);
        }

        @Override
        public void redo() {
            super.redo();
            BaseResponsibleParty.this.setResponsibility(this.m_sNewResponsibility);
        }
    }
}

