/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.IHTTPServer;
import com.sas.etl.models.other.IHTTPTCPIPConnection;
import com.sas.etl.models.other.impl.BaseServer;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import java.rmi.RemoteException;
import java.text.MessageFormat;

public class BaseHTTPServer
extends BaseServer
implements IHTTPServer {
    public BaseHTTPServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    @Override
    public String getProductName() {
        return "Http Server";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void loadClientConnections(OMRAdapter omr) throws MdException, RemoteException {
        ServerComponent mdoSC = (ServerComponent)omr.acquireOMRObject(this);
        this.clearClientConnections();
        AssociationList sourceConnections = mdoSC.getSourceConnections();
        if (!sourceConnections.isEmpty()) {
            TCPIPConnection comp = (TCPIPConnection)sourceConnections.get(0);
            IHTTPTCPIPConnection connection = this.getModel().getObjectFactory().createHTTPTCPIPConnection(comp.getFQID());
            omr.populateFor(connection);
            connection.loadFromOMR(omr);
            this.addClientConnection(connection);
        }
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String fileName) throws BadServerDefinitionException {
        return this.getServerOptions(useAuthDomain, encodePasswords, fileName, true);
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String filename, boolean includeEngine) throws BadServerDefinitionException {
        IConnection conns = this.getConnection();
        if (conns == null || !(conns instanceof IHTTPTCPIPConnection)) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        IHTTPTCPIPConnection connection = (IHTTPTCPIPConnection)conns;
        StringBuffer httpOptions = new StringBuffer();
        if (includeEngine) {
            httpOptions.append("'");
            httpOptions.append(connection.getApplicationProtocol()).append("://");
            httpOptions.append(connection.getHostName());
            int port = connection.getPort();
            if (port > -1) {
                httpOptions.append(":").append(port);
            }
            if (!filename.startsWith("/") && !filename.startsWith("\\")) {
                httpOptions.append("/");
            }
            httpOptions.append(filename).append("' URL ");
        }
        String serverProxy = connection.getHTTPServerProxy();
        boolean isProxy = false;
        if (serverProxy != null && serverProxy.length() > 0) {
            httpOptions.append(" proxy='" + serverProxy + "'");
            isProxy = true;
        }
        httpOptions.append(connection.getUserIdPasswordString(useAuthDomain, isProxy ? false : encodePasswords));
        return httpOptions.toString();
    }

    @Override
    public String getAccessMethodNickName() {
        return "URL";
    }

    @Override
    public String getAccessMethodFilePath(String filename) throws BadServerDefinitionException {
        IConnection conns = this.getConnection();
        if (conns == null || !(conns instanceof IHTTPTCPIPConnection)) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        IHTTPTCPIPConnection connection = (IHTTPTCPIPConnection)conns;
        StringBuffer httpOptions = new StringBuffer();
        httpOptions.append("'");
        httpOptions.append(connection.getApplicationProtocol()).append("://");
        httpOptions.append(connection.getHostName());
        int port = connection.getPort();
        if (port > -1) {
            httpOptions.append(":").append(port);
        }
        if (!filename.startsWith("/") && !filename.startsWith("\\")) {
            httpOptions.append("/");
        }
        httpOptions.append(filename);
        return httpOptions.toString();
    }

    @Override
    public String getDirectoryListingOption() {
        return null;
    }
}

