/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IGridServer;
import com.sas.etl.models.other.impl.BaseServer;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.GridServerInterface;
import com.sas.services.information.metadata.OMRGridApplication;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BaseGridServer
extends BaseServer
implements IGridServer {
    private List<String> m_workloads = new ArrayList<String>();
    private List<String> m_gridOptionSets = new ArrayList<String>();

    public BaseGridServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ChildServerInterface child = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            child = server.newChild(true);
            String key = this.getID() + "/" + this.getOMRType();
            GridServerInterface gridServer = (GridServerInterface)child.fetch(key, false);
            this.m_workloads.clear();
            List wls = gridServer.getGridWorkLoad();
            if (wls != null) {
                this.m_workloads.addAll(wls);
            }
            ApplicationInterface dis = Workspace.getWorkspace().getApplicationInterface((ServerInterface)child, "databuildata");
            this.m_gridOptionSets.clear();
            if (dis != null) {
                for (OMRGridApplication a : gridServer.getExistingGridOptionsSetList(Workspace.getWorkspace().getUserContext().getAuthServer(), dis)) {
                    this.m_gridOptionSets.add(a.getName());
                }
            }
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        this.setChanged(false);
    }

    @Override
    public List<String> getWorkloads() {
        return this.m_workloads;
    }

    @Override
    public List<String> getGridOptionSets() {
        return this.m_gridOptionSets;
    }
}

