/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.tablemaintenance;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.tablemaintenance.RB;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class TableStatement
extends BaseMapping {
    public static final String CODE_ROLE = "TableStatement";
    public static final String DEFAULT_METADATA_NAME = RB.getStringResource("TableStatement.DefaultMetadataName.txt");
    public static final String DEFAULT_METADATA_DESC = RB.getStringResource("TableStatement.DefaultMetadataDesc.txt");
    public static final String TARGET_TABLE_CHANGED = "targ_table_cd";
    private static final String TARGET_TABLE = "Target_Table";
    private IUserWrittenCodeContainer m_hiveCodeContainer;
    public static final String STMT_CREATE = "Create";
    public static final String STMT_ALTER = "Alter";
    private IPhysicalTable m_target;
    private boolean m_bPassThru = true;
    public static final String PASSTHRU_CHANGED = "pass_thru_cd";
    private static final String PASS_THRU = "PassThru";
    public TableMaintenanceTransformModel m_transModel;

    public TableStatement(String sID, IModel model) {
        super(sID, model);
        this.m_hiveCodeContainer = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_hiveCodeContainer.setActiveFlagLocation(0);
        this.m_hiveCodeContainer.setContainerRole(STMT_CREATE);
        this.m_hiveCodeContainer.setIsActive(true);
        this.m_hiveCodeContainer.setSourceAttributes(true);
        this.m_hiveCodeContainer.setTextType(STMT_CREATE);
        this.m_hiveCodeContainer.setName(DEFAULT_METADATA_NAME);
        this.m_hiveCodeContainer.setDescription(DEFAULT_METADATA_DESC);
        this.m_hiveCodeContainer.setContainerOMRType(this.getOMRType());
        this.m_hiveCodeContainer.setContainerId(sID);
        this.setType(STMT_CREATE);
        this.setName(MessageFormat.format(RB.getStringResource("TableStatement.DefaultName.txt"), 1));
    }

    public IUserWrittenCodeContainer getCodeContainer() {
        return this.m_hiveCodeContainer;
    }

    public String getCode() throws ServerException {
        return this.m_hiveCodeContainer.getCode();
    }

    public void setTransformModel(TableMaintenanceTransformModel tm) {
        this.m_transModel = tm;
    }

    public TableMaintenanceTransformModel getTransformModel() {
        return this.m_transModel;
    }

    public void setTargetTable(IPhysicalTable target) {
        if (this.m_target == target) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetUndoable(this.m_target, target));
        }
        this.m_target = target;
        this.fireModelChangedEvent(TARGET_TABLE_CHANGED, target);
        if (this.m_transModel != null) {
            this.m_transModel.fireChange(TARGET_TABLE_CHANGED, target);
        }
    }

    public IPhysicalTable getTargetTable() {
        return this.m_target;
    }

    @Override
    public void dispose() {
        if (this.m_hiveCodeContainer != null) {
            this.m_hiveCodeContainer.dispose();
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        for (int iObject = 0; iObject < this.getDeletedObjects().size(); ++iObject) {
            ((IPersistableObject)this.getDeletedObjects().get(iObject)).deleteFromOMR(omr);
        }
        this.m_hiveCodeContainer.setContainerId(this.getID());
        this.m_hiveCodeContainer.setContainerOMRType(this.getOMRType());
        this.m_hiveCodeContainer.saveToOMR(omr);
        IPhysicalTable target = this.getTargetTable();
        if (target != null) {
            IPhysicalTable[] iPhysicalTableArray = new IPhysicalTable[1];
            iPersistableObjectArray = iPhysicalTableArray;
            iPhysicalTableArray[0] = target;
        } else {
            iPersistableObjectArray = new IPhysicalTable[]{};
        }
        this.saveObjectListPropertyToOMR(omr, TARGET_TABLE, TARGET_TABLE, TARGET_TABLE, TARGET_TABLE, iPersistableObjectArray, 2000, 0);
        this.saveBooleanOptionToOMR(omr, PASS_THRU, PASS_THRU, this.getPassThru());
        this.setChanged(false);
    }

    public boolean getPassThru() {
        return this.m_bPassThru;
    }

    public void setPassThru(boolean bPassThru) {
        if (this.m_bPassThru == bPassThru) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPassThruUndoable(this.m_bPassThru, bPassThru));
        }
        this.m_bPassThru = bPassThru;
        this.fireModelChangedEvent(PASSTHRU_CHANGED, bPassThru);
    }

    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, IPhysicalTable table, TableMaintenanceTransformModel transform) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        if (target != null) {
            IDBMSType dbType = target.getDBMSType();
            if (this.m_bPassThru) {
                dbType.genExecuteBegin(codeSegment, table, "");
                codeSegment.addSourceCode(this.getCode()).addSourceCode("\n");
                dbType.genExecuteEnd(codeSegment, table, "");
            } else {
                codeSegment.addSourceCode(this.getCode()).addSourceCode("\n");
            }
        } else {
            System.out.println("Select a target table");
        }
        return codeSegment;
    }

    public String getCreateCode(ICodeSegment cs) throws BadLibraryDefinitionException {
        IPhysicalTable table = this.getTargetTable();
        table.getDBMSType().getSQLCreateCode(table, this.m_bPassThru, cs);
        return cs.toString();
    }

    public String getAlterCode(ICodeSegment cs) throws BadLibraryDefinitionException {
        IPhysicalTable table = this.getTargetTable();
        String alterCode = null;
        alterCode = this.m_bPassThru ? "ALTER TABLE " + table.getDBMSTableName(true) : "ALTER TABLE " + table.getFullNameQuotedAsNeeded(cs, false);
        return alterCode;
    }

    public String getDropCode(ICodeSegment cs) throws BadLibraryDefinitionException {
        IPhysicalTable table = this.getTargetTable();
        String dropCode = null;
        dropCode = this.m_bPassThru ? "DROP TABLE " + table.getDBMSTableName(true) : "DROP TABLE " + table.getFullNameQuotedAsNeeded(cs, false) + ";";
        return dropCode;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_hiveCodeContainer.isChanged();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_hiveCodeContainer.loadFromOMR(omr);
        IPersistableObject[] targets = this.loadObjectListPropertyFromOMR(omr, omr.acquireOMRObject(this), TARGET_TABLE, TARGET_TABLE, 0);
        this.setTargetTable(targets != null && targets.length > 0 ? (IPhysicalTable)targets[0] : null);
        this.setPassThru(this.loadBooleanOptionFromOMR(omr, PASS_THRU, PASS_THRU, true));
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.m_hiveCodeContainer.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_hiveCodeContainer.updateIds(mapIDs);
    }

    private class SetTargetUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_sOldTable;
        private IPhysicalTable m_sNewTable;

        public SetTargetUndoable(IPhysicalTable sOldTable, IPhysicalTable sNewTable) {
            this.m_sOldTable = sOldTable;
            this.m_sNewTable = sNewTable;
        }

        @Override
        public void undo() {
            super.undo();
            TableStatement.this.setTargetTable(this.m_sOldTable);
        }

        @Override
        public void redo() {
            super.redo();
            TableStatement.this.setTargetTable(this.m_sNewTable);
        }
    }

    private class SetPassThruUndoable
    extends AbstractUndoableEdit {
        private boolean m_bPreviousValue;
        private boolean m_bNewValue;

        public SetPassThruUndoable(boolean bOldValue, boolean bNewValue) {
            this.m_bPreviousValue = bOldValue;
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            TableStatement.this.setPassThru(this.m_bPreviousValue);
        }

        @Override
        public void redo() {
            super.redo();
            TableStatement.this.setPassThru(this.m_bNewValue);
        }
    }
}

