/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.SASSPDSType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.AliasTable;
import com.sas.etl.models.job.transforms.sql.impl.SetSQLSourceParentHelper;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class SourceTable
extends AliasTable
implements ISourceTable {
    private static final String PROPERTY_SET_ROLE = "SourceTableOptions";
    private static final String PROPERTY_NAME_IDXWHERE = "idxwhere";
    private static final String PROPERTY_NAME_FIRSTOBS = "firstobs";
    private static final String PROPERTY_NAME_OBS = "obs";
    private static final String PROPERTY_NAME_READBUFF = "readbuff";
    private static final String PROPERTY_NAME_DBMS_LIBRRARY = "dbmsLibrary";
    private static final String PROPERTY_NAME_PREUPLOAD_ACTION = "preUploadAction";
    private static final String PROPERTY_NAME_UPLOAD_BULKLOAD = "bulkload";
    private static final String PROPERTY_NAME_BULKLOAD_OPTIONS = "bl_options";
    private static final String PROPERTY_NAME_ADDITIONAL_UPLOAD_OPTIONS = "uploadOptions";
    private static final String PROPERTY_NAME_ADDITIONAL_OPTIONS = "AdditionalOptions";
    private static final String DEFAULT_VALUE_YES = "YES";
    private static final String DEFAULT_VALUE_NO = "NO";
    private ITransformTableOptions m_sourceTableOptions;
    private boolean m_bUploadUsingBulkload = false;
    private ILibrary m_uploadLibrary;
    private String m_sPreUploadAction = "delete";
    private String m_sBulkloadOptions = "";
    private String m_sAdditionalUploadOptions = "";
    private boolean m_bTableMoved = false;
    private ILibrary m_oldLibrary;
    private boolean m_bOldCaseSensitive;
    private boolean m_bOldSpecialCharacters;
    private List m_lOldProperties;
    private SetSQLSourceParentHelper m_setParentHelper = new SetSQLSourceParentHelper(this);

    public SourceTable(String sID, IModel model) {
        super(sID, model);
    }

    protected ITransformTableOptions createTransformTableOption(IPhysicalTable table) {
        BaseTransformTableOptions optionSet = new BaseTransformTableOptions(this.createIDForNewObject(), this.getModel());
        optionSet.setOptionTable(table);
        optionSet.setAccessTypeInput(true);
        optionSet.setOwner(this);
        optionSet.setDisplayName(this.getOptionDisplayName());
        return optionSet;
    }

    private String getOptionDisplayName() {
        String sAlias = "";
        IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
        if (table != null && (sAlias = this.getAliasName()).length() == 0) {
            sAlias = table.getTableName(false);
        }
        return sAlias;
    }

    @Override
    public void setTransformSourceTableOption(ITransformTableOptions tableOptions) {
        if (tableOptions == this.m_sourceTableOptions) {
            return;
        }
        if (this.m_sourceTableOptions != null) {
            this.addToDeletedObjects(this.m_sourceTableOptions);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformSourceTableOptionUndoable(this.m_sourceTableOptions, tableOptions));
        }
        this.m_sourceTableOptions = tableOptions;
        if (this.m_sourceTableOptions != null) {
            this.removeFromDeletedObjects(this.m_sourceTableOptions);
            this.m_sourceTableOptions.setOwner(this);
        }
        this.fireModelChangedEvent("DataTransform.TransformTableOptionAddded", this.m_sourceTableOptions);
    }

    @Override
    public ITransformTableOptions getTransformSourceTableOption() {
        return this.m_sourceTableOptions;
    }

    @Override
    public void setAdditionalUploadOptions(String sOptions) {
        if (this.m_sAdditionalUploadOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (sOptions == null) {
            sOptions = "";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalUploadOptionsUndoable(this.m_sAdditionalUploadOptions, sOptions));
        }
        this.m_sAdditionalUploadOptions = sOptions;
        this.fireModelChangedEvent("SQLSourceTable:UploadOptionsChanged", null);
    }

    @Override
    public String getAdditionalUploadOptions() {
        return this.m_sAdditionalUploadOptions;
    }

    @Override
    public void setBulkloadOptions(String sOptions) {
        if (this.m_sBulkloadOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (sOptions == null) {
            sOptions = "";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBulkloadOptionsUndoable(this.m_sBulkloadOptions, sOptions));
        }
        this.m_sBulkloadOptions = sOptions;
        this.fireModelChangedEvent("SQLSourceTable:BulkloadOptionsChanged", null);
    }

    @Override
    public String getBulkloadOptions() {
        return this.m_sBulkloadOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISourceTable moveTable() {
        if (this.isMoveTableToUploadLibrary() && !this.m_bTableMoved) {
            IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
            IModel model = this.getModel();
            boolean oldUndo = model.isUndoSupported();
            model.setUndoSupported(false);
            boolean oldChanged = table.isChanged();
            try {
                this.m_oldLibrary = table.getLibrary();
                this.m_bTableMoved = true;
                table.setLibrary(this.m_uploadLibrary);
                table.setSpecialCharacters(this.isSpecialCharacters());
                table.setCaseSensitive(this.isCaseSensitive());
            }
            finally {
                table.setChanged(oldChanged);
                model.setUndoSupported(oldUndo);
            }
        }
        return this;
    }

    @Override
    public boolean isMoved() {
        return this.m_bTableMoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPassThruSupported() {
        boolean supported = true;
        boolean moveBack = false;
        if (!this.isMoved()) {
            this.moveTable();
            moveBack = this.isMoved();
        }
        try {
            ITable table = this.getAliasedTable();
            if (table != null && table instanceof IPhysicalTable && !((IPhysicalTable)table).getDBMSType().isPassThroughSupported()) {
                supported = false;
            }
        }
        finally {
            if (moveBack) {
                this.resetAttributes();
            }
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSPDSTable() {
        boolean spds = true;
        boolean moveBack = false;
        if (!this.isMoved()) {
            this.moveTable();
            moveBack = this.isMoved();
        }
        try {
            ITable table = this.getAliasedTable();
            if (table != null && table instanceof IPhysicalTable && !(((IPhysicalTable)table).getDBMSType() instanceof SASSPDSType)) {
                spds = false;
            }
        }
        finally {
            if (moveBack) {
                this.resetAttributes();
            }
        }
        return spds;
    }

    @Override
    public boolean isMoveTableToUploadLibrary() {
        ITable table = this.getAliasedTable();
        return table instanceof IPhysicalTable && this.m_uploadLibrary != null;
    }

    @Override
    public void moveTableToUploadLibrary(ICodeSegment codeSegment) throws BadLibraryDefinitionException, MdException, BadServerDefinitionException, RemoteException, CodegenException, ServerException {
        if (!this.isMoved() && this.isMoveTableToUploadLibrary()) {
            boolean deleteTableAction = "delete".equals(this.m_sPreUploadAction);
            IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
            this.m_oldLibrary = table.getLibrary();
            this.m_bTableMoved = true;
            ArrayList<String> optionList = new ArrayList<String>();
            if (this.m_bUploadUsingBulkload) {
                optionList.add("bulkload = yes");
            }
            if (this.m_sBulkloadOptions.trim().length() > 0) {
                optionList.add("bl_options = " + this.m_sBulkloadOptions);
            }
            if (this.m_sAdditionalUploadOptions.trim().length() > 0) {
                optionList.add(this.m_sAdditionalUploadOptions);
            }
            try {
                table.moveTableToLibrary(codeSegment, this.m_uploadLibrary, deleteTableAction, optionList, this.isCaseSensitive(), this.isSpecialCharacters());
            }
            catch (BadLibraryDefinitionException e) {
                this.resetAttributes();
                throw e;
            }
            catch (MdException e) {
                this.resetAttributes();
                throw e;
            }
            catch (BadServerDefinitionException e) {
                this.resetAttributes();
                throw e;
            }
            catch (RemoteException e) {
                this.resetAttributes();
                throw e;
            }
            catch (CodegenException e) {
                this.resetAttributes();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAttributes() {
        if (this.m_bTableMoved) {
            this.m_bTableMoved = false;
            if (this.getAliasedTable() instanceof IPhysicalTable) {
                IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
                boolean oldUndo = this.getModel().isUndoSupported();
                this.getModel().setUndoSupported(false);
                boolean bChanged = table.isChanged();
                try {
                    table.setLibrary(this.m_oldLibrary);
                    table.setSpecialCharacters(this.m_bOldSpecialCharacters);
                    table.setCaseSensitive(this.m_bOldCaseSensitive);
                }
                finally {
                    table.setChanged(bChanged);
                    this.getModel().setUndoSupported(oldUndo);
                }
            }
        }
    }

    @Override
    public ICodeSegment genCleanUpMovedTableCode(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (!this.getParent().getParentQuery().getTargetTable().isView() && this.getAliasedTable() instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
            if ("delete".equals(this.m_sPreUploadAction)) {
                table.getDBMSType().drop(codeSegment, table, false);
            } else {
                table.getDBMSType().deleteAllRows(codeSegment, table, true);
            }
        }
        return codeSegment;
    }

    @Override
    public void setPreUploadAction(String sAction) {
        if (this.m_sPreUploadAction.equalsIgnoreCase(sAction)) {
            return;
        }
        if (sAction == null) {
            sAction = "delete";
        }
        if (!sAction.equalsIgnoreCase("delete") && !sAction.equalsIgnoreCase("truncate")) {
            ModelLogger.getDefaultLogger().debug((Object)("Invalid value has been given, " + sAction + ", forcing the value to be the default."));
            if (this.m_sPreUploadAction.equalsIgnoreCase("delete")) {
                return;
            }
            sAction = "delete";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPreUploadActionUndoable(this.m_sPreUploadAction, sAction));
        }
        this.m_sPreUploadAction = sAction;
        this.fireModelChangedEvent("SQLSourceTable:PreUploadActionChanged", null);
    }

    @Override
    public String getPreUploadAction() {
        return this.m_sPreUploadAction;
    }

    @Override
    public void setUploadLibrary(ILibrary library) {
        if (this.m_uploadLibrary == library) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUploadLibraryUndoable(this.m_uploadLibrary, library));
        }
        this.m_uploadLibrary = library;
        this.fireModelChangedEvent("SQLSourceTable:DbmsLibraryChanged", null);
    }

    @Override
    public ILibrary getUploadLibrary() {
        return this.m_uploadLibrary;
    }

    @Override
    public void setUploadUsingBulkload(boolean bBulkload) {
        if (this.m_bUploadUsingBulkload == bBulkload) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUploadUsingBulkloadUndoable(this.m_bUploadUsingBulkload, bBulkload));
        }
        this.m_bUploadUsingBulkload = bBulkload;
        this.fireModelChangedEvent("SQLSourceTable:AdditionalUploadBulkloadChanged", null);
    }

    @Override
    public boolean isUploadUsingBulkload() {
        return this.m_bUploadUsingBulkload;
    }

    @Override
    public boolean hasOpenPorts() {
        return false;
    }

    @Override
    public ISQLSource[] getObjectsWithOpenPorts() {
        return new ISQLSource[0];
    }

    @Override
    public ISourceTable[] getSQLSourceTables() {
        return new ISourceTable[]{this};
    }

    @Override
    public ITable[] getInputTables() {
        return new ITable[]{this};
    }

    @Override
    public ISubquery[] getSQLSourceSubqueries() {
        return new ISubquery[0];
    }

    @Override
    public void setAliasedTable(ITable table) {
        if (this.getAliasedTable() == table) {
            return;
        }
        this.startCompoundUndoable();
        try {
            super.setAliasedTable(table);
            if (table != null) {
                this.setSpecialCharacters(table.isSpecialCharacters());
                this.setCaseSensitive(table.isCaseSensitive());
            }
            this.setTransformSourceTableOption(this.createTransformTableOption((IPhysicalTable)table));
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setAliasName(String sName) {
        super.setAliasName(sName);
        if (this.m_sourceTableOptions != null) {
            this.m_sourceTableOptions.setDisplayName(this.getOptionDisplayName());
        }
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        return false;
    }

    @Override
    public List getPortDescriptions() {
        boolean iName = false;
        boolean iObject = true;
        int iContainer = 2;
        int iJoinSide = 3;
        ArrayList list = new ArrayList();
        ArrayList<Object> lObjects = new ArrayList<Object>();
        lObjects.add(0, this.getName());
        lObjects.add(1, this);
        IClause parent = this.getParent();
        lObjects.add(2, parent);
        lObjects.add(3, "");
        list.add(lObjects);
        return list;
    }

    @Override
    public List getAllJoins() {
        return new ArrayList();
    }

    @Override
    public boolean hasImplicitJoin() {
        return false;
    }

    @Override
    public void setParent(IClause clause) {
        this.m_setParentHelper.set(clause);
    }

    @Override
    public IClause getParent() {
        return (IClause)this.m_setParentHelper.get();
    }

    public boolean hasTableOptions(ICodeSegment codeSegment) {
        ISQLTransform model = this.getParent().getParentQuery().getTransformModel();
        boolean passthru = model.isPassThru();
        IPhysicalTable realTable = (IPhysicalTable)this.getAliasedTable();
        String allTableOptions = null;
        if (!passthru) {
            allTableOptions = realTable != null ? this.m_sourceTableOptions.getTableOptions(false, "", codeSegment.getCurrentServer()) : "";
        } else {
            StringBuffer additionalOpts = this.getAdditionalOptions();
            String string = allTableOptions = additionalOpts != null ? additionalOpts.toString() : null;
        }
        return allTableOptions != null && allTableOptions.length() > 0;
    }

    private StringBuffer getAdditionalOptions() {
        IPromptDefinitionValue definition;
        PhysicalTablePromptModelCollection optionModel;
        IPhysicalTable realTable = (IPhysicalTable)this.getAliasedTable();
        PhysicalTablePromptModelCollection physicalTablePromptModelCollection = optionModel = realTable != null ? this.m_sourceTableOptions.getOptionModel() : null;
        if (optionModel != null && (definition = optionModel.findDefinition(PROPERTY_NAME_ADDITIONAL_OPTIONS)) != null) {
            try {
                return optionModel.getOptionsString(new IPromptDefinitionValue[]{definition}, null, null);
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (BadLibraryDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (BadServerDefinitionException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (CodegenException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (ServerException e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    public void genTableOptions(ICodeSegment codeSegment) {
        if (this.hasTableOptions(codeSegment)) {
            boolean passthru;
            ISQLTransform model = this.getParent().getParentQuery().getTransformModel();
            boolean bl = passthru = model.isPassThru() && model.isPassThruEnabled();
            if (!passthru) {
                codeSegment.addSourceCode("\n");
                codeSegment.addSourceCode("(\n");
                codeSegment.indent();
            }
            IPhysicalTable realTable = (IPhysicalTable)this.getAliasedTable();
            if (!passthru) {
                String allTableOptions;
                String string = allTableOptions = realTable != null ? this.m_sourceTableOptions.getTableOptions(false, "", codeSegment.getCurrentServer()) : "";
                if (allTableOptions.length() > 0) {
                    codeSegment.addSourceCode(allTableOptions).addSourceCode("\n");
                }
            } else {
                StringBuffer additionalOpts = this.getAdditionalOptions();
                if (additionalOpts != null && additionalOpts.length() > 0) {
                    codeSegment.addSourceCode(additionalOpts);
                }
            }
            if (!passthru) {
                codeSegment.unIndent();
                codeSegment.addSourceCode(")");
            }
        }
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.getParent() == null) {
            return codeSegment;
        }
        ISQLTransform model = this.getParent().getParentQuery().getTransformModel();
        ITable table = this.getAliasedTable();
        if (table == null) {
            return codeSegment;
        }
        if (table instanceof IPhysicalTable) {
            codeSegment.addSourceCode(((IPhysicalTable)table).getFullNameQuotedAsNeeded(codeSegment, passthru));
        }
        this.genTableOptions(codeSegment);
        if (this.isAliased() || passthru) {
            String aliasWord = model.getDBMSType().getTableAliasKeyword(passthru);
            if (aliasWord != null && aliasWord.length() > 0) {
                codeSegment.addSourceCode(aliasWord);
            }
            codeSegment.addSourceCode(passthru && !this.isAliased() ? this.getTableName(false) : this.getAliasName());
        }
        return codeSegment;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_UPLOAD_BULKLOAD, this.isUploadUsingBulkload() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO);
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_BULKLOAD_OPTIONS, this.getBulkloadOptions());
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_PREUPLOAD_ACTION, this.getPreUploadAction());
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_ADDITIONAL_UPLOAD_OPTIONS, this.getAdditionalUploadOptions());
        ILibrary uploadLibrary = this.getUploadLibrary();
        if (uploadLibrary == null) {
            iPersistableObjectArray = new IPersistableObject[]{};
        } else {
            IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray2;
            iPersistableObjectArray2[0] = uploadLibrary;
        }
        IPersistableObject[] aObjects = iPersistableObjectArray;
        this.saveObjectListPropertyToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_DBMS_LIBRRARY, PROPERTY_NAME_DBMS_LIBRRARY, PROPERTY_NAME_DBMS_LIBRRARY, aObjects, 2000, 0);
        Root mdo = omr.acquireOMRObject(this);
        this.m_lOldProperties = new ArrayList();
        Property property = this.findProperty(omr, mdo, PROPERTY_SET_ROLE, PROPERTY_NAME_ADDITIONAL_OPTIONS, 0);
        if (property != null) {
            this.m_lOldProperties.add(property.getFQID());
        }
        if ((property = this.findProperty(omr, mdo, PROPERTY_SET_ROLE, PROPERTY_NAME_FIRSTOBS, 0)) != null) {
            this.m_lOldProperties.add(property.getFQID());
        }
        if ((property = this.findProperty(omr, mdo, PROPERTY_SET_ROLE, PROPERTY_NAME_IDXWHERE, 0)) != null) {
            this.m_lOldProperties.add(property.getFQID());
        }
        if ((property = this.findProperty(omr, mdo, PROPERTY_SET_ROLE, PROPERTY_NAME_OBS, 0)) != null) {
            this.m_lOldProperties.add(property.getFQID());
        }
        if ((property = this.findProperty(omr, mdo, PROPERTY_SET_ROLE, PROPERTY_NAME_READBUFF, 0)) != null) {
            this.m_lOldProperties.add(property.getFQID());
        }
        this.setChanged(false);
    }

    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_sourceTableOptions != null) {
            this.m_sourceTableOptions.saveToOMR(omr);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_lOldProperties != null) {
            for (int i = 0; i < this.m_lOldProperties.size(); ++i) {
                omr.deleteOMRObject((String)this.m_lOldProperties.get(i), "Property");
            }
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setUploadUsingBulkload(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_UPLOAD_BULKLOAD, DEFAULT_VALUE_NO).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setBulkloadOptions(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_BULKLOAD_OPTIONS, ""));
        this.setPreUploadAction(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_PREUPLOAD_ACTION, "delete"));
        this.setAdditionalUploadOptions(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_ADDITIONAL_UPLOAD_OPTIONS, ""));
        IPersistableObject[] aObjects = this.loadObjectListPropertyFromOMR(omr, omr.acquireOMRObject(this), PROPERTY_SET_ROLE, PROPERTY_NAME_DBMS_LIBRRARY, 0);
        ILibrary uploadLibrary = aObjects.length > 0 ? (ILibrary)aObjects[0] : null;
        this.setUploadLibrary(uploadLibrary);
        boolean isChanged = false;
        isChanged = this.loadTransformTableOptionsFromOMR(omr);
        this.setChanged(isChanged);
    }

    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            IPhysicalTable table = transformOpts.loadAssociatedObject(omr, pSet.getFQID());
            if (this.getAliasedTable() == table) {
                this.removeFromDeletedObjects(transformOpts);
                transformOpts.setOwner(this);
                transformOpts.loadFromOMR(omr);
                this.setTransformSourceTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            transformOpts.delete();
            changed = true;
        }
        IPhysicalTable table = (IPhysicalTable)this.getAliasedTable();
        if (table != null && this.m_sourceTableOptions == null) {
            this.setTransformSourceTableOption(this.createTransformTableOption(table));
            changed = true;
        }
        if (this.m_sourceTableOptions != null) {
            try {
                String sReadBuffer;
                String sObs;
                String sFirstObs;
                String sAdditionalOptions;
                PhysicalTablePromptModelCollection optionModel = this.m_sourceTableOptions.getOptionModel();
                if (this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_IDXWHERE, DEFAULT_VALUE_NO).equalsIgnoreCase(DEFAULT_VALUE_YES)) {
                    optionModel.setOptionValue("IDXWHERE", (Object)DEFAULT_VALUE_YES);
                    changed = true;
                }
                if ((sAdditionalOptions = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_ADDITIONAL_OPTIONS, "")).length() > 0) {
                    optionModel.setOptionValue(PROPERTY_NAME_ADDITIONAL_OPTIONS, (Object)sAdditionalOptions);
                    changed = true;
                }
                if ((sFirstObs = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_FIRSTOBS, "")).length() > 0) {
                    optionModel.setOptionValue("FIRSTOBS", (Object)sFirstObs);
                    changed = true;
                }
                if ((sObs = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_OBS, "")).length() > 0) {
                    optionModel.setOptionValue("OBS", (Object)sObs);
                    changed = true;
                }
                if ((sReadBuffer = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_READBUFF, "")).length() > 0) {
                    optionModel.setOptionValue("READBUFF", (Object)sReadBuffer);
                    changed = true;
                }
            }
            catch (IllegalStateException e) {
                ModelLogger.getDefaultLogger().error((Object)"IllegalStateException", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
            }
        }
        return changed;
    }

    private class SetTransformSourceTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_oldObject;
        private ITransformTableOptions m_newObject;

        public SetTransformSourceTableOptionUndoable(ITransformTableOptions oldObject, ITransformTableOptions newObject) {
            this.m_oldObject = oldObject;
            this.m_newObject = newObject;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setTransformSourceTableOption(this.m_oldObject);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setTransformSourceTableOption(this.m_newObject);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldObject = null;
            this.m_newObject = null;
        }
    }

    private class SetAdditionalUploadOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldAdditionalUploadOptions;
        private String m_newAdditionalUploadOptions;

        public SetAdditionalUploadOptionsUndoable(String oldUploadOptions, String newUploadOptions) {
            this.m_oldAdditionalUploadOptions = oldUploadOptions;
            this.m_newAdditionalUploadOptions = newUploadOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setAdditionalUploadOptions(this.m_oldAdditionalUploadOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setAdditionalUploadOptions(this.m_newAdditionalUploadOptions);
        }
    }

    private class SetBulkloadOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldBulkloadOptions;
        private String m_newBulkloadOptions;

        public SetBulkloadOptionsUndoable(String oldBulkloadOptions, String newBulkloadOptions) {
            this.m_oldBulkloadOptions = oldBulkloadOptions;
            this.m_newBulkloadOptions = newBulkloadOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setBulkloadOptions(this.m_oldBulkloadOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setBulkloadOptions(this.m_newBulkloadOptions);
        }
    }

    private class SetPreUploadActionUndoable
    extends AbstractUndoableEdit {
        private String m_oldPreUploadAction;
        private String m_newPreUploadAction;

        public SetPreUploadActionUndoable(String oldPreUploadAction, String newPreUploadAction) {
            this.m_oldPreUploadAction = oldPreUploadAction;
            this.m_newPreUploadAction = newPreUploadAction;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setPreUploadAction(this.m_oldPreUploadAction);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setPreUploadAction(this.m_newPreUploadAction);
        }
    }

    private class SetUploadLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_oldUploadLibrary;
        private ILibrary m_newUploadLibrary;

        public SetUploadLibraryUndoable(ILibrary oldUploadLibrary, ILibrary newUploadLibrary) {
            this.m_oldUploadLibrary = oldUploadLibrary;
            this.m_newUploadLibrary = newUploadLibrary;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setUploadLibrary(this.m_oldUploadLibrary);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setUploadLibrary(this.m_newUploadLibrary);
        }

        @Override
        public void die() {
            super.die();
            this.m_newUploadLibrary = null;
            this.m_oldUploadLibrary = null;
        }
    }

    private class SetUploadUsingBulkloadUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUploadUsingBulkload;
        private boolean m_newUploadUsingBulkload;

        public SetUploadUsingBulkloadUndoable(boolean oldUploadUsingBulkload, boolean newUploadUsingBulkload) {
            this.m_oldUploadUsingBulkload = oldUploadUsingBulkload;
            this.m_newUploadUsingBulkload = newUploadUsingBulkload;
        }

        @Override
        public void undo() {
            super.undo();
            SourceTable.this.setUploadUsingBulkload(this.m_oldUploadUsingBulkload);
        }

        @Override
        public void redo() {
            super.redo();
            SourceTable.this.setUploadUsingBulkload(this.m_newUploadUsingBulkload);
        }
    }
}

