/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DefaultMappingRules;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.SQLMapping;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class SelectResultsContainer
extends BaseObject
implements ISelectResultsContainer {
    protected static final int SUBQUERY_ADDED_TO_RESULTS = 33;
    protected static final int SUBQUERY_REMOVED_FROM_RESULTS = 34;
    public static final String INCLUDED_IN_MAPPING = "IncludedInMapping";
    public static final String INCLUDED_IN_PROPAGATION = "IncludedInPropagation";
    public static final String COLUMNS_EXCLUDED_FROM_MAPPING_NAME = "ColumnsExcludedFromMapping";
    public static final String COLUMNS_EXCLUDED_FROM_PROPAGATION_NAME = "ColumnsExcludedFromPropagation";
    private IQuery m_query;
    private List m_lMappings;
    private List m_lColumnsExcludedFromMapping;
    private List m_lColumnsExcludedFromPropagation;
    private boolean m_bIncludedInPropagation;
    private boolean m_bIncludedInMapping;

    public SelectResultsContainer(String sID, IModel model, IQuery query) {
        super(sID, model);
        this.m_query = query;
        this.m_lMappings = new ArrayList();
        this.m_lColumnsExcludedFromMapping = new ModelList((AbstractPersistableObject)((Object)query), new String[]{"MappingsContainer:ColumnExcludedFromMapping", "MappingsContainer:ColumnIncludedInMapping"}, 0, IColumn.class);
        this.m_lColumnsExcludedFromPropagation = new ModelList((AbstractPersistableObject)((Object)query), new String[]{"MappingsContainer:ColumnExcludedFromPropagation", "MappingsContainer:ColumnIncludedInPropagation"}, 0, IColumn.class);
        this.m_bIncludedInMapping = true;
        this.m_bIncludedInPropagation = true;
    }

    @Override
    protected String getDefaultName() {
        return "Select";
    }

    @Override
    public boolean isComplete() {
        return this.areMappingsComplete() && this.doesMappingExistOnAllTargetTables();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.doesMappingExistOnAllTargetTables()) {
            lReasons.add(RB.getStringResource("SelectResultsContainer.ReasonIncomplete.NoMappings.txt"));
        }
        lReasons.addAll(this.getReasonsMappingsIncomplete());
        return lReasons;
    }

    protected List getReasonsMappingsIncomplete() {
        List lMappings = this.getMappingsList();
        ArrayList lReasons = new ArrayList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            lReasons.addAll(mapping.getReasonsIncomplete());
        }
        return lReasons;
    }

    protected boolean areMappingsComplete() {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (mapping.isComplete()) continue;
            return false;
        }
        return true;
    }

    protected boolean doesMappingExistOnAllTargetTables() {
        List lMappings = this.getMappingsList();
        if (lMappings.isEmpty()) {
            return false;
        }
        ITable[] aTargetTables = this.getTargetTables();
        ArrayList<ITable> lTargetTables = new ArrayList<ITable>(aTargetTables.length);
        for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
            lTargetTables.add(aTargetTables[iTargetTable]);
        }
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary()) continue;
            IColumn[] aColumns = mapping.getTargets();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                if (!lTargetTables.remove(aColumns[iColumn].getTable()) || !lTargetTables.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getIndexOfMappingForColumn(IColumn column) {
        int index = -1;
        IMapping mapping = this.findTargetMapping(column);
        if (mapping != null) {
            return this.m_lMappings.indexOf(mapping);
        }
        mapping = this.findOneToOneSourceMapping(column);
        if (mapping != null) {
            return this.m_lMappings.indexOf(mapping);
        }
        return index;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getType() == 1 && ev.getSource() instanceof IMapping) {
            IMapping mapping = (IMapping)ev.getSource();
            if (mapping.isReplacing()) {
                this.fireModelChangedEvent("SelectResultsContainer:MappingChanged", ev.getSource());
            } else if (mapping.getTargetCount() == 0) {
                this.removeMapping(mapping);
            } else if (mapping.getSourceCount() == 0 && mapping.getExpression() == null) {
                this.removeMapping(mapping);
            } else {
                this.fireModelChangedEvent("SelectResultsContainer:MappingChanged", ev.getSource());
            }
            ModelEvent mdEvent = ev.getModelEvent();
            if (mdEvent != null && mdEvent.getType().equalsIgnoreCase("Mapping:ExpressionChanged") && mdEvent.getData() instanceof ISubquery) {
                this.fireNotifyEvent(33, null);
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        String desc = this.m_query.getDescription();
        if (desc.length() > 0) {
            codeSegment.addCommentLine(desc);
        }
        codeSegment.addSourceCode("select");
        if (this.m_query.useDistinct()) {
            codeSegment.addSourceCode(" distinct");
        }
        if (this.m_query.useImplicit()) {
            codeSegment.addSourceCode(" *\n");
        } else {
            codeSegment.addSourceCode("\n").indent();
            if (this.getTargetTables().length > 0) {
                IColumn[] columns = this.getTargetTables()[0].getColumns();
                for (int i = 0; i < columns.length; ++i) {
                    IColumn column = columns[i];
                    this.getMappingCode(codeSegment, column, passthru);
                    if (i == columns.length - 1) continue;
                    codeSegment.addSourceCode(",\n");
                }
            }
            codeSegment.unIndent().addSourceCode("\n");
        }
        return codeSegment;
    }

    private ICodeSegment getMappingCode(ICodeSegment codeSegment, IColumn targetColumn, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String mappingType;
        IMapping mapping = this.getOrdinaryMappingsForTargetColumn(targetColumn);
        String targetColName = targetColumn.getColumnName(codeSegment, passthru);
        int type = targetColumn.getType();
        String format = targetColumn.getFormat();
        String informat = targetColumn.getInformat();
        String description = targetColumn.getDescription();
        boolean genAdditionalStatements = false;
        String string = mappingType = mapping != null ? mapping.getType() : "UNKNOWN";
        if ("DERIVED".equals(mappingType)) {
            IExpression expression = mapping.getExpression();
            if (expression != null) {
                expression.setUseSQLSyntax(true);
                expression.getGeneratedCode(codeSegment, passthru);
            } else if (passthru) {
                codeSegment.addSourceCode("null");
            } else if (1 == type) {
                codeSegment.addSourceCode(".");
            } else {
                codeSegment.addSourceCode("\"\"");
            }
            codeSegment.addSourceCode(" as ").addSourceCode(targetColName);
            if (!passthru) {
                genAdditionalStatements = true;
            }
        } else if ("ONETOONE".equals(mappingType)) {
            IColumn sourceCol;
            IColumn[] sources = mapping.getSources();
            if (sources.length > 0 && (sourceCol = sources[0]) != null) {
                StringBuffer columnName = new StringBuffer();
                if (sourceCol instanceof IAliasColumn) {
                    columnName.append(((IAliasColumn)sourceCol).getFullColumnName(codeSegment.isQuoting(), passthru, this.getParentQuery()));
                } else {
                    columnName.append(sourceCol.getFullColumnName(codeSegment.isQuoting(), passthru));
                }
                if (!targetColumn.equalsName(sourceCol, codeSegment.isQuoting())) {
                    columnName.append(" as ").append(targetColumn.getColumnName(codeSegment, passthru));
                }
                codeSegment.addSourceCode(columnName);
                if (!passthru) {
                    genAdditionalStatements = true;
                }
            }
        } else {
            if (passthru) {
                codeSegment.addSourceCode("null");
            } else if (1 == type) {
                codeSegment.addSourceCode(".");
            } else {
                codeSegment.addSourceCode("\"\"");
            }
            codeSegment.addSourceCode(" as ").addSourceCode(targetColName);
            if (!passthru) {
                genAdditionalStatements = true;
            }
        }
        if (genAdditionalStatements) {
            codeSegment.addSourceCode(" ").addSourceCode(targetColumn.getLengthStatement(false)).indent();
            if (this.isFormatGenerationEnabled()) {
                if (format.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getFormatStatement());
                }
                if (informat.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getInformatStatement());
                }
            }
            if (description.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getLabelStatement());
            }
            codeSegment.unIndent();
        }
        return codeSegment;
    }

    @Override
    public void setParentQuery(IQuery query) {
        this.m_query = query;
    }

    @Override
    public IQuery getParentQuery() {
        return this.m_query;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.SELECT;
    }

    @Override
    public void addSQLSource(ISQLSource source) {
        if (source instanceof ISourceTable) {
            IMapping[] aMappings = this.getMappings();
            IColumn[] aCols = ((ISourceTable)source).getColumns();
            for (int index = 0; index < aMappings.length; ++index) {
                for (int iCol = 0; iCol < aCols.length; ++iCol) {
                    IExpression expression = aMappings[index].getExpression();
                    if (expression == null || !expression.containsRememberedColumn(aCols[iCol])) continue;
                    expression.replaceColumn(null, aCols[iCol]);
                    aMappings[index].addSource(aCols[iCol]);
                }
            }
            ITable[] aTables = this.getTargetTables();
            if (aTables.length > 0) {
                IJob job;
                if (this.m_query.isLoading()) {
                    return;
                }
                if (this.m_query != null && this.m_query.getTransformModel() != null && (job = this.m_query.getTransformModel().getJob()) != null && job.isMappingAutomatically() && this.m_query.getTransformModel().isIncludedInMapping() && this.m_query.containsQuerySourceTable((ISourceTable)source)) {
                    this.mapColumns(aCols, aTables[0].getColumns());
                }
            }
        }
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
        this.removeSourceTableFromMappings((ITable)((Object)source));
    }

    protected ITable findSourceTable(IPhysicalTable table) {
        ITable[] aSources = this.getSourceTables();
        for (int index = 0; index < aSources.length; ++index) {
            IAliasTable srcTable = (IAliasTable)aSources[index];
            ITable aliasTable = srcTable.getAliasedTable();
            if (aliasTable != table) continue;
            return srcTable;
        }
        return null;
    }

    @Override
    public ISubquery[] getSubqueries() {
        List lSubqueries = this.getSubqueryList();
        return lSubqueries.toArray(new ISubquery[lSubqueries.size()]);
    }

    @Override
    public List getSubqueryList() {
        ArrayList<IExpression> lSubqueries = new ArrayList<IExpression>();
        IMapping[] alMappings = this.getMappings();
        for (int i = 0; i < alMappings.length; ++i) {
            IMapping mapping = alMappings[i];
            IExpression expression = mapping.getExpression();
            if (expression == null || !"SubQueryOperand".equalsIgnoreCase(expression.getExpressionType())) continue;
            lSubqueries.add(expression);
        }
        return lSubqueries;
    }

    @Override
    public ISubquery createNewSubquery() {
        return this.m_query.createNewSubquery();
    }

    @Override
    public void removeSubqueryFromExpression(ISubquery subquery) {
        IMapping[] aMappings = this.getMappings();
        for (int index = 0; index < aMappings.length; ++index) {
            IMapping mapping = aMappings[index];
            IExpression expression = mapping.getExpression();
            if (expression == null || !"SubQueryOperand".equalsIgnoreCase(expression.getExpressionType())) continue;
            mapping.setExpression(null);
            for (int index2 = subquery.getQuerySourceTableCount(); index2 > 0; --index2) {
                subquery.removeQuerySourceTable(subquery.getQuerySourceTables()[index2 - 1]);
            }
            this.fireNotifyEvent(34);
            break;
        }
    }

    @Override
    public ICaseStatement[] getCaseStatements() {
        List lCases = this.getCaseStatementList();
        return lCases.toArray(new ICaseStatement[lCases.size()]);
    }

    @Override
    public List getCaseStatementList() {
        ArrayList<IExpression> lCases = new ArrayList<IExpression>();
        IMapping[] alMappings = this.getMappings();
        for (int i = 0; i < alMappings.length; ++i) {
            IMapping mapping = alMappings[i];
            IExpression expression = mapping.getExpression();
            if (expression == null || !expression.getExpressionType().equalsIgnoreCase("CaseOperand")) continue;
            lCases.add(expression);
        }
        return lCases;
    }

    @Override
    public boolean isMappingAllowed(IColumn[] aSources, IColumn[] aTargets) {
        return !this.isExpressionNeeded(aSources, aTargets) || this.areExpressionsAllowed();
    }

    protected boolean areExpressionsAllowed() {
        return true;
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (this.isExpressionNeeded(aSources, aTargets) && !this.areExpressionsAllowed()) {
            return "Mappings that require an expression are not allowed";
        }
        return null;
    }

    protected boolean isExpressionNeeded(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length != 1 || aTargets.length != 1) {
            return true;
        }
        return aSources[0].getType() != aTargets[0].getType();
    }

    private IMapping createNewMapping() {
        return this.getModel().getObjectFactory().createNewSQLMapping(this.getID(), this);
    }

    @Override
    public IMapping addMapping(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length == 1 && aTargets.length == 1) {
            IMappingRule[] aRules = DefaultMappingRules.getRules();
            for (int iRule = 0; iRule < aRules.length; ++iRule) {
                if (!aRules[iRule].canMap(aSources[0], aTargets[0])) continue;
                String sExpression = aRules[iRule].getExpressionText();
                if (sExpression != null && sExpression.length() > 0) {
                    if (!this.areExpressionsAllowed()) continue;
                    ITextOperand expression = this.getModel().getObjectFactory().createNewSQLTextOperand(this.getID(), this.m_query);
                    expression.setText(sExpression, new IObject[]{aSources[0], aSources[0].getTable()});
                    return this.addMapping(aSources, aTargets, "DERIVED", expression);
                }
                return this.addMapping(aSources, aTargets, "ONETOONE", null);
            }
        }
        String sType = this.isExpressionNeeded(aSources, aTargets) ? "DERIVED" : "ONETOONE";
        return this.addMapping(aSources, aTargets, sType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        aSourceColumns = this.verifyAndGetTheCorrectSourceColumns(aSourceColumns);
        this.startCompoundUndoable();
        try {
            SQLMapping mapping = (SQLMapping)this.createNewMapping();
            mapping.setName(aTargetColumns.length == 1 ? aTargetColumns[0].getName() : "newmapping");
            mapping.setType(sType);
            mapping.setExpression(oExpression);
            for (int iSourceColumn = 0; iSourceColumn < aSourceColumns.length; ++iSourceColumn) {
                mapping.addSource(aSourceColumns[iSourceColumn]);
            }
            for (int iTargetColumn = 0; iTargetColumn < aTargetColumns.length; ++iTargetColumn) {
                mapping.addTarget(aTargetColumns[iTargetColumn]);
            }
            mapping.setAutoType(true);
            this.addMapping(mapping);
            SQLMapping sQLMapping = mapping;
            return sQLMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addMapping(IMapping mapping) {
        this.addMapping(this.m_lMappings.size(), mapping);
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        this.m_query.removeFromQueryDeletedObjects(mapping);
        this.m_lMappings.add(iMapping, mapping);
        this.fireModelChangedEvent("MappingsContainer:MappingAdded", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddMappingUndoable(iMapping, mapping));
        }
        mapping.addNotifyListener(this);
    }

    @Override
    public void removeMapping(IMapping mapping) {
        int iMapping = this.m_lMappings.indexOf(mapping);
        if (iMapping == -1) {
            return;
        }
        this.m_query.addToQueryDeletedObjects(mapping);
        this.m_lMappings.remove(iMapping);
        this.fireModelChangedEvent("MappingsContainer:MappingRemoved", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveMappingUndoable(iMapping, mapping));
        }
        if (mapping.getExpression() instanceof ISubquery) {
            ISubquery subquery = (ISubquery)mapping.getExpression();
            for (int index2 = subquery.getQuerySourceTableCount(); index2 > 0; --index2) {
                subquery.removeQuerySourceTable(subquery.getQuerySourceTables()[index2 - 1]);
            }
            this.fireNotifyEvent(34);
            this.fireModelChangedEvent("SelectResultsContainer:SubqueryRemovedFromMapping", mapping);
        }
        mapping.removeNotifyListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceTableFromMappings(ITable tbl) {
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.removeSourceColumnFromMappings(aColumns[iColumn]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (!mapping.containsInSources(column)) continue;
                mapping.removeSource(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetTableFromMappings(ITable tbl) {
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.removeTargetColumnFromMappings(aColumns[iColumn]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (!mapping.containsInTargets(column)) continue;
                if (mapping.getType() == "ONETOONE") {
                    this.removeMapping(mapping);
                    continue;
                }
                mapping.removeTarget(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        aOldColumns = this.verifyAndGetTheCorrectSourceColumns(aOldColumns);
        aNewColumns = this.verifyAndGetTheCorrectSourceColumns(aNewColumns);
        this.startCompoundUndoable();
        try {
            for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
                IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
                for (int iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                    int iWhere = mapping.indexInSources(aOldColumns[iColumn]);
                    if (iWhere == -1) continue;
                    mapping.replaceSourceColumn(aOldColumns[iColumn], aNewColumns[iColumn]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        this.startCompoundUndoable();
        try {
            for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
                IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
                for (int iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                    int iWhere = mapping.indexInTargets(aOldColumns[iColumn]);
                    if (iWhere == -1) continue;
                    mapping.replaceTargetColumn(aOldColumns[iColumn], aNewColumns[iColumn]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean containsMapping(IMapping mapping) {
        return this.m_lMappings.contains(mapping);
    }

    @Override
    public IColumn[] getColumnsExcludedFromMapping() {
        return this.m_lColumnsExcludedFromMapping.toArray(new IColumn[this.m_lColumnsExcludedFromMapping.size()]);
    }

    @Override
    public List getListOfColumnsExcludedFromMapping() {
        return this.m_lColumnsExcludedFromMapping;
    }

    @Override
    public IColumn[] getColumnsExcludedFromPropagation() {
        return this.m_lColumnsExcludedFromPropagation.toArray(new IColumn[this.m_lColumnsExcludedFromPropagation.size()]);
    }

    @Override
    public List getListOfColumnsExcludedFromPropagation() {
        return this.m_lColumnsExcludedFromPropagation;
    }

    @Override
    public IMapping[] getMappings() {
        List lMappings = this.getMappingsList();
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public List getMappingsList() {
        return this.m_lMappings;
    }

    @Override
    public IMapping[] getOrdinaryMappings() {
        ArrayList<IMapping> lOrdinaryMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary()) continue;
            lOrdinaryMappings.add(mapping);
        }
        return lOrdinaryMappings.toArray(new IMapping[lOrdinaryMappings.size()]);
    }

    @Override
    public IMapping[] getSpecialMappings() {
        ArrayList<IMapping> lSpecialMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isSpecial()) continue;
            lSpecialMappings.add(mapping);
        }
        return lSpecialMappings.toArray(new IMapping[lSpecialMappings.size()]);
    }

    @Override
    public IMapping[] getOrdinaryMappingsForSourceColumn(IColumn source) {
        ArrayList<IMapping> lOrdinaryMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInSources(source)) continue;
            lOrdinaryMappings.add(mapping);
        }
        return lOrdinaryMappings.toArray(new IMapping[lOrdinaryMappings.size()]);
    }

    @Override
    public IMapping getOrdinaryMappingsForTargetColumn(IColumn target) {
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInTargets(target)) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public ITable[] getSourceTables() {
        return this.m_query.getSourcesInFrom();
    }

    @Override
    public ITable[] getTargetTables() {
        ITable table = this.m_query.getTargetTable();
        if (table != null) {
            ITable[] aTable = new ITable[]{table};
            return aTable;
        }
        return new ITable[0];
    }

    @Override
    public void setIncludedInPropagation(boolean bIncluded) {
        if (this.m_bIncludedInPropagation == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInPropagationUndoable(this.m_bIncludedInPropagation, bIncluded));
        }
        this.m_bIncludedInPropagation = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInPropagationChanged", null);
    }

    @Override
    public boolean isIncludedInPropagation() {
        return this.m_bIncludedInPropagation;
    }

    @Override
    public void setIncludedInMapping(boolean bIncluded) {
        if (this.m_bIncludedInMapping == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInMappingUndoable(this.m_bIncludedInMapping, bIncluded));
        }
        this.m_bIncludedInMapping = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInMappingsChanged", null);
    }

    @Override
    public boolean isIncludedInMapping() {
        return this.m_bIncludedInMapping;
    }

    @Override
    public void mapColumns() {
        this.mapColumns(DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget) {
        if (tblSource instanceof IPhysicalTable) {
            tblSource = this.findSourceTable((IPhysicalTable)tblSource);
        }
        if (tblTarget == null || tblSource == null) {
            return;
        }
        this.mapColumns(tblSource, tblTarget, DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets) {
        aSources = this.verifyAndGetTheCorrectSourceColumns(aSources);
        this.mapColumns(aSources, aTargets, DefaultMappingRules.getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapColumns(IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            ITable[] aTargetTables = this.getTargetTables();
            for (int iDataTarget = 0; iDataTarget < aTargetTables.length; ++iDataTarget) {
                ITable target = aTargetTables[iDataTarget];
                if (!(target instanceof ITable)) continue;
                ITable tblTarget = target;
                ITable[] aSourceTables = this.getSourceTables();
                for (int iDataSource = 0; iDataSource < aSourceTables.length; ++iDataSource) {
                    ITable source = aSourceTables[iDataSource];
                    if (!(source instanceof ITable)) continue;
                    ITable tblSource = source;
                    this.mapColumns(tblSource, tblTarget, aRules);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        if (tblSource instanceof IPhysicalTable) {
            tblSource = this.findSourceTable((IPhysicalTable)tblSource);
        }
        this.mapColumns(tblSource.getColumns(), tblTarget.getColumns(), aRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        aSources = this.verifyAndGetTheCorrectSourceColumns(aSources);
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IColumn[] aOneTarget = new IColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                aOneTarget[0] = tgt;
                boolean bUnmapped = !this.existsTargetMapping(tgt);
                for (int iSource = 0; iSource < lSources.size() && bUnmapped; ++iSource) {
                    IColumn src;
                    aOneSource[0] = src = (IColumn)lSources.get(iSource);
                    for (int iRule = 0; iRule < aRules.length && bUnmapped; ++iRule) {
                        if (!aRules[iRule].canMap(src, tgt)) continue;
                        String sExpression = aRules[iRule].getExpressionText();
                        if (sExpression != null && sExpression.length() > 0) {
                            if (!this.areExpressionsAllowed()) continue;
                            ITextOperand expression = this.getModel().getObjectFactory().createNewSQLTextOperand(this.getID(), this.m_query);
                            expression.setUseSQLSyntax(true);
                            expression.setText(sExpression, new IObject[]{src, src.getTable()});
                            this.addMapping(aOneSource, aOneTarget, "DERIVED", expression);
                        } else {
                            this.addMapping(aOneSource, aOneTarget, "ONETOONE", null);
                        }
                        bUnmapped = false;
                        lSources.remove(src);
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private boolean existsTargetMapping(IColumn colTarget) {
        return this.findTargetMapping(colTarget) != null;
    }

    protected final IMapping findTargetMapping(IColumn colTarget) {
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            IColumn[] aTargets = mapping.getTargets();
            if (aTargets.length != 1 || aTargets[0] != colTarget) continue;
            return mapping;
        }
        return null;
    }

    protected final IMapping findOneToOneSourceMapping(IColumn colSource) {
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            IColumn[] aSources = mapping.getSources();
            if (aSources.length != 1 || aSources[0] != colSource || !mapping.getType().equalsIgnoreCase("ONETOONE")) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public IColumn[] updateMappedColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        if ((aSourceColumns = this.verifyAndGetTheCorrectSourceColumns(aSourceColumns)).length > 0) {
            return this.updateMappedColumnsImpl(aSourceColumns, tblTarget, true);
        }
        return new IColumn[0];
    }

    @Override
    public IColumn[] updateMappedColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        if (tblSource instanceof IPhysicalTable) {
            tblSource = this.findSourceTable((IPhysicalTable)tblSource);
        }
        return this.updateMappedColumnsImpl(aTargetColumns, tblSource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] updateMappedColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, boolean bForward) {
        this.startCompoundUndoable();
        try {
            List<IColumn> lSourceColumns = Arrays.asList(aSourceColumns);
            List<IColumn> lTargetColumns = Arrays.asList(tblTarget.getColumns());
            ArrayList<IColumn> lUpdatedColumns = new ArrayList<IColumn>();
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
                boolean bEqual;
                IColumn[] aTargets;
                IColumn[] aSources;
                IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
                if (mapping.getType() == "ONETOONE") {
                    aSources = bForward ? mapping.getSources() : mapping.getTargets();
                    IColumn[] iColumnArray = aTargets = bForward ? mapping.getTargets() : mapping.getSources();
                    if (aSources.length != 1 || aTargets.length != 1 || !lSourceColumns.contains(aSources[0]) || !tblTarget.containsColumn(aTargets[0])) continue;
                    boolean bl = bEqual = bCaseSensitive ? aSources[0].getName().equals(aTargets[0].getName()) : aSources[0].getName().equalsIgnoreCase(aTargets[0].getName());
                    if (!bEqual && this.doesNameExistInColumns(aSources[0].getName(), lTargetColumns, bCaseSensitive)) continue;
                    aSources[0].deepCopy(aTargets[0]);
                    lUpdatedColumns.add(aTargets[0]);
                    continue;
                }
                if (!"DERIVED".equals(mapping.getType())) continue;
                aSources = bForward ? mapping.getSources() : mapping.getTargets();
                IColumn[] iColumnArray = aTargets = bForward ? mapping.getTargets() : mapping.getSources();
                if (aSources.length != 1 || aTargets.length != 1 || this.doesMappingHaveExpression(mapping) || !lSourceColumns.contains(aSources[0]) || !tblTarget.containsColumn(aTargets[0])) continue;
                boolean bl = bEqual = bCaseSensitive ? aSources[0].getName().equals(aTargets[0].getName()) : aSources[0].getName().equalsIgnoreCase(aTargets[0].getName());
                if (!bEqual && this.doesNameExistInColumns(aSources[0].getName(), lTargetColumns, bCaseSensitive)) continue;
                aSources[0].deepCopy(aTargets[0]);
                lUpdatedColumns.add(aTargets[0]);
            }
            IColumn[] iColumnArray = lUpdatedColumns.toArray(new IColumn[lUpdatedColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private boolean doesMappingHaveExpression(IMapping mapping) {
        IExpression expression = mapping.getExpression();
        if (expression == null) {
            return false;
        }
        try {
            return expression.getText(null, false, false).length() > 0;
        }
        catch (RemoteException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (CodegenException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (MdException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (BadServerDefinitionException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (BadLibraryDefinitionException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (ServerException ex) {
            ModelLogger.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        return true;
    }

    private boolean doesNameExistInColumns(String sName, List lColumns, boolean bCaseSensitive) {
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            boolean bEquals;
            IColumn column = (IColumn)lColumns.get(iColumn);
            String sColumnName = column.getName();
            boolean bl = bEquals = bCaseSensitive ? sColumnName.equals(sName) : sColumnName.equalsIgnoreCase(sName);
            if (!bEquals) continue;
            return true;
        }
        return false;
    }

    protected final boolean isQuotingNeeded() {
        return this.m_query.getTransformModel().isQuotingNeeded();
    }

    protected final List getSourceColumnsExcludedFromMapping() {
        ArrayList<IAliasColumn> lColumns = new ArrayList<IAliasColumn>();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IAliasTable aliasTable = (IAliasTable)aTables[iTable];
            if (aliasTable.getAliasedTable() == null) continue;
            IDataTransform[] aProducers = aliasTable.getAliasedTable().getProducerTransforms();
            ArrayList lBaseColumns = new ArrayList();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                lBaseColumns.addAll(aProducers[iProducer].getListOfColumnsExcludedFromMapping());
            }
            for (int index = 0; index < lBaseColumns.size(); ++index) {
                IColumn baseColumn = (IColumn)lBaseColumns.get(index);
                lColumns.add(aliasTable.findAlaisedColumnContainingColumn(baseColumn));
            }
        }
        return lColumns;
    }

    private List getSourceColumnsExcludedFromPropagation() {
        ArrayList<IAliasColumn> lColumns = new ArrayList<IAliasColumn>();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IAliasTable aliasTable = (IAliasTable)aTables[iTable];
            if (aliasTable.getAliasedTable() == null) continue;
            IDataTransform[] aProducers = aliasTable.getAliasedTable().getProducerTransforms();
            ArrayList lBaseColumns = new ArrayList();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                lBaseColumns.addAll(aProducers[iProducer].getListOfColumnsExcludedFromPropagation());
            }
            for (int index = 0; index < lBaseColumns.size(); ++index) {
                IColumn baseColumn = (IColumn)lBaseColumns.get(index);
                lColumns.add(aliasTable.findAlaisedColumnContainingColumn(baseColumn));
            }
        }
        return lColumns;
    }

    @Override
    public void propagateColumnsToSourceTables() {
        this.propagateColumnsToSourceTables(0);
    }

    @Override
    public void propagateColumnsToSourceTables(int eNonWorkTableHandling) {
        this.propagateColumnsToSourceTables(this.getSourceTables(), this.getTargetTables(), eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        if ((aSourceTables = this.verifyAndGetTheCorrectSourceTables(aSourceTables)).length > 0) {
            this.propagateColumnsToSourceTables(aSourceTables, aTargetTables, 0);
        }
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        if ((aSourceTables = this.verifyAndGetTheCorrectSourceTables(aSourceTables)).length > 0) {
            this.propagateColumnsImpl(aTargetTables, aSourceTables, this.getListOfColumnsExcludedFromPropagation(), eNonWorkTableHandling, false);
        }
    }

    @Override
    public void propagateColumnsToTargetTables() {
        this.propagateColumnsToTargetTables(0);
    }

    @Override
    public void propagateColumnsToTargetTables(int eNonWorkTableHandling) {
        this.propagateColumnsToTargetTables(this.getSourceTables(), this.getTargetTables(), eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        if ((aSourceTables = this.verifyAndGetTheCorrectSourceTables(aSourceTables)).length > 0) {
            this.propagateColumnsToTargetTables(aSourceTables, aTargetTables, 0);
        }
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        if ((aSourceTables = this.verifyAndGetTheCorrectSourceTables(aSourceTables)).length > 0) {
            this.propagateColumnsImpl(aSourceTables, aTargetTables, this.getSourceColumnsExcludedFromPropagation(), eNonWorkTableHandling, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void propagateColumnsImpl(ITable[] aSourceTables, ITable[] aTargetTables, List lExcludedColumns, int eNonWorkTableHandling, boolean bForward) {
        this.startCompoundUndoable();
        try {
            int iTargetTable = 0;
            while (iTargetTable < aTargetTables.length) {
                block8: {
                    int iSourceTable;
                    ITable tblTarget;
                    block9: {
                        block7: {
                            tblTarget = aTargetTables[iTargetTable];
                            if (tblTarget instanceof IWorkTable) break block7;
                            if (eNonWorkTableHandling == 2) break block8;
                            if (eNonWorkTableHandling != 1) break block7;
                            break block9;
                        }
                        for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                            this.propagateColumnsImpl(aSourceTables[iSourceTable].getColumns(), tblTarget, lExcludedColumns, bForward);
                        }
                        break block8;
                    }
                    for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                        if (bForward) {
                            this.mapColumns(aSourceTables[iSourceTable], tblTarget);
                            continue;
                        }
                        this.mapColumns(tblTarget, aSourceTables[iSourceTable]);
                    }
                }
                ++iTargetTable;
            }
            return;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, List lExcludedColumns, boolean bForward) {
        IObjectFactory factory = this.getObjectFactory();
        IColumn[] aSource = new IColumn[1];
        IColumn[] aTarget = new IColumn[1];
        this.startCompoundUndoable();
        try {
            IAliasTable tblAliasTarget = null;
            if (tblTarget instanceof IAliasTable) {
                tblAliasTarget = (IAliasTable)tblTarget;
                tblTarget = tblAliasTarget.getAliasedTable();
            }
            ArrayList<IColumn> lTargetColumns = new ArrayList<IColumn>();
            ArrayList<IColumn> lNewTargetColumns = new ArrayList<IColumn>();
            lTargetColumns.addAll(Arrays.asList(tblTarget.getColumns()));
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iColumn = 0; iColumn < aSourceColumns.length; ++iColumn) {
                IColumn colSource = aSourceColumns[iColumn];
                if (lExcludedColumns.contains(colSource) || this.doesNameExistInColumns(colSource.getName(), lTargetColumns, bCaseSensitive) || !bForward && this.getOrdinaryMappingsForTargetColumn(colSource) != null) continue;
                IAliasColumn aliasColumn = null;
                if (colSource instanceof IAliasColumn) {
                    aliasColumn = (IAliasColumn)colSource;
                    colSource = ((IAliasColumn)colSource).getAliasedColumn();
                }
                IColumn colTarget = factory.createNewColumn(tblTarget.getID());
                aSourceColumns[iColumn].copy(colTarget);
                tblTarget.addColumn(colTarget);
                lTargetColumns.add(colTarget);
                if (tblAliasTarget != null) {
                    colTarget = tblAliasTarget.findAlaisedColumnContainingColumn(colTarget);
                }
                lNewTargetColumns.add(colTarget);
                aSource[0] = aliasColumn == null ? colSource : aliasColumn;
                aTarget[0] = colTarget;
                if (bForward) {
                    this.addMapping(aSource, aTarget, "ONETOONE", null);
                    continue;
                }
                this.addMapping(aTarget, aSource, "ONETOONE", null);
            }
            IColumn[] iColumnArray = lNewTargetColumns.toArray(new IColumn[lNewTargetColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        if (tblSource instanceof IPhysicalTable) {
            tblSource = this.findSourceTable((IPhysicalTable)tblSource);
        }
        return this.propagateColumnsToSourceTable(tblSource, aTargetColumns, 0);
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns, int eNonWorkTableHandling) {
        if (tblSource instanceof IPhysicalTable) {
            tblSource = this.findSourceTable((IPhysicalTable)tblSource);
        }
        if (tblSource != null) {
            if (!(((IAliasTable)tblSource).getAliasedTable() instanceof IWorkTable)) {
                if (eNonWorkTableHandling == 2) {
                    return new IColumn[0];
                }
                if (eNonWorkTableHandling == 1) {
                    this.mapColumns(tblSource.getColumns(), aTargetColumns);
                    return new IColumn[0];
                }
            }
            return this.propagateColumnsImpl(aTargetColumns, tblSource, new ArrayList(), false);
        }
        return new IColumn[0];
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        if ((aSourceColumns = this.verifyAndGetTheCorrectSourceColumns(aSourceColumns)).length > 0) {
            return this.propagateColumnsToTargetTable(aSourceColumns, tblTarget, 0);
        }
        return new IColumn[0];
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget, int eNonWorkTableHandling) {
        aSourceColumns = this.verifyAndGetTheCorrectSourceColumns(aSourceColumns);
        if (!(tblTarget instanceof IWorkTable)) {
            if (eNonWorkTableHandling == 2) {
                return new IColumn[0];
            }
            if (eNonWorkTableHandling == 1) {
                this.mapColumns(tblTarget.getColumns(), aSourceColumns);
                return new IColumn[0];
            }
        }
        if (aSourceColumns.length > 0) {
            return this.propagateColumnsImpl(aSourceColumns, tblTarget, new ArrayList(), true);
        }
        return new IColumn[0];
    }

    private IColumn[] verifyAndGetTheCorrectSourceColumns(IColumn[] aSourceColumns) {
        ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
        for (int index = 0; index < aSourceColumns.length; ++index) {
            IColumn srcColumn = aSourceColumns[index];
            if (!(srcColumn instanceof IAliasColumn)) {
                IAliasColumn aliasColumn;
                ITable pTable = srcColumn.getTable();
                ITable aliasTbl = this.findSourceTable((IPhysicalTable)pTable);
                if (aliasTbl == null || (aliasColumn = ((IAliasTable)aliasTbl).findAlaisedColumnContainingColumn(srcColumn)) == null) continue;
                lColumns.add(aliasColumn);
                continue;
            }
            lColumns.add(aSourceColumns[index]);
        }
        return lColumns.toArray(new IColumn[lColumns.size()]);
    }

    private ITable[] verifyAndGetTheCorrectSourceTables(ITable[] aSourceTables) {
        ArrayList<ITable> lSources = new ArrayList<ITable>();
        for (int index = 0; index < aSourceTables.length; ++index) {
            ITable srcTable = aSourceTables[index];
            if (!(srcTable instanceof IAliasTable)) {
                ITable aliasTbl = this.findSourceTable((IPhysicalTable)srcTable);
                if (aliasTbl == null) continue;
                lSources.add(aliasTbl);
                continue;
            }
            lSources.add(srcTable);
        }
        return lSources.toArray(new ITable[lSources.size()]);
    }

    public boolean isFormatGenerationEnabled() {
        if (this.m_query.getTransformModel().getFormatInformatGeneration().equalsIgnoreCase("JOB")) {
            return this.m_query.getTransformModel().getJob().isFormatInformatGenerationEnabled();
        }
        return this.m_query.getTransformModel().getFormatInformatGeneration().equalsIgnoreCase("YES");
    }

    private class AddMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public AddMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            SelectResultsContainer.this.removeMapping(this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            SelectResultsContainer.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void die() {
            super.die();
            this.m_mapping = null;
        }
    }

    private class RemoveMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public RemoveMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            SelectResultsContainer.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            SelectResultsContainer.this.removeMapping(this.m_mapping);
        }

        @Override
        public void die() {
            super.die();
            this.m_mapping = null;
        }
    }

    private class SetIncludedInPropagationUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInPropagation;
        private boolean m_newIncludedInPropagation;

        public SetIncludedInPropagationUndoable(boolean oldIncludedInPropagation, boolean newIncludedInPropagation) {
            this.m_oldIncludedInPropagation = oldIncludedInPropagation;
            this.m_newIncludedInPropagation = newIncludedInPropagation;
        }

        @Override
        public void undo() {
            super.undo();
            SelectResultsContainer.this.setIncludedInPropagation(this.m_oldIncludedInPropagation);
        }

        @Override
        public void redo() {
            super.redo();
            SelectResultsContainer.this.setIncludedInPropagation(this.m_newIncludedInPropagation);
        }
    }

    private class SetIncludedInMappingUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInMapping;
        private boolean m_newIncludedInMapping;

        public SetIncludedInMappingUndoable(boolean oldIncludedInMapping, boolean newIncludedInMapping) {
            this.m_oldIncludedInMapping = oldIncludedInMapping;
            this.m_newIncludedInMapping = newIncludedInMapping;
        }

        @Override
        public void undo() {
            super.undo();
            SelectResultsContainer.this.setIncludedInMapping(this.m_oldIncludedInMapping);
        }

        @Override
        public void redo() {
            super.redo();
            SelectResultsContainer.this.setIncludedInMapping(this.m_newIncludedInMapping);
        }
    }
}

