/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.job.transforms.sql.ISQLPort;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseSQLPort
extends BaseObject
implements ISQLPort {
    int m_nMaximumConnections = 1;
    IObject m_object;
    IObject m_objectContainer;
    String m_sJoinSide = "";

    public BaseSQLPort(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("BaseSQLPort.DefaultPortName.txt");
    }

    @Override
    public void setMaximumConnections(int nMaximumConnections) {
        if (this.m_nMaximumConnections == nMaximumConnections) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaximumConnectionsUndoable(this.m_nMaximumConnections, nMaximumConnections));
        }
        this.m_nMaximumConnections = nMaximumConnections;
        this.fireModelChangedEvent("BaseSQLPort:MaxConnectionsChanged", null);
    }

    @Override
    public int getMaximumConnections() {
        return this.m_nMaximumConnections;
    }

    @Override
    public void setObject(IObject object) {
        if (this.m_object == object) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetObjectUndoable(this.m_object, object));
        }
        this.m_object = object;
        this.fireModelChangedEvent("BaseSQLPort:ObjectChanged", null);
    }

    @Override
    public IObject getObject() {
        return this.m_object;
    }

    @Override
    public void setObjectContainer(IObject object) {
        if (this.m_objectContainer == object) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetObjectContainerUndoable(this.m_objectContainer, object));
        }
        this.m_objectContainer = object;
        this.fireModelChangedEvent("BaseSQLPort:ContainerChanged", null);
    }

    @Override
    public IObject getObjectContainer() {
        return this.m_objectContainer;
    }

    @Override
    public void setJoinSide(String sSide) {
        if (this.m_sJoinSide.equalsIgnoreCase(sSide)) {
            return;
        }
        if (sSide == null) {
            sSide = "";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetJoinSideUndoable(this.m_sJoinSide, sSide));
        }
        this.m_sJoinSide = sSide;
        this.fireModelChangedEvent("BaseSQLPort:JoinSideChanged", null);
    }

    @Override
    public String getJoinSide() {
        return this.m_sJoinSide;
    }

    private class SetMaximumConnectionsUndoable
    extends AbstractUndoableEdit {
        private int m_oldMaximumConnections;
        private int m_newMaximumConnections;

        public SetMaximumConnectionsUndoable(int oldMaximumConnections, int newMaximumConnections) {
            this.m_oldMaximumConnections = oldMaximumConnections;
            this.m_newMaximumConnections = newMaximumConnections;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSQLPort.this.setMaximumConnections(this.m_oldMaximumConnections);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSQLPort.this.setMaximumConnections(this.m_newMaximumConnections);
        }
    }

    private class SetObjectUndoable
    extends AbstractUndoableEdit {
        private IObject m_oldObject;
        private IObject m_newObject;

        public SetObjectUndoable(IObject oldObject, IObject newObject) {
            this.m_oldObject = oldObject;
            this.m_newObject = newObject;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSQLPort.this.setObject(this.m_oldObject);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSQLPort.this.setObject(this.m_newObject);
        }

        @Override
        public void die() {
            super.die();
            this.m_newObject = null;
            this.m_oldObject = null;
        }
    }

    private class SetObjectContainerUndoable
    extends AbstractUndoableEdit {
        private IObject m_oldObjectContainer;
        private IObject m_newObjectContainer;

        public SetObjectContainerUndoable(IObject oldObjectContainer, IObject newObjectContainer) {
            this.m_oldObjectContainer = oldObjectContainer;
            this.m_newObjectContainer = newObjectContainer;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSQLPort.this.setObjectContainer(this.m_oldObjectContainer);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSQLPort.this.setObjectContainer(this.m_newObjectContainer);
        }

        @Override
        public void die() {
            super.die();
            this.m_newObjectContainer = null;
            this.m_oldObjectContainer = null;
        }
    }

    private class SetJoinSideUndoable
    extends AbstractUndoableEdit {
        private String m_oldJoinSide;
        private String m_newJoinSide;

        public SetJoinSideUndoable(String oldJoinSide, String newJoinSide) {
            this.m_oldJoinSide = oldJoinSide;
            this.m_newJoinSide = newJoinSide;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSQLPort.this.setJoinSide(this.m_oldJoinSide);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSQLPort.this.setJoinSide(this.m_newJoinSide);
        }
    }
}

