/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IHaving;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.Join;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.SQLMapping;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.impl.SourceTable;
import com.sas.etl.models.job.transforms.sql.impl.Subquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseQuery
extends AbstractPersistableObject
implements IQuery {
    public static final int PORT_CHANGED = 10;
    private static final String PROPERTY_SET_ROLE = "TargetTableOptions";
    private static final String PROPERTY_NAME_USE_BULKLOAD = "bulkload";
    private static final String PROPERTY_NAME_BULKLOAD_OPTIONS = "bulkloadOptions";
    protected static final String PROPERTY_SET_NAME_SELECT = "SelectProperties";
    protected static final String PROPERTY_NAME_DISTINCT = "Distinct";
    protected static final String PROPERTY_NAME_IMPLICIT = "Implicit";
    private static final String QUERY_TRANSFORM_ROLE = "CreateSelect";
    protected static final String DEFAULT_VALUE_YES = "YES";
    protected static final String DEFAULT_VALUE_NO = "NO";
    private ITable m_targetTable;
    private boolean m_bUseImplicit = false;
    private boolean m_bUseDistinct = false;
    private ISQLTransform m_transformModel;
    private boolean m_bSaveSelectResults = true;
    private boolean m_bNoResetSourceOfFrom = false;
    private ISelectResultsContainer m_selectResults;
    private ISQLSource m_sourceOfFrom;
    private IWhere m_where;
    private IHaving m_having;
    private IOrderBy m_orderBy;
    private IGroupBy m_groupBy;
    private ModelList m_lSourceTables = new ModelList(this, new String[]{"SQLObject:QueryTableAdded", "SQLObject:QueryTableRemoved"}, 0, ISourceTable.class);
    private List m_lSubquerySources = new ModelList(this, new String[]{"BaseQuery:SubquerySourceAdded", "BaseQuery:SubquerySourceRemoved"}, 0, ISourceTable.class);
    private List m_lJoinObjects = new ArrayList();
    private List m_lInlineSubqueries = new ModelList(this, new String[]{"BaseQuery:SubqueryAdded", "BaseQuery:SubqueryRemoved"}, 0, ISubquery.class);
    private boolean m_bUploadUsingBulkload = false;
    private String m_sBulkloadOptions = "";
    private ITransformTableOptions m_targetTableOption;
    private String m_sLastChangeNodeId = "";
    private boolean m_bIsLoading = false;
    private boolean m_bIsInserting = false;
    private boolean m_bRemovingInputPort = false;
    private boolean m_bControlSourceEvents = false;

    public BaseQuery(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return QUERY_TRANSFORM_ROLE;
    }

    public static String getTransformRole() {
        return QUERY_TRANSFORM_ROLE;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() instanceof IClause) {
            if (ev.getType() == 1) {
                this.fireModelChangedEvent("BaseQuery:QueryChanged", null);
            }
            if (ev.getType() == 20 || ev.getType() == 21 || ev.getType() == 31 || ev.getType() == 32 || ev.getType() == 33 || ev.getType() == 34 || ev.getType() == 10) {
                this.fireNotifyEvent(10, null);
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public IClause getClause(ClauseType type) {
        if (type == ClauseType.WHERE) {
            return this.m_where;
        }
        if (type == ClauseType.HAVING) {
            return this.m_having;
        }
        if (type == ClauseType.ORDERBY) {
            return this.m_orderBy;
        }
        if (type == ClauseType.GROUPBY) {
            return this.m_groupBy;
        }
        if (type == ClauseType.SELECT) {
            if (this.m_selectResults == null) {
                return this;
            }
            return this.m_selectResults;
        }
        throw new IllegalArgumentException("BaseQuery: Get of " + type + " not supported.");
    }

    @Override
    public IClause[] getClauses() {
        ArrayList<IObject> lClauses = new ArrayList<IObject>(6);
        lClauses.add(this.m_selectResults);
        lClauses.add(this);
        if (this.m_where != null) {
            lClauses.add(this.m_where);
        }
        if (this.m_groupBy != null) {
            lClauses.add(this.m_groupBy);
        }
        if (this.m_having != null) {
            lClauses.add(this.m_having);
        }
        if (this.m_orderBy != null) {
            lClauses.add(this.m_orderBy);
        }
        return lClauses.toArray(new IClause[lClauses.size()]);
    }

    @Override
    public List getAllClauses() {
        ArrayList<IObject> lClauses = new ArrayList<IObject>();
        lClauses.addAll(this.m_lJoinObjects);
        lClauses.add(this.m_selectResults);
        if (this.m_where != null) {
            lClauses.add(this.m_where);
        }
        if (this.m_groupBy != null) {
            lClauses.add(this.m_groupBy);
        }
        if (this.m_having != null) {
            lClauses.add(this.m_having);
        }
        if (this.m_orderBy != null) {
            lClauses.add(this.m_orderBy);
        }
        lClauses.addAll(this.m_lInlineSubqueries);
        return lClauses;
    }

    @Override
    public IClause addClause(ClauseType type) {
        if (type == ClauseType.WHERE) {
            if (this.m_where != null) {
                return this.m_where;
            }
            return this.addClause(this.getModel().getObjectFactory().createNewSQLWhere(this.getID()));
        }
        if (type == ClauseType.HAVING) {
            if (this.m_having != null) {
                return this.m_having;
            }
            return this.addClause(this.getModel().getObjectFactory().createNewSQLHaving(this.getID()));
        }
        if (type == ClauseType.ORDERBY) {
            if (this.m_orderBy != null) {
                return this.m_orderBy;
            }
            return this.addClause(this.getModel().getObjectFactory().createNewSQLOrderBy(this.getID()));
        }
        if (type == ClauseType.GROUPBY) {
            if (this.m_groupBy != null) {
                return this.m_groupBy;
            }
            return this.addClause(this.getModel().getObjectFactory().createNewSQLGroupBy(this.getID()));
        }
        throw new UnsupportedOperationException("Add of " + type + " not supported.");
    }

    @Override
    public IClause addClause(IClause clause) {
        this.removeFromDeletedObjects((IPersistableObject)((Object)clause));
        if (clause instanceof IWhere) {
            this.m_where = (IWhere)clause;
        } else if (clause instanceof IHaving) {
            this.m_having = (IHaving)clause;
        } else if (clause instanceof IOrderBy) {
            this.m_orderBy = (IOrderBy)clause;
        } else if (clause instanceof IGroupBy) {
            this.m_groupBy = (IGroupBy)clause;
        } else if (clause instanceof IJoin && !this.m_lJoinObjects.contains(clause)) {
            this.m_lJoinObjects.add(clause);
        }
        this.addClauseImpl(clause);
        return clause;
    }

    private void addClauseImpl(IClause clause) {
        clause.setParentQuery(this);
        clause.addNotifyListener(this);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddClauseUndoable(clause));
        }
        this.fireModelChangedEvent("SQL:ClauseAdded", clause);
    }

    @Override
    public void removeClause(IClause clause) {
        if (clause == null || clause instanceof ISelectResultsContainer || clause == this.m_transformModel || clause == this) {
            return;
        }
        if (clause == this.m_where) {
            this.m_where = null;
        } else if (clause == this.m_having) {
            this.m_having = null;
        } else if (clause == this.m_groupBy) {
            this.m_groupBy = null;
        } else if (clause == this.m_orderBy) {
            this.m_orderBy = null;
        } else if (clause instanceof IJoin) {
            if (this.m_lJoinObjects.contains(clause)) {
                this.m_lJoinObjects.remove(clause);
            }
            ((IJoin)clause).setParent(null);
        }
        if (clause instanceof ISQLBooleanExpressionContainer) {
            IBooleanExpression[] alExprs = ((ISQLBooleanExpressionContainer)clause).getBooleanExpressions();
            for (int index = 0; index < alExprs.length; ++index) {
                ((ISQLBooleanExpressionContainer)clause).removeBooleanExpression(alExprs[index]);
            }
        }
        clause.removeNotifyListener(this);
        this.addToDeletedObjects((IPersistableObject)((Object)clause));
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveClauseUndoable(clause));
        }
        this.fireModelChangedEvent("SQL:ClauseRemoved", clause);
    }

    @Override
    public void setTargetTable(ITable target) {
        if (this.m_targetTable == target) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_targetTable != null) {
                this.m_targetTable.removeNotifyListener(this);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTargetTableUndoable(this.m_targetTable, target));
            }
            this.m_targetTable = target;
            if (this.m_targetTable != null) {
                this.m_targetTable.addNotifyListener(this);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public ITable getTargetTable() {
        if (this.m_targetTable == null && this.m_transformModel != null) {
            this.m_targetTable = (ITable)this.m_transformModel.getDataTarget();
        }
        return this.m_targetTable;
    }

    @Override
    public ISourceTable[] getQuerySourceTables() {
        return (ISourceTable[])this.m_lSourceTables.toArray(new ISourceTable[this.m_lSourceTables.size()]);
    }

    @Override
    public List getQuerySourceTableList() {
        return this.m_lSourceTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISourceTable createASourceTableAndAddToJob(IPhysicalTable table) {
        this.startCompoundUndoable();
        try {
            IJob job;
            ISourceTable source = this.getModel().getObjectFactory().createNewSQLSourceTable(this.getID());
            source.setAliasedTable(table);
            this.addQuerySourceTable(source);
            List lDataObjects = null;
            if (this.m_transformModel != null && (job = this.m_transformModel.getJob()) != null && !(lDataObjects = this.m_transformModel.getJob().getDataObjectsList()).contains(table)) {
                lDataObjects.add(table);
            }
            ISourceTable iSourceTable = source;
            return iSourceTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addANewSourceTableAndAddToJob(ISourceTable source) {
        this.startCompoundUndoable();
        try {
            ITable table;
            IJob job;
            this.addQuerySourceTable(source);
            List lDataObjects = null;
            if (this.m_transformModel != null && (job = this.m_transformModel.getJob()) != null && !(lDataObjects = this.m_transformModel.getJob().getDataObjectsList()).contains(table = source.getAliasedTable())) {
                lDataObjects.add(table);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISourceTable addQuerySourceTable(ITable table) {
        this.startCompoundUndoable();
        try {
            ISourceTable source = this.getModel().getObjectFactory().createNewSQLSourceTable(this.getID());
            source.setAliasedTable(table);
            this.addQuerySourceTable(source);
            ISourceTable iSourceTable = source;
            return iSourceTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addQuerySourceTable(ISourceTable source) {
        this.addQuerySourceTable(this.m_lSourceTables.size(), source);
    }

    @Override
    public void addQuerySourceTable(int index, ISourceTable source) {
        if (this.m_lSourceTables.contains(source)) {
            return;
        }
        if (source != null) {
            this.m_lSourceTables.add(index, source);
            source.addNotifyListener(this);
            this.removeFromDeletedObjects(source);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddSourceTableUndoable(source));
            }
            IColumn[] aCols = source.getColumns();
            for (int i = 0; i < aCols.length; ++i) {
                if (!this.containsRememberedColumn(aCols[i])) continue;
                this.replaceColumn(null, aCols[i]);
            }
        }
    }

    @Override
    public int getQuerySourceTableCount() {
        return this.m_lSourceTables.size();
    }

    @Override
    public boolean containsQuerySourceTable(ISourceTable source) {
        return this.m_lSourceTables.contains(source);
    }

    @Override
    public boolean containedInQuerySourceTables(IPhysicalTable table) {
        ISourceTable[] tables = this.findQuerySourceTables(table);
        if (tables.length > 0) {
            return true;
        }
        if (this.m_transformModel != null) {
            List sources = null;
            sources = this.m_transformModel.getQuery() != null ? this.m_transformModel.getQuery().getAllSourceTables() : this.getAllSourceTables();
            for (int i = 0; i < sources.size(); ++i) {
                ISourceTable source = (ISourceTable)sources.get(i);
                if (!source.containsAliasedTable(table)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQuerySourceTable(ISourceTable source) {
        if (!this.m_lSourceTables.contains(source)) {
            return;
        }
        source.setChangedNodeId("");
        this.setLastChangeNodeId("");
        this.startCompoundUndoable();
        try {
            if (source != null) {
                ISourceTable[] alSourceTables;
                ITable table = source.getAliasedTable();
                if (table != null && (alSourceTables = this.findInSourceTables(table, this.m_transformModel.getAllQuerySourceTables())).length == 1 && !this.m_transformModel.getConnectedSources().contains(table)) {
                    this.m_transformModel.removeDataSource(table);
                }
                source.setParent(null);
                source.removeNotifyListener(this);
                this.m_lSourceTables.remove(source);
                this.addToDeletedObjects(source);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new RemoveSourceTableUndoable(source));
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addSubquerySourceTable(ISourceTable source) {
        this.addSubquerySourceTable(this.m_lSubquerySources.size(), source);
    }

    @Override
    public void addSubquerySourceTable(int index, ISourceTable source) {
        if (this.m_lSubquerySources.contains(source)) {
            return;
        }
        this.m_lSubquerySources.add(index, source);
    }

    @Override
    public ISourceTable[] getSubquerySourceTables() {
        return this.m_lSubquerySources.toArray(new ISourceTable[this.m_lSubquerySources.size()]);
    }

    @Override
    public List getSubquerySourceTableList() {
        return this.m_lSubquerySources;
    }

    @Override
    public void removeSubquerySourceTable(ISourceTable source) {
        this.m_lSubquerySources.remove(source);
    }

    @Override
    public ISourceTable[] findQuerySourceTables(ITable table) {
        ArrayList<ISourceTable> lSources = new ArrayList<ISourceTable>();
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            ISourceTable source = (ISourceTable)this.m_lSourceTables.get(i);
            if (!source.containsAliasedTable(table)) continue;
            lSources.add(source);
        }
        return lSources.toArray(new ISourceTable[lSources.size()]);
    }

    @Override
    public ISourceTable[] findInAllQuerySourceTables(ITable table) {
        ArrayList lAllSources = new ArrayList();
        if (this.m_transformModel != null && this.m_transformModel.getQuery() != null) {
            lAllSources.addAll(this.m_transformModel.getQuery().getAllSourceTables());
        } else {
            lAllSources.addAll(this.getAllSourceTables());
        }
        return this.findInSourceTables(table, lAllSources.toArray(new ISourceTable[0]));
    }

    private ISourceTable[] findInSourceTables(ITable table, ISourceTable[] sources) {
        ArrayList<ISourceTable> lFoundSources = new ArrayList<ISourceTable>();
        for (int i = 0; i < sources.length; ++i) {
            if (!sources[i].containsAliasedTable(table)) continue;
            lFoundSources.add(sources[i]);
        }
        return lFoundSources.toArray(new ISourceTable[lFoundSources.size()]);
    }

    @Override
    public ISourceTable findQuerySourceTable(String sAliasName) {
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            ISourceTable source = (ISourceTable)this.m_lSourceTables.get(i);
            String sAlias = source.getAliasName();
            if (!sAliasName.equalsIgnoreCase(sAlias)) continue;
            return source;
        }
        return null;
    }

    @Override
    public ISubquery[] getSubqueries() {
        List lSubqueries = this.getSubqueryList();
        return lSubqueries.toArray(new ISubquery[lSubqueries.size()]);
    }

    @Override
    public List getSubqueryList() {
        ArrayList<IQuery> lSubqueries = new ArrayList<IQuery>();
        lSubqueries.addAll(Arrays.asList(this.getSubqueriesInFrom()));
        if (this.m_selectResults != null) {
            lSubqueries.addAll(this.m_selectResults.getSubqueryList());
        }
        if (this.m_where != null) {
            lSubqueries.addAll(this.m_where.getSubqueryList());
        }
        if (this.m_having != null) {
            lSubqueries.addAll(this.m_having.getSubqueryList());
        }
        return lSubqueries;
    }

    @Override
    public ISubquery createNewSubquery() {
        ISubquery subquery = this.getModel().getObjectFactory().createNewSQLSubquery(this.getID());
        subquery.setTransformModel(this.m_transformModel);
        subquery.setRole("SUBQUERY");
        this.addClause(subquery);
        return subquery;
    }

    @Override
    public void removeSubqueryFromExpression(ISubquery subquery) {
        this.m_selectResults.removeSubqueryFromExpression(subquery);
        if (this.m_where != null) {
            this.m_where.removeSubqueryFromExpression(subquery);
        }
        if (this.m_having != null) {
            this.m_having.removeSubqueryFromExpression(subquery);
        }
        if (this.m_sourceOfFrom != null) {
            List lJoins = this.m_sourceOfFrom.getAllJoins();
            for (int index = 0; index < lJoins.size(); ++index) {
                IJoin join = (IJoin)lJoins.get(index);
                if (join.useImplicit()) continue;
                join.removeSubqueryFromExpression(subquery);
            }
        }
    }

    @Override
    public void setSelectResults(ISelectResultsContainer results) {
        if (this.m_selectResults != null) {
            throw new UnsupportedOperationException("Reseting the select results variable is not allowed.");
        }
        this.m_selectResults = results;
        this.m_selectResults.addNotifyListener(this);
    }

    @Override
    public ISelectResultsContainer getSelectResults() {
        return this.m_selectResults;
    }

    @Override
    public IOrderBy getOrderBy() {
        return this.m_orderBy;
    }

    @Override
    public IGroupBy getGroupBy() {
        return this.m_groupBy;
    }

    @Override
    public IWhere getWhere() {
        return this.m_where;
    }

    @Override
    public IHaving getHaving() {
        return this.m_having;
    }

    @Override
    public ISourceTable getDeletedSourceTable(ITable table) {
        List lDeletedObjects = this.getDeletedObjects();
        for (int i = 0; i < lDeletedObjects.size(); ++i) {
            ISourceTable source;
            IObject object = (IObject)lDeletedObjects.get(i);
            if (!(object instanceof ISourceTable) || (source = (ISourceTable)object).getAliasedTable() != table) continue;
            this.removeFromDeletedObjects(source);
            return source;
        }
        return null;
    }

    @Override
    public void addToQueryDeletedObjects(IPersistableObject obj) {
        this.addToDeletedObjects(obj);
    }

    @Override
    public void removeFromQueryDeletedObjects(IPersistableObject obj) {
        this.removeFromDeletedObjects(obj);
    }

    @Override
    public void setSaveSelectResults(boolean bSaveSelectResults) {
        this.m_bSaveSelectResults = bSaveSelectResults;
    }

    @Override
    public boolean isSaveSelectResults() {
        return this.m_bSaveSelectResults;
    }

    @Override
    public List getFragmentedSourceObjects() {
        int i;
        ArrayList<ISQLSource> lObjects = new ArrayList<ISQLSource>();
        for (i = 0; i < this.getQuerySourceTableCount(); ++i) {
            ISourceTable source = this.getQuerySourceTables()[i];
            if (source.getParent() != null) continue;
            lObjects.add(source);
        }
        for (i = 0; i < this.m_lInlineSubqueries.size(); ++i) {
            ISubquery subquery = (ISubquery)this.m_lInlineSubqueries.get(i);
            if (subquery.getParent() != null) continue;
            lObjects.add(subquery);
        }
        if (this.m_sourceOfFrom != null) {
            List lJoins = this.m_sourceOfFrom.getAllJoins();
            for (int i2 = 0; i2 < this.m_lJoinObjects.size(); ++i2) {
                IJoin join = (IJoin)this.m_lJoinObjects.get(i2);
                if (lJoins.contains(join)) continue;
                lObjects.add(join);
            }
        }
        return lObjects;
    }

    @Override
    public ISourceTable[] getQueryOnlySourceTables() {
        ArrayList<ISourceTable> lObjects = new ArrayList<ISourceTable>();
        for (int i = 0; i < this.getQuerySourceTableCount(); ++i) {
            ISourceTable source = this.getQuerySourceTables()[i];
            if (source.getParent() == null) continue;
            lObjects.add(source);
        }
        return lObjects.toArray(new ISourceTable[lObjects.size()]);
    }

    @Override
    public void setControlDataSourceModelEvents(boolean isFlag) {
        this.m_bControlSourceEvents = isFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromTransformModel(ISQLSource source) {
        if (this.m_transformModel == null) {
            return;
        }
        if (!this.verifySQLSourceIsInMainQueryPath(source)) {
            return;
        }
        ISourceTable[] alSources = this.getAllSourceTables(source);
        for (int i = 0; i < alSources.length; ++i) {
            ISourceTable srcTable = alSources[i];
            ITable table = srcTable.getAliasedTable();
            ISourceTable[] aSourceTables = this.findInSourceTables(table, this.m_transformModel.getAllQuerySourceTables());
            ArrayList<ISourceTable> lMainSourceTables = new ArrayList<ISourceTable>();
            for (int iSrcTbl = 0; iSrcTbl < aSourceTables.length; ++iSrcTbl) {
                if (aSourceTables[iSrcTbl].getParent() == null) continue;
                lMainSourceTables.add(aSourceTables[iSrcTbl]);
            }
            if (lMainSourceTables.size() != 1 || table instanceof IWorkTable || this.m_transformModel.getConnectedSources().contains(table)) continue;
            ModelList lDataSources = (ModelList)this.m_transformModel.getDataSourceList();
            lDataSources.setEventsEnabled(this.m_bControlSourceEvents);
            try {
                this.m_transformModel.removeDataSource(table);
                continue;
            }
            finally {
                lDataSources.setEventsEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToTransformModel(ISQLSource source) {
        if (this.m_transformModel == null) {
            return;
        }
        if (!this.verifySQLSourceIsInMainQueryPath(source)) {
            return;
        }
        ISourceTable[] alSources = this.getAllSourceTables(source);
        for (int i = 0; i < alSources.length; ++i) {
            ISourceTable srcTable = alSources[i];
            ITable table = srcTable.getAliasedTable();
            ISourceTable[] alSourceTables = this.findQuerySourceTables(table);
            if (table == null || alSourceTables.length != 1 && this.m_transformModel.containsInDataSources(table)) continue;
            ModelList lDataSources = (ModelList)this.m_transformModel.getDataSourceList();
            lDataSources.setEventsEnabled(this.m_bControlSourceEvents);
            try {
                if (!lDataSources.contains(table)) {
                    this.m_transformModel.addDataSource(table);
                }
                this.propagateAndMapColumns(table);
                continue;
            }
            finally {
                lDataSources.setEventsEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        if (oldTable == null) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.replaceSourceMappings(oldTable, newTable);
            IColumn[] oldColumns = oldTable.getColumns();
            IColumn[] newColumns = null;
            if (newTable != null) {
                newColumns = newTable.getColumns();
            }
            for (int i = 0; i < oldColumns.length; ++i) {
                boolean isFound = false;
                IColumn oldColumn = oldColumns[i];
                IColumn newColumn = null;
                if (newColumns == null) {
                    this.replaceColumn(oldColumn, null);
                    continue;
                }
                boolean bCaseSensitive = false;
                if (this.m_transformModel != null) {
                    bCaseSensitive = this.m_transformModel.isQuotingNeeded();
                }
                bCaseSensitive = bCaseSensitive || newTable.isQuoted();
                for (int j = 0; j < newColumns.length; ++j) {
                    newColumn = newColumns[j];
                    if (!newColumn.equalsName(oldColumn, bCaseSensitive)) continue;
                    isFound = true;
                    this.replaceColumn(oldColumn, newColumn);
                    break;
                }
                if (isFound) continue;
                this.replaceColumn(oldColumn, null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceSourceMappings(ITable oldTable, ITable newTable) {
        this.startCompoundUndoable();
        try {
            int iMap;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.m_selectResults.getMappings();
            ArrayList<IMapping> lOldTableMappings = new ArrayList<IMapping>();
            block3: for (int iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                IMapping mapping = aMappings[iMap2];
                IColumn[] aColumns = mapping.getSources();
                for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                    lOldTableMappings.add(mapping);
                    continue block3;
                }
            }
            boolean bCaseSensitive = false;
            if (this.m_transformModel != null) {
                bCaseSensitive = this.m_transformModel.isQuotingNeeded();
            }
            bCaseSensitive = bCaseSensitive || newTable.isQuoted();
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < lOldTableMappings.size(); ++iMap) {
                IMapping mapping = (IMapping)lOldTableMappings.get(iMap);
                IColumn[] aColumns = mapping.getSources();
                block6: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn = aNewColumns[iNewColumn];
                        if (!column.equalsName(newColumn, bCaseSensitive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                        mapping.replaceSourceColumn(column, newColumn);
                        lChangedMappings.add(mapping);
                        continue block6;
                    }
                }
            }
            for (iMap = 0; iMap < lOldTableMappings.size(); ++iMap) {
                IMapping mapping = (IMapping)lOldTableMappings.get(iMap);
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.m_selectResults.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        IExpression expression;
        IMapping[] aMappings = this.m_selectResults.getMappings();
        boolean bSelectContainsColumn = false;
        for (int index = 0; !(index >= aMappings.length || aMappings[index].getType().equalsIgnoreCase("DERIVED") && (expression = aMappings[index].getExpression()) != null && (bSelectContainsColumn = expression.containsRememberedColumn(column))); ++index) {
        }
        boolean bOrdByContainsColumn = false;
        if (this.m_orderBy != null) {
            bOrdByContainsColumn = this.m_orderBy.containsRememberedColumn(column);
        }
        boolean bGrpByContainsColumn = false;
        if (this.m_groupBy != null) {
            bGrpByContainsColumn = this.m_groupBy.containsRememberedColumn(column);
        }
        boolean bWhereContainsColumn = false;
        if (this.m_where != null) {
            bWhereContainsColumn = this.m_where.containsRememberedColumn(column);
        }
        boolean bHavingContainsColumn = false;
        if (this.m_having != null) {
            bHavingContainsColumn = this.m_having.containsRememberedColumn(column);
        }
        boolean bFromContainsColumn = false;
        if (this.m_sourceOfFrom != null) {
            bFromContainsColumn = this.m_sourceOfFrom.containsRememberedColumn(column);
        }
        return bSelectContainsColumn || bOrdByContainsColumn || bGrpByContainsColumn || bWhereContainsColumn || bHavingContainsColumn || bFromContainsColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.m_selectResults.getMappings();
            for (int index = 0; index < aMappings.length; ++index) {
                if (oldColumn == null) {
                    IExpression expression = aMappings[index].getExpression();
                    if (expression == null) continue;
                    expression.replaceColumn(null, newColumn);
                    if (!expression.containsColumn(newColumn)) continue;
                    aMappings[index].addSource(newColumn);
                    continue;
                }
                if (!aMappings[index].containsInSources(oldColumn)) continue;
                if (newColumn == null) {
                    aMappings[index].removeSource(oldColumn);
                    continue;
                }
                aMappings[index].replaceSourceColumn(oldColumn, newColumn);
            }
            if (this.m_orderBy != null) {
                this.m_orderBy.replaceSortColumn(oldColumn, newColumn);
            }
            if (this.m_groupBy != null) {
                this.m_groupBy.replaceSortColumn(oldColumn, newColumn);
            }
            if (this.m_where != null) {
                this.m_where.replaceColumn(oldColumn, newColumn);
            }
            if (this.m_having != null) {
                this.m_having.replaceColumn(oldColumn, newColumn);
            }
            if (this.m_sourceOfFrom != null) {
                this.m_sourceOfFrom.replaceColumn(oldColumn, newColumn);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setLastChangeNodeId(String sNodeId) {
        this.m_sLastChangeNodeId = sNodeId;
    }

    @Override
    public String getLastChangeNodeId() {
        return this.m_sLastChangeNodeId;
    }

    protected boolean verifySQLSourceIsInMainQueryPath(ISQLSource source) {
        if (this.m_sourceOfFrom != null) {
            List lJoins;
            IClause parent = source.getParent();
            if (parent == null) {
                return false;
            }
            if (parent instanceof IJoin && !(lJoins = this.m_sourceOfFrom.getAllJoins()).contains(parent)) {
                return false;
            }
        }
        return true;
    }

    protected ISourceTable[] getAllSourceTables(ISQLSource source) {
        ArrayList<ISQLSource> lSourceTables = new ArrayList<ISQLSource>();
        if (source instanceof IJoin) {
            ISourceTable[] alSourceTables = source.getSQLSourceTables();
            lSourceTables.addAll(Arrays.asList(alSourceTables));
        } else if (source instanceof ISourceTable) {
            lSourceTables.add(source);
        } else if (source instanceof ISubquery) {
            ISubquery subquery = (ISubquery)source;
            lSourceTables.addAll(subquery.getQuerySourceTableList());
            List lSubqueries = subquery.getSubqueryList();
            for (int i = 0; i < lSubqueries.size(); ++i) {
                ISubquery subquery2 = (ISubquery)lSubqueries.get(i);
                lSourceTables.addAll(subquery2.getQuerySourceTableList());
            }
        }
        return lSourceTables.toArray(new ISourceTable[lSourceTables.size()]);
    }

    @Override
    public List getAllSourceTables() {
        ArrayList tables = new ArrayList();
        tables.addAll(this.m_lSourceTables);
        tables.addAll(this.m_lSubquerySources);
        return tables;
    }

    protected void propagateAndMapColumns(ITable table) {
        IJob job;
        if (this.m_bIsLoading) {
            return;
        }
        if (this.m_transformModel != null && (job = this.m_transformModel.getJob()) != null) {
            if (job.isPropagatingAutomatically() && this.m_transformModel.isIncludedInPropagation()) {
                if (this instanceof Subquery) {
                    boolean bFoundExistingMaps = false;
                    ISourceTable[] aSources = this.findQuerySourceTables(table);
                    for (int iSource = 0; iSource < aSources.length; ++iSource) {
                        IMapping[] aMappings = this.m_selectResults.getMappings();
                        block1: for (int iMap = 0; iMap < aMappings.length; ++iMap) {
                            IMapping mapping = aMappings[iMap];
                            IColumn[] aColumns = mapping.getSources();
                            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                                IColumn column = aColumns[iColumn];
                                if (Arrays.asList(aSources[iSource].getColumns()).indexOf(column) <= -1) continue;
                                bFoundExistingMaps = true;
                                continue block1;
                            }
                        }
                    }
                    if (!bFoundExistingMaps && !(this.getTargetTable() instanceof ISubqueryTargetTable)) {
                        this.m_selectResults.propagateColumnsToTargetTable(table.getColumns(), this.getTargetTable());
                    }
                } else if (job.getAutomaticPropagationDirection() == 0) {
                    ((DesignTimeJobModel)job.getModel()).propagateFromBeginningToEnd(table, this.m_transformModel);
                } else {
                    ((DesignTimeJobModel)job.getModel()).propagateFromEndToBeginning(table, this.m_transformModel);
                }
            }
            if (job.isMappingAutomatically() && this.m_transformModel.isIncludedInMapping()) {
                this.m_selectResults.mapColumns();
            }
        }
    }

    @Override
    public List getPortDescriptions() {
        boolean iName = false;
        boolean iObject = true;
        int iContainer = 2;
        int iJoinSide = 3;
        ArrayList lObjects = new ArrayList();
        if (this.getSourceOfFrom() != null) {
            lObjects.addAll(this.getSourceOfFrom().getPortDescriptions());
        } else {
            ArrayList<Object> lPortObjects = new ArrayList<Object>();
            lPortObjects.add(0, RB.getStringResource("BaseSQLPort.DefaultPortName.txt"));
            lPortObjects.add(1, null);
            lPortObjects.add(2, this);
            lPortObjects.add(3, "");
            lObjects.add(lPortObjects);
        }
        ArrayList lSubqueries = new ArrayList();
        lSubqueries.addAll(this.getSelectResults().getSubqueryList());
        if (this.getWhere() != null) {
            lSubqueries.addAll(this.getWhere().getSubqueryList());
        }
        if (this.getHaving() != null) {
            lSubqueries.addAll(this.getHaving().getSubqueryList());
        }
        for (int i = 0; i < lSubqueries.size(); ++i) {
            lObjects.addAll(((ISQLSource)lSubqueries.get(i)).getPortDescriptions());
        }
        return lObjects;
    }

    @Override
    public boolean hasImplicitJoin() {
        if (this.m_sourceOfFrom != null) {
            if (this.m_sourceOfFrom instanceof ISubquery) {
                return false;
            }
            return this.m_sourceOfFrom.hasImplicitJoin();
        }
        return false;
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean isPassThru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        CodeGenerationEnvironment environment = new CodeGenerationEnvironment(currentServer);
        ICodeSegment codeSegment = environment.createNewCodeSegment(this);
        if (this.m_selectResults != null) {
            this.m_selectResults.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_sourceOfFrom != null) {
            codeSegment.addSourceCode("from\n").indent();
            this.m_sourceOfFrom.getGeneratedCode(codeSegment, isPassThru);
            codeSegment.unIndent();
            codeSegment.addSourceCode("\n");
        }
        if (this.m_where != null) {
            this.m_where.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_having != null) {
            this.m_having.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.getGeneratedCode(codeSegment, isPassThru);
        }
        return codeSegment.getGeneratedCode().toString();
    }

    protected ICodeSegment getGeneratedQuery(ICodeSegment parentSegment, boolean isPassThru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        if (this.m_selectResults != null) {
            this.m_selectResults.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_sourceOfFrom != null) {
            codeSegment.addSourceCode("from\n").indent();
            this.m_sourceOfFrom.getGeneratedCode(codeSegment, isPassThru);
            codeSegment.unIndent();
            codeSegment.addSourceCode("\n");
        }
        if (this.m_where != null) {
            this.m_where.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_having != null) {
            this.m_having.getGeneratedCode(codeSegment, isPassThru);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.getGeneratedCode(codeSegment, isPassThru);
        }
        return codeSegment;
    }

    @Override
    public StringBuffer getTargetTableOptions() {
        boolean isTargetPassthru = this.getTransformModel().isTargetPassThru();
        StringBuffer tableOptions = new StringBuffer();
        ITable targetTable = this.getTargetTable();
        if (targetTable instanceof IPhysicalTable && !isTargetPassthru) {
            String bulkloadOpts;
            String allTableOptions;
            if (this.m_targetTableOption != null && (allTableOptions = this.m_targetTableOption.getTableOptions(null)) != null && allTableOptions.length() > 0) {
                tableOptions.append(allTableOptions).append("\n");
            }
            if (this.isUploadUsingBulkload()) {
                tableOptions.append("bulkload = yes\n");
            }
            if ((bulkloadOpts = this.getBulkloadOptions()) != null && bulkloadOpts.length() > 0) {
                tableOptions.append("bl_options = ").append(bulkloadOpts).append("\n");
            }
        }
        return tableOptions;
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean isPassThru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable sourceTable;
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        ISQLTransform transform = this.getTransformModel();
        boolean isTargetPassThru = transform.isTargetPassThru();
        IDBMSType dbmsType = transform.getDBMSType();
        IPhysicalTable iPhysicalTable = sourceTable = transform.getDataSourcesCount() > 0 ? (IPhysicalTable)transform.getSourceTables()[0] : null;
        if (sourceTable != null && isPassThru && !isTargetPassThru) {
            dbmsType.genBeginSelectAllFromConnect(codeSegment, sourceTable, this.getSelectResultsForPassthru(codeSegment));
        }
        this.getGeneratedQuery(parentSegment, isPassThru);
        if (isPassThru && sourceTable != null && !isTargetPassThru) {
            codeSegment.unIndent();
            dbmsType.genEndSelectAllFromConnect(codeSegment, sourceTable);
        }
        return codeSegment;
    }

    public StringBuffer getSelectResultsForPassthru(ICodeSegment codeSegment) {
        StringBuffer code = new StringBuffer();
        IColumn[] tableColumns = this.m_targetTable.getColumns();
        for (int i = 0; i < tableColumns.length; ++i) {
            IColumn tColumn = tableColumns[i];
            String columnName = tColumn.getColumnName(codeSegment);
            code.append(columnName);
            char[] indent = new char[columnName.length() + 1];
            Arrays.fill(indent, ' ');
            code.append(" length = ").append(tColumn.getLength());
            String format = tColumn.getFormat();
            String informat = tColumn.getInformat();
            String desc = tColumn.getDescription();
            if (format.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("format = ").append(format);
            }
            if (informat.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("informat = ").append(informat);
            }
            if (desc.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append(tColumn.getLabelStatement());
            }
            if (i == tableColumns.length - 1) continue;
            code.append(",\n");
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJoin createAJoin(ISQLSource left, ISQLSource right, String type) {
        this.startCompoundUndoable();
        try {
            IJoin join = this.getModel().getObjectFactory().createNewSQLJoin(this.getID());
            this.addJoin(join);
            join.setJoinType(type);
            join.setLeftSide(left);
            join.setRightSide(right);
            IJoin iJoin = join;
            return iJoin;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSourceTableAndAddToFromClause(ITable table) {
        this.startCompoundUndoable();
        try {
            ISourceTable qSource = this.addQuerySourceTable(table);
            ISQLSource from = this.getSourceOfFrom();
            if (from == null) {
                this.setSourceOfFrom(qSource);
            } else if (from instanceof ISourceTable || from instanceof ISubquery) {
                IJoin join = this.createAJoin(from, qSource, "Inner");
                this.setSourceOfFrom(join);
            } else if (from instanceof IJoin) {
                IJoin fromJoin = (IJoin)from;
                if (fromJoin.getLeftSide() == null) {
                    fromJoin.setLeftSide(qSource);
                    return;
                }
                if (fromJoin.getRightSide() == null) {
                    fromJoin.setRightSide(qSource);
                    return;
                }
                IJoin join = this.createAJoin(fromJoin, qSource, "Inner");
                this.setSourceOfFrom(join);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addJoin(IJoin join) {
        this.startCompoundUndoable();
        try {
            join.setParentQuery(this);
            this.addClause(join);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJoin createAndInsertAJoinInFrom(String type, ISQLSource source) {
        this.startCompoundUndoable();
        try {
            IJoin join = this.createAJoin(null, null, type);
            this.insertAJoinInFrom(source, join);
            IJoin iJoin = join;
            return iJoin;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAJoinInFrom(ISQLSource source, IJoin join) {
        this.startCompoundUndoable();
        try {
            this.m_bIsInserting = true;
            if (source == this.getSourceOfFrom()) {
                this.setSourceOfFrom(join);
                if (source != null) {
                    join.setLeftSide(source);
                }
            } else {
                IClause parent = source.getParent();
                if (parent instanceof IJoin) {
                    IJoin joinParent = (IJoin)parent;
                    if (joinParent.getLeftSide() == source) {
                        joinParent.setLeftSide(join);
                    } else {
                        joinParent.setRightSide(join);
                    }
                }
            }
            if (source != null && join.getLeftSide() == null) {
                join.setLeftSide(source);
            }
        }
        finally {
            this.m_bIsInserting = false;
            this.endCompoundUndoable();
        }
    }

    @Override
    public ISQLSource[] getObjectsInFromWithOpenPorts() {
        if (this.m_sourceOfFrom == null) {
            return new ISQLSource[0];
        }
        return this.m_sourceOfFrom.getObjectsWithOpenPorts();
    }

    @Override
    public ITable[] getSourcesInFrom() {
        if (this.m_sourceOfFrom != null) {
            return this.m_sourceOfFrom.getInputTables();
        }
        return new ITable[0];
    }

    @Override
    public IQuery[] getSubqueriesInFrom() {
        if (this.m_sourceOfFrom == null) {
            return new IQuery[0];
        }
        if (this.m_sourceOfFrom instanceof IQuery) {
            return new IQuery[]{(IQuery)((Object)this.m_sourceOfFrom)};
        }
        return this.m_sourceOfFrom.getSQLSourceSubqueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceInFrom(ISQLSource oldSource, ISQLSource newSource) {
        this.startCompoundUndoable();
        try {
            IClause parent;
            if (oldSource == newSource) {
                return;
            }
            if (oldSource != null && oldSource instanceof IClause) {
                if (oldSource instanceof IJoin) {
                    ((IJoin)oldSource).setRole("Join");
                } else {
                    ((ISubquery)oldSource).setRole("SUBQUERY");
                }
            }
            if (newSource != null) {
                newSource.setParent(null);
            }
            IClause iClause = parent = oldSource != null ? oldSource.getParent() : this;
            if (oldSource == this.getSourceOfFrom()) {
                this.setSourceOfFrom(newSource);
                if (newSource == null && oldSource instanceof IClause) {
                    this.removeClause((IClause)((Object)oldSource));
                }
            } else if (parent instanceof IJoin) {
                IJoin join = (IJoin)parent;
                if (join.getRightSide() == oldSource) {
                    join.setRightSide(newSource);
                } else if (join.getLeftSide() == oldSource) {
                    join.setLeftSide(newSource);
                }
            }
            oldSource.setParent(null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setSourceOfFrom(ISQLSource source) {
        if (this.m_sourceOfFrom == null ? source == null : this.m_sourceOfFrom.equals(source)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_sourceOfFrom != null) {
                this.disconnectFromTransformModel(this.m_sourceOfFrom);
                this.m_bNoResetSourceOfFrom = true;
                this.m_sourceOfFrom.setParent(null);
                if (this.m_sourceOfFrom instanceof IJoin) {
                    ((IJoin)this.m_sourceOfFrom).setRole("Join");
                }
            }
            if (source instanceof ISourceTable && !this.m_lSourceTables.contains(source)) {
                this.addQuerySourceTable((ISourceTable)source);
            }
            this.setSourceOfFromImpl(source);
            if (this.m_sourceOfFrom != null) {
                this.m_bNoResetSourceOfFrom = true;
                this.m_sourceOfFrom.setParent(this);
                this.connectToTransformModel(this.m_sourceOfFrom);
                if (this.m_sourceOfFrom instanceof IJoin) {
                    ((IJoin)this.m_sourceOfFrom).setRole("StartJoin");
                }
            }
            this.fireNotifyEvent(10, null);
        }
        finally {
            this.m_bNoResetSourceOfFrom = false;
            this.endCompoundUndoable();
        }
    }

    private void setSourceOfFromImpl(ISQLSource source) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceOfFromUndoable(this.m_sourceOfFrom, source));
        }
        this.m_sourceOfFrom = source;
        this.fireModelChangedEvent("SQLFrom:SourceOfFromChanged", source);
    }

    @Override
    public ISQLSource getSourceOfFrom() {
        return this.m_sourceOfFrom;
    }

    @Override
    public ISubquery createNewInlineSubquery() {
        this.startCompoundUndoable();
        try {
            ISubquery subquery = this.getModel().getObjectFactory().createNewSQLSubquery(this.getID());
            this.addInlineSubquery(subquery);
            ISubquery iSubquery = subquery;
            return iSubquery;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public List getInlineSubqueryList() {
        return this.m_lInlineSubqueries;
    }

    @Override
    public void addInlineSubquery(ISubquery subquery) {
        this.startCompoundUndoable();
        try {
            subquery.setTransformModel(this.m_transformModel);
            subquery.setRole("SUBQUERY");
            this.m_lInlineSubqueries.add(subquery);
            this.addClause(subquery);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeInlineSubquery(ISubquery subquery) {
        this.startCompoundUndoable();
        try {
            this.removeClause(subquery);
            this.m_lInlineSubqueries.remove(subquery);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setUploadUsingBulkload(boolean bBulkload) {
        if (this.m_bUploadUsingBulkload == bBulkload) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUploadUsingBulkloadUndoable(this.m_bUploadUsingBulkload, bBulkload));
        }
        this.m_bUploadUsingBulkload = bBulkload;
        this.fireModelChangedEvent("SQLTargetTable:BulkloadChanged", null);
    }

    @Override
    public boolean isUploadUsingBulkload() {
        return this.m_bUploadUsingBulkload;
    }

    @Override
    public void setBulkloadOptions(String sOptions) {
        if (this.m_sBulkloadOptions.equalsIgnoreCase(sOptions)) {
            return;
        }
        if (sOptions == null) {
            sOptions = "";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBulkloadOptionsUndoable(this.m_sBulkloadOptions, sOptions));
        }
        this.m_sBulkloadOptions = sOptions;
        this.fireModelChangedEvent("SQLTargetTable:BulkloadOptionsChanged", null);
    }

    @Override
    public String getBulkloadOptions() {
        return this.m_sBulkloadOptions;
    }

    @Override
    public void setUseDistinct(boolean useDistinct) {
        if (this.m_bUseDistinct == useDistinct) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseDistinctUndoable(this.m_bUseDistinct, useDistinct));
        }
        this.m_bUseDistinct = useDistinct;
        this.fireModelChangedEvent("SelectResults:UseDistinctChanged", null);
    }

    @Override
    public boolean useDistinct() {
        return this.m_bUseDistinct;
    }

    @Override
    public void setUseImplicit(boolean useImplicit) {
        if (this.m_bUseImplicit == useImplicit) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseImplicitUndoable(this.m_bUseImplicit, useImplicit));
        }
        this.m_bUseImplicit = useImplicit;
        this.fireModelChangedEvent("SelectResults:UseImplicitChanged", null);
    }

    @Override
    public boolean useImplicit() {
        return this.m_bUseImplicit;
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        if (this.m_bIsInserting || this.m_bRemovingInputPort) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_sourceOfFrom == source && !this.m_bNoResetSourceOfFrom) {
                this.setSourceOfFrom(null);
            }
            if (this.m_selectResults != null) {
                if (source instanceof ISourceTable) {
                    this.m_selectResults.removeSourceTableFromMappings((ITable)((Object)source));
                } else if (source instanceof ISubquery && this.m_lInlineSubqueries.contains(source)) {
                    this.m_selectResults.removeSourceTableFromMappings(((ISubquery)source).getTargetTable());
                    this.m_selectResults.removeSourceTableFromMappings(((ISubquery)source).getAliasTable());
                }
            }
            source.setParent(null);
            if (this.m_where != null) {
                this.m_where.removeSQLSource(source);
            }
            if (this.m_having != null) {
                this.m_having.removeSQLSource(source);
            }
            if (this.m_orderBy != null) {
                this.m_orderBy.removeSQLSource(source);
            }
            if (this.m_groupBy != null) {
                this.m_groupBy.removeSQLSource(source);
            }
        }
        finally {
            this.m_bRemovingInputPort = false;
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setRemovingInputPort(boolean bRemoving) {
        this.m_bRemovingInputPort = bRemoving;
    }

    @Override
    public void addSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        if (this.m_bIsInserting) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_selectResults != null) {
                this.m_selectResults.addSQLSource(source);
            }
            if (this.m_where != null) {
                this.m_where.addSQLSource(source);
            }
            if (this.m_having != null) {
                this.m_having.addSQLSource(source);
            }
            if (this.m_orderBy != null) {
                this.m_orderBy.addSQLSource(source);
            }
            if (this.m_groupBy != null) {
                this.m_groupBy.addSQLSource(source);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setParentQuery(IQuery query) {
    }

    @Override
    public IQuery getParentQuery() {
        return this;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.FROM;
    }

    @Override
    public void setTransformModel(ISQLTransform model) {
        this.m_transformModel = model;
    }

    @Override
    public ISQLTransform getTransformModel() {
        return this.m_transformModel;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isWhereComplete() && this.isHavingComplete() && this.isOrderByComplete() && this.isGroupByComplete() && this.isFromComplete();
    }

    protected boolean isFromComplete() {
        if (this.m_sourceOfFrom == null) {
            return false;
        }
        if (this.m_sourceOfFrom.hasOpenPorts()) {
            return false;
        }
        return this.m_sourceOfFrom.isComplete();
    }

    protected boolean isSelectResultsComplete() {
        if (this.m_selectResults == null) {
            return true;
        }
        return this.m_selectResults.isComplete();
    }

    protected boolean isWhereComplete() {
        if (this.m_where == null) {
            return true;
        }
        return this.m_where.isComplete();
    }

    protected boolean isHavingComplete() {
        if (this.m_having == null) {
            return true;
        }
        return this.m_having.isComplete();
    }

    protected boolean isOrderByComplete() {
        if (this.m_orderBy == null) {
            return true;
        }
        return this.m_orderBy.isComplete();
    }

    protected boolean isGroupByComplete() {
        if (this.m_groupBy == null) {
            return true;
        }
        return this.m_groupBy.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isFromComplete()) {
            if (this.m_sourceOfFrom != null) {
                if (this.m_sourceOfFrom.hasOpenPorts()) {
                    lReasons.add(RB.getStringResource("BaseQuery.ReasonIncomplete.FromOpenPorts.txt"));
                }
                lReasons.addAll(this.m_sourceOfFrom.getReasonsIncomplete());
            } else {
                lReasons.add(RB.getStringResource("BaseQuery.ReasonIncomplete.FromOpenPorts.txt"));
            }
        }
        if (!this.isWhereComplete()) {
            lReasons.add(RB.getStringResource("BaseQuery.ReasonIncomplete.WhereIncomplete.txt"));
            lReasons.addAll(this.m_where.getReasonsIncomplete());
        }
        if (!this.isGroupByComplete()) {
            lReasons.addAll(this.m_groupBy.getReasonsIncomplete());
        }
        if (!this.isHavingComplete()) {
            lReasons.add(RB.getStringResource("BaseQuery.ReasonIncomplete.HavingIncomplet.txt"));
            lReasons.addAll(this.m_having.getReasonsIncomplete());
        }
        if (!this.isOrderByComplete()) {
            lReasons.addAll(this.m_orderBy.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_sourceOfFrom != null && this.m_sourceOfFrom.isChanged() || this.m_where != null && this.m_where.isChanged() || this.m_having != null && this.m_having.isChanged() || this.m_orderBy != null && this.m_orderBy.isChanged() || this.m_groupBy != null && this.m_groupBy.isChanged();
    }

    @Override
    public String getOMRType() {
        return "Select";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        int i;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Select mdoSelect = (Select)omr.acquireOMRObject(this);
        mdoSelect.setTransformRole(QUERY_TRANSFORM_ROLE);
        AssociationList lTransSources = mdoSelect.getTransformationSources(false);
        lTransSources.clear();
        for (int iJoin = 0; iJoin < this.m_lJoinObjects.size(); ++iJoin) {
            ((IJoin)this.m_lJoinObjects.get(iJoin)).setRole("Join");
        }
        AssociationList lClsSources = mdoSelect.getClassifierSources(false);
        lClsSources.clear();
        for (int iSource = 0; iSource < this.m_lSourceTables.size(); ++iSource) {
            ISourceTable source = (ISourceTable)this.m_lSourceTables.get(iSource);
            source.saveToOMR(omr);
            QueryTable mdoQT = (QueryTable)omr.acquireOMRObject(source);
            lClsSources.add(mdoQT);
            lTransSources.add(source.getClassifierMapObject(omr));
        }
        for (i = 0; i < this.m_lInlineSubqueries.size(); ++i) {
            ISubquery subquery = (ISubquery)this.m_lInlineSubqueries.get(i);
            subquery.saveToOMR(omr);
            Select mdoSubquery = (Select)omr.acquireOMRObject(subquery);
            lTransSources.add(mdoSubquery);
        }
        if (this.m_sourceOfFrom != null) {
            if (this.m_sourceOfFrom instanceof IJoin) {
                ((IJoin)this.m_sourceOfFrom).setRole("StartJoin");
            } else if (this.m_sourceOfFrom instanceof ISubquery) {
                ((ISubquery)this.m_sourceOfFrom).setRole("InLineView");
            }
            this.m_sourceOfFrom.saveToOMR(omr);
        }
        for (i = 0; i < this.m_lJoinObjects.size(); ++i) {
            IJoin join = (IJoin)this.m_lJoinObjects.get(i);
            join.saveToOMR(omr);
            ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(join);
            lTransSources.add(mdoCM);
        }
        if (this.m_where != null) {
            this.m_where.saveToOMR(omr);
            ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this.m_where);
            lTransSources.add(mdoCM);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.saveToOMR(omr);
            GroupByClause mdoGB = (GroupByClause)omr.acquireOMRObject(this.m_groupBy);
            mdoSelect.setGroupByForSelect(mdoGB);
        }
        if (this.m_having != null) {
            this.m_having.saveToOMR(omr);
            ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this.m_having);
            lTransSources.add(mdoCM);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.saveToOMR(omr);
            OrderByClause mdoOB = (OrderByClause)omr.acquireOMRObject(this.m_orderBy);
            mdoSelect.setOrderByForSelect(mdoOB);
        }
        this.saveQueryProperties(omr);
        this.saveSelectResults(omr, mdoSelect);
        this.setChanged(false);
    }

    protected void saveQueryProperties(OMRAdapter omr) throws MdException, RemoteException {
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_USE_BULKLOAD, this.isUploadUsingBulkload() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO);
        this.saveStringOptionToOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_BULKLOAD_OPTIONS, this.getBulkloadOptions());
        this.saveStringOptionToOMR(omr, PROPERTY_SET_NAME_SELECT, PROPERTY_NAME_DISTINCT, this.useDistinct() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO);
        this.saveStringOptionToOMR(omr, PROPERTY_SET_NAME_SELECT, PROPERTY_NAME_IMPLICIT, this.useImplicit() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO);
    }

    protected void saveSelectResults(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        AssociationList lTransSources = mdoSelect.getTransformationSources(false);
        if (this.m_selectResults != null) {
            ICaseStatement[] aCases = this.m_selectResults.getCaseStatements();
            for (int iCase = 0; iCase < aCases.length; ++iCase) {
                ICaseStatement oCase = aCases[iCase];
                oCase.saveToOMR(omr);
                lTransSources.addElement((Object)omr.acquireOMRObject(oCase));
            }
            ISubquery[] aSubqueries = this.m_selectResults.getSubqueries();
            for (int iSub = 0; iSub < aSubqueries.length; ++iSub) {
                ISubquery oSub = aSubqueries[iSub];
                lTransSources.add((Object)omr.acquireOMRObject(oSub));
            }
            if (this.isSaveSelectResults()) {
                AssociationList lFMs = mdoSelect.getFeatureMaps(false);
                lFMs.clear();
                IMapping[] aMappings = this.m_selectResults.getMappings();
                for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                    IMapping mapping = aMappings[iMapping];
                    IColumn[] aTargets = mapping.getTargets();
                    if (aTargets.length == 0) {
                        this.m_selectResults.removeMapping(mapping);
                        continue;
                    }
                    if (aTargets[0].getTable() != this.getTargetTable()) continue;
                    mapping.saveToOMR(omr);
                    Root mdoMapping = omr.acquireOMRObject(mapping);
                    lFMs.add(mdoMapping);
                }
                this.saveCustomListToOMR(omr, "ColumnsExcludedFromMapping", this.m_selectResults.getColumnsExcludedFromMapping());
                this.saveCustomListToOMR(omr, "ColumnsExcludedFromPropagation", this.m_selectResults.getColumnsExcludedFromPropagation());
            }
        }
    }

    @Override
    public boolean isLoading() {
        return this.m_bIsLoading;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        OrderByClause mdoOrderBy;
        GroupByClause mdoGroupBy;
        String role;
        String type;
        Root mdoObject;
        super.loadFromOMR(omr);
        this.m_bIsLoading = true;
        this.m_lSourceTables.clear();
        this.m_lInlineSubqueries.clear();
        this.m_lJoinObjects.clear();
        this.m_lSubquerySources.clear();
        Select mdoSelect = (Select)omr.acquireOMRObject(this);
        AssociationList lClsSources = mdoSelect.getClassifierSources();
        for (int iSources = 0; iSources < lClsSources.size(); ++iSources) {
            QueryTable mdoQueryTable = (QueryTable)lClsSources.get(iSources);
            IOMRPersistable object = omr.acquireObject((Root)mdoQueryTable);
            if (!(object instanceof ISourceTable)) {
                this.addToDeletedObjects((IPersistableObject)object);
                continue;
            }
            ISourceTable source = (ISourceTable)object;
            if (source.getAliasedTable() == null) {
                this.addToDeletedObjects((IPersistableObject)object);
                continue;
            }
            source.addNotifyListener(this);
            if (this.m_lSourceTables.contains(source)) continue;
            this.m_lSourceTables.add(source);
        }
        AssociationList lTransSources = mdoSelect.getTransformationSources();
        ArrayList<Root> otherTranSources = new ArrayList<Root>();
        if (!lTransSources.isEmpty()) {
            for (int i = 0; i < lTransSources.size(); ++i) {
                mdoObject = (Root)lTransSources.get(i);
                type = mdoObject.getCMetadataType();
                if (type.equals("Select")) {
                    QueryTable mdoTarget;
                    AssociationList lVariables;
                    AssociationList lClsTargets;
                    Select mdoSubquery;
                    AssociationList lTargetTrans;
                    role = ((Select)mdoObject).getTransformRole();
                    if (role.equalsIgnoreCase("InLineView")) {
                        ISubquery subquery = (ISubquery)this.getModel().getObject(mdoObject.getFQID());
                        if (subquery == null) {
                            subquery = (ISubquery)this.getModel().getObjectFactory().createObjectFromOMRObject(mdoObject);
                            subquery.setTransformModel(this.m_transformModel);
                            subquery.setParentQuery(this);
                            subquery.setParent(this);
                            subquery.loadFromOMR(omr);
                            subquery.addNotifyListener(this);
                        }
                        if (this.m_lInlineSubqueries.contains(subquery)) continue;
                        this.m_lInlineSubqueries.add(subquery);
                        continue;
                    }
                    if (!role.equalsIgnoreCase("SUBQUERY") || !(lTargetTrans = (mdoSubquery = (Select)mdoObject).getTargetTransformations()).isEmpty() || (lClsTargets = mdoSubquery.getClassifierTargets()).isEmpty() || !(lVariables = (mdoTarget = (QueryTable)lClsTargets.get(0)).getVariables()).isEmpty()) continue;
                    ISubquery subquery = (ISubquery)this.getModel().getObject(mdoSubquery.getFQID());
                    if (subquery == null) {
                        subquery = (ISubquery)this.getModel().getObjectFactory().createObjectFromOMRObject((Root)mdoSubquery);
                        subquery.setTransformModel(this.m_transformModel);
                        subquery.setParentQuery(this);
                        subquery.loadFromOMR(omr);
                        subquery.addNotifyListener(this);
                    }
                    if (this.m_lInlineSubqueries.contains(subquery)) continue;
                    this.m_lInlineSubqueries.add(subquery);
                    continue;
                }
                otherTranSources.add(mdoObject);
            }
        }
        for (int i = 0; i < otherTranSources.size(); ++i) {
            IJoin join;
            mdoObject = (Root)otherTranSources.get(i);
            type = mdoObject.getCMetadataType();
            if (!type.equals("ClassifierMap")) continue;
            role = ((ClassifierMap)mdoObject).getTransformRole();
            if (role.equalsIgnoreCase("StartJoin")) {
                join = (IJoin)this.getModel().getObject(mdoObject.getFQID());
                if (join == null) {
                    join = (IJoin)this.getModel().getObjectFactory().createObjectFromOMRObject(mdoObject);
                    join.setParentQuery(this);
                    join.setRole(role);
                    join.loadFromOMR(omr);
                    join.addNotifyListener(this);
                }
                if (!this.m_lJoinObjects.contains(join)) {
                    this.m_lJoinObjects.add(join);
                }
                if (this.m_sourceOfFrom == null) {
                    this.m_sourceOfFrom = join;
                    continue;
                }
                if (!(this.m_sourceOfFrom instanceof IJoin) || ((IJoin)this.m_sourceOfFrom).getLeftSide() != null && ((IJoin)this.m_sourceOfFrom).getRightSide() != null || join.getLeftSide() == null || join.getRightSide() == null) continue;
                this.m_sourceOfFrom = join;
                continue;
            }
            if (role.equals("Join")) {
                join = (IJoin)this.getModel().getObject(mdoObject.getFQID());
                if (join == null) {
                    join = (IJoin)this.getModel().getObjectFactory().createObjectFromOMRObject(mdoObject);
                    join.setParentQuery(this);
                    join.loadFromOMR(omr);
                    join.addNotifyListener(this);
                }
                if (this.m_lJoinObjects.contains(join)) continue;
                this.m_lJoinObjects.add(join);
                continue;
            }
            if (role.equalsIgnoreCase("Where")) {
                this.m_where = (IWhere)this.getModel().getObject(mdoObject.getFQID());
                if (this.m_where != null) continue;
                this.m_where = (IWhere)this.getModel().getObjectFactory().createObjectFromOMRObject(mdoObject);
                this.m_where.setParentQuery(this);
                this.m_where.loadFromOMR(omr);
                this.m_where.addNotifyListener(this);
                continue;
            }
            if (!role.equalsIgnoreCase("Having")) continue;
            this.m_having = (IHaving)this.getModel().getObject(mdoObject.getFQID());
            if (this.m_having != null) continue;
            this.m_having = (IHaving)this.getModel().getObjectFactory().createObjectFromOMRObject(mdoObject);
            this.m_having.setParentQuery(this);
            this.m_having.loadFromOMR(omr);
            this.m_having.addNotifyListener(this);
        }
        if (this.m_sourceOfFrom == null && this.m_lSourceTables.size() > 0) {
            this.m_sourceOfFrom = (ISQLSource)this.m_lSourceTables.get(0);
        }
        if (this.m_sourceOfFrom == null && this.m_lInlineSubqueries.size() == 1) {
            this.m_sourceOfFrom = (ISQLSource)this.m_lInlineSubqueries.get(0);
        }
        if (this.m_sourceOfFrom != null) {
            this.m_sourceOfFrom.setParent(this);
        }
        if ((mdoGroupBy = mdoSelect.getGroupByForSelect()) != null) {
            this.m_groupBy = (IGroupBy)this.getModel().getObject(mdoGroupBy.getFQID());
            if (this.m_groupBy == null) {
                this.m_groupBy = this.getModel().getObjectFactory().createSQLGroupBy(mdoGroupBy.getFQID());
                this.m_groupBy.setParentQuery(this);
                this.m_groupBy.loadFromOMR(omr);
                this.m_groupBy.addNotifyListener(this);
            }
        }
        if ((mdoOrderBy = mdoSelect.getOrderByForSelect()) != null) {
            this.m_orderBy = (IOrderBy)this.getModel().getObject(mdoOrderBy.getFQID());
            if (this.m_orderBy == null) {
                this.m_orderBy = this.getModel().getObjectFactory().createSQLOrderBy(mdoOrderBy.getFQID());
                this.m_orderBy.setParentQuery(this);
                this.m_orderBy.loadFromOMR(omr);
                this.m_orderBy.addNotifyListener(this);
            }
        }
        this.loadQueryProperties(omr);
        this.loadSelectResults(omr, mdoSelect);
        this.m_bIsLoading = false;
        this.setChanged(false);
    }

    protected void loadQueryProperties(OMRAdapter omr) throws MdException, RemoteException {
        this.setUploadUsingBulkload(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_USE_BULKLOAD, DEFAULT_VALUE_NO).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setBulkloadOptions(this.loadStringOptionFromOMR(omr, PROPERTY_SET_ROLE, PROPERTY_NAME_BULKLOAD_OPTIONS, ""));
        this.setUseDistinct(this.loadStringOptionFromOMR(omr, PROPERTY_SET_NAME_SELECT, PROPERTY_NAME_DISTINCT, DEFAULT_VALUE_NO).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setUseImplicit(this.loadStringOptionFromOMR(omr, PROPERTY_SET_NAME_SELECT, PROPERTY_NAME_IMPLICIT, DEFAULT_VALUE_NO).equalsIgnoreCase(DEFAULT_VALUE_YES));
    }

    protected void loadSelectResults(OMRAdapter omr, Select mdoSelect) throws MdException, RemoteException {
        if (this.m_selectResults == null) {
            this.m_selectResults = new SelectResultsContainer(this.createIDForNewObject(), this.getModel(), this);
            this.m_selectResults.addNotifyListener(this);
        }
        if (this.isSaveSelectResults()) {
            int iColumn;
            IPersistableObject[] aColumns = this.loadCustomListFromOMR(omr, "ColumnsExcludedFromMapping");
            for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_selectResults.getListOfColumnsExcludedFromMapping().add(aColumns[iColumn]);
            }
            aColumns = this.loadCustomListFromOMR(omr, "ColumnsExcludedFromPropagation");
            for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_selectResults.getListOfColumnsExcludedFromPropagation().add(aColumns[iColumn]);
            }
            AssociationList lFMs = mdoSelect.getFeatureMaps();
            for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
                FeatureMap mdoFM = (FeatureMap)lFMs.get(iFM);
                SQLMapping mapping = (SQLMapping)this.getModel().getObject(mdoFM.getFQID());
                if (mapping == null) {
                    mapping = (SQLMapping)this.getModel().getObjectFactory().createSQLMapping(mdoFM.getFQID(), this.m_selectResults);
                    mapping.loadFromOMR(omr);
                }
                mapping.setExpressionAllowed(true);
                if (mapping.isOrdinary()) {
                    mapping.setAutoType(true);
                }
                this.m_selectResults.addMapping(mapping);
            }
        }
    }

    @Override
    public void delete() {
        IPersistableObject object;
        int iObject;
        for (iObject = 0; iObject < this.m_lSourceTables.size(); ++iObject) {
            object = (IPersistableObject)this.m_lSourceTables.get(iObject);
            object.delete();
        }
        for (iObject = 0; iObject < this.m_lSubquerySources.size(); ++iObject) {
            object = (IPersistableObject)this.m_lSubquerySources.get(iObject);
            object.delete();
        }
        for (iObject = 0; iObject < this.m_lInlineSubqueries.size(); ++iObject) {
            object = (IPersistableObject)this.m_lInlineSubqueries.get(iObject);
            object.delete();
        }
        for (iObject = 0; iObject < this.m_lJoinObjects.size(); ++iObject) {
            object = (IPersistableObject)this.m_lJoinObjects.get(iObject);
            object.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        int i;
        if (this.isNew()) {
            return;
        }
        if (this.m_sourceOfFrom != null) {
            this.m_sourceOfFrom.deleteFromOMR(omr);
        }
        if (this.m_where != null) {
            this.m_where.deleteFromOMR(omr);
        }
        if (this.m_having != null) {
            this.m_having.deleteFromOMR(omr);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.deleteFromOMR(omr);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.deleteFromOMR(omr);
        }
        if (this.m_targetTable instanceof IAliasTable) {
            this.m_targetTable.deleteFromOMR(omr);
        }
        for (i = 0; i < this.m_lSourceTables.size(); ++i) {
            ((SourceTable)this.m_lSourceTables.get(i)).deleteFromOMR(omr);
        }
        for (i = 0; i < this.m_lSubquerySources.size(); ++i) {
            ((SourceTable)this.m_lSubquerySources.get(i)).deleteFromOMR(omr);
        }
        for (i = 0; i < this.m_lInlineSubqueries.size(); ++i) {
            ((Subquery)this.m_lInlineSubqueries.get(i)).deleteFromOMR(omr);
        }
        for (i = 0; i < this.m_lJoinObjects.size(); ++i) {
            ((Join)this.m_lJoinObjects.get(i)).deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("ClassifierSources");
            lAssociations.add("ClassifierTargets");
            lAssociations.add("TransformationSources");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("ClassifierSources");
            lAssociations.add("ClassifierTargets");
            lAssociations.add("TransformationSources");
        }
        return map;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        int index;
        super.updateIDs(mapIDs);
        for (index = 0; index < this.m_lJoinObjects.size(); ++index) {
            ((IJoin)this.m_lJoinObjects.get(index)).updateIDs(mapIDs);
        }
        for (index = 0; index < this.m_lSourceTables.size(); ++index) {
            ((ISourceTable)this.m_lSourceTables.get(index)).updateIDs(mapIDs);
        }
        if (this.m_where != null) {
            this.m_where.updateIDs(mapIDs);
        }
        if (this.m_having != null) {
            this.m_having.updateIDs(mapIDs);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.updateIDs(mapIDs);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.updateIDs(mapIDs);
        }
        for (index = 0; index < this.m_lInlineSubqueries.size(); ++index) {
            ((ISubquery)this.m_lInlineSubqueries.get(index)).updateIDs(mapIDs);
        }
        if (this.m_selectResults != null) {
            List lSubqueries = this.m_selectResults.getSubqueryList();
            for (int index2 = 0; index2 < lSubqueries.size(); ++index2) {
                ((ISubquery)lSubqueries.get(index2)).updateIDs(mapIDs);
            }
            List lCaseStats = this.m_selectResults.getCaseStatementList();
            for (int index3 = 0; index3 < lCaseStats.size(); ++index3) {
                ((ICaseStatement)lCaseStats.get(index3)).updateIDs(mapIDs);
            }
            IMapping[] maps = this.m_selectResults.getMappings();
            for (int i = 0; i < maps.length; ++i) {
                maps[i].updateIDs(mapIDs);
            }
        }
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    private class AddClauseUndoable
    extends AbstractUndoableEdit {
        private IClause m_clause;

        public AddClauseUndoable(IClause clause) {
            this.m_clause = clause;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.removeClause(this.m_clause);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.addClause(this.m_clause);
        }

        @Override
        public void die() {
            super.die();
            this.m_clause = null;
        }
    }

    private class RemoveClauseUndoable
    extends AbstractUndoableEdit {
        private IClause m_clause;

        public RemoveClauseUndoable(IClause clause) {
            this.m_clause = clause;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.addClause(this.m_clause);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.removeClause(this.m_clause);
        }

        @Override
        public void die() {
            super.die();
            this.m_clause = null;
        }
    }

    private class SetTargetTableUndoable
    extends AbstractUndoableEdit {
        private ITable m_oldTargetTable;
        private ITable m_newTargetTable;

        public SetTargetTableUndoable(ITable oldTargetTable, ITable newTargetTable) {
            this.m_oldTargetTable = oldTargetTable;
            this.m_newTargetTable = newTargetTable;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setTargetTable(this.m_oldTargetTable);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setTargetTable(this.m_newTargetTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newTargetTable = null;
            this.m_oldTargetTable = null;
        }
    }

    private class AddSourceTableUndoable
    extends AbstractUndoableEdit {
        private ISourceTable m_source;

        public AddSourceTableUndoable(ISourceTable source) {
            this.m_source = source;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.addToDeletedObjects(this.m_source);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.removeFromDeletedObjects(this.m_source);
        }

        @Override
        public void die() {
            super.die();
            this.m_source = null;
        }
    }

    private class RemoveSourceTableUndoable
    extends AbstractUndoableEdit {
        private ISourceTable m_source;

        public RemoveSourceTableUndoable(ISourceTable source) {
            this.m_source = source;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.removeFromDeletedObjects(this.m_source);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.addToDeletedObjects(this.m_source);
        }

        @Override
        public void die() {
            super.die();
            this.m_source = null;
        }
    }

    private class SetSourceOfFromUndoable
    extends AbstractUndoableEdit {
        private ISQLSource m_oldSourceOfFrom;
        private ISQLSource m_newSourceOfFrom;

        public SetSourceOfFromUndoable(ISQLSource oldSourceOfFrom, ISQLSource newSourceOfFrom) {
            this.m_oldSourceOfFrom = oldSourceOfFrom;
            this.m_newSourceOfFrom = newSourceOfFrom;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setSourceOfFromImpl(this.m_oldSourceOfFrom);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setSourceOfFromImpl(this.m_newSourceOfFrom);
        }

        @Override
        public void die() {
            super.die();
            this.m_newSourceOfFrom = null;
            this.m_oldSourceOfFrom = null;
        }
    }

    private class SetUploadUsingBulkloadUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUploadUsingBulkload;
        private boolean m_newUploadUsingBulkload;

        public SetUploadUsingBulkloadUndoable(boolean oldUploadUsingBulkload, boolean newUploadUsingBulkload) {
            this.m_oldUploadUsingBulkload = oldUploadUsingBulkload;
            this.m_newUploadUsingBulkload = newUploadUsingBulkload;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setUploadUsingBulkload(this.m_oldUploadUsingBulkload);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setUploadUsingBulkload(this.m_newUploadUsingBulkload);
        }
    }

    private class SetBulkloadOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldBulkloadOptions;
        private String m_newBulkloadOptions;

        public SetBulkloadOptionsUndoable(String oldBulkloadOptions, String newBulkloadOptions) {
            this.m_oldBulkloadOptions = oldBulkloadOptions;
            this.m_newBulkloadOptions = newBulkloadOptions;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setBulkloadOptions(this.m_oldBulkloadOptions);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setBulkloadOptions(this.m_newBulkloadOptions);
        }
    }

    private class SetUseDistinctUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUseDistinct;
        private boolean m_newUseDistinct;

        public SetUseDistinctUndoable(boolean oldUseDistinct, boolean newUseDistinct) {
            this.m_oldUseDistinct = oldUseDistinct;
            this.m_newUseDistinct = newUseDistinct;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setUseDistinct(this.m_oldUseDistinct);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setUseDistinct(this.m_newUseDistinct);
        }
    }

    private class SetUseImplicitUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUseImplicit;
        private boolean m_newUseImplicit;

        public SetUseImplicitUndoable(boolean oldUseImplicit, boolean newUseImplicit) {
            this.m_oldUseImplicit = oldUseImplicit;
            this.m_newUseImplicit = newUseImplicit;
        }

        @Override
        public void undo() {
            super.undo();
            BaseQuery.this.setUseImplicit(this.m_oldUseImplicit);
        }

        @Override
        public void redo() {
            super.redo();
            BaseQuery.this.setUseImplicit(this.m_newUseImplicit);
        }
    }
}

