/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.scd.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOHWQType;
import com.sas.etl.models.data.dbmstypes.SASIOIMPType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.data.dbmstypes.SASIOMGOType;
import com.sas.etl.models.data.dbmstypes.SASIOPIType;
import com.sas.etl.models.data.dbmstypes.SPARKType;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.AbstractLoaderTransform;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTables;
import com.sas.etl.models.job.transforms.scd.ISCDType1TransformModel;
import com.sas.etl.models.job.transforms.scd.impl.RB;
import com.sas.etl.models.job.transforms.scd.impl.SCDType1PortDescriptionModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TransformationStep;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SCDType1TransformModel
extends AbstractLoaderTransform
implements ISCDType1TransformModel {
    private static final String TRANSFORMATION_CLASS = "job.transforms.SCDType1TransformModel";
    private static final String TRANSFORMATION_ROLE = "job.transforms.SCDType1TransformModel";
    private static final String ARM_DISPLAY_NAME = "SCDType1";
    private static final String MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE = "SCDType1_FM";
    private static final String TARGET_TABLE = "TargetTable";
    private static final String XREF_TABLE = "XrefTable";
    private static final String MAX_KEY_LOOKUP = "MaxKeyLookupTable";
    private static final String SURROGATE_KEY = "SurrogateKey";
    private static final String MAX_KEY_GENERATION = "MaxKeyGeneration";
    private static final String SURROGATE_KEY_FMAP_NAME = "SCD1 Surrogate Key";
    private static final String SURROGATE_KEY_FMAP_DESC = "Feature map that contains the surrogate key column and expression.";
    private static final String SURROGATE_KEY_TRANSFORMROLE = "SCD1_SurrogateKey";
    private static final String MAXKEY_FMAP_NAME = "SCD1 Max Key Generator";
    private static final String MAXKEY_FMAP_DESC = "Feature map that contains the generated the max key column and expression.";
    private static final String MAXKEY_TRANSFORMROLE = "SCD1_MaxKeyGenerator";
    private static final String MAXKEY_UPDATE_PROPERTY_NAME = "MaxKeyUpdate";
    private static final String MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME = "NextKeyValue";
    private static final String HAS_SURROGATE_KEY_PROPERTY_NAME = "HasSurrogateKey";
    private static final String OPTIONS_TRUE = "YES";
    private static final String OPTIONS_FALSE = "NO";
    private static final int TARGET_PORT = 0;
    private static final int XREF_PORT = 1;
    private static final int CHANGED_RCDS_PORT = 2;
    private static final int NEW_RCDS_PORT = 3;
    private static final int MAX_KEY_LOOKUP_PORT = 4;
    private static final String DEFAULT_NEW_KEY_EXP = "sum(NewMaxKey, 1)";
    private static final String DEFAULT_LAST_UPDATE_EXP = "DATETIME()";
    private List<SCDType1PortDescriptionModel> m_lOutputPortDescriptions;
    private static final String TEMP_NEW_MAX_KEY = "NewMaxKey";
    private static final String MAX_KEY_MACRO = "etls_maxkey";
    private static final String WORK_XREF = "work.etls_xref";
    private CompareTables m_oCompareTable;
    private IPhysicalTable m_oXrefTable;
    private IPhysicalTable m_oTargetTable;
    private IPhysicalTable m_oMaxLookupTable;
    private IMapping m_oSurrogateKeyMap;
    private IMapping m_oMaxKeyMap;
    private IColumn m_oLastUpdateColumn;
    private String m_sLastUpdateExpression = "DATETIME()";
    private boolean m_bHasSurrogateKey = false;
    private boolean m_bGenerateMaxKeyCode = true;
    private boolean m_bUpdateMaxKeyValueInLookupTable = false;
    private boolean m_bNextKeyValueInGenKey = false;
    private boolean m_bReplacingSource;
    private boolean m_bReplacingTarget;
    private IUserWrittenCodeContainer m_maxKeyUserWrittenCodeContainer;
    protected static Map m_hTargetTableNames;
    protected static Map m_hTargetTablesTemp;

    public SCDType1TransformModel(String sid, IModel model) {
        super(sid, model);
        this.m_oCompareTable = new CompareTables(model.createIDForNewObject(this.getID()), model, this);
        this.m_oCompareTable.addNotifyListener(this);
        this.m_lOutputPortDescriptions = new ArrayList<SCDType1PortDescriptionModel>();
        this.addDefaultOutputPorts();
        if (this.isNew()) {
            this.m_oSurrogateKeyMap = this.createSurrogateKeyMap();
            this.m_oMaxKeyMap = this.createMaxKeyMap();
        }
        this.m_maxKeyUserWrittenCodeContainer = this.getModel().getObjectFactory().createUserWrittenHelper(this);
        this.m_maxKeyUserWrittenCodeContainer.setContainerOMRType("FeatureMap");
        this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
        this.m_maxKeyUserWrittenCodeContainer.createUserWrittenSourceCodeText();
    }

    private IMapping createSurrogateKeyMap() {
        IMapping map = this.createNewMapping();
        map.setType(SURROGATE_KEY_TRANSFORMROLE);
        map.setName(SURROGATE_KEY_FMAP_NAME);
        map.setDescription(SURROGATE_KEY_FMAP_DESC);
        map.setExpression(this.createDefaultNewKeyExpression());
        map.addNotifyListener(this);
        return map;
    }

    private IMapping createMaxKeyMap() {
        IMapping map = this.createNewMapping();
        map.setType(MAXKEY_TRANSFORMROLE);
        map.setName(MAXKEY_FMAP_NAME);
        map.setDescription(MAXKEY_FMAP_DESC);
        map.addNotifyListener(this);
        return map;
    }

    @Override
    protected IMapping createNewMapping() {
        IMapping map = this.getModel().getObjectFactory().createNewMapping(this.getID());
        map.addNotifyListener(this);
        return map;
    }

    @Override
    public ICompareTables getCompareTablesObject() {
        return this.m_oCompareTable;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_oCompareTable.isChanged() || this.m_maxKeyUserWrittenCodeContainer != null && this.m_maxKeyUserWrittenCodeContainer.isChanged();
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject source;
        block22: {
            IMapping map;
            block25: {
                ModelEvent event;
                block23: {
                    block24: {
                        if (ev.getType() == 1 && ev.getSource() == this.m_oCompareTable) {
                            this.fireModelChangedEvent("ITransform:TransformChanged", this.m_oCompareTable);
                        }
                        source = (IObject)ev.getSource();
                        if (ev.getType() != 1 || !(source instanceof IMapping) || (event = ev.getModelEvent()) == null) break block22;
                        map = (IMapping)source;
                        if (!event.getType().equals("Mapping:TargetColumnRemoved") && !event.getType().equals("Mapping:TargetColumnAdded")) break block23;
                        if (map.getType().equals("MatchKey")) break block24;
                        if (!map.getType().equals("CompareColumns")) break block23;
                    }
                    this.addColumnsToSpecialWorkTables();
                }
                if (!event.getType().equals("Mapping:SourceColumnAdded") && !event.getType().equals("Mapping:TargetColumnAdded")) break block22;
                if (!map.getType().equals("MatchKey")) break block25;
                if (map.getType().equals("CompareColumns")) break block22;
            }
            if (map.getSourceCount() > 0 && map.getTargetCount() > 0) {
                int i;
                IColumn srcColumn = map.getSources()[0];
                for (i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                    IMapping keyMap = this.m_oCompareTable.getMatchKeyMappings()[i];
                    if (keyMap.getSourceCount() <= 0 || keyMap.getSources()[0] != srcColumn || map.getTargetCount() <= 0) continue;
                    if (keyMap.getTargetCount() > 0 && keyMap.getTargets()[0] != map.getTargets()[0]) {
                        keyMap.clearTargets();
                        keyMap.addTarget(map.getTargets()[0]);
                        continue;
                    }
                    if (keyMap.getTargetCount() != 0) continue;
                    keyMap.addTarget(map.getTargets()[0]);
                }
                for (i = 0; i < this.m_oCompareTable.getCompareColumnsMappings().length; ++i) {
                    IMapping compMap = this.m_oCompareTable.getCompareColumnsMappings()[i];
                    if (compMap.getSourceCount() <= 0 || compMap.getSources()[0] != srcColumn || map.getTargetCount() <= 0) continue;
                    if (compMap.getTargetCount() > 0 && compMap.getTargets()[0] != map.getTargets()[0]) {
                        compMap.clearTargets();
                        compMap.addTarget(map.getTargets()[0]);
                        continue;
                    }
                    if (compMap.getTargetCount() != 0) continue;
                    compMap.addTarget(map.getTargets()[0]);
                }
            }
        }
        if (ev.getType() == 0) {
            IMapping map;
            if (source instanceof IColumn) {
                IColumn column = (IColumn)ev.getSource();
                if (this.m_oLastUpdateColumn == column) {
                    this.setLastUpdateColumn(null);
                }
            } else if (source instanceof IDataObject) {
                IDataObject dataObject = (IDataObject)source;
                if (this.m_oTargetTable == dataObject) {
                    this.setGenerateKeyColumn(null);
                    this.setMaxKeyColumn(null);
                    this.setLastUpdateColumn(null);
                }
            } else if (source instanceof IMapping && ((map = (IMapping)source).getType().equals("MatchKey") || map.getType().equals("CompareColumns")) && map.getTargetCount() > 0) {
                this.addColumnsToSpecialWorkTables();
            }
        }
        super.notify(ev);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.isUsingUserWrittenCode() || this.m_oCompareTable.isComplete() && this.areAdditionalTablesComplete() && this.isSurrogateKeyComplete() && this.areMappingAndMatchKeyMappingsInSync() && this.areMappingAndCompareMappingsInSync() && this.isValidAsTargetTable());
    }

    private boolean areMappingAndMatchKeyMappingsInSync() {
        for (int i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
            IMapping map;
            IMapping keyMap = this.m_oCompareTable.getMatchKeyMappings()[i];
            IColumn srcCol = null;
            IColumn tgtCol = null;
            if (keyMap.getSourceCount() > 0) {
                srcCol = keyMap.getSources()[0];
            }
            if (keyMap.getTargetCount() > 0) {
                tgtCol = keyMap.getTargets()[0];
            }
            if (srcCol == null || (map = this.findSourceMapping(srcCol)) == null || map.getTargetCount() <= 0 || tgtCol == map.getTargets()[0]) continue;
            return false;
        }
        return true;
    }

    protected final IMapping findSourceMapping(IColumn colSource) {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            IColumn[] aSources = mapping.getSources();
            if (aSources.length != 1 || aSources[0] != colSource) continue;
            return mapping;
        }
        return null;
    }

    private boolean areMappingAndCompareMappingsInSync() {
        for (int i = 0; i < this.m_oCompareTable.getCompareColumnsMappings().length; ++i) {
            IMapping map;
            IMapping keyMap = this.m_oCompareTable.getCompareColumnsMappings()[i];
            IColumn srcCol = null;
            IColumn tgtCol = null;
            if (keyMap.getSourceCount() > 0) {
                srcCol = keyMap.getSources()[0];
            }
            if (keyMap.getTargetCount() > 0) {
                tgtCol = keyMap.getTargets()[0];
            }
            if (srcCol == null || (map = this.findSourceMapping(srcCol)) == null || map.getTargetCount() <= 0 || tgtCol == map.getTargets()[0]) continue;
            return false;
        }
        return true;
    }

    private boolean areAdditionalTablesComplete() {
        if (this.m_oXrefTable == null) {
            return false;
        }
        if (this.m_oCompareTable.getChangedRcdsTable() == null) {
            return false;
        }
        return this.m_oCompareTable.getNewRcdsTable() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isUsingUserWrittenCode() && !this.m_oCompareTable.isComplete()) {
            lReasons.addAll(this.m_oCompareTable.getReasonsIncomplete());
        }
        if (!this.areAdditionalTablesComplete()) {
            if (this.m_oXrefTable == null) {
                lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.MissingXrefTable.txt"));
            }
            if (this.m_oCompareTable.getChangedRcdsTable() == null) {
                lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.MissingChangeTable.txt"));
            }
            if (this.m_oCompareTable.getNewRcdsTable() == null) {
                lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.MissingNewTable.txt"));
            }
        }
        if (this.getDataTarget() != null && !this.isValidAsTargetTable()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.InvalidTargetTableType.txt"));
        }
        if (!this.areMappingAndMatchKeyMappingsInSync()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.InvalidKeyMap.txt"));
        }
        if (!this.areMappingAndCompareMappingsInSync()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.InvalidCompareMap.txt"));
        }
        if (!this.isLoadTimeColumnValid()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.InvalidLoadTime.txt"));
        }
        if (!this.isLastUpdateColumnValid()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.InvalidLastUpdate.txt"));
        }
        if (!this.isSurrogateKeyComplete()) {
            lReasons.add(RB.getStringResource("SCDType1TransformModel.ReasonIncomplete.NoSurrogateKeyColumn.txt"));
        }
        return lReasons;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        if (this.getXrefColumnsWarning() != null && this.getXrefColumnsWarning().length() > 0) {
            return true;
        }
        if (this.getChangedRcdsColumnsWarning() != null && this.getChangedRcdsColumnsWarning().length() > 0) {
            return true;
        }
        return this.getNewRcdsColumnsWarning() != null && this.getNewRcdsColumnsWarning().length() > 0;
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        if (this.getXrefColumnsWarning() != null && this.getXrefColumnsWarning().length() > 0) {
            warnings.add(this.getXrefColumnsWarning());
        }
        if (this.getChangedRcdsColumnsWarning() != null && this.getChangedRcdsColumnsWarning().length() > 0) {
            warnings.add(this.getChangedRcdsColumnsWarning());
        }
        if (this.getNewRcdsColumnsWarning() != null && this.getNewRcdsColumnsWarning().length() > 0) {
            warnings.add(this.getNewRcdsColumnsWarning());
        }
        return warnings;
    }

    private String getXrefColumnsWarning() {
        if (this.m_oXrefTable != null) {
            List<String> columns = this.getRequiredXrefColumns();
            StringBuffer columnNames = new StringBuffer();
            for (int i = 0; i < columns.size(); ++i) {
                String sName = columns.get(i);
                IColumn column = this.getColumnWithMatchingName(sName, this.m_oXrefTable.getColumns());
                if (column != null) continue;
                if (columnNames.length() > 0) {
                    columnNames.append(", ");
                }
                columnNames.append(sName);
            }
            if (columnNames.length() > 0) {
                return MessageFormat.format(RB.getStringResource("SCDType1TransformModel.Warnings.MissingXrefColumns.txt"), columnNames.toString());
            }
            if (columns.size() < this.m_oXrefTable.getColumnCount()) {
                return RB.getStringResource("SCDType1TransformModel.Warnings.ExtraXrefColumns.txt");
            }
        }
        return null;
    }

    private String getChangedRcdsColumnsWarning() {
        IPhysicalTable chgdRcds;
        if (this.m_oCompareTable != null && (chgdRcds = this.m_oCompareTable.getChangedRcdsTable()) != null) {
            List<String> columns = this.getRequiredChangeRecordColumns();
            StringBuffer columnNames = new StringBuffer();
            for (int i = 0; i < columns.size(); ++i) {
                String sName = columns.get(i);
                IColumn column = this.getColumnWithMatchingName(sName, chgdRcds.getColumns());
                if (column != null) continue;
                if (columnNames.length() > 0) {
                    columnNames.append(", ");
                }
                columnNames.append(sName);
            }
            if (columnNames.length() > 0) {
                return MessageFormat.format(RB.getStringResource("SCDType1TransformModel.Warnings.MissingChangedColumns.txt"), columnNames.toString());
            }
            if (columns.size() < chgdRcds.getColumnCount()) {
                return RB.getStringResource("SCDType1TransformModel.Warnings.ExtraChangedColumns.txt");
            }
        }
        return null;
    }

    private String getNewRcdsColumnsWarning() {
        IPhysicalTable newRcds;
        if (this.m_oCompareTable != null && (newRcds = this.m_oCompareTable.getNewRcdsTable()) != null) {
            List<String> columns = this.getRequiredNewRecordColumns();
            StringBuffer columnNames = new StringBuffer();
            for (int i = 0; i < columns.size(); ++i) {
                String sName = columns.get(i);
                IColumn column = this.getColumnWithMatchingName(sName, newRcds.getColumns());
                if (column != null) continue;
                if (columnNames.length() > 0) {
                    columnNames.append(", ");
                }
                columnNames.append(sName);
            }
            if (columnNames.length() > 0) {
                return MessageFormat.format(RB.getStringResource("SCDType1TransformModel.Warnings.MissingNewColumns.txt"), columnNames.toString());
            }
            if (columns.size() < newRcds.getColumnCount()) {
                return RB.getStringResource("SCDType1TransformModel.Warnings.ExtraNewColumns.txt");
            }
        }
        return null;
    }

    private IColumn getColumnWithMatchingName(String columnName, IColumn[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equalsName(columnName, false)) continue;
            return columns[i];
        }
        return null;
    }

    private List<String> getRequiredXrefColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.m_oXrefTable != null) {
            IColumn col = this.getGenerateKeyColumn();
            if (col != null) {
                columns.add(col.getColumnName(false));
            }
            for (int i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                IMapping map = this.m_oCompareTable.getMatchKeyMappings()[i];
                if (map.getTargetCount() <= 0) continue;
                col = map.getTargets()[0];
                columns.add(col.getColumnName(false));
            }
            columns.add("compare_digest");
        }
        return columns;
    }

    private List<String> getRequiredChangeRecordColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.m_oCompareTable != null && this.m_oCompareTable.getChangedRcdsTable() != null) {
            int i;
            IColumn col = this.getGenerateKeyColumn();
            if (col != null) {
                columns.add(col.getColumnName(false));
            }
            for (i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                IColumn newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                IMapping map = this.m_oCompareTable.getMatchKeyMappings()[i];
                if (map.getTargetCount() <= 0) continue;
                col = map.getTargets()[0];
                columns.add(col.getColumnName(false));
            }
            for (i = 0; i < this.m_oCompareTable.getCompareColumnsMappings().length; ++i) {
                IMapping map = this.m_oCompareTable.getCompareColumnsMappings()[i];
                if (map.getTargetCount() <= 0) continue;
                col = map.getTargets()[0];
                columns.add(col.getColumnName(false));
            }
            if (this.m_oLastUpdateColumn != null) {
                columns.add(this.m_oLastUpdateColumn.getColumnName(false));
            }
            columns.add("compare_digest");
        }
        return columns;
    }

    private List<String> getRequiredNewRecordColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.m_oTargetTable != null) {
            for (int i = 0; i < this.m_oTargetTable.getColumnCount(); ++i) {
                columns.add(this.m_oTargetTable.getColumns()[i].getColumnName(false));
            }
        }
        columns.add("compare_digest");
        return columns;
    }

    @Override
    protected void postAddDataSource(IDataObject source) {
        super.postAddDataSource(source);
        this.setSourceTable((IPhysicalTable)source);
    }

    @Override
    protected void postRemoveDataSource(IDataObject source) {
        super.postRemoveDataSource(source);
        if (!this.m_bReplacingSource) {
            this.setSourceTable(null);
        }
    }

    private void setSourceTable(IPhysicalTable source) {
        IPhysicalTable oldSourceTable = this.m_oCompareTable.getSourceTable();
        this.m_oCompareTable.setSourceTable(source);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceTableUndoable(source, oldSourceTable));
        }
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        ArrayList<ITable> aTargets = new ArrayList<ITable>();
        for (int i = 0; i < aTargetTables.length; ++i) {
            if (aTargetTables[i] != this.m_oTargetTable) continue;
            aTargets.add(aTargetTables[i]);
        }
        if (aSourceTables.length > 0 && aTargets.size() > 0) {
            super.propagateColumnsToTargetTables(aSourceTables, aTargets.toArray(new ITable[aTargets.size()]), eNonWorkTableHandling);
        }
    }

    @Override
    public IColumn getLastUpdateColumn() {
        return this.m_oLastUpdateColumn;
    }

    @Override
    public void setLastUpdateColumn(IColumn column) {
        if (this.m_oLastUpdateColumn == column) {
            return;
        }
        if (!(column == null || this.m_oTargetTable == null || Arrays.asList(this.m_oTargetTable.getColumns()).contains(column) && column.getType() == 1)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLastUpdateColumnUndoable(this.m_oLastUpdateColumn, column));
            }
            if (column != null) {
                column.addNotifyListener(this);
            }
            if (this.m_oLastUpdateColumn != null) {
                this.m_oLastUpdateColumn.removeNotifyListener(this);
            }
            this.m_oLastUpdateColumn = column;
            this.fireModelChangedEvent("SCDType1TransformModel:LastUpdateColumnChanged", this.m_oLastUpdateColumn);
            if (this.m_oLastUpdateColumn != null) {
                this.addColumnsToChangeRecordsTable();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public String getLastUpdateExpression() {
        if (this.isUseLastUpdate() || this.isUseLoadTime()) {
            if (this.m_sLastUpdateExpression == null) {
                this.setLastUpdateExpression(DEFAULT_LAST_UPDATE_EXP);
            } else if (this.m_sLastUpdateExpression.trim().length() == 0) {
                this.setLastUpdateExpression(DEFAULT_LAST_UPDATE_EXP);
            }
        }
        return this.m_sLastUpdateExpression;
    }

    @Override
    public void setLastUpdateExpression(String sLastUpdateExpression) {
        if (this.m_sLastUpdateExpression.equals(sLastUpdateExpression)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLastUpdateExpressionUndoable(this.m_sLastUpdateExpression, sLastUpdateExpression));
        }
        this.m_sLastUpdateExpression = sLastUpdateExpression;
        this.fireModelChangedEvent("SCDType1TransformModel:LastUpdateExpressionChanged", this.m_sLastUpdateExpression);
    }

    protected boolean isLastUpdateColumnValid() {
        IColumn lastUpdate = this.getLastUpdateColumn();
        if (lastUpdate == null) {
            return true;
        }
        return super.isColumnValidForLoadTimeValue(lastUpdate);
    }

    private boolean isUseLastUpdate() {
        boolean use = false;
        if (this.isLastUpdateColumnValid() && this.getLastUpdateColumn() != null) {
            use = true;
        }
        return use;
    }

    @Override
    protected boolean isLoadTimeColumnValid() {
        IColumn loadTime = this.getLoadTimeColumn();
        if (loadTime == null) {
            return true;
        }
        return super.isLoadTimeColumnValid();
    }

    private boolean isUseLoadTime() {
        boolean use = false;
        if (this.isLoadTimeColumnValid() && this.getLoadTimeColumn() != null) {
            use = true;
        }
        return use;
    }

    public String getLoadTimeExpression() {
        return this.getLastUpdateExpression();
    }

    private boolean isSASWorkTable(ICodeSegment codeSegment, IPhysicalTable sasTable) throws BadLibraryDefinitionException {
        boolean temp = false;
        if (sasTable.getLibref(codeSegment.getCurrentServer()).equalsIgnoreCase("work")) {
            temp = true;
        }
        return temp;
    }

    @Override
    public boolean hasSurrogateKey() {
        return this.m_bHasSurrogateKey;
    }

    @Override
    public void setHasSurrogateKey(boolean bHasSurrogateKey) {
        if (this.m_bHasSurrogateKey == bHasSurrogateKey) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHasSurrogateKeyUndoable(this.m_bHasSurrogateKey, bHasSurrogateKey));
        }
        this.m_bHasSurrogateKey = bHasSurrogateKey;
        this.fireModelChangedEvent("SCDType1TransformModel:HasSurrgateKeyChanged", null);
    }

    private boolean isSurrogateKeyComplete() {
        if (this.m_bHasSurrogateKey) {
            return this.getGenerateKeyColumn() != null;
        }
        return true;
    }

    @Override
    public IColumn getGenerateKeyColumn() {
        if (this.m_oSurrogateKeyMap.getTargetCount() > 0) {
            return this.m_oSurrogateKeyMap.getTargets()[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGenerateKeyColumn(IColumn column) {
        IColumn oldKey = this.getGenerateKeyColumn();
        if (this.getGenerateKeyColumn() == column) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IColumn newKey;
            if (oldKey != null) {
                IColumn oldColumn;
                oldKey.removeNotifyListener(this);
                if (this.m_oXrefTable != null && this.m_oXrefTable instanceof IWorkTable && (oldColumn = this.m_oXrefTable.getColumnWithMatchingName(oldKey.getName())) != null) {
                    this.m_oXrefTable.removeColumn(oldColumn);
                }
            }
            this.m_oSurrogateKeyMap.clearTargets();
            if (column != null) {
                this.m_oSurrogateKeyMap.addTarget(column);
            }
            if ((newKey = this.getGenerateKeyColumn()) != null) {
                IColumn keyCol;
                if (oldKey == this.getMaxKeyColumn()) {
                    this.setMaxKeyColumn(newKey);
                }
                newKey.addNotifyListener(this);
                if (this.m_oXrefTable != null && this.m_oXrefTable instanceof IWorkTable && (keyCol = this.m_oXrefTable.getColumnWithMatchingName(newKey.getName())) == null) {
                    keyCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    newKey.copy(keyCol);
                    this.m_oXrefTable.addColumn(0, keyCol);
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetSurrogateKeyUndoable(oldKey, newKey));
            }
            this.fireModelChangedEvent("SCDType1TransformModel:SurrogateKeyChanged", newKey);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public ITextExpression createDefaultNewKeyExpression() {
        ITextExpression expression = this.getObjectFactory().createNewTextExpression(this.getID());
        expression.setText(DEFAULT_NEW_KEY_EXP, new IColumn[0]);
        return expression;
    }

    @Override
    public ITextExpression getNewGenerateKeyExpression() {
        return (ITextExpression)this.m_oSurrogateKeyMap.getExpression();
    }

    @Override
    public String getNewGenerateKeyExpressionText() {
        if (this.getNewGenerateKeyExpression() == null || this.m_oTargetTable == null) {
            return "";
        }
        try {
            return this.getNewGenerateKeyExpression().getText(null, this.m_oTargetTable.isQuoted());
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewGenerateKeyExpressionText(String text) {
        ITable[] targets = this.getTargetTables();
        if (this.m_oTargetTable == null || this.getNewGenerateKeyExpression() == null) {
            return;
        }
        this.startCompoundUndoable();
        try {
            String oldText = this.getNewGenerateKeyExpressionText();
            this.getNewGenerateKeyExpression().setText(text, targets[0].getColumns());
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetNewSurrogateKeyExpressionTextUndoable(oldText, this.getNewGenerateKeyExpressionText()));
            }
            this.fireModelChangedEvent("SCDType1TransformModel:NewSurrogateKeyExpressionTextChanged", this.getNewGenerateKeyExpressionText());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isGenerateMaxKeyCode() {
        return this.m_bGenerateMaxKeyCode;
    }

    @Override
    public void setGenerateMaxKeyCode(boolean bOption) {
        if (this.m_bGenerateMaxKeyCode == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGenerateMaxKeyCodeUndoable(this.m_bGenerateMaxKeyCode, bOption));
        }
        this.m_bGenerateMaxKeyCode = bOption;
        this.fireModelChangedEvent("SCDTransformModel:GenerateMaxKeyCodeChanged", null);
    }

    @Override
    public IColumn getMaxKeyColumn() {
        if (this.m_oMaxKeyMap.getTargetCount() > 0) {
            return this.m_oMaxKeyMap.getTargets()[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxKeyColumn(IColumn column) {
        IColumn oldMaxKey = this.getMaxKeyColumn();
        if (oldMaxKey == column) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (oldMaxKey != null && this.m_oMaxLookupTable != null) {
                this.setTargetTable(null, 4);
            }
            if (oldMaxKey != null) {
                oldMaxKey.removeNotifyListener(this);
            }
            this.m_oMaxKeyMap.clearTargets();
            if (column != null) {
                this.m_oMaxKeyMap.addTarget(column);
            } else if (this.getGenerateKeyColumn() != null) {
                this.m_oMaxKeyMap.addTarget(this.getGenerateKeyColumn());
            }
            if (this.getMaxKeyColumn() != null && this.getMaxKeyColumn() != this.getGenerateKeyColumn()) {
                this.getMaxKeyColumn().addNotifyListener(this);
                IPhysicalTable maxKeyTable = (IPhysicalTable)this.getMaxKeyColumn().getTable();
                if (maxKeyTable != null && maxKeyTable != this.m_oTargetTable) {
                    this.setTargetTable(maxKeyTable, 4);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public ITextExpression getMaxKeyRowSelectorExpression() {
        return (ITextExpression)this.m_oMaxKeyMap.getExpression();
    }

    @Override
    public void setMaxKeyRowSelectorExpression(ITextExpression expression) {
        if (this.getMaxKeyRowSelectorExpression() != null && this.getMaxKeyRowSelectorExpression().equals(expression)) {
            return;
        }
        this.getModel().startCompoundUndoable();
        try {
            this.m_oMaxKeyMap.setExpression(expression);
            if (this.getMaxKeyRowSelectorExpression() != null) {
                this.getMaxKeyRowSelectorExpression().setTextStoreRole(MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE);
            }
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    @Override
    public String getMaxKeyRowSelectorExpressionText() {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return null;
        }
        try {
            if (this.getMaxKeyRowSelectorExpression() != null) {
                return this.getMaxKeyRowSelectorExpression().getText(null, this.m_oMaxLookupTable != null ? this.m_oMaxLookupTable.isQuoted() : false);
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return "";
    }

    @Override
    public void setMaxKeyRowSelectorExpressionText(String text) {
        this.startCompoundUndoable();
        try {
            if (this.m_oMaxLookupTable == null) {
                return;
            }
            if (this.getMaxKeyRowSelectorExpression() == null) {
                ITextExpression expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                this.setMaxKeyRowSelectorExpression(expression);
            }
            this.getMaxKeyRowSelectorExpression().setText(text, this.m_oMaxLookupTable.getColumns());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isNextKeyValueInGenKey() {
        return this.m_bNextKeyValueInGenKey;
    }

    @Override
    public void setNextKeyValueInGenKey(boolean bOption) {
        if (this.m_bNextKeyValueInGenKey == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNextAvailableKeyUndoable(this.m_bNextKeyValueInGenKey, bOption));
        }
        this.m_bNextKeyValueInGenKey = bOption;
        this.fireModelChangedEvent("SCDTransformModel:NextKeyInGenKeyChanged", null);
    }

    @Override
    public boolean isUpdateTableWithMaxKey() {
        return this.m_bUpdateMaxKeyValueInLookupTable;
    }

    @Override
    public void setUpdateTableWithMaxKey(boolean bOption) {
        if (this.m_bUpdateMaxKeyValueInLookupTable == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxKeyValueInLookupTableUndoable(this.m_bUpdateMaxKeyValueInLookupTable, bOption));
        }
        this.m_bUpdateMaxKeyValueInLookupTable = bOption;
        this.fireModelChangedEvent("SCDTransformModel:UpdateTableWithMaxKeyChanged", null);
    }

    @Override
    public boolean isUseMaxKeyUserWrittenCode() {
        return this.m_maxKeyUserWrittenCodeContainer.isActive();
    }

    public boolean isValidAsTargetTable() {
        IPhysicalTable target = (IPhysicalTable)this.getDataTarget();
        boolean bValidTargetTypes = true;
        IDBMSType oDBMSType = target.getDBMSType();
        if (oDBMSType instanceof SASIOPIType || oDBMSType instanceof SASIOHWQType || oDBMSType instanceof SASHDATType || oDBMSType instanceof SASIOLAType || oDBMSType instanceof SASIOIMPType || oDBMSType instanceof HADOOPType || oDBMSType instanceof SPARKType || oDBMSType instanceof SASIOMGOType) {
            bValidTargetTypes = false;
        }
        return bValidTargetTypes;
    }

    public IDataObject getDataTarget() {
        if (this.getDataTargetsCount() > 0) {
            return this.getDataTargets()[0];
        }
        return null;
    }

    public void setUseMaxKeyUserWrittenExpression(String expression) {
        this.m_maxKeyUserWrittenCodeContainer.setUserWrittenCode(expression);
    }

    @Override
    public void setUseMaxKeyUserWrittenCode(boolean bOption) {
        this.startCompoundUndoable();
        try {
            this.m_maxKeyUserWrittenCodeContainer.setIsActive(bOption);
            if (!bOption) {
                this.m_maxKeyUserWrittenCodeContainer.setUserWrittenCode("");
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IUserWrittenCodeContainer getMaxKeyUserWrittenCode() {
        return this.m_maxKeyUserWrittenCodeContainer;
    }

    @Override
    public void setMaxKeyUserWrittenCode(ICodeSource code) {
        if (this.m_maxKeyUserWrittenCodeContainer != null) {
            this.m_maxKeyUserWrittenCodeContainer.setUserWrittenSourceCode(code);
        }
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.addNewWorkTable();
        this.addNewWorkTable();
    }

    private void addDefaultOutputPorts() {
        SCDType1PortDescriptionModel targetTable = new SCDType1PortDescriptionModel();
        targetTable.setName(RB.getStringResource("SCDType1TransformModel.OutputPortName.txt"));
        targetTable.setTooltipText(RB.getStringResource("SCDType1TransformModel.OutputPortText.txt"));
        this.m_lOutputPortDescriptions.add(targetTable);
        SCDType1PortDescriptionModel xrefTable = new SCDType1PortDescriptionModel();
        xrefTable.setName(RB.getStringResource("SCDType1TransformModel.XrefPortName.txt"));
        xrefTable.setTooltipText(RB.getStringResource("SCDType1TransformModel.XrefPOrtPortText.txt"));
        this.m_lOutputPortDescriptions.add(xrefTable);
        SCDType1PortDescriptionModel changedRecords = new SCDType1PortDescriptionModel();
        changedRecords.setName(RB.getStringResource("SCDType1TransformModel.ChangedRecordsPortName.txt"));
        changedRecords.setTooltipText(RB.getStringResource("SCDType1TransformModel.ChangedRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(changedRecords);
        SCDType1PortDescriptionModel newRecords = new SCDType1PortDescriptionModel();
        newRecords.setName(RB.getStringResource("SCDType1TransformModel.NewRecordsPortName.txt"));
        newRecords.setTooltipText(RB.getStringResource("SCDType1TransformModel.NewRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(newRecords);
        SCDType1PortDescriptionModel maxKeyLookup = new SCDType1PortDescriptionModel();
        maxKeyLookup.setName(RB.getStringResource("SCDType1TransformModel.MaxLookupPortName.txt"));
        maxKeyLookup.setTooltipText(RB.getStringResource("SCDType1TransformMdoel.MaxLookupPortText.txt"));
        this.m_lOutputPortDescriptions.add(maxKeyLookup);
    }

    @Override
    public void addDataTarget(IDataObject target) {
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    private void addDataTarget(SCDType1PortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() != target) {
            portDesc.setObject(target);
            this.addDataTargetImpl(target);
        }
    }

    private void addDataTargetImpl(IDataObject target) {
        if (!target.containsInProducerTransforms(this)) {
            target.addProducerTransform(this);
            target.addNotifyListener(this);
            if (target instanceof IWorkTable) {
                this.removeFromDeletedObjects(target);
                this.updateTargetLibrary((IWorkTable)target);
            }
            if (!this.getModel().isUndoing()) {
                this.postAddTransformTableOption(target, false);
            }
        }
    }

    @Override
    public IDataObject[] getDataTargets() {
        return this.getDataTargetList().toArray(new IDataObject[this.getDataTargetsCount()]);
    }

    @Override
    public List getDataTargetList() {
        ArrayList<IPhysicalTable> lDataTargets = new ArrayList<IPhysicalTable>();
        if (this.m_oTargetTable != null) {
            lDataTargets.add(this.m_oTargetTable);
        }
        if (this.m_oXrefTable != null) {
            lDataTargets.add(this.m_oXrefTable);
        }
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getChangedRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getChangedRcdsTable());
            }
            if (this.m_oCompareTable.getNewRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getNewRcdsTable());
            }
        }
        if (this.m_oMaxLookupTable != null) {
            lDataTargets.add(this.m_oMaxLookupTable);
        }
        return lDataTargets;
    }

    public List getWorkDataTargetList() {
        ArrayList<IPhysicalTable> lDataTargets = new ArrayList<IPhysicalTable>();
        if (this.m_oXrefTable != null && this.m_oXrefTable instanceof IWorkTable) {
            lDataTargets.add(this.m_oXrefTable);
        }
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getChangedRcdsTable() != null && this.m_oCompareTable.getChangedRcdsTable() instanceof IWorkTable) {
                lDataTargets.add(this.m_oCompareTable.getChangedRcdsTable());
            }
            if (this.m_oCompareTable.getNewRcdsTable() != null && this.m_oCompareTable.getNewRcdsTable() instanceof IWorkTable) {
                lDataTargets.add(this.m_oCompareTable.getNewRcdsTable());
            }
        }
        return lDataTargets;
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public IPhysicalTable getTargetTable() {
        return this.m_oTargetTable;
    }

    @Override
    public int getDataTargetsCount() {
        return this.getDataTargetList().size();
    }

    public int getWorkDataTargetsCount() {
        return this.getWorkDataTargetList().size();
    }

    private boolean isTargetAttachedToMultipleOutputPorts(IDataObject target) {
        if (target == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_oTargetTable == target) {
            ++iCount;
        }
        if (this.m_oXrefTable == target) {
            ++iCount;
        }
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getChangedRcdsTable() == target) {
                ++iCount;
            }
            if (this.m_oCompareTable.getNewRcdsTable() == target) {
                ++iCount;
            }
        }
        if (this.m_oMaxLookupTable == target) {
            ++iCount;
        }
        return iCount > 1;
    }

    @Override
    public void removeDataTarget(IDataObject target) {
    }

    private void removeDataTarget(SCDType1PortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() == target) {
            portDesc.setObject(null);
            this.removeDataTargetImpl(target);
            if (this.m_lOutputPortDescriptions.indexOf(portDesc) == 0 && !this.getModel().isUndoing()) {
                this.postRemoveDataTarget(target);
            }
        }
    }

    private void removeDataTargetImpl(IDataObject target) {
        if (target.containsInProducerTransforms(this) && !this.isTargetAttachedToMultipleOutputPorts(target)) {
            target.removeProducerTransform(this);
            target.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeTargetTableFromMappings((ITable)target);
                this.preRemoveTransformTableOptions(target, false);
            }
            if (target instanceof IWorkTable) {
                this.addToDeletedObjects(target);
            }
        }
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        for (int i = 1; i < this.m_lOutputPortDescriptions.size() - 1; ++i) {
            SCDType1PortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
            if (!portDesc.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDataTargetsAllowed() {
        int index = this.findFirstEmptyPort();
        return index > -1;
    }

    private int findFirstEmptyPort() {
        int port = -1;
        for (int i = 0; i < this.m_lOutputPortDescriptions.size(); ++i) {
            SCDType1PortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
            if (!portDesc.isEmpty()) continue;
            return i;
        }
        return port;
    }

    @Override
    public ITable[] getTargetTables() {
        ArrayList<IPhysicalTable> lDataTargets = new ArrayList<IPhysicalTable>();
        if (this.m_oTargetTable != null) {
            lDataTargets.add(this.m_oTargetTable);
        }
        return lDataTargets.toArray(new ITable[lDataTargets.size()]);
    }

    public IPhysicalTable getTargetTable(int portIndex) {
        if (portIndex == 0) {
            return this.m_oTargetTable;
        }
        if (portIndex == 1) {
            return this.m_oXrefTable;
        }
        if (portIndex == 2) {
            return this.m_oCompareTable.getChangedRcdsTable();
        }
        if (portIndex == 3) {
            return this.m_oCompareTable.getNewRcdsTable();
        }
        if (portIndex == 4) {
            return this.m_oMaxLookupTable;
        }
        return null;
    }

    public void setTargetTable(IPhysicalTable target) {
        for (int i = 0; i < this.m_lOutputPortDescriptions.size(); ++i) {
            SCDType1PortDescriptionModel portDesc;
            if (target instanceof IWorkTable && i == 0 || !(portDesc = this.m_lOutputPortDescriptions.get(i)).isEmpty()) continue;
            this.setTargetTable(target, i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetTable(IPhysicalTable target, int portIndex) {
        IPhysicalTable oldTarget = null;
        if (portIndex == 0) {
            oldTarget = this.m_oTargetTable;
        } else if (portIndex == 1) {
            oldTarget = this.m_oXrefTable;
        } else if (portIndex == 2) {
            oldTarget = this.m_oCompareTable.getChangedRcdsTable();
        } else if (portIndex == 3) {
            oldTarget = this.m_oCompareTable.getNewRcdsTable();
        } else if (portIndex == 4) {
            oldTarget = this.m_oMaxLookupTable;
        }
        if (oldTarget == null ? target == null : oldTarget.equals(target)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (portIndex == 0) {
                this.m_oTargetTable = target;
                this.setComparisonTable(target);
            } else if (portIndex == 1) {
                this.m_oXrefTable = target;
            } else if (portIndex == 2) {
                this.m_oCompareTable.setChangedRcdsTable(target);
            } else if (portIndex == 3) {
                this.m_oCompareTable.setNewRcdsTable(target);
            } else if (portIndex == 4) {
                this.m_oMaxLookupTable = target;
                if (this.m_oMaxLookupTable != null && !this.getJob().getDataObjectsList().contains(this.m_oMaxLookupTable)) {
                    this.getJob().getDataObjectsList().add(this.m_oMaxLookupTable);
                }
            }
            SCDType1PortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(portIndex);
            if (oldTarget != null) {
                this.removeDataTarget(portDesc, oldTarget);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldTarget, new Integer(portIndex + 1));
            }
            if (target != null) {
                this.addDataTarget(portDesc, (IDataObject)target);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", target, new Integer(portIndex + 1));
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTargetTableUndoable(target, oldTarget, portIndex));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setComparisonTable(IPhysicalTable target) {
        IPhysicalTable oldComparisonTable = this.m_oCompareTable.getComparisonTable();
        this.m_oCompareTable.setComparisonTable(target, this.m_bReplacingTarget);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComparisonTableUndoable(target, oldComparisonTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            int port = -1;
            for (int i = 1; i < this.m_lOutputPortDescriptions.size() - 1; ++i) {
                SCDType1PortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
                if (!portDesc.isEmpty()) continue;
                port = i;
                break;
            }
            if (port == -1) {
                IWorkTable i = null;
                return i;
            }
            IWorkTable tbl = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            this.setTargetTable(tbl);
            String name = tbl.getName();
            if (port == 1) {
                name = RB.getStringResource("SCDType1TransformModel.NewWorkTableXrefName.txt");
                this.addColumnsToXrefTable();
            } else if (port == 2) {
                name = RB.getStringResource("SCDType1TransformModel.NewWorkTableChangedName.txt");
                this.addColumnsToChangeRecordsTable();
            } else if (port == 3) {
                name = RB.getStringResource("SCDType1TransformModel.NewWorkTableNewName.txt");
                this.addColumnsNewRecordsTable();
            }
            tbl.setName(name);
            IWorkTable iWorkTable = tbl;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addColumnsToSpecialWorkTables() {
        this.startCompoundUndoable();
        try {
            this.addColumnsToXrefTable();
            this.addColumnsToChangeRecordsTable();
            this.addColumnsNewRecordsTable();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToXrefTable() {
        if (!this.isUndoSupported()) {
            return;
        }
        if (this.m_oXrefTable != null && this.m_oXrefTable instanceof IWorkTable) {
            this.startCompoundUndoable();
            try {
                for (int i = this.m_oXrefTable.getColumnCount() - 1; i >= 0; --i) {
                    this.m_oXrefTable.removeColumn(this.m_oXrefTable.getColumns()[i]);
                }
                IColumn col = this.getGenerateKeyColumn();
                if (col != null) {
                    IColumn newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    col.copy(newCol);
                    this.m_oXrefTable.addColumn(newCol);
                }
                for (int i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                    IColumn newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    IMapping map = this.m_oCompareTable.getMatchKeyMappings()[i];
                    if (map.getTargetCount() <= 0) continue;
                    col = map.getTargets()[0];
                    col.copy(newCol);
                    this.m_oXrefTable.addColumn(newCol);
                }
                this.m_oXrefTable.addColumn(this.createNewDigestColumn());
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToChangeRecordsTable() {
        if (!this.isUndoSupported()) {
            return;
        }
        if (this.m_oCompareTable != null && this.m_oCompareTable.getChangedRcdsTable() != null && this.m_oCompareTable.getChangedRcdsTable() instanceof IWorkTable) {
            this.startCompoundUndoable();
            try {
                IMapping map;
                IColumn newCol;
                int i;
                IPhysicalTable oChgRcds = this.m_oCompareTable.getChangedRcdsTable();
                for (int i2 = oChgRcds.getColumnCount() - 1; i2 >= 0; --i2) {
                    oChgRcds.removeColumn(oChgRcds.getColumns()[i2]);
                }
                IColumn col = this.getGenerateKeyColumn();
                if (col != null) {
                    IColumn newCol2 = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    col.copy(newCol2);
                    oChgRcds.addColumn(newCol2);
                }
                for (i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                    newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    map = this.m_oCompareTable.getMatchKeyMappings()[i];
                    if (map.getTargetCount() <= 0) continue;
                    col = map.getTargets()[0];
                    col.copy(newCol);
                    oChgRcds.addColumn(newCol);
                }
                for (i = 0; i < this.m_oCompareTable.getCompareColumnsMappings().length; ++i) {
                    newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    map = this.m_oCompareTable.getCompareColumnsMappings()[i];
                    if (map.getTargetCount() <= 0) continue;
                    col = map.getTargets()[0];
                    col.copy(newCol);
                    oChgRcds.addColumn(newCol);
                }
                if (this.m_oLastUpdateColumn != null) {
                    IColumn newCol3 = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    this.m_oLastUpdateColumn.copy(newCol3);
                    oChgRcds.addColumn(newCol3);
                }
                oChgRcds.addColumn(this.createNewDigestColumn());
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsNewRecordsTable() {
        IPhysicalTable oNewRcds;
        if (!this.isUndoSupported()) {
            return;
        }
        if (this.m_oCompareTable != null && (oNewRcds = this.m_oCompareTable.getNewRcdsTable()) != null && oNewRcds instanceof IWorkTable) {
            this.startCompoundUndoable();
            try {
                int i;
                for (i = oNewRcds.getColumnCount() - 1; i >= 0; --i) {
                    oNewRcds.removeColumn(oNewRcds.getColumns()[i]);
                }
                if (this.m_oTargetTable != null) {
                    for (i = 0; i < this.m_oTargetTable.getColumnCount(); ++i) {
                        IColumn newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                        this.m_oTargetTable.getColumns()[i].copy(newCol);
                        oNewRcds.addColumn(newCol);
                    }
                }
                oNewRcds.addColumn(this.createNewDigestColumn());
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    private IColumn createNewDigestColumn() {
        IColumn digestColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
        digestColumn.setName("compare_digest");
        digestColumn.setLength(32);
        digestColumn.setType(0);
        digestColumn.setInformat("$32.");
        digestColumn.setFormat("$32.");
        digestColumn.setNullable(true);
        return digestColumn;
    }

    public static String getTransformTypeID() {
        return "job.transforms.SCDType1TransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "job.transforms.SCDType1TransformModel";
    }

    @Override
    protected String getTransformRole() {
        return "job.transforms.SCDType1TransformModel";
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SCDType1TransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SCDType1TransformModel.Name.txt");
    }

    public SCDType1PortDescriptionModel[] getOutputPortDescriptions() {
        return this.m_lOutputPortDescriptions.toArray(new SCDType1PortDescriptionModel[this.m_lOutputPortDescriptions.size()]);
    }

    public List<SCDType1PortDescriptionModel> getOutputPortDescriptionList() {
        return this.m_lOutputPortDescriptions;
    }

    public int[] findInTargetPorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lOutputPortDescriptions.size(); ++iPort) {
            SCDType1PortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(iPort);
            IObject targetTable = portDesc.getObject();
            if (targetTable != table) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return 5;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        if (!this.m_oCompareTable.isChanged()) {
            this.m_oCompareTable.setChanged(true);
        }
        TransformationStep step = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lCustAssoc = step.getCustomAssociations(false);
        lCustAssoc.clear();
        super.saveToOMR(omr);
        if (this.m_oTargetTable != null) {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[]{this.m_oTargetTable});
        } else {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oXrefTable != null) {
            this.saveCustomListToOMR(omr, XREF_TABLE, new IPhysicalTable[]{this.m_oXrefTable});
        } else {
            this.saveCustomListToOMR(omr, XREF_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oMaxLookupTable != null) {
            this.saveCustomListToOMR(omr, MAX_KEY_LOOKUP, new IPhysicalTable[]{this.m_oMaxLookupTable});
        } else {
            this.saveCustomListToOMR(omr, MAX_KEY_LOOKUP, new IPhysicalTable[0]);
        }
        if (this.m_oSurrogateKeyMap != null) {
            this.m_oSurrogateKeyMap.saveToOMR(omr);
            this.saveCustomListToOMR(omr, SURROGATE_KEY, new IMapping[]{this.m_oSurrogateKeyMap});
        } else {
            this.saveCustomListToOMR(omr, SURROGATE_KEY, new IMapping[0]);
        }
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.saveToOMR(omr);
        }
        if (this.isUseMaxKeyUserWrittenCode()) {
            FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this.m_oMaxKeyMap);
            this.m_maxKeyUserWrittenCodeContainer.setName(this.m_oMaxKeyMap.getName());
            this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
            this.m_maxKeyUserWrittenCodeContainer.setContainerRole(MAXKEY_TRANSFORMROLE);
            this.m_maxKeyUserWrittenCodeContainer.saveToOMR(omr);
        }
        this.m_oMaxKeyMap.saveToOMR(omr);
        ((AbstractPersistableObject)((Object)this.m_oMaxKeyMap)).saveBooleanOptionToOMR(omr, MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME, this.m_bNextKeyValueInGenKey);
        ((AbstractPersistableObject)((Object)this.m_oMaxKeyMap)).saveBooleanOptionToOMR(omr, MAXKEY_UPDATE_PROPERTY_NAME, this.m_bUpdateMaxKeyValueInLookupTable);
        if (this.m_oMaxKeyMap != null) {
            this.saveCustomListToOMR(omr, MAX_KEY_GENERATION, new IMapping[]{this.m_oMaxKeyMap});
        } else {
            this.saveCustomListToOMR(omr, MAX_KEY_GENERATION, new IMapping[0]);
        }
        this.saveBooleanOptionToOMR(omr, HAS_SURROGATE_KEY_PROPERTY_NAME, this.hasSurrogateKey());
        this.saveStringOptionToOMR(omr, "UpdateDateExpression", this.getLastUpdateExpression());
        if (this.m_oLastUpdateColumn != null) {
            IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray2;
            iPersistableObjectArray2[0] = this.m_oLastUpdateColumn;
        } else {
            iPersistableObjectArray = new IPersistableObject[]{};
        }
        this.saveObjectListPropertyToOMR(omr, "OPTIONS", "UpdateDateColumn", "UpdateDateColumn", "", iPersistableObjectArray, 2000, 2);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] aMaxKey;
        IPersistableObject[] aMaxKeyLookupTable;
        IPersistableObject[] aXrefTable;
        IPersistableObject[] aTargetTable = this.loadCustomListFromOMR(omr, TARGET_TABLE);
        if (aTargetTable.length > 0) {
            this.m_oTargetTable = (IPhysicalTable)aTargetTable[0];
        }
        if ((aXrefTable = this.loadCustomListFromOMR(omr, XREF_TABLE)).length > 0) {
            this.m_oXrefTable = (IPhysicalTable)aXrefTable[0];
        }
        if ((aMaxKeyLookupTable = this.loadCustomListFromOMR(omr, MAX_KEY_LOOKUP)).length > 0) {
            this.m_oMaxLookupTable = (IPhysicalTable)aMaxKeyLookupTable[0];
        }
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.loadFromOMR(omr);
            this.setComparisonTable(this.m_oTargetTable);
        }
        this.loadTablesIntoPorts();
        super.loadFromOMR(omr);
        IPersistableObject[] aSurrogateKey = this.loadCustomListFromOMR(omr, SURROGATE_KEY);
        if (aSurrogateKey.length > 0) {
            this.m_oSurrogateKeyMap = (IMapping)aSurrogateKey[0];
        }
        if ((aMaxKey = this.loadCustomListFromOMR(omr, MAX_KEY_GENERATION)).length > 0) {
            this.m_oMaxKeyMap = (IMapping)aMaxKey[0];
        }
        this.setGenerateMaxKeyCode(true);
        if (this.m_oMaxKeyMap != null) {
            ITextExpression maxKeyRowSelectorExpression;
            FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this.m_oMaxKeyMap);
            if (this.m_oMaxKeyMap.getTargetCount() == 0 && this.getGenerateKeyColumn() != null) {
                this.m_oMaxKeyMap.addTarget(this.getGenerateKeyColumn());
            }
            if ((maxKeyRowSelectorExpression = (ITextExpression)this.m_oMaxKeyMap.getExpression()) != null) {
                String sRole = maxKeyRowSelectorExpression.getTextStoreRole();
                if (sRole.equalsIgnoreCase(MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE)) {
                    this.setGenerateMaxKeyCode(true);
                } else {
                    this.setGenerateMaxKeyCode(false);
                    this.m_maxKeyUserWrittenCodeContainer.setTextRole(maxKeyRowSelectorExpression.getTextStoreRole());
                    this.m_maxKeyUserWrittenCodeContainer.setName(this.m_oMaxKeyMap.getName());
                    this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
                    this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
                    this.m_maxKeyUserWrittenCodeContainer.setContainerRole(MAXKEY_TRANSFORMROLE);
                    this.m_maxKeyUserWrittenCodeContainer.loadFromOMR(omr);
                }
            } else {
                Text mdoFile = mdoFM.getSourceCode();
                if (mdoFile != null && mdoFile.getCMetadataType().equalsIgnoreCase("File")) {
                    this.setGenerateMaxKeyCode(false);
                    this.m_oMaxKeyMap.setExpression(null);
                    IFile file = (IFile)omr.acquireObject((Root)mdoFile);
                    this.m_maxKeyUserWrittenCodeContainer.setName(file.getName());
                    this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
                    this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
                    this.m_maxKeyUserWrittenCodeContainer.setContainerRole(MAXKEY_TRANSFORMROLE);
                    this.m_maxKeyUserWrittenCodeContainer.loadFromOMR(omr);
                }
            }
            this.setNextKeyValueInGenKey(((AbstractPersistableObject)((Object)this.m_oMaxKeyMap)).loadBooleanOptionFromOMR(omr, MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME, true));
            this.setUpdateTableWithMaxKey(((AbstractPersistableObject)((Object)this.m_oMaxKeyMap)).loadBooleanOptionFromOMR(omr, MAXKEY_UPDATE_PROPERTY_NAME, true));
            this.setHasSurrogateKey(this.loadBooleanOptionFromOMR(omr, HAS_SURROGATE_KEY_PROPERTY_NAME, false));
            this.setLastUpdateExpression(this.loadStringOptionFromOMR(omr, "UpdateDateExpression", DEFAULT_LAST_UPDATE_EXP));
            IPersistableObject[] cols = this.loadObjectListPropertyFromOMR(omr, "OPTIONS", "UpdateDateColumn", 2);
            if (cols != null && cols.length > 0) {
                this.setLastUpdateColumn((IColumn)cols[0]);
            } else {
                this.setLastUpdateColumn(null);
            }
        }
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.setUseDataHashStep(this.loadBooleanOptionFromOMR(omr, "DataHash", true));
            this.m_oCompareTable.setHashInternalTableSize(this.loadIntOptionFromOMR(omr, "HashExp", 10));
            this.m_oCompareTable.setCompareToDigestColumn(this.loadBooleanOptionFromOMR(omr, "CompareDigest", false));
            this.m_oCompareTable.setChangeDigestVersion(this.loadStringOptionFromOMR(omr, "ChangeDigestVersion", "V2_1"));
        }
        this.setChanged(false);
    }

    private void loadTablesIntoPorts() {
        this.addDataTarget(this.m_lOutputPortDescriptions.get(0), (IDataObject)this.m_oTargetTable);
        this.addDataTarget(this.m_lOutputPortDescriptions.get(1), (IDataObject)this.m_oXrefTable);
        this.addDataTarget(this.m_lOutputPortDescriptions.get(4), (IDataObject)this.m_oMaxLookupTable);
        if (this.m_oCompareTable == null) {
            return;
        }
        this.addDataTarget(this.m_lOutputPortDescriptions.get(2), (IDataObject)this.m_oCompareTable.getChangedRcdsTable());
        this.addDataTarget(this.m_lOutputPortDescriptions.get(3), (IDataObject)this.m_oCompareTable.getNewRcdsTable());
    }

    @Override
    public void delete() {
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.removeNotifyListener(this);
            this.m_oCompareTable.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.deleteFromOMR(omr);
        }
        if (this.m_maxKeyUserWrittenCodeContainer != null) {
            this.m_maxKeyUserWrittenCodeContainer.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IColumn newColumn;
            int iNewColumn;
            boolean bFoundColumn;
            IColumn column;
            int iColumn;
            IColumn[] aColumns;
            IMapping mapping;
            int iMap;
            this.m_bReplacingSource = true;
            super.replaceSourceTable(oldTable, newTable, columnsMap);
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            IMapping[] aMappings = this.m_oCompareTable.getMatchKeyMappings();
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                aColumns = mapping.getSources();
                for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        continue;
                    }
                    if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                    bFoundColumn = false;
                    for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        newColumn = aNewColumns[iNewColumn];
                        if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                        mapping.replaceSourceColumn(column, newColumn);
                        bFoundColumn = true;
                        break;
                    }
                    if (bFoundColumn) continue;
                    this.m_oCompareTable.removeMatchKeyMapping(mapping);
                }
            }
            aMappings = this.m_oCompareTable.getCompareColumnsMappings();
            aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                aColumns = mapping.getSources();
                for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        continue;
                    }
                    if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                    bFoundColumn = false;
                    for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        newColumn = aNewColumns[iNewColumn];
                        if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                        mapping.replaceSourceColumn(column, newColumn);
                        bFoundColumn = true;
                        break;
                    }
                    if (bFoundColumn) continue;
                    this.m_oCompareTable.removeCompareColumnsMapping(mapping);
                }
            }
        }
        finally {
            this.m_bReplacingSource = false;
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            IColumn newColumn;
            int iCol;
            IMapping mapping;
            int iMap;
            this.m_bReplacingTarget = true;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.getTargetTableMapping(oldTable);
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                IColumn[] aColumns = mapping.getTargets();
                block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    if (Arrays.asList(oldTable.getColumns()).indexOf(column) == -1) continue;
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn2 = aNewColumns[iNewColumn];
                        if (!column.getName().equals(newColumn2.getName()) || column.getLength() < newColumn2.getLength() || column.getType() != newColumn2.getType()) continue;
                        mapping.replaceTargetColumn(column, newColumn2);
                        lChangedMappings.add(mapping);
                        continue block4;
                    }
                }
            }
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.removeMapping(mapping);
            }
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            for (int i = 0; i < portIndexes.length; ++i) {
                IColumn newColumn3;
                int iNewColumn;
                boolean bFoundColumn;
                IColumn column;
                int iColumn;
                IColumn[] aColumns;
                IMapping mapping2;
                int iMap2;
                int iPortIndex = portIndexes[i] - 1;
                if (iPortIndex != 0) continue;
                aMappings = this.m_oCompareTable.getCompareColumnsMappings();
                aNewColumns = newTable.getColumns();
                for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                    mapping2 = aMappings[iMap2];
                    aColumns = mapping2.getTargets();
                    for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping2.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        bFoundColumn = false;
                        for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            newColumn3 = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn3, bCaseSensitive) || column.getType() != newColumn3.getType()) continue;
                            mapping2.replaceTargetColumn(column, newColumn3);
                            bFoundColumn = true;
                            break;
                        }
                        if (bFoundColumn) continue;
                        mapping2.removeTarget(column);
                    }
                }
                aMappings = this.m_oCompareTable.getMatchKeyMappings();
                aNewColumns = newTable.getColumns();
                for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                    mapping2 = aMappings[iMap2];
                    aColumns = mapping2.getTargets();
                    for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping2.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        bFoundColumn = false;
                        for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            newColumn3 = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn3, bCaseSensitive) || column.getType() != newColumn3.getType()) continue;
                            mapping2.replaceTargetColumn(column, newColumn3);
                            bFoundColumn = true;
                            break;
                        }
                        if (bFoundColumn) continue;
                        mapping2.removeTarget(column);
                    }
                }
            }
            if (oldTable == this.m_oTargetTable) {
                IColumn oldSurrogateKey = this.getGenerateKeyColumn();
                IColumn[] newColumns = newTable.getColumns();
                for (iCol = 0; iCol < newColumns.length; ++iCol) {
                    newColumn = newColumns[iCol];
                    if (oldSurrogateKey == null || !newColumn.equalsName(oldSurrogateKey, bCaseSensitive) || newColumn.getType() != oldSurrogateKey.getType()) continue;
                    this.setGenerateKeyColumn(newColumn);
                }
                this.setTargetTable((IPhysicalTable)newTable, 0);
                this.addColumnsToSpecialWorkTables();
            } else if (oldTable == this.m_oXrefTable) {
                this.setTargetTable((IPhysicalTable)newTable, 1);
            } else if (oldTable == this.m_oCompareTable.getChangedRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 2);
            } else if (oldTable == this.m_oCompareTable.getNewRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 3);
            } else if (oldTable == this.m_oMaxLookupTable) {
                IColumn oldMaxKeyColumn = this.getMaxKeyColumn();
                IColumn[] newColumns = newTable.getColumns();
                for (iCol = 0; iCol < newColumns.length; ++iCol) {
                    newColumn = newColumns[iCol];
                    if (oldMaxKeyColumn == null || !newColumn.equalsName(oldMaxKeyColumn, bCaseSensitive) || newColumn.getType() != oldMaxKeyColumn.getType()) continue;
                    this.setMaxKeyColumn(newColumn);
                }
                this.setTargetTable((IPhysicalTable)newTable, 4);
            }
        }
        finally {
            this.m_bReplacingTarget = false;
            this.endCompoundUndoable();
        }
    }

    private IMapping[] getTargetTableMapping(ITable table) {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        IColumn[] aCols = table.getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IMapping mapping = this.getOrdinaryMappingsForTargetColumn(aCols[index]);
            if (mapping == null) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable sourceTable = this.m_oCompareTable.getSourceTable();
        IPhysicalTable targetTable = this.m_oTargetTable;
        IPhysicalTable m_oChangedRcdsTable = this.m_oCompareTable.getChangedRcdsTable();
        IPhysicalTable m_oNewRcdsTable = this.m_oCompareTable.getNewRcdsTable();
        codeSegment.addSourceCode("%macro etls_scd_type_1;").newLine(2);
        codeSegment.addSectionComment("Delete any pre-existing work tables");
        codeSegment.genTableDelete(WORK_XREF);
        codeSegment.genTableDelete(m_oChangedRcdsTable);
        codeSegment.genTableDelete(m_oNewRcdsTable);
        this.m_oTargetTable.genTableExist(codeSegment);
        this.m_oTargetTable.getDBMSType().create(codeSegment, this.m_oTargetTable, true, true, true, true, null, this);
        this.m_oXrefTable.genTableExist(codeSegment);
        this.m_oXrefTable.getDBMSType().create(codeSegment, this.m_oXrefTable, true, true, true, true, null, this);
        boolean bMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable);
        String sMappedSourceTableName = codeSegment.getUniqueWorkTableName(true, 0);
        if (bMappingNeeded) {
            this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, sMappedSourceTableName, sourceTable.getFullNameQuotedAsNeeded(codeSegment), "", "", true, false, false, null, null, false, "", null, null, false, false);
        }
        if (this.m_oCompareTable.useDataHashStep()) {
            this.generateWorkXrefTable(codeSegment, this.isSASWorkTable(codeSegment, this.m_oXrefTable), false);
        } else if (!this.m_oCompareTable.useDataHashStep()) {
            this.generateWorkXrefTable(codeSegment, this.isSASWorkTable(codeSegment, this.m_oXrefTable), true);
        }
        IColumn m_surrogateKeyColumn = this.getGenerateKeyColumn();
        IColumn m_maxKeyColumn = this.getMaxKeyColumn();
        String sGenChgKeyExpr = "";
        String sGenNewKeyExpr = "";
        if (this.hasSurrogateKey()) {
            if (this.isGenerateMaxKeyCode()) {
                if (m_maxKeyColumn != null) {
                    if (m_maxKeyColumn == m_surrogateKeyColumn) {
                        this.generateMaxKey(codeSegment, m_maxKeyColumn, this.getMaxKeyRowSelectorExpression(), this.isNextKeyValueInGenKey(), false);
                    } else if (m_maxKeyColumn != m_surrogateKeyColumn) {
                        if (this.m_oMaxLookupTable == this.m_oTargetTable) {
                            this.generateMaxKey(codeSegment, m_maxKeyColumn, null, false, false);
                        } else if (this.m_oMaxLookupTable != null && this.m_oMaxLookupTable != this.m_oTargetTable) {
                            this.m_oMaxLookupTable.genAccessPath(codeSegment, null);
                            this.generateMaxKey(codeSegment, m_maxKeyColumn, this.getMaxKeyRowSelectorExpression(), this.isNextKeyValueInGenKey(), false);
                        }
                    }
                }
            } else if (this.m_maxKeyUserWrittenCodeContainer != null && this.isUseMaxKeyUserWrittenCode()) {
                codeSegment.addCommentLine("start user written: generate maximum surrogate key").addSourceCode(this.m_maxKeyUserWrittenCodeContainer.getCode()).newLine().addCommentLine("end user written: generate maximum surrogate key");
                codeSegment.addCommentLine("reset maxkey value if required").addSourceCode("%if &maxkey ne %str() %then").newLine().indent().addSourceCode("%if &maxkey gt 0 %then").newLine().indent().addSourceCode("%let etls_maxkey = &maxkey;").newLine(2).unIndent(2);
            }
            sGenNewKeyExpr = this.getNewGenerateKeyExpression() != null ? this.getNewGenerateKeyExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting()) : DEFAULT_NEW_KEY_EXP;
        }
        if (this.m_oCompareTable.useDataHashStep()) {
            this.generateHashLookup(codeSegment, bMappingNeeded, sMappedSourceTableName);
        } else if (!this.m_oCompareTable.useDataHashStep()) {
            this.generateMergeLookup(codeSegment, bMappingNeeded, sMappedSourceTableName);
        }
        codeSegment.addCommentLine("changed records table - record check").genGetNumRows(m_oChangedRcdsTable.getFullNameQuotedAsNeeded(codeSegment), null, "etls_change_rows", false, "1").genRCSetCall("&syscc");
        codeSegment.addCommentLine("new records table - record check").genGetNumRows(m_oNewRcdsTable.getFullNameQuotedAsNeeded(codeSegment), null, "etls_new_rows", false, "1").genRCSetCall("&syscc");
        this.generateUpdateTargetTable(codeSegment);
        this.generateUpdateXrefTable(codeSegment);
        if (this.isUpdateTableWithMaxKey() && !m_maxKeyColumn.getTable().equals(this.m_oTargetTable)) {
            this.generateMaxKey(codeSegment, m_maxKeyColumn, null, false, this.isUpdateTableWithMaxKey());
            this.generateUpdateMaxKeyLookupTable(codeSegment, m_maxKeyColumn, this.getMaxKeyRowSelectorExpression());
        }
        codeSegment.addCommentLine("Delete work.etls_xref table");
        codeSegment.genTableDelete(WORK_XREF);
        codeSegment.addSourceCode("%mend etls_scd_type_1;").newLine(2);
        codeSegment.addCommentLine("execute etls_scd_type_1").addSourceCode("%etls_scd_type_1").newLine(2);
        return codeSegment;
    }

    private ICodeSegment generateHashLookup(ICodeSegment codeSegment, boolean sourceTableMapped, String mappedSourceTableName) throws RemoteException, MdException, BadLibraryDefinitionException {
        IPhysicalTable m_oChangedRcdsTable = this.m_oCompareTable.getChangedRcdsTable();
        IPhysicalTable m_oNewRcdsTable = this.m_oCompareTable.getNewRcdsTable();
        IPhysicalTable m_oSourceTable = this.m_oCompareTable.getSourceTable();
        String sSurrogateKey = "";
        String sNewRecordExpression = "";
        if (this.hasSurrogateKey()) {
            sSurrogateKey = this.getGenerateKeyColumn().getColumnName(codeSegment.isQuoting());
            sNewRecordExpression = this.getNewGenerateKeyExpressionText();
        }
        String sDefineKeyList = codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", true, ",").replace("\"n", "\"").trim();
        String sDefineDataList = "";
        if (this.hasSurrogateKey()) {
            sDefineDataList = '\"' + this.getGenerateKeyColumn().getColumnName(codeSegment).replace("\"n", "\"").replace('\"', ' ').trim() + '\"' + ", " + '\"' + "compare_digest" + '\"';
        } else if (!this.hasSurrogateKey()) {
            sDefineDataList = sDefineKeyList + ", " + '\"' + "compare_digest" + '\"';
        }
        String sHashExp = Integer.toString(this.m_oCompareTable.getHashInternalTableSize());
        boolean bUseLoadTime = this.isUseLoadTime();
        String sLoadTimeColumn = "";
        String sLoadTimeExpression = "";
        if (bUseLoadTime) {
            sLoadTimeColumn = this.getLoadTimeColumn().getColumnName(codeSegment.isQuoting());
            sLoadTimeExpression = this.getLoadTimeExpression();
        }
        boolean bUseLastUpdate = this.isUseLastUpdate();
        String sLastUpdateColumn = "";
        String sLastUpdateExpression = "";
        if (bUseLastUpdate) {
            sLastUpdateColumn = this.getLastUpdateColumn().getColumnName(codeSegment.isQuoting());
            sLastUpdateExpression = this.getLastUpdateExpression();
        }
        String sDateStampKeepList = sLoadTimeColumn + " " + sLastUpdateColumn;
        StringBuffer sbChangedRcdsTableKeepList = new StringBuffer();
        if (this.hasSurrogateKey()) {
            sbChangedRcdsTableKeepList.append(sSurrogateKey + " ");
        }
        sbChangedRcdsTableKeepList.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", false, " ") + " ");
        sbChangedRcdsTableKeepList.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false), " ", false, " ") + " ");
        if (bUseLastUpdate) {
            sbChangedRcdsTableKeepList.append(this.getLastUpdateColumn().getColumnName(codeSegment.isQuoting()) + " ");
        }
        sbChangedRcdsTableKeepList.append("compare_digest");
        codeSegment.addSectionComment("SCD Type 1 processing: hash lookup method").addSourceCode("data ");
        if (m_oChangedRcdsTable != null) {
            String sAdditionalTableOptions = "keep = " + sbChangedRcdsTableKeepList.toString();
            codeSegment.newLine().indent().addCommentLine("Changed Records Table").addSourceCode(m_oChangedRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oChangedRcdsTable, false).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()));
        }
        codeSegment.newLine();
        if (m_oNewRcdsTable != null) {
            codeSegment.newLine().addCommentLine("New Records Table").addSourceCode(m_oNewRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oNewRcdsTable, false).getTableOptions(true, null, null, codeSegment.getCurrentServer()));
        }
        codeSegment.addSourceCode(";").newLine(2);
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode("drop source_digest NewMaxKey;").newLine(2).addSourceCode("retain NewMaxKey &etls_maxkey;").newLine(2);
        } else if (!this.hasSurrogateKey()) {
            codeSegment.addSourceCode("drop source_digest;").newLine(2);
        }
        codeSegment.addSourceCode("length source_digest $ 32;").newLine(2).addSourceCode("if 0 then").newLine();
        if (!bUseLoadTime && !bUseLastUpdate) {
            codeSegment.indent().addSourceCode("set work.etls_xref;").newLine(2).unIndent();
        } else if (bUseLoadTime || bUseLastUpdate) {
            codeSegment.addSourceCode("do;").newLine().indent().addSourceCode("set work.etls_xref;").newLine().addSourceCode("set " + this.m_oTargetTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode("(keep = " + sDateStampKeepList.trim() + ");").newLine().unIndent().addSourceCode("end;").newLine(2);
        }
        codeSegment.addSourceCode("if _N_ eq 1 then").newLine().addSourceCode("do;").newLine().indent().addSourceCode("declare hash hct(dataset: 'work.etls_xref', hashexp: " + sHashExp + ");").newLine().indent(4).space().addSourceCode("hct.defineKey(" + sDefineKeyList + ");").newLine().space().addSourceCode("hct.defineData(" + sDefineDataList + ");").newLine().space().addSourceCode("hct.defineDone();").newLine().unIndent(5).addSourceCode("end;").newLine(2).addSourceCode("set ");
        if (!sourceTableMapped) {
            codeSegment.addSourceCode(m_oSourceTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oSourceTable, true).getTableOptions(true, null, null, codeSegment.getCurrentServer()) + ";");
        } else if (sourceTableMapped) {
            codeSegment.addSourceCode(mappedSourceTableName + ";");
        }
        codeSegment.newLine(2);
        this.m_oCompareTable.generateDigest(codeSegment, true);
        codeSegment.newLine().addCommentLine("match").addSourceCode("if hct.find() eq 0 then").newLine().addSourceCode("do;").newLine().indent().addCommentLine("scd type 1 records").addSourceCode("if source_digest ne compare_digest then").newLine().addSourceCode("do;").newLine().indent();
        if (bUseLastUpdate) {
            codeSegment.addSourceCode(sLastUpdateColumn + " = " + sLastUpdateExpression + ";").newLine();
        }
        codeSegment.addSourceCode("compare_digest = source_digest;").newLine().addSourceCode("output " + m_oChangedRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false) + ";").newLine().unIndent().addSourceCode("end;").newLine().unIndent().addSourceCode("end;").newLine().addCommentLine("new records").addSourceCode("else if hct.find() ne 0 then").newLine().addSourceCode("do;").newLine().indent();
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode("NewMaxKey = ").addSourceCode(sNewRecordExpression + ";").newLine().addSourceCode(sSurrogateKey + " = " + TEMP_NEW_MAX_KEY + ";").newLine();
        }
        if (bUseLoadTime) {
            codeSegment.addSourceCode(sLoadTimeColumn + " = " + sLoadTimeExpression + ";").newLine();
        }
        if (bUseLastUpdate) {
            codeSegment.addSourceCode(sLastUpdateColumn + " = " + sLastUpdateExpression + ";").newLine();
        }
        codeSegment.addSourceCode("compare_digest = source_digest;").newLine().addSourceCode("output " + m_oNewRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false) + ";").newLine().unIndent().addSourceCode("end;").newLine(2).unIndent().addSourceCode("run;").newLine().genRCSetCall("&syscc");
        return codeSegment;
    }

    private ICodeSegment generateMergeLookup(ICodeSegment codeSegment, boolean sourceTableMapped, String mappedSourceTableName) throws RemoteException, MdException, BadLibraryDefinitionException {
        IPhysicalTable m_oChangedRcdsTable = this.m_oCompareTable.getChangedRcdsTable();
        IPhysicalTable m_oNewRcdsTable = this.m_oCompareTable.getNewRcdsTable();
        IPhysicalTable m_oSourceTable = this.m_oCompareTable.getSourceTable();
        String sSurrogateKey = "";
        String sNewRecordExpression = "";
        String sAdditionalTableOptions = "";
        if (this.hasSurrogateKey()) {
            sSurrogateKey = this.getGenerateKeyColumn().getColumnName(codeSegment.isQuoting());
            sNewRecordExpression = this.getNewGenerateKeyExpressionText();
        }
        boolean bUseLoadTime = this.isUseLoadTime();
        String sLoadTimeColumn = "";
        String sLoadTimeExpression = "";
        if (bUseLoadTime) {
            sLoadTimeColumn = this.getLoadTimeColumn().getColumnName(codeSegment.isQuoting());
            sLoadTimeExpression = this.getLoadTimeExpression();
        }
        boolean bUseLastUpdate = this.isUseLastUpdate();
        String sLastUpdateColumn = "";
        String sLastUpdateExpression = "";
        if (bUseLastUpdate) {
            sLastUpdateColumn = this.getLastUpdateColumn().getColumnName(codeSegment.isQuoting());
            sLastUpdateExpression = this.getLastUpdateExpression();
        }
        String sDateStampKeepList = sLoadTimeColumn + " " + sLastUpdateColumn;
        StringBuffer sbChangedRcdsTableKeepList = new StringBuffer();
        if (this.hasSurrogateKey()) {
            sbChangedRcdsTableKeepList.append(sSurrogateKey + " ");
        }
        sbChangedRcdsTableKeepList.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", false, " ") + " ");
        sbChangedRcdsTableKeepList.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false), " ", false, " ") + " ");
        if (bUseLastUpdate) {
            sbChangedRcdsTableKeepList.append(this.getLastUpdateColumn().getColumnName(codeSegment.isQuoting()) + " ");
        }
        sbChangedRcdsTableKeepList.append("compare_digest");
        String sByColumns = "";
        sByColumns = codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", false, " ") + " ";
        codeSegment.addSectionComment("SCD Type 1 processing: merge lookup method").addSourceCode("data ");
        if (m_oChangedRcdsTable != null) {
            sAdditionalTableOptions = "keep = " + sbChangedRcdsTableKeepList.toString();
            codeSegment.newLine().indent().addCommentLine("Changed Records Table").addSourceCode(m_oChangedRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oChangedRcdsTable, false).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()));
        }
        codeSegment.newLine();
        if (m_oNewRcdsTable != null) {
            codeSegment.newLine().addCommentLine("New Records Table").addSourceCode(m_oNewRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oNewRcdsTable, false).getTableOptions(true, null, null, codeSegment.getCurrentServer()));
        }
        codeSegment.addSourceCode(";").newLine(2);
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode("drop source_digest NewMaxKey;").newLine(2).addSourceCode("retain NewMaxKey &etls_maxkey;").newLine(2);
        }
        codeSegment.addSourceCode("length source_digest $ 32;").newLine(2);
        if (bUseLoadTime || bUseLastUpdate) {
            codeSegment.addSourceCode("if 0 then").newLine().indent().addSourceCode("set " + this.m_oTargetTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode("(keep = " + sDateStampKeepList.trim() + ");").newLine(2).unIndent();
        }
        codeSegment.addSourceCode("merge ");
        if (!sourceTableMapped) {
            sAdditionalTableOptions = "in = inSOURCE";
            codeSegment.addSourceCode(m_oSourceTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(m_oSourceTable, true).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()));
        } else if (sourceTableMapped) {
            sAdditionalTableOptions = "(in = inSOURCE)";
            codeSegment.addSourceCode(mappedSourceTableName + sAdditionalTableOptions);
        }
        codeSegment.newLine().indent(2).addSourceCode("work.etls_xref(in = inCOMPARE);").newLine().unIndent(2).addSourceCode("by " + sByColumns.trim() + ";").newLine(2);
        this.m_oCompareTable.generateDigest(codeSegment, true);
        codeSegment.newLine().addCommentLine("match").addSourceCode("if inSOURCE and inCOMPARE then").newLine().addSourceCode("do;").newLine().indent().addCommentLine("scd type 1 records").addSourceCode("if source_digest ne compare_digest then").newLine().addSourceCode("do;").newLine().indent();
        if (bUseLastUpdate) {
            codeSegment.addSourceCode(sLastUpdateColumn + " = " + sLastUpdateExpression + ";").newLine();
        }
        codeSegment.addSourceCode("compare_digest = source_digest;").newLine().addSourceCode("output " + m_oChangedRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false) + ";").newLine().unIndent().addSourceCode("end;").newLine().unIndent().addSourceCode("end;").newLine().addCommentLine("new records").addSourceCode("else if inSOURCE and not inCOMPARE then").newLine().addSourceCode("do;").newLine().indent();
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode("NewMaxKey = ").addSourceCode(sNewRecordExpression + ";").newLine().addSourceCode(sSurrogateKey + " = " + TEMP_NEW_MAX_KEY + ";").newLine();
        }
        if (bUseLoadTime) {
            codeSegment.addSourceCode(sLoadTimeColumn + " = " + sLoadTimeExpression + ";").newLine();
        }
        if (bUseLastUpdate) {
            codeSegment.addSourceCode(sLastUpdateColumn + " = " + sLastUpdateExpression + ";").newLine();
        }
        codeSegment.addSourceCode("compare_digest = source_digest;").newLine().addSourceCode("output " + m_oNewRcdsTable.getFullNameQuotedAsNeeded(codeSegment, false) + ";").newLine().unIndent().addSourceCode("end;").newLine(2).unIndent().addSourceCode("run;").newLine().genRCSetCall("&syscc");
        return codeSegment;
    }

    private ICodeSegment generateWorkXrefTable(ICodeSegment codeSegment, Boolean bXrefTableTemp, Boolean bCreateIndex) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException {
        StringBuffer sbKeepList1 = new StringBuffer();
        StringBuffer sbKeepList2 = new StringBuffer();
        String sSurrogateKey = "";
        if (this.hasSurrogateKey() && (sSurrogateKey = this.getGenerateKeyColumn().getColumnName(codeSegment.isQuoting())) != null && sSurrogateKey.length() > 0) {
            sbKeepList1.append(sSurrogateKey + " ");
            sbKeepList2.append(sSurrogateKey + " ");
        }
        String sMatchKeyColumns = "";
        sMatchKeyColumns = codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", false, " ").trim();
        Boolean bCreateIndexSimple = true;
        if (sMatchKeyColumns != null && sMatchKeyColumns.length() > 0) {
            if (sMatchKeyColumns.split("\\s+").length > 1) {
                bCreateIndexSimple = false;
            }
            sbKeepList1.append(sMatchKeyColumns + " ");
            sbKeepList2.append(sMatchKeyColumns + " ");
        }
        String sChangeColumns = "";
        sChangeColumns = codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false), " ", false, " ").trim();
        if (sChangeColumns != null && sChangeColumns.length() > 0) {
            sbKeepList1.append(sChangeColumns);
        }
        sbKeepList2.append("compare_digest");
        String sAdditionalTableOptions = "";
        codeSegment.addCommentLine("create work xref table");
        if (bXrefTableTemp.booleanValue()) {
            sAdditionalTableOptions = "keep = " + sbKeepList1.toString();
            if (bCreateIndex.booleanValue()) {
                if (bCreateIndexSimple.booleanValue()) {
                    codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + " index=(" + sMatchKeyColumns + "));");
                } else {
                    codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + " index=(index1=(" + sMatchKeyColumns + ")));");
                }
            } else if (!bCreateIndex.booleanValue()) {
                codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + ");");
            }
            codeSegment.newLine(2).indent().addSourceCode("length " + "compare_digest" + " $ 32;").newLine(2).addSourceCode("set ").addSourceCode(this.m_oTargetTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(this.m_oTargetTable, false).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()) + ";").newLine(2);
            this.m_oCompareTable.generateDigest(codeSegment, false);
        }
        if (!bXrefTableTemp.booleanValue()) {
            sAdditionalTableOptions = "keep = " + sbKeepList2.toString();
            if (bCreateIndex.booleanValue()) {
                if (bCreateIndexSimple.booleanValue()) {
                    codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + " index=(" + sMatchKeyColumns + "));");
                } else {
                    codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + " index=(index1=(" + sMatchKeyColumns + ")));");
                }
            } else if (!bCreateIndex.booleanValue()) {
                codeSegment.addSourceCode("data work.etls_xref(keep = " + sbKeepList2.toString() + ");");
            }
            codeSegment.newLine(2).indent().addSourceCode("set ").addSourceCode(this.m_oXrefTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(this.getTableOptionObject(this.m_oXrefTable, false).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()) + ";").newLine();
        }
        codeSegment.newLine().unIndent().addSourceCode("run;").newLine().genRCSetCall("&syscc");
        return codeSegment;
    }

    private ICodeSegment generateUpdateXrefTable(ICodeSegment codeSegment) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        String sMatchKeyColumnName;
        IColumn matchColumn;
        int i;
        String sXrefTableName = this.m_oXrefTable.getFullNameQuotedAsNeeded(codeSegment);
        String sChangedRcdsTable = this.m_oCompareTable.getChangedRcdsTable().getFullNameQuotedAsNeeded(codeSegment);
        String sNewRcdsTable = this.m_oCompareTable.getNewRcdsTable().getFullNameQuotedAsNeeded(codeSegment);
        List lMatchKeyMappings = this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false);
        String sMatchKeyMappings = codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false), " ", false, " ").replace("\"n", "\"").trim();
        List lCompareColumns = this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), true);
        String sSurrogateKey = "";
        String sKeepList = "";
        if (this.hasSurrogateKey()) {
            sSurrogateKey = this.getGenerateKeyColumn().getColumnName(codeSegment.isQuoting());
            sKeepList = "keep = " + sSurrogateKey + " " + sMatchKeyMappings + " " + "compare_digest";
        } else if (!this.hasSurrogateKey()) {
            sKeepList = "keep = " + sMatchKeyMappings + " " + "compare_digest";
        }
        codeSegment.addSectionComment("cross reference table: update/append rows").newLine();
        codeSegment.addCommentLine("cross reference table: update change rows").addSourceCode("%if &etls_change_rows ge 1 %then").newLine().addSourceCode("%do;").newLine().indent();
        codeSegment.addSourceCode("proc sql;").newLine().indent().addSourceCode("update " + sXrefTableName + " as m").newLine().indent().addSourceCode("set ").addSourceCode("compare_digest").addSourceCode(" = (select " + "compare_digest" + " from " + sChangedRcdsTable + " as t");
        codeSegment.newLine().indent(3);
        codeSegment.addSourceCode("where ");
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode("m." + sSurrogateKey + " = t." + sSurrogateKey + ")");
            codeSegment.newLine();
        } else if (!this.hasSurrogateKey()) {
            for (i = 1; i <= lMatchKeyMappings.size(); ++i) {
                matchColumn = (IColumn)lMatchKeyMappings.get(i - 1);
                sMatchKeyColumnName = DBMSNamesUtil.getQuotedColumnName(matchColumn, codeSegment.isQuoting(), false);
                if (i == 1) {
                    codeSegment.addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                } else if (i != 1) {
                    codeSegment.space(6).addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                }
                if (i < lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(" and");
                } else if (i == lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(")");
                }
                codeSegment.newLine();
            }
        }
        codeSegment.unIndent(3).addSourceCode("where ");
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode(sSurrogateKey + " in (select distinct " + sSurrogateKey + " from " + sChangedRcdsTable + ");").newLine();
        } else if (!this.hasSurrogateKey()) {
            codeSegment.addSourceCode("exists (select * from " + sChangedRcdsTable + " as t").newLine().indent();
            for (i = 1; i <= lMatchKeyMappings.size(); ++i) {
                matchColumn = (IColumn)lMatchKeyMappings.get(i - 1);
                sMatchKeyColumnName = DBMSNamesUtil.getQuotedColumnName(matchColumn, codeSegment.isQuoting(), false);
                if (i == 1) {
                    codeSegment.addSourceCode("where m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                } else if (i != 1) {
                    codeSegment.space(6).addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                }
                if (i < lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(" and ");
                } else if (i == lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(");");
                }
                codeSegment.newLine();
            }
        }
        codeSegment.unIndent(3);
        codeSegment.addSourceCode("quit;").newLine().addSourceCode("%rcSet(&syscc);").newLine().unIndent().addSourceCode("%end;").newLine(2);
        codeSegment.addCommentLine("cross reference table - append new rows").addSourceCode("%if &etls_new_rows ge 1 %then").newLine().addSourceCode("%do;").newLine().indent();
        codeSegment.addSourceCode("proc append base = ").addSourceCode(sXrefTableName).addSourceCode(this.getTableOptionObject(this.m_oTargetTable, false).getTableOptions(true, null, codeSegment.getCurrentServer())).newLine().space(12).addSourceCode("data = ").addSourceCode(sNewRcdsTable).addSourceCode(this.getTableOptionObject(this.m_oCompareTable.getNewRcdsTable(), false).getTableOptions(true, null, sKeepList, codeSegment.getCurrentServer())).newLine().addSourceCode("force nowarn;").newLine().addSourceCode("run;").newLine().addSourceCode("%rcSet(&syscc);").newLine().unIndent().addSourceCode("%end;").newLine(2);
        this.m_oXrefTable.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, this.m_oXrefTable);
        return codeSegment;
    }

    protected ICodeSegment generateUpdateTargetTable(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        int i;
        String sTargetTableName = this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
        String sChangedRcdsTable = this.m_oCompareTable.getChangedRcdsTable().getFullNameQuotedAsNeeded(codeSegment);
        String sNewRcdsTable = this.m_oCompareTable.getNewRcdsTable().getFullNameQuotedAsNeeded(codeSegment);
        String sSurrogateKey = "";
        if (this.hasSurrogateKey()) {
            sSurrogateKey = this.getGenerateKeyColumn().getColumnName(codeSegment.isQuoting());
        }
        List lMatchKeyMappings = this.m_oCompareTable.getColumnList(this.m_oCompareTable.getMatchKeyMappings(), false);
        List lCompareColumns = this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false);
        if (this.isUseLastUpdate()) {
            lCompareColumns.add(this.getLastUpdateColumn());
        }
        codeSegment.addSectionComment("target table: update/append rows").newLine();
        codeSegment.addCommentLine("target table: update change rows").addSourceCode("%if &etls_change_rows ge 1 %then").newLine().addSourceCode("%do;").newLine().indent();
        codeSegment.addSourceCode("proc sql;").newLine().indent().addSourceCode("update " + sTargetTableName + " as m").newLine().indent();
        for (i = 1; i <= lCompareColumns.size(); ++i) {
            IColumn compareColumn = (IColumn)lCompareColumns.get(i - 1);
            String sCompareColumnName = DBMSNamesUtil.getQuotedColumnName(compareColumn, codeSegment.isQuoting(), false);
            if (i == 1) {
                codeSegment.addSourceCode("set ").addSourceCode(sCompareColumnName + " = (select " + sCompareColumnName + " from " + sChangedRcdsTable + " as t");
            } else if (i != 1) {
                codeSegment.unIndent(3).space(4).addSourceCode(sCompareColumnName + " = (select " + sCompareColumnName + " from " + sChangedRcdsTable + " as t");
            }
            codeSegment.newLine().indent(3);
            codeSegment.addSourceCode("where ");
            if (this.hasSurrogateKey()) {
                codeSegment.addSourceCode("m." + sSurrogateKey + " = t." + sSurrogateKey + ")");
                if (i < lCompareColumns.size()) {
                    codeSegment.addSourceCode(",");
                }
                codeSegment.newLine();
                continue;
            }
            if (this.hasSurrogateKey()) continue;
            for (int j = 1; j <= lMatchKeyMappings.size(); ++j) {
                IColumn matchColumn = (IColumn)lMatchKeyMappings.get(j - 1);
                String sMatchKeyColumnName = DBMSNamesUtil.getQuotedColumnName(matchColumn, codeSegment.isQuoting(), false);
                if (j == 1) {
                    codeSegment.addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                } else if (j != 1) {
                    codeSegment.space(6).addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                }
                if (j < lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(" and");
                } else if (j == lMatchKeyMappings.size()) {
                    if (i < lCompareColumns.size()) {
                        codeSegment.addSourceCode("),");
                    } else if (i == lCompareColumns.size()) {
                        codeSegment.addSourceCode(")");
                    }
                }
                codeSegment.newLine();
            }
        }
        codeSegment.unIndent(3).addSourceCode("where ");
        if (this.hasSurrogateKey()) {
            codeSegment.addSourceCode(sSurrogateKey + " in (select distinct " + sSurrogateKey + " from " + sChangedRcdsTable + ");").newLine();
        } else if (!this.hasSurrogateKey()) {
            codeSegment.addSourceCode("exists (select * from " + sChangedRcdsTable + " as t").newLine().indent();
            for (i = 1; i <= lMatchKeyMappings.size(); ++i) {
                IColumn matchColumn = (IColumn)lMatchKeyMappings.get(i - 1);
                String sMatchKeyColumnName = DBMSNamesUtil.getQuotedColumnName(matchColumn, codeSegment.isQuoting(), false);
                if (i == 1) {
                    codeSegment.addSourceCode("where m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                } else if (i != 1) {
                    codeSegment.space(6).addSourceCode("m." + sMatchKeyColumnName + " = t." + sMatchKeyColumnName);
                }
                if (i < lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(" and ");
                } else if (i == lMatchKeyMappings.size()) {
                    codeSegment.addSourceCode(");");
                }
                codeSegment.newLine();
            }
        }
        codeSegment.unIndent(3);
        codeSegment.addSourceCode("quit;").newLine().addSourceCode("%rcSet(&syscc);").newLine().unIndent().addSourceCode("%end;").newLine(2);
        codeSegment.addCommentLine("target table - append new rows").addSourceCode("%if &etls_new_rows ge 1 %then").newLine().addSourceCode("%do;").newLine().indent();
        codeSegment.addSourceCode("proc append base = ").addSourceCode(sTargetTableName).addSourceCode(this.getTableOptionObject(this.m_oTargetTable, false).getTableOptions(true, null, codeSegment.getCurrentServer())).newLine().space(12).addSourceCode("data = ").addSourceCode(sNewRcdsTable).addSourceCode(this.getTableOptionObject(this.m_oCompareTable.getNewRcdsTable(), false).getTableOptions(true, null, codeSegment.getCurrentServer())).addSourceCode(" force nowarn;").newLine().addSourceCode("run;").newLine().addSourceCode("%rcSet(&syscc);").newLine().unIndent().addSourceCode("%end;").newLine(2);
        this.m_oTargetTable.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, this.m_oTargetTable);
        return codeSegment;
    }

    protected void generateMaxKey(ICodeSegment codeSegment, IColumn maxKeyColumn, ITextExpression maxKeyRowSelector, boolean isNextKeyValue, boolean isUpdateMaxKeyLookupTable) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        codeSegment.addSectionComment("get the maximum surrogate key value");
        if (!isUpdateMaxKeyLookupTable) {
            String whereClause;
            IPhysicalTable table = (IPhysicalTable)maxKeyColumn.getTable();
            String sReadOnlyOptions = table.getReadTableOptions(true);
            codeSegment.addSourceCode("%let etls_maxkey = -1;").newLine(2).addSourceCode("proc sql noprint;").newLine().indent().addSourceCode("select compress(put(max(" + maxKeyColumn.getColumnName(codeSegment) + "), best32.))").newLine().indent().addSourceCode("into :etls_maxkey").newLine().unIndent().addSourceCode("from " + table.getFullNameQuotedAsNeeded(codeSegment));
            if (sReadOnlyOptions.length() > 0) {
                codeSegment.newLine().addSourceCode(sReadOnlyOptions).newLine();
            }
            if (maxKeyRowSelector != null && (whereClause = maxKeyRowSelector.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting())).length() > 0) {
                codeSegment.newLine().addSourceCode("where " + whereClause);
            }
            codeSegment.addSourceCode(";").newLine().unIndent().addSourceCode("quit;").newLine(2);
            if (this.isNextKeyValueInGenKey() && !this.getMaxKeyColumn().getTable().equals(this.m_oTargetTable)) {
                codeSegment.addCommentLine("subtract 1 to obtain next surrogate key value").addSourceCode("%let etls_maxkey = %eval(&etls_maxkey - 1);").newLine(2).unIndent();
            }
        } else if (isUpdateMaxKeyLookupTable) {
            codeSegment.addSourceCode("%let etls_maxkey = -1;").newLine(2).addSourceCode("proc sql noprint;").newLine().indent().addSourceCode("select compress(put(max(" + this.getGenerateKeyColumn().getColumnName(codeSegment) + "), best32.))").newLine().indent().addSourceCode("into :etls_maxkey").newLine().unIndent().addSourceCode("from " + this.m_oTargetTable.getFullNameQuotedAsNeeded(codeSegment) + ";").newLine().unIndent().addSourceCode("quit;").newLine(2);
        }
        codeSegment.addCommentLine("if etls_maxkey value is missing then set it to zero.").addSourceCode("%if (&etls_maxkey eq .)").newLine().indent().addSourceCode("%then %let etls_maxkey = 0;").newLine(2).unIndent();
    }

    protected void generateUpdateMaxKeyLookupTable(ICodeSegment codeSegment, IColumn maxKeyColumn, ITextExpression maxKeyRowSelector) throws BadServerDefinitionException, CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException {
        if (this.isNextKeyValueInGenKey()) {
            codeSegment.addCommentLine("add 1 to obtain next surrogate key value").addSourceCode("%let etls_maxkey = %eval(&etls_maxkey + 1);").newLine(2).unIndent();
        }
        codeSegment.addSectionComment("update surrogate key lookup table").addSourceCode("proc sql;").newLine().indent().addSourceCode("update " + this.m_oMaxLookupTable.getFullNameQuotedAsNeeded(codeSegment)).newLine().indent();
        if (maxKeyRowSelector != null) {
            codeSegment.addSourceCode("set " + maxKeyColumn.getColumnName(codeSegment.isQuoting()) + " = &" + MAX_KEY_MACRO);
            String whereClause = maxKeyRowSelector.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            if (whereClause.length() > 0) {
                codeSegment.newLine().addSourceCode("where " + whereClause + ";");
            }
        } else if (maxKeyRowSelector == null) {
            codeSegment.addSourceCode("set " + maxKeyColumn.getColumnName(codeSegment.isQuoting()) + " = &" + MAX_KEY_MACRO + ";");
        }
        codeSegment.newLine().unIndent(2).addSourceCode("quit;").newLine().genRCSetCall("&syscc");
    }

    public List getIgnoreColumnList() throws MdException, RemoteException {
        ArrayList<IColumn> ignoreColumnList = new ArrayList<IColumn>();
        IColumn compareDigestColumn = this.getModel().getObjectFactory().createNewColumn(this.getID());
        compareDigestColumn.setName("compare_digest");
        compareDigestColumn.setLength(32);
        compareDigestColumn.setType(0);
        compareDigestColumn.setInformat("$32.");
        compareDigestColumn.setFormat("$32.");
        compareDigestColumn.setNullable(false);
        ignoreColumnList.add(compareDigestColumn);
        if (this.hasSurrogateKey() && this.getGenerateKeyColumn() != null) {
            ignoreColumnList.add(this.getGenerateKeyColumn());
        }
        if (this.isUseLoadTime() && this.getLoadTimeColumn() != null) {
            ignoreColumnList.add(this.getLoadTimeColumn());
        }
        if (this.isUseLastUpdate() && this.getLastUpdateColumn() != null) {
            ignoreColumnList.add(this.getLastUpdateColumn());
        }
        return ignoreColumnList;
    }

    public ICodeSegment generateDigest(ICodeSegment codeSegment, boolean sourceDigest) throws RemoteException, MdException {
        StringBuffer sbDigest = new StringBuffer();
        if (this.m_oCompareTable.getChangeDigestVersion().equalsIgnoreCase("V2_1")) {
            if (sourceDigest) {
                sbDigest.append("source_digest = put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false), " ", false, ",").trim());
            } else {
                sbDigest.append("compare_digest = put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false), " ", false, ",").trim());
            }
            sbDigest.append(")), $hex32.);");
            codeSegment.addCommentLine("create digest - version 2.1");
        } else if (this.m_oCompareTable.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
            if (sourceDigest) {
                sbDigest.append("source_digest = put(md5(catq(' ', ");
            } else {
                sbDigest.append("compare_digest = put(md5(catq(' ', ");
            }
            List lColumns = this.m_oCompareTable.getColumnList(this.m_oCompareTable.getCompareColumnsMappings(), false);
            int maxLineLength = 60;
            for (int i = 0; i < lColumns.size(); ++i) {
                IColumn col = (IColumn)lColumns.get(i);
                String colName = col.getColumnName(codeSegment);
                if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                    sbDigest.append("\n      ");
                    maxLineLength += 60;
                }
                if (i == 0) {
                    sbDigest.append("put(md5(catq(' ', ");
                }
                if (col.getType() == 1) {
                    colName = "put(" + col.getColumnName(codeSegment) + ",ieee8.)";
                }
                if (i + 1 != lColumns.size()) {
                    sbDigest.append(colName + ',');
                    continue;
                }
                sbDigest.append(colName);
                sbDigest.append(")),$hex32.);");
            }
            sbDigest.append(")), $hex32.);");
            codeSegment.addCommentLine("create digest - version 2.2");
        }
        codeSegment.addSourceCode(sbDigest).newLine();
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cSCDType1OptionModel(this);
    }

    private class SetSourceTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newSourceTable;
        private IPhysicalTable m_oldSourceTable;

        public SetSourceTableUndoable(IPhysicalTable newSourceTable, IPhysicalTable oldSourceTable) {
            this.m_newSourceTable = newSourceTable;
            this.m_oldSourceTable = oldSourceTable;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setSourceTable(this.m_oldSourceTable);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setSourceTable(this.m_newSourceTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newSourceTable = null;
            this.m_oldSourceTable = null;
        }
    }

    private class SetLastUpdateColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldLastUpdate;
        private IColumn m_newLastUpdate;

        public SetLastUpdateColumnUndoable(IColumn oldLastUpdate, IColumn newLastUpdate) {
            this.m_oldLastUpdate = oldLastUpdate;
            this.m_newLastUpdate = newLastUpdate;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setLastUpdateColumn(this.m_oldLastUpdate);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setLastUpdateColumn(this.m_newLastUpdate);
        }
    }

    private class SetLastUpdateExpressionUndoable
    extends AbstractUndoableEdit {
        private String m_oldLastUpdateExpression;
        private String m_newLastUpdateExpression;

        public SetLastUpdateExpressionUndoable(String oldLastUpdateExpression, String newLastUpdateExpression) {
            this.m_oldLastUpdateExpression = oldLastUpdateExpression;
            this.m_newLastUpdateExpression = newLastUpdateExpression;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setLastUpdateExpression(this.m_oldLastUpdateExpression);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setLastUpdateExpression(this.m_newLastUpdateExpression);
        }
    }

    private class SetHasSurrogateKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetHasSurrogateKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setHasSurrogateKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setHasSurrogateKey(this.m_newValue);
        }
    }

    private class SetSurrogateKeyUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetSurrogateKeyUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.fireModelChangedEvent("SCDType1TransformModel:SurrogateKeyChanged", this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.fireModelChangedEvent("SCDType1TransformModel:SurrogateKeyChanged", this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class SetNewSurrogateKeyExpressionTextUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetNewSurrogateKeyExpressionTextUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.fireModelChangedEvent("SCDType1TransformModel:NewSurrogateKeyExpressionTextChanged", this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.fireModelChangedEvent("SCDType1TransformModel:NewSurrogateKeyExpressionTextChanged", this.m_newValue);
        }
    }

    private class SetGenerateMaxKeyCodeUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetGenerateMaxKeyCodeUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setGenerateMaxKeyCode(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setGenerateMaxKeyCode(this.m_newValue);
        }
    }

    private class SetNextAvailableKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetNextAvailableKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setNextKeyValueInGenKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setNextKeyValueInGenKey(this.m_newValue);
        }
    }

    private class SetMaxKeyValueInLookupTableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetMaxKeyValueInLookupTableUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setUpdateTableWithMaxKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setUpdateTableWithMaxKey(this.m_newValue);
        }
    }

    private class SetTargetTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newTargetTable;
        private IPhysicalTable m_oldTargetTable;
        private int m_iPort;

        public SetTargetTableUndoable(IPhysicalTable newTargetTable, IPhysicalTable oldTargetTable, int portIndex) {
            this.m_newTargetTable = newTargetTable;
            this.m_oldTargetTable = oldTargetTable;
            this.m_iPort = portIndex;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setTargetTable(this.m_oldTargetTable, this.m_iPort);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setTargetTable(this.m_newTargetTable, this.m_iPort);
        }

        @Override
        public void die() {
            super.die();
            this.m_newTargetTable = null;
            this.m_oldTargetTable = null;
        }
    }

    private class SetComparisonTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newComparisonTable;
        private IPhysicalTable m_oldComparisonTable;

        public SetComparisonTableUndoable(IPhysicalTable newComparisonTable, IPhysicalTable oldComparisonTable) {
            this.m_newComparisonTable = newComparisonTable;
            this.m_oldComparisonTable = oldComparisonTable;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType1TransformModel.this.setComparisonTable(this.m_oldComparisonTable);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType1TransformModel.this.setComparisonTable(this.m_newComparisonTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newComparisonTable = null;
            this.m_oldComparisonTable = null;
        }
    }

    protected class cSCDType1OptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cSCDType1OptionModel(SCDType1TransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cSCDType1OptionModel.class.getResource("res/Options_SCDType1_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            SCDType1TransformModel transform = (SCDType1TransformModel)this.getOwner();
            ICompareTables compare = transform.getCompareTablesObject();
            if (compare != null) {
                this.setOptionValue("DataHash", (Object)(compare.useDataHashStep() ? SCDType1TransformModel.OPTIONS_TRUE : SCDType1TransformModel.OPTIONS_FALSE));
                this.setOptionValue("HashExp", (Object)compare.getHashInternalTableSize());
                this.setOptionValue("ChangeDigestVersion", (Object)compare.getChangeDigestVersion());
            }
            this.setOptionValue("UpdateDateColumn", (Object)transform.getLastUpdateColumn());
            this.setOptionValue("UpdateDateExpression", (Object)transform.getLastUpdateExpression());
        }

        @Override
        protected IModelListener createModelListener() {
            return new cSCDType1ModelChangeListener((SCDType1TransformModel)this.getOwner());
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new cSCDType1TransformValueChangedListener((SCDType1TransformModel)this.getOwner(), this);
        }

        @Override
        public void fixDefinition(IPromptDefinitionValue definition) throws RemoteException, ServiceException, MdException, ServerConnectionException {
            if (definition != null && this.isFixDefinitionsEnabled()) {
                if ("LoadTime".equals(definition.getName()) || "UpdateDateColumn".equals(definition.getName())) {
                    DataSourceInterface[] dataSourceInterfaceArray;
                    SCDType1TransformModel transform = (SCDType1TransformModel)this.getOwner();
                    DataSourceInterface table = this.getDataProvider().getPromptDataTarget(transform.getTargetTable());
                    if (table != null) {
                        DataSourceInterface[] dataSourceInterfaceArray2 = new DataSourceInterface[1];
                        dataSourceInterfaceArray = dataSourceInterfaceArray2;
                        dataSourceInterfaceArray2[0] = table;
                    } else {
                        dataSourceInterfaceArray = new DataSourceInterface[]{};
                    }
                    DataSourceInterface[] targets = dataSourceInterfaceArray;
                    definition.fixDefinition(this.getDataProvider().getPromptDataSources(), targets, this.getDataProvider());
                } else {
                    super.fixDefinition(definition);
                }
            }
        }

        private class cSCDType1ModelChangeListener
        extends BaseLoaderModelListener {
            public cSCDType1ModelChangeListener(SCDType1TransformModel transform) {
                super(transform, (IPromptModel)cSCDType1OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    ICompareTables compare = SCDType1TransformModel.this.getCompareTablesObject();
                    if (compare != null) {
                        if (type.equals("CompareTablesTransformModel:UseHashObjectChanged")) {
                            cSCDType1OptionModel.this.setOptionValue("DataHash", (Object)(compare.useDataHashStep() ? SCDType1TransformModel.OPTIONS_TRUE : SCDType1TransformModel.OPTIONS_FALSE));
                        } else if (type.equals("CompareTablesTransformModel:HashExpChanged")) {
                            cSCDType1OptionModel.this.setOptionValue("HashExp", (Object)compare.getHashInternalTableSize());
                        } else if (type.equals("CompareTables:ChangeDigestVersionChanged")) {
                            cSCDType1OptionModel.this.setOptionValue("ChangeDigestVersion", (Object)compare.getChangeDigestVersion());
                        }
                    }
                    if (type.equals("UpdateDateColumn")) {
                        cSCDType1OptionModel.this.setOptionValue("UpdateDateColumn", (Object)SCDType1TransformModel.this.getLastUpdateColumn());
                    } else if (type.equals("UpdateDateExpression")) {
                        cSCDType1OptionModel.this.setOptionValue("UpdateDateExpression", (Object)SCDType1TransformModel.this.getLastUpdateExpression());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class cSCDType1TransformValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public cSCDType1TransformValueChangedListener(SCDType1TransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    ICompareTables compare;
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if ((compare = SCDType1TransformModel.this.getCompareTablesObject()) != null) {
                        if (optionName.equals("DataHash")) {
                            compare.setUseDataHashStep(value.equals(SCDType1TransformModel.OPTIONS_TRUE));
                        } else if (optionName.equals("HashExp")) {
                            compare.setHashInternalTableSize(new Integer(value.toString()));
                        } else if (optionName.equals("ChangeDigestVersion")) {
                            compare.setChangeDigestVersion(value.toString());
                        }
                    }
                    if (optionName.equals("UpdateDateColumn")) {
                        if (value instanceof IColumn) {
                            SCDType1TransformModel.this.setLastUpdateColumn((IColumn)value);
                        } else {
                            SCDType1TransformModel.this.setLastUpdateColumn(null);
                        }
                    } else if (optionName.equals("UpdateDateExpression")) {
                        SCDType1TransformModel.this.setLastUpdateExpression(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                    SCDType1TransformModel.this.getPromptModel().setListeningForChanges(true);
                    cSCDType1OptionModel.this.setChanged(true);
                }
            }
        }
    }
}

