/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.scd.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.impl.AbstractSCDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class KEDTransformModel
extends AbstractSCDTransformModel {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.scd.KeyEffectiveDate";
    private static final String TRANSFORMATION_ROLE = "KeyEffDateLoader";
    private static final String ARM_DISPLAY_NAME = "KeyEffDate";
    private static final String KEYEFFDT_TRANSFORMROLE = "SCD2_KEYEFFDATE";
    private static final String WORKSORTEDXREFNAME = "work.etls_sortedxref";
    private static final String WORKINPUTSOURCE = "work.etls_source";

    public KEDTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("KeyEffectiveDateTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("KeyEffectiveDateTransformModel.Name.txt");
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getBusinessKeyColumnsList().size() == 0) {
            lReasons.add(RB.getStringResource("KEDTransformModel.ReasonIncomplete.NoKeyColumns.txt"));
        }
        if (!this.isBusinessKeyComplete()) {
            lReasons.add(RB.getStringResource("KEDTransformModel.ReasonIncomplete.InvalidKey.txt"));
        }
        return lReasons;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        this.setTrackChangesByDates(true);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole(TRANSFORMATION_ROLE);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable sourceTable = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        ILibrary targetLibrary = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        boolean usePassThru = this.isSQLPassThruEnabled(targetLibrary);
        codeSegment.addSourceCode("%macro etls_kedloader;\n\n").indent();
        this.genCreateTargetTable(codeSegment);
        ArrayList lKeyColumnsNoFromDate = new ArrayList(this.getBusinessKeyColumnsList());
        lKeyColumnsNoFromDate.remove(this.getFromDateColumn());
        String sByColumns = codeSegment.makeColumnList(lKeyColumnsNoFromDate, "   ", codeSegment.isQuoting());
        boolean isXrefPermanent = false;
        String sXrefTableName = this.getXrefTableName();
        String sXrefInputName = "";
        IPhysicalTable xRefTable = null;
        if (sXrefTableName.length() > 0) {
            isXrefPermanent = true;
            ArrayList<IColumn> lXrefColumns = new ArrayList<IColumn>();
            lXrefColumns.addAll(this.getBusinessKeyColumnsList());
            if (!lXrefColumns.contains(this.getFromDateColumn())) {
                lXrefColumns.add(this.getFromDateColumn());
            }
            ArrayList<IColumn> lIndexColumns = new ArrayList<IColumn>();
            lIndexColumns.addAll(lXrefColumns);
            xRefTable = this.genCreatePermanentXRefTable(codeSegment, lXrefColumns, lIndexColumns, false);
            sXrefInputName = xRefTable.getFullNameQuotedAsNeeded(codeSegment);
            codeSegment.addCommentLine("Sort the cross-reference table into key order").addSourceCode("proc sort data=").addSourceCode(sXrefInputName).addSourceCode("\n").indent().addSourceCode("out=").addSourceCode(WORKSORTEDXREFNAME).addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByColumns).addSourceCode(" ").addSourceCode(this.getFromDateColumn().getColumnName(codeSegment)).addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        } else {
            String sTargetTableType = "";
            sTargetTableType = targetTable.getDBMSProductName();
            this.genCreateTempXrefTable(targetTable.getFullNameQuotedAsNeeded(codeSegment), lKeyColumnsNoFromDate, null, null, null, false, false, null, WORKSORTEDXREFNAME, codeSegment, sTargetTableType, "", "", "");
        }
        String sFromDateExpr = "";
        if (this.getFromDateExpression() != null) {
            sFromDateExpr = this.getFromDateExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
        }
        String sToDateExpr = "";
        if (this.getToDateExpression() != null) {
            sToDateExpr = this.getToDateExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
        }
        if (sFromDateExpr.length() == 0) {
            codeSegment.addSourceCode("%let etls_begdate = DATETIME(); \n\n");
        } else {
            codeSegment.addSourceCode("%let ").addSourceCode("etls_begdate").addSourceCode(" = ").addSourceCode("%sysfunc(" + sFromDateExpr + ")").addSourceCode(";\n");
        }
        if (sToDateExpr.length() == 0) {
            this.genToDateExpression(codeSegment);
        } else {
            codeSegment.addCommentLine("Generate the to date expression").addSourceCode("%let ").addSourceCode("etls_enddate").addSourceCode(" = ").addSourceCode(sToDateExpr).addSourceCode(";\n\n");
        }
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            ITransformTableOptions sourceTableOptions = this.getTableOptionObject(sourceTable, true);
            String sSrcTableOptions = sourceTableOptions.getTableOptions(codeSegment.getCurrentServer());
            this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingStepOutputName, sourceTable.getFullNameQuotedAsNeeded(codeSegment), sSrcTableOptions.length() > 0 ? "&etls_tableOptions" : "", null, true, true, false, null, null, false, null, null, null);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            codeSegment.addSourceCode("%let etls_tableOptions = ; \n\n");
        }
        codeSegment.genRCSetCall("&sqlrc");
        String sFromDate = this.getFromDateColumn().getColumnName(codeSegment);
        String sToDate = this.getToDateColumn().getColumnName(codeSegment);
        String sourceTblName = isMappingNeeded ? "&syslast" : sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        codeSegment.addCommentLine("Sort the source table by the key").addSourceCode("proc sort data=").addSourceCode(sourceTblName).addSourceCode("\n").indent().addSourceCode("out=").addSourceCode(WORKINPUTSOURCE).addSourceCode(" nodupkey").addSourceCode(";\n").addSourceCode("by ").addSourceCode(sByColumns).addSourceCode(" ").addSourceCode(sFromDate).addSourceCode(";\n").unIndent().addSourceCode("run; \n").genRCSetCall("&syserr");
        if (this.getDateFormatType().equals("DATE")) {
            codeSegment.addCommentLine("Automatically convert the dates if \"Format Type for Date\" option is set to DATE").addSourceCode("data ").addSourceCode(WORKINPUTSOURCE).addSourceCode("; \n").indent().addSourceCode("set ").addSourceCode(WORKINPUTSOURCE).addSourceCode("; \n").addSourceCode("by ").addSourceCode(sByColumns).addSourceCode("; \n").addSourceCode("if ").addSourceCode(sFromDate).addSourceCode(" ne . \n").indent().addSourceCode("then ").addSourceCode(sFromDate).addSourceCode(" = DHMS(").addSourceCode(sFromDate).addSourceCode(",0,0,0);\n").unIndent().addSourceCode("if ").addSourceCode(sToDate).addSourceCode(" ne . \n").indent().addSourceCode("then ").addSourceCode(sToDate).addSourceCode(" = DHMS(").addSourceCode(sToDate).addSourceCode(",0,0,0);\n").unIndent().unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        }
        this.genDateDataMergeStep(lKeyColumnsNoFromDate, null, null, false, false, null, null, null, false, WORKINPUTSOURCE, WORKSORTEDXREFNAME, null, codeSegment, "1", "0");
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateBefore(targetTable);
        }
        this.genCheckUpdateTableStats("kedldout", true, false, false, false, codeSegment);
        this.genDateUpdateTargetTable(lKeyColumnsNoFromDate, usePassThru, null, false, null, null, codeSegment, "1", "0");
        String sTargetEngine = "";
        sTargetEngine = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer()).getEngine();
        ArrayList lKeyColumns = new ArrayList();
        if (isXrefPermanent) {
            this.genUpdateXrefTable(sTargetEngine, sTargetDSName, xRefTable, lKeyColumnsNoFromDate, null, null, false, usePassThru, "", lKeyColumns, codeSegment, "1", "0");
        }
        codeSegment.addSourceCode("%let etls_lastTable = %nrquote(").addSourceCode(sTargetDSName).addSourceCode(");\n\n");
        IDBMSType oDBMSType = targetTable.getDBMSType();
        oDBMSType.genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, targetTable);
        codeSegment.addSourceCode("%if &etls_debug lt 2 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(WORKINPUTSOURCE).genTableDelete(WORKSORTEDXREFNAME).unIndent().addSourceCode("%end;\n\n");
        codeSegment.addSourceCode("%goto kedldout;\n").addSourceCode("%error:\n").indent().addSourceCode("%let sysrc = 9999;\n").genRCSetCall("sysrc").unIndent().addSourceCode("%kedldout:\n");
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.indent().genJobStatusUpdateAfter(targetTable).unIndent();
        }
        codeSegment.unIndent().addSourceCode("%mend etls_kedloader;\n\n");
        codeSegment.addCommentLine("Execute the Key Effective Date Loader").addSourceCode("%etls_kedloader;\n\n");
        oDBMSType.genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, targetTable);
        oDBMSType.genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, targetTable);
        oDBMSType.genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, targetTable);
        if (isMappingNeeded && !targetTable.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        return codeSegment;
    }

    @Override
    protected void loadBusinessKeyColumns(OMRAdapter omr) throws MdException, RemoteException {
        IMapping keyMapping = this.findTargetMapping(KEYEFFDT_TRANSFORMROLE);
        if (keyMapping != null) {
            IColumn[] aTargets = keyMapping.getTargets();
            for (int index = 0; index < aTargets.length; ++index) {
                this.addBusinessKeyColumn(aTargets[index]);
            }
        }
    }

    @Override
    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
        IMapping mapping = this.findTargetMapping(KEYEFFDT_TRANSFORMROLE);
        if (this.getBusinessKeyColumnsList().size() > 0) {
            if (mapping == null) {
                mapping = this.createNewMapping();
                mapping.setName("KED Key Columns");
                mapping.setType(KEYEFFDT_TRANSFORMROLE);
                IColumn[] aCols = this.getBusinessKeyColumns();
                for (int index = 0; index < aCols.length; ++index) {
                    mapping.addTarget(aCols[index]);
                }
                this.addMapping(mapping);
            } else {
                int index;
                IColumn[] aCols = mapping.getTargets();
                for (index = 0; index < aCols.length; ++index) {
                    mapping.removeTarget(aCols[index]);
                }
                aCols = this.getBusinessKeyColumns();
                for (index = 0; index < aCols.length; ++index) {
                    mapping.addTarget(aCols[index]);
                }
            }
        } else {
            this.removeMapping(mapping);
        }
        super.saveMappingsToOMR(omr, mdoCM, tblTarget);
    }
}

